/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editports;

import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.dataimpl.RMCPChangePort;
import sanproject.serverux.dataimpl.SetChannelSpeed;
import sanproject.serverux.dataimpl.SetFibreAddress;
import sanproject.serverux.dataimpl.SetFibreTopology;
import sanproject.serverux.dataimpl.SetSecuritySwitchInfo;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsAttributeAC;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsConfirmDC;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsDC;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsData;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsKindAC;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;

public class SJctrEditPortsSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "EDIT_PORT";
    private static final Class<?> CONFIRM_DC = SJctrEditPortsConfirmDC.class;

    @Override
    public SJctrError checkInitParam(Object param) {
        return null;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrEditPortsAttributeAC attributeAC = new SJctrEditPortsAttributeAC();
        SJctrEditPortsKindAC kindAC = new SJctrEditPortsKindAC();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        List<?> confirmDataList = dc.getProxy().getCache(SJctrEditPortsData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            return;
        }
        SJctrEditPortsData confirmData = (SJctrEditPortsData)confirmDataList.get(0);
        List<SJmoPortAttributeInfo> portAttributeInfoList = confirmData.getPortAttributeInfoList();
        List<SJmoPortDetail> portDetailList = confirmData.getPortDetailList();
        ArrayList<RMCPChangePort> mChangePortList = new ArrayList<RMCPChangePort>(portAttributeInfoList.size());
        if (portAttributeInfoList.size() != 0) {
            RMCPChangePort changePort = null;
            boolean attributeACFlg = confirmData.isEnableCheckBox(SJctrEditPortsData.CHECKBOX_ITEM.ATTRIBUTE);
            if (attributeACFlg) {
                changePort = new RMCPChangePort();
                changePort.NumofPort = portAttributeInfoList.size();
                SJmoPortAttributeInfo firstPortAttribute = portAttributeInfoList.get(0);
                changePort.Mode = SJctrEditPortsAttributeAC.getPortAttributeToRmi(firstPortAttribute.getByPortKind());
                for (int index = 0; index < portAttributeInfoList.size(); ++index) {
                    SJmoPortAttributeInfo portAttribute = portAttributeInfoList.get(index);
                    changePort.PortNumber[index] = portAttribute.getSPort();
                }
                mChangePortList.add(changePort);
                attributeAC.setApplyList(mChangePortList);
                wizard.addConfirmData(attributeAC, related);
            }
        }
        ArrayList<SetSecuritySwitchInfo> mSetSecuritySwitchInfoList = new ArrayList<SetSecuritySwitchInfo>(portDetailList.size());
        ArrayList<SetChannelSpeed> mSetChannelSpeedList = new ArrayList<SetChannelSpeed>(portDetailList.size());
        ArrayList<SetFibreAddress> mSetFibreAddressList = new ArrayList<SetFibreAddress>(portDetailList.size());
        ArrayList<SetFibreTopology> mSetFibreTopologyList = new ArrayList<SetFibreTopology>(portDetailList.size());
        boolean kindACFlg = false;
        for (SJmoPortDetail portDetail : portDetailList) {
            SetSecuritySwitchInfo setSecuritySwitchInfo = new SetSecuritySwitchInfo();
            setSecuritySwitchInfo.setSPort(portDetail.getSPort());
            byte bySwitchOnOff = 0;
            if (portDetail.isBPortSecuritySwitch()) {
                bySwitchOnOff = 1;
            }
            setSecuritySwitchInfo.setBySwitchOnOff(bySwitchOnOff);
            SetChannelSpeed setChannelSpeed = new SetChannelSpeed();
            setChannelSpeed.setSPort(portDetail.getSPort());
            setChannelSpeed.setSChannelSpeed(SJctrEditPortsKindAC.getChannelSpeedToRmi(portDetail.getByUserChannelSpeed(), portDetail.getByDKCChannelSpeed()));
            SetFibreAddress setFibreAddress = new SetFibreAddress();
            setFibreAddress.setSPort(portDetail.getSPort());
            setFibreAddress.setSFibreAddress(portDetail.getSPortFibreAddress());
            SetFibreTopology setFibreTopology = new SetFibreTopology();
            setFibreTopology.setSPort(portDetail.getSPort());
            setFibreTopology.setSFibreTopology(portDetail.getByPortFibreTopology());
            if (confirmData.isEnableCheckBox(SJctrEditPortsData.CHECKBOX_ITEM.SECURITY)) {
                mSetSecuritySwitchInfoList.add(setSecuritySwitchInfo);
                kindACFlg = true;
            }
            if (confirmData.isEnableCheckBox(SJctrEditPortsData.CHECKBOX_ITEM.SPEED)) {
                mSetChannelSpeedList.add(setChannelSpeed);
                kindACFlg = true;
            }
            if (confirmData.isEnableCheckBox(SJctrEditPortsData.CHECKBOX_ITEM.ADDRESS)) {
                mSetFibreAddressList.add(setFibreAddress);
                kindACFlg = true;
            }
            if (!confirmData.isEnableCheckBox(SJctrEditPortsData.CHECKBOX_ITEM.CONNECTION) && !confirmData.isEnableCheckBox(SJctrEditPortsData.CHECKBOX_ITEM.FCSWITCH)) continue;
            mSetFibreTopologyList.add(setFibreTopology);
            kindACFlg = true;
        }
        if (kindACFlg) {
            kindAC.setApplyList(mSetSecuritySwitchInfoList, mSetChannelSpeedList, mSetFibreAddressList, mSetFibreTopologyList);
            wizard.addConfirmData(kindAC, related);
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{SJctrEditPortsDC.class};
        return clsList;
    }

    @Override
    public short[] getRequireRoll() {
        return null;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }
}

