/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.initiator.addiscsipath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetPathInfoComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.addiscsipath.SJctrAddIscsiPathConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.addiscsipath.SJctrAvailableIscsiPathTableDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.addiscsipath.SJctrIscsiTargetPathInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.addiscsipath.SJctrSelectedIscsiPathTableDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.discoveryiscsitarget.SJctrDiscoveryIscsiTargetDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrAddIscsiPathDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17834033;
    private static final String DISP_TITLE = "ADD_ISCSI_PATHS";
    private static final String KEY_BTN_DISCCVERY = "BTN_DISCOVERY";
    private static final String KEY_TABLE_AVA = "COM_AVA_TABLE";
    private static final String KEY_CMB_AUTH_METHOD = "CMB_AUTH_METHOD";
    private static final String KEY_AUTH_NONE = String.valueOf(0);
    private static final String KEY_AUTH_CHAP = String.valueOf(1);
    private static final String KEY_RAIDO_MUTUAL_CHAP = "RADIO_CHAP_USER";
    private static final String KEY_MUTUAL_ENABLE = String.valueOf(1);
    private static final String KEY_MUTUAL_DISABLE = String.valueOf(0);
    private static final String KEY_TXT_USER_NAME = "COM_TXT_USER_NAME";
    private static final String KEY_TXT_SECRET = "COM_TXT_SECRET";
    private static final String KEY_BTN_ADD = "BTN_ADD";
    private static final String KEY_TABLE_SEL = "COM_SEL_TABLE";
    private static final String KEY_BTN_REMOVE = "BTN_REMOVE";
    public static final String KEY_CASH_USABLE_PORT_LIST = "CASH_USABLE_PORT_LIST";
    private int numRegistPath = 0;

    public SJctrAddIscsiPathDC() throws SJcException {
        super(17834033);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetPathInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    protected void initDataModel() {
        SJctrButtonDataModel discoveryBtn = new SJctrButtonDataModel();
        discoveryBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrAddIscsiPathDC.this.fireMessageEvent(ADD_ISCSI_PATH_MSG.PUSH_DISCOVERY);
                }
            }
        });
        this.addDataObjectModel(KEY_BTN_DISCCVERY, discoveryBtn);
        SJctrAvailableIscsiPathTableDataModel avaTbl = new SJctrAvailableIscsiPathTableDataModel();
        this.addDataObjectModel(KEY_TABLE_AVA, avaTbl);
        SJctrComboBoxDataModel cmbAuth = new SJctrComboBoxDataModel();
        this.addDataObjectModel(KEY_CMB_AUTH_METHOD, SJctrIscsiUtility.addItemSelectEventListener(cmbAuth, ADD_ISCSI_PATH_MSG.CHANGE_AUTH));
        SJctrRadioButtonGroupDataModel mutualRadio = new SJctrRadioButtonGroupDataModel();
        mutualRadio.add(KEY_MUTUAL_ENABLE);
        mutualRadio.add(KEY_MUTUAL_DISABLE);
        this.addDataObjectModel(KEY_RAIDO_MUTUAL_CHAP, SJctrIscsiUtility.addItemSelectEventListener(mutualRadio, ADD_ISCSI_PATH_MSG.CHANGE_MUTUAL));
        SJctrTextBoxDataModel txtUserName = new SJctrTextBoxDataModel();
        this.addDataObjectModel(KEY_TXT_USER_NAME, txtUserName);
        SJctrTextBoxDataModel txtSecret = new SJctrTextBoxDataModel();
        txtSecret.setTrim(false);
        this.addDataObjectModel(KEY_TXT_SECRET, txtSecret);
        SJctrButtonDataModel addBtn = new SJctrButtonDataModel();
        addBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrAddIscsiPathDC.this.fireMessageEvent(ADD_ISCSI_PATH_MSG.SELECT_ADD);
                }
            }
        });
        this.addDataObjectModel(KEY_BTN_ADD, addBtn);
        SJctrSelectedIscsiPathTableDataModel selTbl = new SJctrSelectedIscsiPathTableDataModel();
        selTbl.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL, selTbl);
        SJctrButtonDataModel removeBtn = new SJctrButtonDataModel();
        removeBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrAddIscsiPathDC.this.fireMessageEvent(ADD_ISCSI_PATH_MSG.SELECT_REMOVE);
                }
            }
        });
        this.addDataObjectModel(KEY_BTN_REMOVE, removeBtn);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    protected void initListener() {
        this.addMessageEventListener(ADD_ISCSI_PATH_MSG.PUSH_DISCOVERY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddIscsiPathDC.this.makeDiscoveryiSCSITargets();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map param = (Map)event.getNofifyObject();
                SJctrAddIscsiPathDC.this.exitDialogAction(param);
            }
        });
        this.addMessageEventListener(ADD_ISCSI_PATH_MSG.CHANGE_AUTH, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddIscsiPathDC.this.statusChangeTxtBox();
            }
        });
        this.addMessageEventListener(ADD_ISCSI_PATH_MSG.CHANGE_MUTUAL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddIscsiPathDC.this.statusChangeTxtBox();
            }
        });
        this.addMessageEventListener(ADD_ISCSI_PATH_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddIscsiPathDC.this.AddAction();
                SJctrIscsiUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(ADD_ISCSI_PATH_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddIscsiPathDC.this.RemoveAction();
                SJctrIscsiUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    @Override
    public boolean checkConstructData() {
        try {
            ArrayList<SJmoPortDetail> usablePortList = new ArrayList<SJmoPortDetail>();
            List<SJmoPortDetail> mPortDetailList = SJctrIscsiUtility.getSJmoPortDetailList(this);
            List<SJmoPortIscsiTargetPathInfo> mPortIscsiPathList = SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(this);
            List<SJmoRSGgetAllRsgs> mRsglList = SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this);
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), mRsglList.get(0));
            for (SJmoPortDetail port : mPortDetailList) {
                if (!SJctrIscsiUtility.isIscsiPort(port) || !SJctrIscsiUtility.isRsgPortIndex(port, rsgUtil)) continue;
                usablePortList.add(port);
            }
            if (usablePortList.size() == 0) {
                throw SJctrIscsiUtility.makeException(206274);
            }
            Collections.sort(usablePortList);
            this.putCache(KEY_CASH_USABLE_PORT_LIST, usablePortList);
            for (SJmoPortIscsiTargetPathInfo portPathInfo : mPortIscsiPathList) {
                ArrayList<SJmoIscsiTargetPathInfo> pathList = portPathInfo.getAlPortIscsiTargetPath();
                this.numRegistPath += pathList.size();
            }
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107002);
        }
        return true;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrComboBoxDataModel cmbAuth = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_AUTH_METHOD);
        SJctrRadioButtonGroupDataModel radioMutual = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_RAIDO_MUTUAL_CHAP);
        cmbAuth.setEnableListener(false);
        radioMutual.setEnableListener(false);
        cmbAuth.addItem(KEY_AUTH_CHAP, this.getComUtility().getGuidance("CHAP"));
        cmbAuth.addItem(KEY_AUTH_NONE, this.getComUtility().getGuidance("CHAP_NONE"));
        cmbAuth.setSelection(KEY_AUTH_NONE);
        radioMutual.setSelect(KEY_MUTUAL_DISABLE);
        this.statusChangeTxtBox();
        cmbAuth.setEnableListener(true);
        radioMutual.setEnableListener(true);
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrAddIscsiPathConfirmData confirmData = new SJctrAddIscsiPathConfirmData();
            SJctrSelectedIscsiPathTableDataModel tbl = (SJctrSelectedIscsiPathTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL);
            List<Object> rowData = tbl.getAllRowData();
            Collections.sort(rowData, new SJctrIscsiTargetPathInfoComparator());
            confirmData.setIscsiPathInfo(rowData);
            confirmData.setNeedData(this);
            ArrayList<SJctrAddIscsiPathConfirmData> confirmDataList = new ArrayList<SJctrAddIscsiPathConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrAddIscsiPathConfirmData.class, confirmDataList);
            SJctrIscsiUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107003);
        }
        return true;
    }

    private void makeDiscoveryiSCSITargets() {
        try {
            HashMap param = new HashMap();
            List<?> portList = this.getCache(KEY_CASH_USABLE_PORT_LIST);
            param.put("PORT_LIST", portList);
            param.put(SJmoGetPortDetail.class.getName(), SJctrIscsiUtility.getSJmoPortDetailList(this));
            param.put(SJmoGetPortIscsiTargetPathInfo.class.getName(), SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(this));
            SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrDiscoveryIscsiTargetDC.class, param);
            this.addUpdateDisp(dialogRelated);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
    }

    private void exitDialogAction(Map<String, List<?>> carryMap) {
        List<?> discoveryPathList = carryMap.get("DICSCOVERY_PATH_LIST");
        if (discoveryPathList != null && discoveryPathList.size() > 0) {
            ArrayList<Object> addRowData = new ArrayList<Object>();
            SJctrIscsiTargetPathInfoComparator comparatorObj = new SJctrIscsiTargetPathInfoComparator();
            SJctrAvailableIscsiPathTableDataModel tblAva = (SJctrAvailableIscsiPathTableDataModel)this.getDataObjectModel(KEY_TABLE_AVA);
            ArrayList<Object> rowDataAvaList = new ArrayList<Object>(tblAva.getAllRowData());
            Collections.sort(rowDataAvaList, comparatorObj);
            SJctrSelectedIscsiPathTableDataModel tblSel = (SJctrSelectedIscsiPathTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL);
            ArrayList<Object> rowDataSelList = new ArrayList<Object>(tblSel.getAllRowData());
            Collections.sort(rowDataSelList, comparatorObj);
            for (Object obj : discoveryPathList) {
                if (obj instanceof SJctrIscsiTargetPathInfo) {
                    SJctrIscsiTargetPathInfo discoveryPath = (SJctrIscsiTargetPathInfo)obj;
                    int searchIndex = Collections.binarySearch(rowDataAvaList, discoveryPath, comparatorObj);
                    if (searchIndex >= 0 || (searchIndex = Collections.binarySearch(rowDataSelList, discoveryPath, comparatorObj)) >= 0) continue;
                    addRowData.add(discoveryPath);
                    continue;
                }
                throw SJctrIscsiUtility.makeException(107001);
            }
            if (addRowData.size() > 0) {
                tblAva.addRowDataTop(addRowData);
                tblAva.addRowSelectionList(addRowData);
            }
            tblAva.setDirty();
            this.updateFooter();
        }
    }

    private void statusChangeTxtBox() {
        SJctrComboBoxDataModel cmbAuth = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_AUTH_METHOD);
        SJctrRadioButtonGroupDataModel radioMutual = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_RAIDO_MUTUAL_CHAP);
        SJctrTextBoxDataModel txtName = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TXT_USER_NAME);
        SJctrTextBoxDataModel txtSecret = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TXT_SECRET);
        int iAuthSwitch = Integer.valueOf(cmbAuth.getSelection());
        int iAuthMode = Integer.valueOf(radioMutual.getSelect());
        if (iAuthSwitch == 1) {
            txtName.setEnable(true);
            txtSecret.setEnable(true);
            if (iAuthMode == 0) {
                txtName.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR_OR_BLANK"));
                txtSecret.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR_OR_BLANK"));
            } else if (iAuthMode == 1) {
                txtName.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR"));
                txtSecret.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR"));
            }
        } else if (iAuthSwitch == 0) {
            txtName.setValue("");
            txtName.setLabel("(-)");
            txtName.setEnable(false);
            txtSecret.setValue("");
            txtSecret.setLabel("(-)");
            txtSecret.setEnable(false);
        }
        txtSecret.setDirtyAll();
        txtName.setDirtyAll();
    }

    private void AddAction() {
        SJctrComboBoxDataModel cmbAuth = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_AUTH_METHOD);
        SJctrRadioButtonGroupDataModel radioMutual = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_RAIDO_MUTUAL_CHAP);
        SJctrTextBoxDataModel txtName = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TXT_USER_NAME);
        SJctrTextBoxDataModel txtSecret = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TXT_SECRET);
        SJctrAvailableIscsiPathTableDataModel tblAva = (SJctrAvailableIscsiPathTableDataModel)this.getDataObjectModel(KEY_TABLE_AVA);
        List<Object> selectData = tblAva.getSelectedRowData();
        SJctrSelectedIscsiPathTableDataModel tblSel = (SJctrSelectedIscsiPathTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL);
        int count = this.countNewIscsiPathNum(selectData);
        if (this.numRegistPath + count > 4096) {
            throw SJctrIscsiUtility.makeException(206275);
        }
        this.numRegistPath += count;
        if (!this.checkInputValueTxt(txtName, txtSecret)) {
            throw SJctrIscsiUtility.makeException(206224);
        }
        int iAuthSwitch = Integer.valueOf(cmbAuth.getSelection());
        int iAuthMode = Integer.valueOf(radioMutual.getSelect());
        String sUser = "";
        String sSecret = "";
        if (iAuthSwitch == 1 && txtName.getValue().length() != 0) {
            sUser = txtName.getValue();
            sSecret = txtSecret.getValue();
        }
        for (SJmoIscsiTargetPathInfo sJmoIscsiTargetPathInfo : selectData) {
            sJmoIscsiTargetPathInfo.setIAuthentSwitch(iAuthSwitch);
            sJmoIscsiTargetPathInfo.setIAuthentMode(iAuthMode);
            sJmoIscsiTargetPathInfo.setStrTargetUserName(sUser);
            sJmoIscsiTargetPathInfo.setStrTargetSecret(sSecret);
        }
        tblSel.addRowDataTop(selectData);
        tblSel.addRowSelectionList(selectData);
        tblAva.removeSelectedRowData();
        tblSel.setDirty();
        tblAva.setDirty();
        this.updateFooter();
    }

    private boolean checkInputValueTxt(SJctrTextBoxDataModel txtName, SJctrTextBoxDataModel txtSecret) {
        boolean flgUser = true;
        boolean flgSecret = true;
        if (txtName.getValue().length() == 0) {
            flgUser = false;
        }
        if (txtSecret.getValue().length() == 0) {
            flgSecret = false;
        }
        return flgUser == flgSecret;
    }

    private int countNewIscsiPathNum(List<SJctrIscsiTargetPathInfo> pathList) {
        int count = 0;
        List<SJmoPortIscsiTargetPathInfo> mIscsiPathList = SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(this);
        for (SJmoIscsiTargetPathInfo sJmoIscsiTargetPathInfo : pathList) {
            int portSerchIndex = Collections.binarySearch(mIscsiPathList, sJmoIscsiTargetPathInfo);
            if (portSerchIndex >= 0) {
                ArrayList<SJmoIscsiTargetPathInfo> mPathList = mIscsiPathList.get(portSerchIndex).getAlPortIscsiTargetPath();
                Collections.sort(mPathList, new SJctrIscsiTargetPathInfoComparator());
                int searchIndex = Collections.binarySearch(mPathList, sJmoIscsiTargetPathInfo, new SJctrIscsiTargetPathInfoComparator());
                if (searchIndex >= 0) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    private void RemoveAction() {
        SJctrAvailableIscsiPathTableDataModel tblAva = (SJctrAvailableIscsiPathTableDataModel)this.getDataObjectModel(KEY_TABLE_AVA);
        List<Object> avaAllRowData = tblAva.getAllRowData();
        SJctrSelectedIscsiPathTableDataModel tblSel = (SJctrSelectedIscsiPathTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL);
        List<Object> removeData = tblSel.removeSelectedRowData();
        int count = this.countNewIscsiPathNum(removeData);
        this.numRegistPath -= count;
        avaAllRowData.addAll(removeData);
        Collections.sort(avaAllRowData, new SJctrIscsiTargetPathInfoComparator());
        tblAva.setBasicDataList(avaAllRowData);
        tblAva.doRefresh();
        tblSel.setDirty();
        this.updateFooter();
    }

    public static enum ADD_ISCSI_PATH_MSG implements SJctrNotifyState
    {
        PUSH_DISCOVERY,
        CHANGE_AUTH,
        CHANGE_MUTUAL,
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

