/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.mapluns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.column.SJctrALUAModeColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrAluaAsymmetricAccessStateColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrArrayGroupColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.column.SJctrEmulationTypeColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrHGNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevAttributeColumnFromPortLunInfoTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLunIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrPoolNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrPortNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrVolumeTypeFromPortLunInfoTableKey;
import sanproject.sn2.controller.com.column.iscsi.SJctrIscsiTargetNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.data.SJctrTblDataObject;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLUNsSubWizard;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLunsCapacityColumnFromPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLunsComTableModel;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLunsData;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotVvolRelation;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrMapLunsConfirmTableModel
extends SJctrMapLunsComTableModel {
    private static final String KEY_TOTAL_CAPACITY = "COM_TOTAL_CAPACITY";
    protected static final String KEY_PTNAME = "COM_COL_PTNAME";
    protected static final String KEY_LUNNUM = "COM_COL_LUNNUM";
    protected static final String KEY_HG_IT_NAME = "COM_COL_HG_IT_NAME";
    public static final String KEY_ISCSI_TARGETNAME = "COM_COL_ISCSI_TARGET_NAME";
    protected static final String KEY_HG_IT_ALUAMODE = "COM_COL_ALUAMODE";
    protected static final String KEY_HG_ALUASTATE = "COM_COL_ALUASTATE";

    public SJctrMapLunsConfirmTableModel() {
    }

    public SJctrMapLunsConfirmTableModel(boolean paging) {
        super(paging);
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        return this.getBasicDataListFromConfirmData();
    }

    @Override
    public void makeDataModel() {
        SJctrMapLunsData mapLunsData = this.getMapLunsData();
        List<SJctrPortHostGroupTableKey> keyList = mapLunsData.getPortHostGroup();
        boolean fibreFlg = true;
        if (keyList != null && !keyList.isEmpty()) {
            SJctrPortHostGroupTableKey portHGTabkeKeyInfo = keyList.get(0);
            fibreFlg = portHGTabkeKeyInfo.isFibre();
        }
        SJctrComUtility util = this.getComUtility();
        for (String key : this.getAllColumnKeySet(false)) {
            SJctrColumn colimn = this.getColumnInfo(key);
            if (colimn == null) continue;
            if (key.equals(KEY_HG_IT_NAME)) {
                if (fibreFlg) {
                    colimn.setLabel(util.getGuidance("HG_NAME"));
                    continue;
                }
                colimn.setLabel(util.getGuidance("ISCSI_TARGET_ALIAS"));
                continue;
            }
            if (key.equals(KEY_ISCSI_TARGETNAME)) {
                colimn.setShowColumn(!fibreFlg);
                continue;
            }
            if (key.equals(KEY_HG_IT_ALUAMODE)) {
                colimn.setShowColumn(fibreFlg);
                continue;
            }
            if (!key.equals(KEY_HG_ALUASTATE)) continue;
            colimn.setShowColumn(fibreFlg);
        }
        super.makeDataModel();
    }

    @Override
    public void makeDataObject() {
        this.makeTotalCapacity();
        super.makeDataObject();
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        HashMap map = new HashMap();
        super.setModelData(map);
        SJctrMapLunsData mapLunsData = this.getMapLunsData();
        this.setModelDataFromConfirmData(mapLunsData);
    }

    public void setModelDataFromConfirmData(SJctrMapLunsData mapLunsData) {
        this.setBasicData(SJmoGetLdevDetail.class, mapLunsData.getLdevDetail());
        this.setBasicData(SJmoGetLdevLuseInfo.class, mapLunsData.getLdevLuseInfo());
        this.setBasicData(SJmoGetPortLunInfo.class, mapLunsData.getPortLunInfo());
        this.setBasicData(SJmoGetLdevNicknameInfo.class, mapLunsData.getLdevNicknameInfo());
        this.setBasicData(SJmoGetPoolNameInfo.class, mapLunsData.getPoolNameInfo());
        this.setBasicData(SJmoGetHDPRelation.class, mapLunsData.getHdprInfo());
        this.setBasicData(SJmoGetSnapshotVvolRelation.class, mapLunsData.getPoolQsInfo());
        this.setBasicData(SJmoGetPortHostGroupInfo.class, mapLunsData.getPortHostGroupInfo());
        this.setBasicData(SJmoGetPortDetail.class, mapLunsData.getPortDetail());
        this.setBasicData(SJmoGetPortIscsiTargetInfo.class, mapLunsData.getPortiTInfo());
    }

    private List<SJctrPortLunTableKey> getBasicDataListFromConfirmData() {
        SJctrMapLunsData mapLunsData = this.getMapLunsData();
        List<SJmoPortLunInfo> portLunInfoList = mapLunsData.getPortLunInfo();
        ArrayList<SJctrPortLunTableKey> retList = new ArrayList<SJctrPortLunTableKey>(portLunInfoList.size());
        for (SJmoPortLunInfo portLunInfo : portLunInfoList) {
            ArrayList portLunDtlList = portLunInfo.getAlPortLun();
            for (int i = 0; i < portLunDtlList.size(); ++i) {
                SJmoPortLunDetail portLunDetail = (SJmoPortLunDetail)portLunDtlList.get(i);
                SJctrPortLunTableKey portLunTableKey = new SJctrPortLunTableKey(portLunInfo, portLunDetail);
                retList.add(portLunTableKey);
            }
        }
        Collections.sort(retList);
        return retList;
    }

    private SJctrMapLunsData getMapLunsData() {
        SJctrConfirmDataController dc = (SJctrConfirmDataController)this.getDataController();
        List<?> confirmDataList = dc.getCache(SJctrMapLUNsSubWizard.KEY_MAP_LUNS_DATA);
        SJctrMapLunsData mapLunsData = (SJctrMapLunsData)confirmDataList.get(0);
        return mapLunsData;
    }

    private void makeTotalCapacity() {
        Map<Class<?>, List<?>> map = this.getBasicDataMap();
        List<?> ldevList = map.get(SJmoGetLdevDetail.class);
        long totalCapacity = 0L;
        for (SJmoLdevDetail ldev : ldevList) {
            totalCapacity += ldev.getLLDEVLBASize();
        }
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        String str = util.toUnitString(totalCapacity);
        ((SJctrTblDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY, str);
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrPortNameColumnFromPortLunTableKey(KEY_PTNAME));
        this.addColumn(new SJctrLunIdColumnFromPortLunTableKey(KEY_LUNNUM));
        this.addColumn(new SJctrLdevIdColumnFromPortLunTableKey("COM_COL_LDEVID"));
        this.addColumn(new SJctrLdevNameColumnFromPortLunTableKey("COM_COL_LDEVNAME"));
        this.addColumn(new SJctrHGNameColumnFromPortLunTableKey(KEY_HG_IT_NAME));
        this.addColumn(new SJctrIscsiTargetNameColumnFromPortLunTableKey(KEY_ISCSI_TARGETNAME));
        this.addColumn(new SJctrArrayGroupColumnFromPortLunTableKey("COM_COL_ARYGRP"));
        this.addColumn(new SJctrPoolNameColumnFromPortLunTableKey("COM_COL_POOLNAME"));
        SJctrEmulationTypeColumnFromPortLunTableKey emuType = new SJctrEmulationTypeColumnFromPortLunTableKey("COM_COL_EMUTYPE");
        if (SJctrDataController.isHM()) {
            emuType.setSupportColumn(false);
        }
        this.addColumn(emuType);
        this.addColumn(new SJctrMapLunsCapacityColumnFromPortLunTableKey("COM_COL_LDEVCAP"));
        this.addColumn(new SJctrVolumeTypeFromPortLunInfoTableKey("COM_COL_VOLTYPE"));
        this.addColumn(new SJctrLdevAttributeColumnFromPortLunInfoTableKey("COM_COL_LDEVATTR"));
        this.addColumn(new SJctrALUAModeColumnFromPortLunTableKey(KEY_HG_IT_ALUAMODE));
        this.addColumn(new SJctrAluaAsymmetricAccessStateColumnFromPortLunTableKey(KEY_HG_ALUASTATE));
    }
}

