/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.mapluns;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVNameData;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVSettingDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLuPathLdevIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHGIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.comdialog.changelunid.SJctrChangeLunIdDC;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrLunIdCheckColumn;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLUNsSubWizard;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLunsData;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLunsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilLun;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotVvolRelation;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtilLun;

public class SJctrMapLunsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1001103;
    static final String GUID_TITLE = "DISP_ML3_TITLE";
    static final String GUID_MSGFMT_SETOFPATH = "LUN_SET_OF_PATH";
    private static final String KEY_TABLE = "COM_TABLE";
    public static final int MAX_SELECT_HG = 64;
    public static final int MAX_SELECT_IT = 64;
    public static final String KEY_PTTYPE = "COM_PTTYPE";

    public SJctrMapLunsDC() throws SJcException {
        super(0x1001103);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkEndData() {
        ArrayList errorList = new ArrayList();
        List<?> list = this.getCache("KEY_CREATE_LU_PATH");
        if (list == null || list.size() <= 0) {
            this.logUty.putlog("checkEndData", "There is no Create PortLunInfo.");
            SJctrError error = new SJctrError(10, 22, 107001);
            throw error.createException();
        }
        this.logUty.putlog("checkEndData", "Create PortLunInfo = " + list.size());
        List<?> portDetailList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_DETAIL);
        List<SJctrPortHostGroupTableKey> targetHg = this.getCache("KEY_TARGET_HG_INFO");
        if (targetHg.size() == 0) {
            targetHg = this.getCache("KEY_TARGET_IT_INFO");
        }
        SJctrComUtility comUtil = this.getComUtility();
        SJctrPortUtility portUtil = comUtil.getPortUtility();
        portUtil.checkPortSecurityMsg(portDetailList, targetHg, this);
        return errorList.size() == 0;
    }

    @Override
    public boolean checkStartData() {
        ArrayList errorList = new ArrayList();
        List<?> list = this.getCache("KEY_TARGET_HG_INFO");
        if (!(list != null && list.size() != 0 || (list = this.getCache("KEY_TARGET_IT_INFO")) != null && list.size() != 0)) {
            this.logUty.putlog("checkStartData", "There is no Target PortHostGroup.");
            SJctrError error = new SJctrError(10, 22, 107001);
            throw error.createException();
        }
        SJctrPortHostGroupTableKey ptHgKey = (SJctrPortHostGroupTableKey)list.get(0);
        if (ptHgKey.isFibre()) {
            int size = list.size();
            if (0 >= size || size > 64) {
                this.logUty.putlog("checkStartData", "Target PortHostGroup range error = " + size);
                String[] msgArg = new String[]{Integer.toString(64)};
                SJctrError error = new SJctrError(10, 22, 105091);
                SJcException ex = error.createException();
                ex.getMsg().setMsg_argument(msgArg);
                throw ex;
            }
        } else {
            int size = list.size();
            if (0 >= size || size > 64) {
                this.logUty.putlog("checkStartData", "Target PortIscsiTarget range error = " + size);
                String[] msgArg = new String[]{Integer.toString(64)};
                SJctrError error = new SJctrError(10, 22, SJctrMapLUNsSubWizard.MSG_SEL_IT_OVER);
                SJcException ex = error.createException();
                ex.getMsg().setMsg_argument(msgArg);
                throw ex;
            }
        }
        this.logUty.putlog("checkStartData", "Target PortHostGroup = " + list.size());
        return errorList.size() == 0;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        List<?> rscUtilLun = this.getCache(SJctrMapLUNsSubWizard.KEY_LUN_UTIL_DATA);
        if (rscUtilLun == null || rscUtilLun.size() == 0) {
            this.logUty.putlog("checkConstructData", "SJmoRscUtilLun is not Found.");
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkConstructData", "SJmoRscUtilLun = " + rscUtilLun.size());
        return ret;
    }

    public SJctrMapLunsData createConfirmData() {
        ArrayList updLdevNicknameList;
        SJctrMapLunsData mapLunsData = new SJctrMapLunsData();
        List<?> targetLdev = this.getCache("KEY_TARGET_LDEV_INFO");
        List<?> luseInfoList = this.getCache(SJctrMapLUNsSubWizard.KEY_LDEV_LUSE);
        ArrayList<SJmoLdevLuseInfo> subLuseInfoList = new ArrayList<SJmoLdevLuseInfo>(targetLdev.size());
        for (SJmoLdevDetail detail : targetLdev) {
            int index = Collections.binarySearch(luseInfoList, detail);
            if (index >= 0) {
                SJmoLdevLuseInfo data = (SJmoLdevLuseInfo)luseInfoList.get(index);
                subLuseInfoList.add(data);
                continue;
            }
            SJctrLogUty.debug("SJctrMapLunsDC", "createConfirmData", "Not found LdevLuseInfo: " + detail);
        }
        mapLunsData.setLdevLuseInfo(subLuseInfoList);
        List<?> ldevDetailList = this.getCache(SJctrMapLUNsSubWizard.KEY_LDEV_INFO);
        ArrayList<SJmoLdevDetail> subLdevDetailList = new ArrayList<SJmoLdevDetail>(ldevDetailList.size());
        subLdevDetailList.addAll(targetLdev);
        for (SJmoLdevLuseInfo luseInfo : subLuseInfoList) {
            for (Object obj : luseInfo.getAlLUSELdevIndex()) {
                SJmoLdevIndex ldevIndex = (SJmoLdevIndex)obj;
                int index = Collections.binarySearch(ldevDetailList, ldevIndex);
                if (index >= 0) {
                    SJmoLdevDetail data = (SJmoLdevDetail)ldevDetailList.get(index);
                    subLdevDetailList.add(data);
                    continue;
                }
                this.logUty.putlog("createConfirmData", "Not found from LdevDetail list: " + ldevIndex);
            }
        }
        Collections.sort(subLdevDetailList);
        mapLunsData.setLdevDetail(subLdevDetailList);
        List<?> ldevNicknameList = this.getCache("KEY_TARGET_LDEV_NICKNAME");
        ArrayList<SJmoLdevNicknameInfo> subLdevNicknameList = new ArrayList<SJmoLdevNicknameInfo>(ldevNicknameList.size());
        subLdevNicknameList.addAll(ldevNicknameList);
        Collections.sort(subLdevNicknameList);
        mapLunsData.setLdevNicknameInfo(subLdevNicknameList);
        List<?> ldevNicknameList2 = this.getCache("KEY_UPDATE_LDEV_NICKNAME");
        if (ldevNicknameList2 != null) {
            updLdevNicknameList = new ArrayList(ldevNicknameList2.size());
            updLdevNicknameList.addAll(ldevNicknameList2);
            Collections.sort(updLdevNicknameList);
        } else {
            updLdevNicknameList = null;
        }
        mapLunsData.setUpdLdevNicknameInfo(updLdevNicknameList);
        List<?> poolNameList = this.getCache(SJctrMapLUNsSubWizard.KEY_POOL_NAME);
        ArrayList<SJmoPoolNameInfo> subPoolNameList = new ArrayList<SJmoPoolNameInfo>(poolNameList.size());
        subPoolNameList.addAll(poolNameList);
        Collections.sort(subPoolNameList);
        mapLunsData.setPoolNameInfo(subPoolNameList);
        List<?> ldevQsList = this.getCache(SJctrMapLunsData.KEY_POOL_QS);
        ArrayList<SJmoLocalReplicationPairVolInfo> confirmLdevQsList = new ArrayList<SJmoLocalReplicationPairVolInfo>(ldevQsList.size());
        confirmLdevQsList.addAll(ldevQsList);
        Collections.sort(confirmLdevQsList);
        mapLunsData.setPoolQsInfo(confirmLdevQsList);
        List<?> HDPRelationList = this.getCache(SJctrMapLUNsSubWizard.KEY_HDPR);
        ArrayList<SJmoHDPRelation> hdprList = new ArrayList<SJmoHDPRelation>(HDPRelationList.size());
        hdprList.addAll(HDPRelationList);
        Collections.sort(hdprList);
        mapLunsData.setHdprInfo(hdprList);
        List<SJctrPortHostGroupTableKey> targetHg = this.getCache("KEY_TARGET_HG_INFO");
        if (targetHg == null || targetHg.size() < 1) {
            targetHg = this.getCache("KEY_TARGET_IT_INFO");
        }
        mapLunsData.setPortHostGroup(targetHg);
        List<?> portDetailList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_DETAIL);
        ArrayList<SJmoPortDetail> subPortDetailList = new ArrayList<SJmoPortDetail>(portDetailList.size());
        short port = -1;
        for (SJctrPortHostGroupTableKey tableKey : targetHg) {
            SJmoPortIndex portIndex = null;
            portIndex = tableKey.isFibre() ? tableKey.getPortHostGroupInfo() : tableKey.getPortIscsiTargetInfo();
            short tableKeyPort = portIndex.getSPort();
            if (tableKeyPort == port) continue;
            port = tableKeyPort;
            int index = Collections.binarySearch(portDetailList, portIndex);
            if (index >= 0) {
                SJmoPortDetail data = (SJmoPortDetail)portDetailList.get(index);
                subPortDetailList.add(data);
                continue;
            }
            this.logUty.putlog("createConfirmData", "Not found from PortDetail list: " + portIndex);
        }
        mapLunsData.setPortDetail(subPortDetailList);
        List<SJmoPortLunInfo> createLunInfoList = this.getCache("KEY_CREATE_LU_PATH");
        mapLunsData.setPortLunInfo(createLunInfoList);
        ArrayList<SJctrMapLunsData> list = new ArrayList<SJctrMapLunsData>(1);
        list.add(mapLunsData);
        this.putCache(SJctrMapLUNsSubWizard.KEY_MAP_LUNS_DATA, list);
        return mapLunsData;
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", GUID_TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRscUtilLun();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSnapshotVvolRelation();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void makeDataModel() {
        List<SJmoLdevDetail> targetLdev = this.getCache("KEY_TARGET_LDEV_INFO");
        List<?> targetHg = this.getCache("KEY_TARGET_HG_INFO");
        String portType = Byte.toString((byte)2);
        if (targetHg == null || targetHg.size() == 0) {
            targetHg = this.getCache("KEY_TARGET_IT_INFO");
            portType = Byte.toString((byte)5);
        }
        SJctrDataObject mgrData = this.getManageData();
        mgrData.setData(KEY_PTTYPE, portType);
        List<?> defineLunList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_LUN);
        List<?> portDetailList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_DETAIL);
        List<?> lunUtilList = this.getCache(SJctrMapLUNsSubWizard.KEY_LUN_UTIL_DATA);
        SJmoRscUtilLun rscUtilLun = (SJmoRscUtilLun)lunUtilList.get(0);
        this.resetRscUtil();
        SJctrMapLunsTableModel table = (SJctrMapLunsTableModel)this.getDataObjectModel(KEY_TABLE);
        SJctrComUtility comUtil = this.getComUtility();
        SJctrPortUtility portUtil = comUtil.getPortUtility();
        String pattern = this.getComUtility().getGuidance("COMMON", GUID_MSGFMT_SETOFPATH);
        String label = MessageFormat.format(pattern, targetHg.size());
        table.setLunIdsColumnLabel(label);
        HashMap<Integer, SJmoPortLunInfo> portLunInfoMap = new HashMap<Integer, SJmoPortLunInfo>();
        BitSet bitSet = new BitSet();
        for (SJctrPortHostGroupTableKey tableKey : targetHg) {
            Integer portObj;
            SJmoPortLunInfo createLunInfo;
            ArrayList defineHgLunList;
            byte asymmetricAccessState = -1;
            if (!tableKey.isFibre()) {
                table.addLunChildColumn(this.makeIscsiDataModel(targetLdev, tableKey, defineLunList, portDetailList, table, portLunInfoMap, bitSet, rscUtilLun, comUtil, portUtil));
                continue;
            }
            SJmoPortHostGroupInfo phgInfo = tableKey.getPortHostGroupInfo();
            short port = phgInfo.getSPort();
            SJmoHostGroupInfo hgInfo = tableKey.getHostGroupInfo();
            short hg = hgInfo.getSHostGroup();
            int index = Collections.binarySearch(defineLunList, phgInfo);
            if (index >= 0) {
                SJmoPortLunInfo defineLunInfo = (SJmoPortLunInfo)defineLunList.get(index);
                defineHgLunList = defineLunInfo.getAlHostGroupLun(hg);
            } else {
                defineHgLunList = Collections.emptyList();
            }
            bitSet.clear();
            for (SJmoPortLunDetail lunDetail : defineHgLunList) {
                bitSet.set(lunDetail.getSLUN());
                if (asymmetricAccessState != -1) continue;
                asymmetricAccessState = lunDetail.getByAsymmetricAccessState();
            }
            if (defineHgLunList.size() == 0) {
                asymmetricAccessState = 0;
            }
            if ((createLunInfo = (SJmoPortLunInfo)portLunInfoMap.get(portObj = Integer.valueOf(port))) == null) {
                createLunInfo = new SJmoPortLunInfo();
                createLunInfo.setSPort(port);
                portLunInfoMap.put(portObj, createLunInfo);
            }
            ArrayList createLunList = createLunInfo.getAlPortLun();
            ArrayList<SJmoPortLunDetail> createHgLunList = new ArrayList<SJmoPortLunDetail>();
            int lun = -1;
            for (SJmoLdevDetail ldevDetail : targetLdev) {
                short ldkc = ldevDetail.getSLdkc();
                short cu = ldevDetail.getSCu();
                short ldev = ldevDetail.getSLdev();
                int chkHgId = 3;
                while (chkHgId != 0) {
                    if ((lun = bitSet.nextClearBit(lun + 1)) >= SJctrPortUtility.PORT_LUN_MAX) {
                        this.logUty.putlog("makeDataModel", "LUN is Maximum Error(Consider to include Resouce Diff)!!!");
                        SJctrError error = new SJctrError(10, 22, 105207);
                        throw error.createException();
                    }
                    chkHgId = rscUtilLun.chkLunID(port, hg, (short)lun);
                }
                SJmoPortLunDetail lunDetail = new SJmoPortLunDetail();
                lunDetail.setSPort(port);
                lunDetail.setSHostGroup(hg);
                lunDetail.setSLUN((short)lun);
                lunDetail.setSLDKC(ldkc);
                lunDetail.setSCU(cu);
                lunDetail.setSLDEV(ldev);
                lunDetail.setByAsymmetricAccessState(asymmetricAccessState);
                createLunList.add(lunDetail);
                lunDetail.setIDataMode(2);
                createHgLunList.add(lunDetail);
            }
            createLunInfo.setAlPortLun(createLunList);
            int i = Collections.binarySearch(portDetailList, phgInfo);
            if (i < 0) {
                this.logUty.putlog("makeDataModel", "Not found from PortDetail list: " + phgInfo);
                SJctrError error = new SJctrError(10, 22, 106520);
                throw error.createException();
            }
            SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(i);
            StringBuilder buf = new StringBuilder();
            buf.append(portUtil.toPortNameDisplay(portDetail));
            buf.append(comUtil.getGuidance("SLASH"));
            buf.append(hgInfo.getStrHostgroupNickName());
            String columnLabel = buf.toString();
            String columnKey = table.getNewColumnKey();
            SJctrLunIdCheckColumn column = new SJctrLunIdCheckColumn(columnKey, columnLabel, createHgLunList, true);
            column.setBLunIdDec(this.isLunIdNotationDec());
            table.addLunChildColumn(column);
        }
        ArrayList<SJmoPortLunInfo> infoList = new ArrayList<SJmoPortLunInfo>(portLunInfoMap.values());
        Collections.sort(infoList);
        this.putCache("KEY_CREATE_LU_PATH", infoList);
        this.setRscRsv(infoList, rscUtilLun);
        super.makeDataModel();
    }

    private SJctrLunIdCheckColumn makeIscsiDataModel(List<SJmoLdevDetail> targetLdev, SJctrPortHostGroupTableKey tableKey, List defineLunList, List portDetailList, SJctrMapLunsTableModel table, Map<Integer, SJmoPortLunInfo> portLunInfoMap, BitSet bitSet, SJmoRscUtilLun rscUtilLun, SJctrComUtility comUtil, SJctrPortUtility portUtil) {
        ArrayList defineItLunList;
        SJmoPortIscsiTargetInfo ptItInfo = tableKey.getPortIscsiTargetInfo();
        short port = ptItInfo.getSPort();
        SJmoIscsiTargetInfo itInfo = tableKey.getIscsiTargetInfo();
        short it = itInfo.getSIscsiTarget();
        int index = Collections.binarySearch(defineLunList, ptItInfo);
        if (index >= 0) {
            SJmoPortLunInfo defineLunInfo = (SJmoPortLunInfo)defineLunList.get(index);
            defineItLunList = defineLunInfo.getAlHostGroupLun(it);
        } else {
            defineItLunList = Collections.emptyList();
        }
        bitSet.clear();
        for (SJmoPortLunDetail lunDetail : defineItLunList) {
            bitSet.set(lunDetail.getSLUN());
        }
        Integer portObj = port;
        SJmoPortLunInfo createLunInfo = portLunInfoMap.get(portObj);
        if (createLunInfo == null) {
            createLunInfo = new SJmoPortLunInfo();
            createLunInfo.setSPort(port);
            portLunInfoMap.put(portObj, createLunInfo);
        }
        ArrayList createLunList = createLunInfo.getAlPortLun();
        ArrayList<SJmoPortLunDetail> createItLunList = new ArrayList<SJmoPortLunDetail>();
        int lun = -1;
        for (SJmoLdevDetail ldevDetail : targetLdev) {
            short ldkc = ldevDetail.getSLdkc();
            short cu = ldevDetail.getSCu();
            short ldev = ldevDetail.getSLdev();
            int chkHgId = 3;
            while (chkHgId != 0) {
                if ((lun = bitSet.nextClearBit(lun + 1)) >= SJctrPortUtility.PORT_LUN_MAX) {
                    this.logUty.putlog("makeDataModel", "LUN is Maximum Error(Consider to include Resouce Diff)!!!");
                    SJctrError error = new SJctrError(10, 22, 105207);
                    throw error.createException();
                }
                chkHgId = rscUtilLun.chkLunID(port, it, (short)lun);
            }
            SJmoPortLunDetail lunDetail = new SJmoPortLunDetail();
            lunDetail.setSPort(port);
            lunDetail.setSHostGroup(it);
            lunDetail.setSLUN((short)lun);
            lunDetail.setSLDKC(ldkc);
            lunDetail.setSCU(cu);
            lunDetail.setSLDEV(ldev);
            createLunList.add(lunDetail);
            lunDetail.setIDataMode(2);
            createItLunList.add(lunDetail);
        }
        createLunInfo.setAlPortLun(createLunList);
        int i = Collections.binarySearch(portDetailList, ptItInfo);
        if (i < 0) {
            this.logUty.putlog("makeDataModel", "Not found from PortDetail list: " + ptItInfo);
            SJctrError error = new SJctrError(10, 22, 106520);
            throw error.createException();
        }
        SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(i);
        StringBuilder buf = new StringBuilder();
        buf.append(portUtil.toPortNameDisplay(portDetail));
        buf.append(comUtil.getGuidance("SLASH"));
        buf.append(itInfo.getStrIscsiTargetAlias());
        String columnLabel = buf.toString();
        String columnKey = table.getNewColumnKey();
        SJctrLunIdCheckColumn column = new SJctrLunIdCheckColumn(columnKey, columnLabel, createItLunList, true);
        column.setBLunIdDec(this.isLunIdNotationDec());
        return column;
    }

    @Override
    public void rollback() {
        super.rollback();
        SJctrMapLunsTableModel table = (SJctrMapLunsTableModel)this.getDataObjectModel(KEY_TABLE);
        table.clearChildColumn();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrMapLunsTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(MAP_LUNS_MSG.CHANGE_LDEV, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMapLunsDC.this.makeChangeLdevSetingDialog();
            }
        });
        this.addMessageEventListener(MAP_LUNS_MSG.CHANGE_LU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map columMap = SJctrMapLunsDC.this.getSelectColumnMap();
                List changeList = SJctrMapLunsDC.this.createSelectLunList(columMap.values());
                HashMap param = new HashMap();
                param.put(SJctrChangeLunIdDC.KEY_SELECTPATHLDEV.getName(), changeList);
                List list = SJctrMapLunsDC.this.createPortLunInfo(columMap.keySet());
                param.put(SJctrMapLUNsSubWizard.KEY_PORT_LUN.getName(), list);
                SJctrRelatedDispDataObject related = SJctrMapLunsDC.this.createDialog(SJctrChangeLunIdDC.class, param);
                SJctrMapLunsDC.this.addUpdateDisp(related);
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map param = (Map)event.getNofifyObject();
                SJctrMapLunsDC.this.exitChangeLdevSetingDialog(param);
                SJctrMapLunsDC.this.exitChangeLunIdDialog(param);
            }
        });
    }

    private Map<SJctrPortHGIndex, SJctrLunIdCheckColumn> getSelectColumnMap() {
        SJctrMapLunsTableModel table = (SJctrMapLunsTableModel)this.getDataObjectModel(KEY_TABLE);
        Map<SJctrPortHGIndex, SJctrLunIdCheckColumn> selectMap = table.getSelectColumnMap();
        if (selectMap.isEmpty()) {
            this.logUty.putlog("getSelectColumnLunMap", "The column has not been selected.");
            SJctrError error = new SJctrError(10, 22, 105088);
            throw error.createException();
        }
        int DATA_LENGTH = 9;
        StringBuilder buf = new StringBuilder(576);
        for (SJctrPortHGIndex index : selectMap.keySet()) {
            buf.append(index.getPort());
            buf.append('-');
            buf.append(index.getHostGroup());
            buf.append(", ");
        }
        this.getLogUty().putlog("Select Port-HG: " + selectMap.size(), buf.substring(0, buf.length() - 2));
        return selectMap;
    }

    private List<SJctrLuPathLdevIndex> createSelectLunList(Collection<SJctrLunIdCheckColumn> columnList) {
        SJctrLogUty logger = this.getLogUty();
        SJctrMapLunsTableModel table = (SJctrMapLunsTableModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectList = table.getSelectedRowDataOrder();
        int selectLength = selectList.size();
        logger.putlog("getSelectLunList", "Select LDEV: " + selectLength);
        ArrayList<SJctrLuPathLdevIndex> retList = new ArrayList<SJctrLuPathLdevIndex>(columnList.size() * selectLength);
        for (SJctrLunIdCheckColumn column : columnList) {
            for (int i = 0; i < selectLength; ++i) {
                Object key = selectList.get(i);
                SJmoPortLunDetail lunDetail = column.getPortLunDetail(key);
                if (lunDetail == null) {
                    this.getLogUty().putlog("getSelectLunList", "Not found from PortLunDetail list: " + key, 40000);
                    SJctrError error = new SJctrError(10, 22, 107002);
                    throw error.createException();
                }
                SJctrLuPathLdevIndex luPath = this.toSJctrLuPathLdevIndex(lunDetail);
                retList.add(luPath);
            }
        }
        logger.putlog("getSelectLunList", "Change LUN: " + retList.size());
        return retList;
    }

    private List<SJmoPortLunInfo> createPortLunInfo(Set<SJctrPortHGIndex> keySet) {
        TreeSet<Short> portIdSet = new TreeSet<Short>();
        for (SJctrPortHGIndex index : keySet) {
            portIdSet.add(index.getPort());
        }
        ArrayList<SJmoPortLunInfo> retList = new ArrayList<SJmoPortLunInfo>(portIdSet.size());
        for (Short port : portIdSet) {
            SJmoPortLunInfo info = this.getPortLunInfo(port);
            retList.add(info);
        }
        return retList;
    }

    private void makeChangeLdevSetingDialog() {
        SJctrChangeLDEVNameData data = new SJctrChangeLDEVNameData();
        SJctrMapLunsTableModel table = (SJctrMapLunsTableModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectList = table.getSelectedRowDataOrder();
        ArrayList<Object> ldevNameList = new ArrayList<Object>();
        ldevNameList.addAll(selectList);
        ArrayList<SJmoLdevNicknameInfo> ldevNickList = new ArrayList<SJmoLdevNicknameInfo>();
        List<?> cacheList = this.getCache("KEY_TARGET_LDEV_NICKNAME");
        ArrayList targetLdevNickname = new ArrayList(cacheList);
        for (Object e : ldevNameList) {
            SJmoLdevNicknameInfo ldevNickname;
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)e;
            int ldevIndex = Collections.binarySearch(targetLdevNickname, ldevDetail);
            if (ldevIndex < 0) {
                ldevNickname = new SJmoLdevNicknameInfo();
                ldevNickname.setLdevIndex(ldevDetail.getSLdkc(), ldevDetail.getSCu(), ldevDetail.getSLdev());
            } else {
                SJmoLdevNicknameInfo ldevNick = (SJmoLdevNicknameInfo)targetLdevNickname.get(ldevIndex);
                try {
                    ldevNickname = (SJmoLdevNicknameInfo)ldevNick.clone();
                }
                catch (CloneNotSupportedException e2) {
                    this.logUty.putlog("makeChangeLdevSetingDialog", "clone(): " + ldevNick);
                    SJctrError error = new SJctrError(10, 22, 107002);
                    throw error.createException();
                }
            }
            ldevNickList.add(ldevNickname);
        }
        data.setLdevNameList(ldevNickList);
        ArrayList<SJctrChangeLDEVNameData> dataList = new ArrayList<SJctrChangeLDEVNameData>();
        dataList.add(data);
        HashMap param = new HashMap();
        param.put("CHANGE_LDEVNAME", dataList);
        SJctrRelatedDispDataObject related = this.createDialog(SJctrChangeLDEVSettingDC.class, param);
        this.addUpdateDisp(related);
    }

    private void exitChangeLdevSetingDialog(Map<String, List<?>> param) {
        List<?> changeLdevNameList = param.get("KEY_DD12_DIALOG_OUT_LDEVNAME");
        if (changeLdevNameList == null || changeLdevNameList.size() == 0) {
            return;
        }
        SJctrChangeLDEVNameData nameData = (SJctrChangeLDEVNameData)changeLdevNameList.get(0);
        ArrayList ldevNickList = new ArrayList();
        ldevNickList.addAll(nameData.getLdevNameList());
        List<?> cacheList = this.getCache("KEY_TARGET_LDEV_NICKNAME");
        ArrayList LdevNicknameList = new ArrayList(cacheList);
        List<?> cacheUpdateList = this.getCache("KEY_UPDATE_LDEV_NICKNAME");
        if (cacheUpdateList == null) {
            cacheUpdateList = new ArrayList();
        }
        TreeMap<String, SJmoLdevNicknameInfo> updateNicknameMap = new TreeMap<String, SJmoLdevNicknameInfo>();
        for (SJmoLdevNicknameInfo ldevNicknameUpd : cacheUpdateList) {
            updateNicknameMap.put(ldevNicknameUpd.toString(), ldevNicknameUpd);
        }
        Collections.sort(LdevNicknameList);
        for (int i = ldevNickList.size() - 1; i >= 0; --i) {
            SJmoLdevNicknameInfo chgLdevNick = (SJmoLdevNicknameInfo)ldevNickList.get(i);
            int index = Collections.binarySearch(LdevNicknameList, chgLdevNick);
            if (index >= 0) {
                LdevNicknameList.remove(index);
                LdevNicknameList.add(index, chgLdevNick);
            }
            updateNicknameMap.put(chgLdevNick.toString(), chgLdevNick);
        }
        Collections.sort(LdevNicknameList);
        this.putCache("KEY_TARGET_LDEV_NICKNAME", LdevNicknameList);
        ArrayList LdevNicknameUpdList = new ArrayList(updateNicknameMap.values());
        this.putCache("KEY_UPDATE_LDEV_NICKNAME", LdevNicknameUpdList);
        SJctrMapLunsTableModel table = (SJctrMapLunsTableModel)this.getDataObjectModel(KEY_TABLE);
        table.setUpdateModelData();
        table.doRefresh();
    }

    private void exitChangeLunIdDialog(Map<String, List<?>> param) {
        List<SJctrLuPathLdevIndex> lunList = param.get(SJctrChangeLunIdDC.KEY_CHANGELUNDATA.getName());
        if (lunList == null || lunList.isEmpty()) {
            return;
        }
        Map<SJctrPortHGIndex, List<SJmoPortLunDetail>> changeLunMap = this.createChangeLunData(lunList);
        this.updateCreateLuPath(changeLunMap);
        this.updateSelectColumnData(changeLunMap);
    }

    private Map<SJctrPortHGIndex, List<SJmoPortLunDetail>> createChangeLunData(List<SJctrLuPathLdevIndex> lunList) {
        HashMap<SJctrPortHGIndex, List<SJmoPortLunDetail>> retMap = new HashMap<SJctrPortHGIndex, List<SJmoPortLunDetail>>();
        Collections.sort(lunList);
        short nowPort = -1;
        short nowHg = -1;
        List nowList = Collections.emptyList();
        for (SJctrLuPathLdevIndex lunInfo : lunList) {
            short port = lunInfo.getPort();
            short hg = lunInfo.getHostGroup();
            if (nowPort != port || nowHg != hg) {
                nowPort = port;
                nowHg = hg;
                SJctrPortHGIndex key = new SJctrPortHGIndex();
                key.setPort(nowPort);
                key.setHostGroup(nowHg);
                nowList = new ArrayList();
                retMap.put(key, nowList);
            }
            SJmoPortLunDetail changeInfo = this.toSJmoPortLunDetail(lunInfo);
            nowList.add(changeInfo);
        }
        return retMap;
    }

    private void updateCreateLuPath(Map<SJctrPortHGIndex, List<SJmoPortLunDetail>> changeLunMap) {
        ArrayList<SJmoPortLunInfo> infoList = new ArrayList<SJmoPortLunInfo>(this.getCache("KEY_CREATE_LU_PATH"));
        List<?> lunUtilList = this.getCache(SJctrMapLUNsSubWizard.KEY_LUN_UTIL_DATA);
        SJmoRscUtilLun rscUtilLun = (SJmoRscUtilLun)lunUtilList.get(0);
        this.resetRscUtil();
        for (Map.Entry<SJctrPortHGIndex, List<SJmoPortLunDetail>> entry : changeLunMap.entrySet()) {
            SJctrPortHGIndex portHgIndex = entry.getKey();
            SJmoPortIndex keyObj = new SJmoPortIndex();
            keyObj.setSPort(portHgIndex.getPort());
            int index = Collections.binarySearch(infoList, keyObj);
            if (index < 0) {
                this.getLogUty().putlog("updateCreateLuPath", "Not found from PortLunDetail list: " + keyObj, 40000);
                SJctrError error = new SJctrError(10, 22, 107002);
                throw error.createException();
            }
            SJmoPortLunInfo info = (SJmoPortLunInfo)infoList.get(index);
            ArrayList createLunList = info.getAlPortLun();
            Collections.sort(createLunList, SJctrLunIdCheckColumn.PORT_HG_LDEV_COMPARATOR);
            List<SJmoPortLunDetail> changeLunList = entry.getValue();
            int listSize = changeLunList.size();
            for (int i = 0; i < listSize; ++i) {
                SJmoPortLunDetail key = changeLunList.get(i);
                int index2 = Collections.binarySearch(createLunList, key, SJctrLunIdCheckColumn.PORT_HG_LDEV_COMPARATOR);
                if (index2 >= 0) {
                    createLunList.set(index2, key);
                    continue;
                }
                this.getLogUty().putlog("updateCreateLuPath", "Not found from Cache PortLunDetail list: " + key);
            }
        }
        this.putCache("KEY_CREATE_LU_PATH", infoList);
        this.setRscRsv(infoList, rscUtilLun);
    }

    private void updateSelectColumnData(Map<SJctrPortHGIndex, List<SJmoPortLunDetail>> changeLunMap) {
        SJctrMapLunsTableModel table = (SJctrMapLunsTableModel)this.getDataObjectModel(KEY_TABLE);
        Map<SJctrPortHGIndex, SJctrLunIdCheckColumn> selectColumnMap = table.getSelectColumnMap();
        for (Map.Entry<SJctrPortHGIndex, List<SJmoPortLunDetail>> entry : changeLunMap.entrySet()) {
            SJctrPortHGIndex portHgIndex = entry.getKey();
            SJctrLunIdCheckColumn selectColumn = selectColumnMap.get(portHgIndex);
            List<SJmoPortLunDetail> createLunList = selectColumn.getLunList();
            Collections.sort(createLunList, SJctrLunIdCheckColumn.PORT_HG_LDEV_COMPARATOR);
            List<SJmoPortLunDetail> changeLunList = entry.getValue();
            int listSize = changeLunList.size();
            for (int i = 0; i < listSize; ++i) {
                SJmoPortLunDetail key = changeLunList.get(i);
                int index = Collections.binarySearch(createLunList, key, SJctrLunIdCheckColumn.PORT_HG_LDEV_COMPARATOR);
                if (index >= 0) {
                    createLunList.set(index, key);
                    continue;
                }
                this.getLogUty().putlog("updateSelectColumnData", "Not found from Cache PortLunDetail list: " + key);
            }
            Collections.sort(createLunList, SJctrLunIdCheckColumn.LDEV_COMPARATOR);
            table.doRefresh(selectColumn.getMyFullPathKey());
        }
    }

    private SJmoPortLunInfo getPortLunInfo(short port) {
        ArrayList defineLunList;
        ArrayList createLunList;
        SJmoPortIndex keyObj = new SJmoPortIndex();
        keyObj.setSPort(port);
        List<?> infoList = this.getCache("KEY_CREATE_LU_PATH");
        int index = Collections.binarySearch(infoList, keyObj);
        if (index >= 0) {
            SJmoPortLunInfo info = (SJmoPortLunInfo)infoList.get(index);
            createLunList = info.getAlPortLun();
        } else {
            createLunList = Collections.emptyList();
        }
        SJmoPortLunInfo copy = null;
        List<?> infoList2 = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_LUN);
        int index2 = Collections.binarySearch(infoList2, keyObj);
        if (index2 >= 0) {
            SJmoPortLunInfo info = (SJmoPortLunInfo)infoList2.get(index2);
            defineLunList = info.getAlPortLun();
            try {
                copy = (SJmoPortLunInfo)info.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logUty.putlog("getPortLunInfo", "clone(): " + info);
                SJctrError error = new SJctrError(10, 22, 107002);
                throw error.createException();
            }
        } else {
            defineLunList = Collections.emptyList();
            copy = new SJmoPortLunInfo();
            copy.setSPort(port);
        }
        ArrayList mixList = new ArrayList(createLunList.size() + defineLunList.size());
        mixList.addAll(createLunList);
        mixList.addAll(defineLunList);
        copy.setAlPortLun(mixList);
        return copy;
    }

    private SJctrLuPathLdevIndex toSJctrLuPathLdevIndex(SJmoPortLunDetail src) {
        SJctrLuPathLdevIndex ret = new SJctrLuPathLdevIndex(src.getSPort(), src.getSHostGroup(), src.getSLUN(), src.getSLDKC(), src.getSCU(), src.getSLDEV());
        return ret;
    }

    private SJmoPortLunDetail toSJmoPortLunDetail(SJctrLuPathLdevIndex src) {
        SJmoPortLunDetail ret = new SJmoPortLunDetail();
        ret.setSPort(src.getPort());
        ret.setSHostGroup(src.getHostGroup());
        ret.setSLUN(src.getLun());
        ret.setSLDKC(src.getLdkc());
        ret.setSCU(src.getCu());
        ret.setSLDEV(src.getLdev());
        ret.setIDataMode(2);
        return ret;
    }

    private void setRscRsv(List<SJmoPortLunInfo> infoList, SJmoRscUtilLun rscUtilLun) {
        rscUtilLun.clearRsvData();
        ArrayList createHgLunList = new ArrayList();
        for (SJmoPortLunInfo lunInfo : infoList) {
            ArrayList allPortLun = lunInfo.getAlPortLun();
            createHgLunList.addAll(allPortLun);
        }
        ArrayList rsvList = new ArrayList();
        rsvList.add(createHgLunList);
        rscUtilLun.setRsvData(rsvList);
        ArrayList<SJmoRscUtilLun> rscUtilLunLst = new ArrayList<SJmoRscUtilLun>();
        rscUtilLunLst.add(rscUtilLun);
        this.putCache(SJctrMapLUNsSubWizard.KEY_LUN_UTIL_DATA, rscUtilLunLst);
    }

    private boolean isLunIdNotationDec() {
        boolean bRet = false;
        SJbaseUserSessionInterface userSession = this.getOwner().getUserSession();
        bRet = SJctrPortUtility.isLunIdDecimal(userSession);
        return bRet;
    }

    public static enum MAP_LUNS_MSG implements SJctrNotifyState
    {
        CHANGE_LDEV,
        CHANGE_LU;

    }
}

