/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.relhostreserve.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.serverux.dataimpl.LUNMgetHostReserved;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.column.SJctrLdevIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLunIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrParentColumn;
import sanproject.sn2.controller.com.column.SJctrPathNumColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrPortNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrVSSDeviceNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrVSSLdevIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrVSSSsidColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrVirtualStorageSystemColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetailComparator;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.com.SJctrGetHostReserve;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.com.SJctrRsvStatusColumnFromPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.properties.SJctrHostReserveDC;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;

public class SJctrHostReserveLunTableModel
extends SJctrTableDataModel {
    public static final String KEY_COL_PTNAME = "COM_COL_PTNAME";
    public static final String KEY_COL_LUNID = "COM_COL_LUNID";
    public static final String KEY_COL_LDEVID = "COM_COL_LDEVID";
    public static final String KEY_COL_LDEVNAME = "COM_COL_LDEVNAME";
    public static final String KEY_COL_LUNNUM = "COM_COL_LUNNUM";
    public static final String KEY_COL_HTRSVST = "COM_COL_HTRSVST";
    public static final String KEY_COL_VSS_UVM_MODE = "COM_COL_HUVM_MODE";
    public static final String KEY_COL_VSS = "COM_COL_VSS";
    public static final String KEY_COL_VSS_MDL_SN = "COM_COL_VSS_MDL_SN";
    public static final String KEY_COL_VSS_LDEVID = "COM_COL_VSS_LDEVID";
    public static final String KEY_COL_VSS_DEVNAME = "COM_COL_VSS_DEVNAME";
    public static final String KEY_COL_VSS_SSID = "COM_COL_VSS_SSID";
    public static final String GUID_VSS = "VDKC";
    public static int HOSTRSV_ERR_CACHE_INVALID_LEVEL4 = 107002;
    public static int HOSTRSV_ERR_PORT_NOT_EXIST_LEVEL4 = 106501;
    static final SJctrPortLunDetailComparator PORTLUN_COMP = new SJctrPortLunDetailComparator();

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        SJctrHostReserveDC dc = (SJctrHostReserveDC)this.getDataController();
        List<?> cacheKeyList = dc.getProxy().getCache("KEY_PORTLUN_TO_VIEWHOSTRSV");
        if (cacheKeyList == null || cacheKeyList.size() == 0) {
            return new ArrayList(0);
        }
        ArrayList<SJctrPortLunTableKey> retList = new ArrayList<SJctrPortLunTableKey>(cacheKeyList.size());
        List<?> moPortLunInfoList = this.getDataController().getProxy().getCache(SJmoGetPortLunInfo.class);
        if (moPortLunInfoList == null || moPortLunInfoList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoGetPortLunInfo Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_CACHE_INVALID_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortIndex portIndex = new SJmoPortIndex();
        SJctrPortLunTableKey firstKey = (SJctrPortLunTableKey)cacheKeyList.get(0);
        portIndex.setSPort(firstKey.getPortLunInfo().getSPort());
        int searchIdx = Collections.binarySearch(moPortLunInfoList, portIndex);
        if (searchIdx < 0) {
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_PORT_NOT_EXIST_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortLunInfo moPortLunInfo = (SJmoPortLunInfo)moPortLunInfoList.get(searchIdx);
        ArrayList moPortLunDtlList = moPortLunInfo.getAlPortLun();
        Collections.sort(moPortLunDtlList, PORTLUN_COMP);
        List<LUNMgetHostReserved> hostReserveList = dc.getHostReservedList(firstKey);
        if (hostReserveList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Getting Host-Reserved info failed.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_CACHE_INVALID_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        if (hostReserveList.size() == 0) {
            return new ArrayList(0);
        }
        this.setBasicData(SJctrGetHostReserve.class, hostReserveList);
        block0: for (int i = 0; i < cacheKeyList.size(); ++i) {
            SJctrPortLunTableKey tableKey = (SJctrPortLunTableKey)cacheKeyList.get(i);
            searchIdx = Collections.binarySearch(moPortLunDtlList, tableKey.getPortLunDetail(), PORTLUN_COMP);
            if (searchIdx < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Port#= " + portIndex.getSPort() + ", HostGroup#= " + tableKey.getPortLunDetail().getSHostGroup() + ", Lun= " + tableKey.getPortLunDetail().getSLUN() + " Not Found!!!");
                continue;
            }
            SJmoPortLunDetail moPortLunDetail = (SJmoPortLunDetail)moPortLunDtlList.get(searchIdx);
            short sLun = moPortLunDetail.getSLUN();
            for (int j = 0; j < hostReserveList.size(); ++j) {
                LUNMgetHostReserved hostReserve = hostReserveList.get(j);
                if (sLun != hostReserve.getSLUN()) continue;
                if (hostReserve.getLHostReserved() == 0L || hostReserve.getLHostReserved() == 64L) continue block0;
                SJctrPortLunTableKey newTableKey = new SJctrPortLunTableKey(moPortLunInfo, moPortLunDetail);
                retList.add(newTableKey);
                continue block0;
            }
        }
        return retList;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrPortNameColumnFromPortLunTableKey(KEY_COL_PTNAME));
        this.addColumn(new SJctrLunIdColumnFromPortLunTableKey(KEY_COL_LUNID));
        this.addColumn(new SJctrLdevIdColumnFromPortLunTableKey(KEY_COL_LDEVID));
        this.addColumn(new SJctrLdevNameColumnFromPortLunTableKey(KEY_COL_LDEVNAME));
        this.addColumn(new SJctrPathNumColumnFromPortLunTableKey(KEY_COL_LUNNUM));
        this.addColumn(new SJctrRsvStatusColumnFromPortLunTableKey(KEY_COL_HTRSVST));
        SJctrParentColumn vssParentsColumn = new SJctrParentColumn(KEY_COL_VSS);
        vssParentsColumn.setPartsId(GUID_VSS);
        this.addColumn(vssParentsColumn);
        vssParentsColumn.addColumn(new SJctrVirtualStorageSystemColumnFromPortLunTableKey(KEY_COL_VSS_MDL_SN));
        vssParentsColumn.addColumn(new SJctrVSSLdevIdColumnFromPortLunTableKey(KEY_COL_VSS_LDEVID));
        vssParentsColumn.addColumn(new SJctrVSSDeviceNameColumnFromPortLunTableKey(KEY_COL_VSS_DEVNAME));
        vssParentsColumn.addColumn(new SJctrVSSSsidColumnFromPortLunTableKey(KEY_COL_VSS_SSID));
        this.setPrimaryColumn(KEY_COL_LUNID);
    }
}

