/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.addnewmonwwns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrMonPortWWNComparator;
import sanproject.sn2.controller.com.comparator.SJctrMonitorAvailablePortsInfoComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.addnewmonwwns.SJctrAddNewMonWWNsConfirmData;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorAvailablePortsInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorAvailablePortsTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorPortWWNInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorWWNsTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPPCALLPortWWNInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortWwnInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortWwnInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.monitor.SJmoPPCALLPortWWNInfo;

public class SJctrAddNewMonWWNsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100901;
    private static final String[] DISP_TITLE = SJctrOptionMonitorGuidance.ADD_NEW_MON_WWN;
    private static final String KEY_HBA_WWN_INF = "COM_HBA_WWN_INF";
    private static final String KEY_WWN_NAME_INF = "COM_WWN_NAME_INF";
    private static final String KEY_TABLE_PORTS = "COM_TABLE_PORTS";
    private static final String KEY_TABLE_MON_WWN = "COM_TABLE_MON_WWN";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_DELETE = "COM_DELETE";
    private static final SJctrMonitorAvailablePortsInfoComparator AVA_PORT_COMP = new SJctrMonitorAvailablePortsInfoComparator();
    protected static final SJctrMonPortWWNComparator PORT_WWN_COMP = new SJctrMonPortWWNComparator();

    public SJctrAddNewMonWWNsDC() throws SJcException {
        super(0x1100901);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPPCALLPortWWNInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortWwnInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        SJctrTextBoxDataModel hbaWwnTextBox = new SJctrTextBoxDataModel();
        hbaWwnTextBox.setValue("");
        hbaWwnTextBox.setVisible(true);
        this.addDataObjectModel(KEY_HBA_WWN_INF, hbaWwnTextBox);
        SJctrTextBoxDataModel wwnNameTextBox = new SJctrTextBoxDataModel();
        wwnNameTextBox.setValue("");
        wwnNameTextBox.setVisible(true);
        this.addDataObjectModel(KEY_WWN_NAME_INF, wwnNameTextBox);
        this.addDataObjectModel(KEY_TABLE_PORTS, new SJctrMonitorAvailablePortsTableModel());
        SJctrMonitorWWNsTableModel wwnTable = new SJctrMonitorWWNsTableModel();
        wwnTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_MON_WWN, wwnTable);
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAddNewMonWWNsDC.this.fireMessageEvent(ADD_NEW_WWNS_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel deleteButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DELETE, deleteButton);
        deleteButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAddNewMonWWNsDC.this.fireMessageEvent(ADD_NEW_WWNS_MSG.SELECT_DELETE);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(ADD_NEW_WWNS_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddNewMonWWNsDC.this.addMonWwnsAction(event, dstModel);
                SJctrAddNewMonWWNsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addMessageEventListener(ADD_NEW_WWNS_MSG.SELECT_DELETE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddNewMonWWNsDC.this.deleteMonWwnsAction(event, dstModel);
                SJctrAddNewMonWWNsDC.this.setFinishChangeCheck(true);
            }
        });
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoPPCALLPortWWNInfo> monWwnInfos = SJctrOptionMonitorUtility.getPPCALLPortWWNInfo(this);
            List<SJmoPortWwnInfo> loginWwnInfos = SJctrOptionMonitorUtility.getSJmoPortWwnInfo(this);
            List<SJmoPortHostGroupInfo> lunmWwnInfos = SJctrOptionMonitorUtility.getSJmoPortHostGroupInfo(this);
            List<SJmoPortDetail> portDetails = SJctrOptionMonitorUtility.getSJmoPortDetail(this);
            int monitoredWwnCount = SJctrOptionMonitorUtility.getMonitoringWWNCount(monWwnInfos, portDetails);
            if (monitoredWwnCount >= 2048) {
                SJctrError err = new SJctrError(51, 22, 105229);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJctrMonitorAvailablePortsInfo> portList = SJctrOptionMonitorUtility.fillterAvailableMonPorts(monWwnInfos, loginWwnInfos, lunmWwnInfos, portDetails);
            if (0 == portList.size()) {
                SJctrError err = new SJctrError(51, 22, 105108);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrMonitorAvailablePortsTableModel availablePortsTable = (SJctrMonitorAvailablePortsTableModel)this.getDataObjectModel(KEY_TABLE_PORTS);
            Collections.sort(portList, AVA_PORT_COMP);
            availablePortsTable.setBasicDataList(portList);
            SJctrTextBoxDataModel hbaWwnTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HBA_WWN_INF);
            hbaWwnTextBox.setLabel(SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.DISP_HBA_WWN_MAX_CHAR));
            SJctrTextBoxDataModel wwnNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_WWN_NAME_INF);
            wwnNameTextBox.setLabel(SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.DISP_WWN_NAME_MAX_CHAR));
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        SJctrAddNewMonWWNsConfirmData confirmData = new SJctrAddNewMonWWNsConfirmData();
        SJctrMonitorWWNsTableModel selectedWwnTable = (SJctrMonitorWWNsTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWN);
        List<Object> selectedList = selectedWwnTable.getAllRowData();
        Collections.sort(selectedList, PORT_WWN_COMP);
        confirmData.setMonitorWwns(selectedList);
        ArrayList<SJctrAddNewMonWWNsConfirmData> confirmDataList = new ArrayList<SJctrAddNewMonWWNsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrAddNewMonWWNsConfirmData.class, confirmDataList);
        this.setFinishChangeCheck(false);
        return true;
    }

    private void addMonWwnsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrError err;
            List<SJmoPPCALLPortWWNInfo> monWwnInfos = SJctrOptionMonitorUtility.getPPCALLPortWWNInfo(this);
            List<SJmoPortWwnInfo> loginWwnInfos = SJctrOptionMonitorUtility.getSJmoPortWwnInfo(this);
            List<SJmoPortHostGroupInfo> lunmWwnInfos = SJctrOptionMonitorUtility.getSJmoPortHostGroupInfo(this);
            List<SJmoPortDetail> portDetails = SJctrOptionMonitorUtility.getSJmoPortDetail(this);
            SJctrTextBoxDataModel hbaWwnTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HBA_WWN_INF);
            String strHbaWwn = hbaWwnTextBox.getValue();
            SJctrTextBoxDataModel wwnNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_WWN_NAME_INF);
            String strWwnName = wwnNameTextBox.getValue();
            SJctrMonitorWWNsTableModel selectedWwnTable = (SJctrMonitorWWNsTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWN);
            List<Object> selectedList = selectedWwnTable.getAllRowData();
            if (SJctrOptionMonitorUtility.isDuplicationWWNNameAddNew(strHbaWwn, strWwnName, selectedList, monWwnInfos, portDetails)) {
                SJctrError err2 = new SJctrError(51, 22, 105104);
                SJcException exp2 = err2.createException();
                throw exp2;
            }
            SJctrMonitorAvailablePortsTableModel availablePortsTable = (SJctrMonitorAvailablePortsTableModel)this.getDataObjectModel(KEY_TABLE_PORTS);
            List<Object> addData = availablePortsTable.getSelectedRowDataOrder();
            ArrayList<SJctrMonitorPortWWNInfo> addList = new ArrayList<SJctrMonitorPortWWNInfo>();
            SJmoWwn wwnInfo = new SJmoWwn();
            strHbaWwn = strHbaWwn.toUpperCase();
            wwnInfo.setByWWN(SJctrComUtility.toByteFromString(strHbaWwn));
            wwnInfo.setStrWWNNickName(strWwnName);
            for (SJctrMonitorAvailablePortsInfo sJctrMonitorAvailablePortsInfo : addData) {
                SJctrMonitorPortWWNInfo monPortWwnInfo = new SJctrMonitorPortWWNInfo(wwnInfo, sJctrMonitorAvailablePortsInfo.getPortDetail());
                addList.add(monPortWwnInfo);
            }
            if (SJctrOptionMonitorUtility.isDuplicationHBAWWNAddnew(strHbaWwn, addList, selectedList, monWwnInfos, loginWwnInfos, lunmWwnInfos, portDetails)) {
                err = new SJctrError(51, 22, 105103);
                SJcException sJcException = err.createException();
                throw sJcException;
            }
            if (SJctrOptionMonitorUtility.isOverMonitoringWWNsMaxAddNew(addList, selectedList, monWwnInfos, portDetails)) {
                err = new SJctrError(51, 22, 105115);
                SJcException sJcException = err.createException();
                throw sJcException;
            }
            List<SJctrMonitorPortWWNInfo> overPorts = SJctrOptionMonitorUtility.getOverMonitoringWWNsMaxPortsAddNew(addList, selectedList, monWwnInfos, portDetails);
            if (0 < overPorts.size()) {
                SJctrMonitorWWNsTableModel sJctrMonitorWWNsTableModel = new SJctrMonitorWWNsTableModel();
                sJctrMonitorWWNsTableModel.initGuidance(this.getComUtility());
                sJctrMonitorWWNsTableModel.setPaging(false);
                sJctrMonitorWWNsTableModel.addRowData(overPorts);
                SJctrRelatedDispDataObject related = this.createDialog(SJctrErrorDataController.class, null);
                SJctrErrorDataController errorDialog = (SJctrErrorDataController)this.getOwner().getDataController(related);
                errorDialog.setParameter(sJctrMonitorWWNsTableModel);
                SJctrError error = new SJctrError(51, 22, 105116);
                SJcException exp3 = error.createException();
                exp3.setErrDisp(related);
                throw exp3;
            }
            selectedWwnTable.addRowData(addList, 0);
            List<Object> list = selectedWwnTable.getFilterData(addList);
            selectedWwnTable.setRowSelectionList(list);
            selectedWwnTable.setCurrentPage(Integer.toString(1));
            selectedWwnTable.setVScrollReset(true);
            selectedWwnTable.setSortColumn(null, Boolean.TRUE);
            this.updateFooter();
            selectedWwnTable.setDirty();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107004);
        }
    }

    private void deleteMonWwnsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrMonitorWWNsTableModel selectedWwnTable = (SJctrMonitorWWNsTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWN);
        selectedWwnTable.removeSelectedRowData();
        this.updateFooter();
        selectedWwnTable.setDirty();
    }

    private void setFinishChangeCheck(boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    public static enum ADD_NEW_WWNS_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_DELETE;

    }
}

