/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.serverux.data.MonMonitoringInfoLDKC;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorWarningMsgFlagData;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrDispObjDataInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrDispObjDataModel;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrDispTermDataModelEx;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrEditGraphDispObjDC;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrMonitorPerformanceUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrMonitorWindowDC;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrSelectDispTermInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.table.SJctrAvailableObjectsTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.table.SJctrSelectedObjectsTableModel;
import sanproject.sn2.model.connector.kind.SJmoGetPPCALLPortWWNInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.monitor.SJmoPPCALLPortWWNInfo;

public class SJctrMonitorPerformanceDC
extends SJctrEditGraphDispObjDC {
    protected static final int DISP_ID = 33599491;
    public static final Set<SJctrFooterDataModel.Button> BGO_APPLYCANCEL = Collections.unmodifiableSet(EnumSet.of(SJctrFooterDataModel.Button.APPLY, SJctrFooterDataModel.Button.DLG_CANCEL));
    public static final String KEY_DISP_TERM = "COM_DISP_TERM";
    public static final String KEY_CONFIRM = "COM_CONFIRM";

    public SJctrMonitorPerformanceDC() throws SJcException {
        super(33599491);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    @Override
    protected void initDataModel() {
        SJctrAvailableObjectsTableModel avaTable = new SJctrAvailableObjectsTableModel();
        this.addDataObjectModel("COM_TABLE_MON_AVAILABLE", avaTable);
        this.addDataObjectModel(KEY_DISP_TERM, new SJctrDispTermDataModelEx());
        this.addDataObjectModel("COM_DISP_OBJ", new SJctrDispObjDataModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_ADD", addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                ArrayList param = new ArrayList();
                SJctrMonitorPerformanceDC.this.fireMessageEvent(MON_PF_MSG.SELECT_ADD, param);
            }
        });
        SJctrSelectedObjectsTableModel selTable = new SJctrSelectedObjectsTableModel();
        this.addDataObjectModel("COM_TABLE_MON_OBJECT", selTable);
        SJctrButtonDataModel deleteButton = selTable.getButton("COM_DELETE");
        deleteButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                ArrayList param = new ArrayList();
                SJctrMonitorPerformanceDC.this.fireMessageEvent(MON_PF_MSG.SELECT_DELETE, param);
            }
        });
        this.addDataObjectModel(KEY_CONFIRM, new SJctrOptionMonitorWarningMsgFlagData());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(BGO_APPLYCANCEL));
    }

    @Override
    protected void initListener() {
        this.addMessageEventListener(MON_PF_MSG.CHG_MONDATATYPE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "MON_PF_MSG.CHG_MONDATATYPE Start");
                SJctrDispTermDataModelEx termDataModel = (SJctrDispTermDataModelEx)SJctrMonitorPerformanceDC.this.getDataObjectModel(SJctrMonitorPerformanceDC.KEY_DISP_TERM);
                termDataModel.initUpdateFlg();
                SJctrMonitorPerformanceDC.this.doChgMonDataType();
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "MON_PF_MSG.CHG_MONDATATYPE End");
            }
        });
        this.addMessageEventListener(SJctrEditGraphDispObjDC.MON_EDTOBJ_MSG.CHG_MON_OBJECT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "MON_EDTOBJ_MSG.CHG_MON_OBJECT Start");
                SJctrDispTermDataModelEx termDataModel = (SJctrDispTermDataModelEx)SJctrMonitorPerformanceDC.this.getDataObjectModel(SJctrMonitorPerformanceDC.KEY_DISP_TERM);
                termDataModel.initUpdateFlg();
                SJctrMonitorPerformanceDC.this.doChgMonObject();
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "MON_EDTOBJ_MSG.CHG_MON_OBJECT End");
            }
        });
        this.addMessageEventListener(MON_PF_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "MON_PF_MSG.SELECT_ADD Start");
                SJctrDispTermDataModelEx termDataModel = (SJctrDispTermDataModelEx)SJctrMonitorPerformanceDC.this.getDataObjectModel(SJctrMonitorPerformanceDC.KEY_DISP_TERM);
                termDataModel.initUpdateFlg();
                SJctrMonitorPerformanceDC.this.doSelectAdd();
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "MON_PF_MSG.SELECT_ADD End");
            }
        });
        this.addMessageEventListener(MON_PF_MSG.SELECT_DELETE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "MON_PF_MSG.SELECT_DELETE Start");
                SJctrDispTermDataModelEx termDataModel = (SJctrDispTermDataModelEx)SJctrMonitorPerformanceDC.this.getDataObjectModel(SJctrMonitorPerformanceDC.KEY_DISP_TERM);
                termDataModel.initUpdateFlg();
                SJctrMonitorPerformanceDC.this.doSelectDelete();
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "MON_PF_MSG.SELECT_DELETE End");
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.APPLY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "WIZ_MSG.APPLY Start");
                SJctrMonitorPerformanceDC.this.checkEndData();
                HashMap param = new HashMap();
                SJctrSelectedObjectsTableModel selectedTable = (SJctrSelectedObjectsTableModel)SJctrMonitorPerformanceDC.this.getDataObjectModel("COM_TABLE_MON_OBJECT");
                param.put("KEY_SELECT_OBJ", selectedTable.getAllRowData());
                SJctrDispTermDataModelEx termDataModel = (SJctrDispTermDataModelEx)SJctrMonitorPerformanceDC.this.getDataObjectModel(SJctrMonitorPerformanceDC.KEY_DISP_TERM);
                SJctrSelectDispTermInfo dispTermInfo = termDataModel.getSelectDispTermInfo();
                ArrayList<SJctrSelectDispTermInfo> terms = new ArrayList<SJctrSelectDispTermInfo>();
                terms.add(dispTermInfo);
                param.put("KEY_SEL_DISP_TERM", terms);
                SJctrRelatedDispDataObject newRelated = SJctrMonitorPerformanceDC.this.createDialog(SJctrMonitorWindowDC.class, param);
                SJctrUserController uc = SJctrMonitorPerformanceDC.this.getOwner();
                SJctrRelatedDispDataObject removeRelated = uc.removeRelatedDispData(SJctrMonitorPerformanceDC.this.getuId());
                SJctrMonitorPerformanceDC.this.addUpdateDisp(removeRelated);
                SJctrMonitorPerformanceDC.this.addUpdateDisp(newRelated);
                SJctrMonitorPerformanceDC.this.getLogUty().putlog("doMessageAction", "WIZ_MSG.APPLY End");
            }
        });
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = false;
        try {
            this.getProxy().getCacheMap().remove("KEY_SELECT_OBJ_SHORT");
            this.getProxy().getCacheMap().remove("KEY_SELECT_OBJ_LONG");
            SJctrMonitorPerformanceUtility.reqMonMonitoringModel(this, this.logUty);
            MonMonitoringInfoLDKC monitoringInfo = this.getMonMonitoringInfo();
            if (!monitoringInfo.getLongRangeInfo().isExist() && !monitoringInfo.getShortRangeInfo().isExist()) {
                this.logUty.putlog("checkConstructData", "isExist = false");
                SJctrError error = new SJctrError(51, 22, 105112);
                throw error.createException();
            }
            SJctrMonitorPerformanceUtility.reqMonitoredWWNModel(this, this.logUty);
            List<SJmoPPCALLPortWWNInfo> monWwns = this.getProxy().getCache(SJmoGetPPCALLPortWWNInfo.class);
            SJctrMonitorPerformanceUtility.reqPortDetailInfoModel(this, this.logUty);
            List<SJmoPortDetail> portDetails = this.getProxy().getCache(SJmoGetPortDetail.class);
            SJctrOptionMonitorWarningMsgFlagData confirmFlagModel = (SJctrOptionMonitorWarningMsgFlagData)this.getDataObjectModel(KEY_CONFIRM);
            int monCusCount = SJctrOptionMonitorUtility.getMonitoringCUCount(monitoringInfo);
            int monWwnsCount = SJctrOptionMonitorUtility.getMonitoringWWNCount(monWwns, portDetails);
            if (0 < monCusCount && 0 < monWwnsCount) {
                confirmFlagModel.setWarningFlag(0);
            } else {
                confirmFlagModel.setWarningFlag(1);
            }
            SJctrDispTermDataModelEx termDataModel = (SJctrDispTermDataModelEx)this.getDataObjectModel(KEY_DISP_TERM);
            termDataModel.constructDataModel(monitoringInfo);
            SJctrDispObjDataModel dispObjDataModel = (SJctrDispObjDataModel)this.getDataObjectModel("COM_DISP_OBJ");
            SJctrSelectedObjectsTableModel selectedTable = (SJctrSelectedObjectsTableModel)this.getDataObjectModel("COM_TABLE_MON_OBJECT");
            dispObjDataModel.setMonitorObjComboData(termDataModel.getMonDataType(), null, selectedTable.getAllRowData());
            SJctrDispObjDataInfo dispObjInfo = this.getDispObjDataInfo();
            SJctrAvailableObjectsTableModel avaTable = dispObjDataModel.changeMonitoringObject(dispObjInfo);
            this.addDataObjectModel("COM_TABLE_MON_AVAILABLE", avaTable);
            avaTable.makeDataModel();
            avaTable.initGuidance(this.getComUtility());
            avaTable.updateTableData(termDataModel.getMonDataType(), null);
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107002);
        }
        ret = true;
        return ret;
    }

    @Override
    public void makeDataModel() {
        this.makeDataModelParent();
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            SJctrMonitorPerformanceUtility.checkTermData(termInfo, this.getMonMonitoringInfo(), this.logUty);
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107003);
        }
        return true;
    }

    protected void doChgMonDataType() {
        try {
            SJctrDispObjDataModel dispObjDataModel = (SJctrDispObjDataModel)this.getDataObjectModel("COM_DISP_OBJ");
            SJctrSelectedObjectsTableModel selectedTable = (SJctrSelectedObjectsTableModel)this.getDataObjectModel("COM_TABLE_MON_OBJECT");
            SJctrDispTermDataModelEx termDataModel = (SJctrDispTermDataModelEx)this.getDataObjectModel(KEY_DISP_TERM);
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            List<Object> nowList = selectedTable.getAllRowData();
            int oldMonType = 0;
            if (termInfo.getMonDataType() == 0) {
                oldMonType = 1;
            }
            SJctrAvailableObjectsTableModel avaTable = (SJctrAvailableObjectsTableModel)this.getDataObjectModel("COM_TABLE_MON_AVAILABLE");
            this.saveSelectedObjects(oldMonType, nowList);
            List<Object> selList = this.loadSelectedObjects(termInfo.getMonDataType());
            selectedTable.clearRowData();
            selectedTable.doRefresh();
            if (selList != null) {
                selectedTable.addRowData(selList);
            }
            selectedTable.setDirty();
            MonMonitoringInfoLDKC monitoringInfo = this.getMonMonitoringInfo();
            termDataModel.initDisplayType(monitoringInfo);
            termDataModel.setDefaultTerm(monitoringInfo);
            dispObjDataModel.setMonitorObjComboData(termInfo.getMonDataType(), null, selList);
            SJctrDispObjDataInfo dispObjInfo = this.getDispObjDataInfo();
            avaTable = dispObjDataModel.changeMonitoringObject(dispObjInfo);
            this.addDataObjectModel("COM_TABLE_MON_AVAILABLE", avaTable);
            avaTable.makeDataModel();
            avaTable.initGuidance(this.getComUtility());
            avaTable.updateTableData(termInfo.getMonDataType(), selList);
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107015);
        }
    }

    public void saveSelectedObjects(int monDataType, List<Object> data) {
        String key = "KEY_SELECT_OBJ_LONG";
        if (monDataType == 0) {
            key = "KEY_SELECT_OBJ_SHORT";
        }
        this.putCache(key, data);
    }

    public List<Object> loadSelectedObjects(int monDataType) {
        List<Object> ret = null;
        String key = "KEY_SELECT_OBJ_LONG";
        if (monDataType == 0) {
            key = "KEY_SELECT_OBJ_SHORT";
        }
        ret = this.getCache(key);
        return ret;
    }

    @Override
    public SJctrSelectDispTermInfo getSelectDispTermInfo() {
        SJctrDispTermDataModelEx termDataModel = (SJctrDispTermDataModelEx)this.getDataObjectModel(KEY_DISP_TERM);
        return termDataModel.getSelectDispTermInfo();
    }

    public static enum MON_PF_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_DELETE,
        CHG_MONDATATYPE,
        SELECT_APPLY;

    }
}

