/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.graph;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import sanproject.serverux.arg.monitor.HIHsmPhysicalOwnerUseRateArgInfo;
import sanproject.serverux.data.HIHsmPhysicalOwnerUseRate;
import sanproject.serverux.data.MonMonitoringInfoLDKC;
import sanproject.serverux.data.MonitorElementInfo;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorMessage;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrAddNewGraphDC;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrChgGraphDispTermDC;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrEditGraphDispObjDC;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrMonitorPerformanceUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrPlotDataInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrSelectDispTermInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrSelectedObjectInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.param.SJctrGetPlotParam;
import sanproject.sn2.controller.wizard.monitor.optmon.mpproperties.SJctrMPPropertiesDialogDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetMonMonitoringInfoLDKC;
import sanproject.sn2.model.connector.kind.SJmoGetMonitorInfoCollection;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.monitor.SJmoMPCompositionInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrMonitorWindowDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33603585;
    private static final String KEY_GRAPH_INFO = "COM_GRAPH_INFO";
    private static final String KEY_Y_SCALE = "COM_Y_SCALE_";
    private static final String KEY_GRAPH_PANEL = "COM_GRAPH_PANEL";
    private static final String KEY_OLD_PROT_DATE = "COM_OLD_PROT_DATE";
    private static final String KEY_UNIT_TITLE = "COM_UNIT_TITLE";
    private static final String KEY_INIT_YSCALE_FLG = "COM_INIT_YSCALE_FLG";
    private static final String KEY_X_DATE_LIST = "COM_X_DATE_LIST";
    private static final String KEY_GRAPH_DISP_TERM = "COM_GRAPH_DISP_TERM";
    private static final String KEY_GRAPH_DATA = "COM_GRAPH_DATA";
    private static final String KEY_GRAPH_PANEL_NO = "COM_GRAPH_PANEL_NO";
    private static final String KEY_LIST_DATA = "COM_LIST_DATA";
    private static final String KEY_COL_OBJECT = "COM_COL_OBJECT";
    private static final String KEY_COL_MON_DATA = "COM_COL_MON_DATA";
    private static final String KEY_COL_OBJECT_NAME = "COM_COL_OBJECT_NAME";
    private static final String KEY_ROWDATA = "COM_ROWDATA";
    private static final String KEY_PROT_DATA = "COM_PROT_DATA";
    private static final String KEY_DISPLAY_MODE = "COM_DISPLAY_MODE";
    private static final String KEY_MONITOR_TYPE = "COM_MONITOR_TYPE";
    private static final String KEY_INTERVAL = "COM_INTERVAL";
    private static final String KEY_UPDATE_FLG = "COM_UPDATE_FLG";
    private static final String KEY_FOOTER = "COM_FOOTER";
    private static final String KEY_CHG_TERM = "COM_CHG_TERM";
    private static final String KEY_ADD_GRAPH = "COM_ADD_GRAPH";
    private static final String KEY_EDT_GRAPH_PANEL_NO = "COM_EDT_GRAPH_PANEL_NO";
    private static final String KEY_EVENT_TYPE = "COM_EVENT_TYPE";
    public static final String KEY_CHG_SEL_DISP_TERM = "KEY_CHG_SEL_DISP_TERM";
    public static final String KEY_ADD_SELECT_OBJ = "KEY_ADD_SELECT_OBJ";
    public static final String KEY_EDIT_SELECT_OBJ = "KEY_EDIT_SELECT_OBJ";
    private static final String KEY_DISP_UPDATE_FLG = "COM_DISP_UPDATE_FLG";
    private static final String KEY_GETDATA_FLG = "COM_GETDATA_FLG";
    private static final String KEY_LASTUPDATE = "COM_LASTUPDATE";
    private static final String KEY_INIT_ANCHOR_PANEL = "COM_INIT_ANCHOR_PANEL";
    public static final String KEY_VIEW_MP_INFO = "COM_VIEW_MP_INFO";
    public static final String KEY_VIEW_SELECT_MP = "COM_VIEW_SELECT_MP";
    public static final String KEY_GET_TERM = "COM_GET_TERM";
    private static final String KEY_LABELVIEW_ERR_MSG = "COM_LABELVIEW_ERR_MSG";
    private static final int FLG_NOT_INIT_ANCHOR_PANEL = -1;
    public static final int MONITOR_TYPE_SETTERM = 0;
    public static final int MONITOR_TYPE_REAL = 1;
    private static final int EVENT_DELETEGRAPH = 1;
    private static final int EVENT_EDITGRAPHOBJ = 2;
    private static final int EVENT_POLLINGUPDATE = 3;
    private static final int MAX_GRAPH = 4;
    private static final int REAL_TIME_PROT_NUM = 60;
    private static final int GETDATAFLG_CONSTRUCT = 0;
    private static final int GETDATAFLG_EDITOBJ = 1;
    private static final int GETDATAFLG_ADDGRAPH = 2;
    private static final int GETDATAFLG_EDITRANGE = 3;
    private static final int GETDATAFLG_REALTIME = 4;
    private static final int GETDATAFLG_DELETE = 5;
    private static final int GETDATAFLG_MPPROPCLOSE = 6;
    private static final int CHK_FLG_NULL = 1;
    private static final int CHK_FLG_ZERO = 2;
    private static final int CHK_FLG_NULL_ZERO = 3;

    public SJctrMonitorWindowDC(int dispId) throws SJcException {
        super(dispId);
    }

    public SJctrMonitorWindowDC() throws SJcException {
        super(33603585);
        this.initDataModel();
        this.initListener();
    }

    private void initListener() {
        this.addMessageEventListener(MON_MW_MSG.SELECT_CHG_DISPTERM, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_CHG_DISPTERM Start");
                SJctrMonitorWindowDC.this.initYScaleComboFlg();
                SJctrMonitorWindowDC.this.setInitAnchor(-1);
                SJctrMonitorWindowDC.this.doSelectChangeDisplayTerm();
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_CHG_DISPTERM End");
            }
        });
        this.addMessageEventListener(MON_MW_MSG.SELECT_ADD_GRAPH, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_ADD_GRAPH Start");
                SJctrMonitorWindowDC.this.initYScaleComboFlg();
                SJctrMonitorWindowDC.this.setInitAnchor(-1);
                SJctrMonitorWindowDC.this.doSelectAddGraph();
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_ADD_GRAPH End");
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "DIALOG_MSG.EXIT Start");
                Map param = (Map)event.getNofifyObject();
                SJctrMonitorWindowDC.this.initYScaleComboFlg();
                SJctrMonitorWindowDC.this.setInitAnchor(-1);
                boolean exec = SJctrMonitorWindowDC.this.exitChangeGraphTerm(param);
                if (!exec) {
                    exec = SJctrMonitorWindowDC.this.exitAddGraph(param);
                }
                if (!exec) {
                    exec = SJctrMonitorWindowDC.this.exitEditGraphObject(param);
                }
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "DIALOG_MSG.EXIT End");
            }
        });
        this.addMessageEventListener(MON_MW_MSG.SELECT_DELETE_GRAPH, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_DELETE_GRAPH Start");
                SJctrMonitorWindowDC.this.initYScaleComboFlg();
                SJctrMonitorWindowDC.this.setInitAnchor(-1);
                SJctrMonitorWindowDC.this.doSelectDeleteGraph();
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_DELETE_GRAPH End");
            }
        });
        this.addMessageEventListener(MON_MW_MSG.SELECT_EDT_DISPOBJ, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_EDT_DISPOBJ Start");
                SJctrMonitorWindowDC.this.initYScaleComboFlg();
                SJctrMonitorWindowDC.this.setInitAnchor(-1);
                SJctrMonitorWindowDC.this.doSelectEditGraphObj();
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_EDT_DISPOBJ End");
            }
        });
        this.addMessageEventListener(MON_MW_MSG.UPD_REALTIME, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.UPD_REALTIME Start");
                SJctrMonitorWindowDC.this.initYScaleComboFlg();
                SJctrMonitorWindowDC.this.setInitAnchor(-1);
                SJctrMonitorWindowDC.this.doUpdateRealTime();
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.UPD_REALTIME End");
            }
        });
        this.addMessageEventListener(MON_MW_MSG.SELECT_MP_LINK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_MP_LINK Start");
                SJctrMonitorWindowDC.this.initYScaleComboFlg();
                SJctrMonitorWindowDC.this.setInitAnchor(-1);
                SJctrMonitorWindowDC.this.doSelectMpLink();
                SJctrMonitorWindowDC.this.getLogUty().putlog("doMessageAction", "MON_MW_MSG.SELECT_MP_LINK End");
            }
        });
    }

    private void initYScaleComboFlg() {
        SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
        List graphPanels = (List)((SJctrDataObject)graphInfo.getManageData()).getData(KEY_GRAPH_PANEL);
        for (Map graphPanel : graphPanels) {
            graphPanel.put(KEY_INIT_YSCALE_FLG, new Boolean(false));
        }
    }

    protected void doUpdateRealTime() {
        SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
        ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GETDATA_FLG, new Integer(4));
        this.setDirtyAll();
    }

    private Date getPrevEndDate() {
        Date prevEndDate = null;
        SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
        List xdatas = (List)((SJctrDataObject)graphInfo.getManageData()).getData(KEY_X_DATE_LIST);
        if (xdatas != null && xdatas.size() > 0 && (prevEndDate = SJctrMonitorPerformanceUtility.getStringToDate((String)xdatas.get(xdatas.size() - 1), this.logUty)) == null) {
            this.logUty.putlog("getPrevEndDate", "prevEndDate = null");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        return prevEndDate;
    }

    private void checkRealTimeUpdate() {
        this.getMonitoringOption();
        MonMonitoringInfoLDKC monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
        if (!monitoringInfo.isStatus()) {
            this.logUty.putlog("doUpdateRealTime", "monitoringInfo.isStatus = false");
            SJctrError error = new SJctrError(51, 22, 105113);
            throw error.createException();
        }
        SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
        Integer intervalObj = (Integer)((SJctrDataObject)graphInfo.getManageData()).getData(KEY_INTERVAL);
        int interval = intervalObj * 60;
        if (interval != monitoringInfo.getInterval()) {
            this.logUty.putlog("doUpdateRealTime", "changed interval");
            SJctrError error = new SJctrError(51, 22, 105113);
            throw error.createException();
        }
        if (!monitoringInfo.getShortRangeInfo().isExist()) {
            this.logUty.putlog("doUpdateRealTime", "isExist = false");
            SJctrError error = new SJctrError(51, 22, 105113);
            throw error.createException();
        }
    }

    protected void doSelectAddGraph() {
        Integer dispModeObj;
        List<Map<String, Object>> graphDatas = this.getGraphDataObject();
        if (graphDatas.size() >= 16) {
            this.logUty.putlog("doSelectAddGraph", "monitor object max");
            SJctrError error = new SJctrError(51, 22, 105110);
            throw error.createException();
        }
        HashMap param = new HashMap();
        int graphNo = 0;
        List<Map<String, Object>> graphPnlInfos = this.getGraphPanelObject();
        for (int cnt = 0; cnt < 4; ++cnt) {
            Map<String, Object> graphPnlInfo = graphPnlInfos.get(cnt);
            String unit = (String)graphPnlInfo.get(KEY_UNIT_TITLE);
            if (unit != null) continue;
            graphNo = cnt;
            break;
        }
        if ((dispModeObj = (Integer)this.getDataObjectModel(KEY_GRAPH_INFO).getManageData().getData(KEY_DISPLAY_MODE)) == null) {
            this.logUty.putlog("doSelectAddGraph", "dispModeObj = null");
            SJctrError error = new SJctrError(51, 22, 107004);
            throw error.createException();
        }
        int dispMode = dispModeObj;
        dispMode = dispMode == 0 ? 0 : graphNo + 1;
        ArrayList<Integer> numList = new ArrayList<Integer>();
        numList.add(new Integer(graphDatas.size()));
        param.put("KEY_OBJECT_NUM", numList);
        ArrayList<Integer> noList = new ArrayList<Integer>();
        noList.add(new Integer(graphNo));
        param.put("KEY_EDT_GRAPH_PANEL_NO", noList);
        ArrayList<Integer> dispList = new ArrayList<Integer>();
        dispList.add(new Integer(dispMode));
        param.put("KEY_DISPLAY_MODE", dispList);
        SJctrRelatedDispDataObject newRelated = this.createDialog(SJctrAddNewGraphDC.class, param);
        this.addUpdateDisp(newRelated);
    }

    protected void doSelectChangeDisplayTerm() {
        SJctrMonitorPerformanceUtility.reqMonMonitoringModel(this, "KEY_MONITORING_OPTION_EDITRANGE", this.logUty);
        SJctrRelatedDispDataObject newRelated = this.createDialog(SJctrChgGraphDispTermDC.class, null);
        this.addUpdateDisp(newRelated);
    }

    protected void doSelectEditGraphObj() {
        Integer graphNoObj = (Integer)this.getManageData().getData(KEY_EDT_GRAPH_PANEL_NO);
        if (graphNoObj == null) {
            this.logUty.putlog("initListener", "SELECT_DELETE_GRAPH:graphNoObj = null");
            SJctrError error = new SJctrError(51, 22, 107004);
            throw error.createException();
        }
        int graphNo = graphNoObj - 1;
        if (graphNo >= 4 || graphNo < 0) {
            this.logUty.putlog("initGraphPanelInfo", "graphPnlInfo or graphPanel Error");
            SJctrError error = new SJctrError(51, 22, 107004);
            throw error.createException();
        }
        HashMap param = new HashMap();
        ArrayList<SJctrSelectedObjectInfo> selList = new ArrayList<SJctrSelectedObjectInfo>();
        List<Map<String, Object>> graphDatas = this.getGraphDataObject();
        for (Map<String, Object> graphData : graphDatas) {
            Integer dataNo = (Integer)graphData.get(KEY_GRAPH_PANEL_NO);
            if (dataNo == null) {
                this.logUty.putlog("doSelectEditGraphObj", "dataNo = null");
                continue;
            }
            if (dataNo != graphNo) continue;
            Map listData = (Map)graphData.get(KEY_LIST_DATA);
            SJctrSelectedObjectInfo selInfo = (SJctrSelectedObjectInfo)listData.get(KEY_ROWDATA);
            selList.add(selInfo);
        }
        param.put("KEY_SELECT_OBJ", selList);
        ArrayList<Integer> numList = new ArrayList<Integer>();
        numList.add(new Integer(graphDatas.size() - selList.size()));
        param.put("KEY_OBJECT_NUM", numList);
        ArrayList<Integer> noList = new ArrayList<Integer>();
        noList.add(new Integer(graphNo));
        param.put("KEY_EDT_GRAPH_PANEL_NO", noList);
        SJctrRelatedDispDataObject newRelated = this.createDialog(SJctrEditGraphDispObjDC.class, param);
        this.addUpdateDisp(newRelated);
    }

    protected void doSelectDeleteGraph() {
        Integer graphNoObj = (Integer)this.getManageData().getData(KEY_EDT_GRAPH_PANEL_NO);
        if (graphNoObj == null) {
            this.logUty.putlog("initListener", "SELECT_DELETE_GRAPH:graphNoObj = null");
            SJctrError error = new SJctrError(51, 22, 107004);
            throw error.createException();
        }
        int graphNo = graphNoObj - 1;
        if (graphNo >= 4 || graphNo < 0) {
            this.logUty.putlog("initGraphPanelInfo", "graphPnlInfo or graphPanel Error");
            SJctrError error = new SJctrError(51, 22, 107004);
            throw error.createException();
        }
        Integer dispModeObj = (Integer)this.getDataObjectModel(KEY_GRAPH_INFO).getManageData().getData(KEY_DISPLAY_MODE);
        if (dispModeObj == null) {
            this.logUty.putlog("doSelectAddGraph", "dispModeObj = null");
            SJctrError error = new SJctrError(51, 22, 107004);
            throw error.createException();
        }
        try {
            this.initGraphPanelInfo(graphNo);
            this.initGraphListData(graphNo);
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            List<Map<String, Object>> graphDatas = this.getGraphDataObject();
            int dispMode = dispModeObj;
            if (dispMode != 0) {
                dispMode = this.updateDispMode(graphNo);
            }
            SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
            if (!termInfo.isSelectTerm() && graphDatas.size() > 0) {
                ArrayList<Integer> modeList = new ArrayList<Integer>();
                modeList.add(new Integer(dispMode));
                this.putCache("KEY_DISPLAY_MODE", modeList);
                ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GETDATA_FLG, new Integer(5));
            } else {
                ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISPLAY_MODE, new Integer(dispMode));
                ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_UPDATE_FLG, new Boolean(true));
                ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISP_UPDATE_FLG, new Boolean(true));
            }
            this.updateButton();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107015);
        }
    }

    private int updateDispMode(int graphNo) {
        String unit;
        Map<String, Object> graphPnl;
        int searchNo;
        List<Map<String, Object>> graphPnls = this.getGraphPanelObject();
        int dispMode = 0;
        for (searchNo = graphNo; searchNo >= 0; --searchNo) {
            graphPnl = graphPnls.get(searchNo);
            unit = (String)graphPnl.get(KEY_UNIT_TITLE);
            if (unit == null) continue;
            dispMode = searchNo + 1;
            break;
        }
        if (dispMode == 0) {
            for (searchNo = graphNo; searchNo < 4; ++searchNo) {
                graphPnl = graphPnls.get(searchNo);
                unit = (String)graphPnl.get(KEY_UNIT_TITLE);
                if (unit == null) continue;
                dispMode = searchNo + 1;
                break;
            }
        }
        if (dispMode == 0) {
            dispMode = graphNo + 1;
        }
        return dispMode;
    }

    protected void doSelectMpLink() {
        HashMap param = new HashMap();
        ArrayList<String> viewMp = new ArrayList<String>();
        String objectString = (String)this.getManageData().getData(KEY_VIEW_SELECT_MP);
        String mpNoObj = this.changeSelectedStr(objectString);
        viewMp.add(mpNoObj);
        MonMonitoringInfoLDKC monitoringInfo = this.getMonitoringInfoNoParam();
        if (!monitoringInfo.isStatus()) {
            this.logUty.putlog("doSelectMpLink", "monitoringInfo.isStatus = false");
            SJctrError error = new SJctrError(51, 22, 105113);
            throw error.createException();
        }
        Date endDate = monitoringInfo.getShortRangeInfo().getEndDate();
        int interval = monitoringInfo.getShortRangeInfo().getInterval();
        Date preEndDate = new Date(endDate.getTime() - (long)(interval * 1000));
        SJctrComUtility util = this.getComUtility();
        String getOwnerInfoTerm = SJctrMonitorPerformanceUtility.getDateToString(preEndDate) + " " + SJctrOptionMonitorGuidance.getMonitorGuidanceStr(util, SJctrOptionMonitorGuidance.BAR) + " " + SJctrMonitorPerformanceUtility.getDateToString(endDate);
        ArrayList<String> getOwnerInfoTermList = new ArrayList<String>();
        getOwnerInfoTermList.add(getOwnerInfoTerm);
        HIHsmPhysicalOwnerUseRateArgInfo ownerParam = new HIHsmPhysicalOwnerUseRateArgInfo(1, preEndDate, endDate, 1);
        List<Map<String, Object>> graphDatas = this.getGraphDataObject();
        SJmoMPCompositionInfo equalMP = null;
        for (Map<String, Object> graphData : graphDatas) {
            Map listData = (Map)graphData.get(KEY_LIST_DATA);
            SJctrSelectedObjectInfo selInfo = (SJctrSelectedObjectInfo)listData.get(KEY_ROWDATA);
            if (!selInfo.getObjectName().equals(mpNoObj)) continue;
            equalMP = (SJmoMPCompositionInfo)selInfo.getRowObject();
            ownerParam.setAllParam(0, equalMP.getCluster(), equalMP.getMppcbNum(), equalMP.getNumber());
            break;
        }
        if (equalMP == null) {
            this.logUty.putlog("doSelectMpLink", "equalMP is null");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        List<SJmoLdevNicknameInfo> ldevNameList = this.getLDEVNickName();
        ArrayList<MonitorElementInfo> ownerDetailList = new ArrayList<MonitorElementInfo>();
        MonitorInfoCollection ownerInfo = this.getMonitoringInfoInParam(ownerParam);
        ownerDetailList.add(ownerInfo.get(0));
        param.put(KEY_VIEW_MP_INFO, viewMp);
        param.put(KEY_GET_TERM, getOwnerInfoTermList);
        param.put(HIHsmPhysicalOwnerUseRate.class.getName(), ownerDetailList);
        param.put(SJmoLdevNicknameInfo.class.getName(), ldevNameList);
        SJctrRelatedDispDataObject newRelated = this.createDialog(SJctrMPPropertiesDialogDC.class, param);
        this.addUpdateDisp(newRelated);
    }

    private List<Map<String, Object>> getGraphPanelObject() {
        SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
        List graphPnlInfo = (List)((SJctrDataObject)graphInfo.getManageData()).getData(KEY_GRAPH_PANEL);
        if (graphPnlInfo == null || graphPnlInfo.size() != 4) {
            this.logUty.putlog("initGraphPanelInfo", "graphPnlInfo = null");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        return graphPnlInfo;
    }

    private List<Map<String, Object>> getGraphDataObject() {
        SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
        List graphDatas = (List)((SJctrDataObject)graphInfo.getManageData()).getData(KEY_GRAPH_DATA);
        if (graphDatas == null) {
            this.logUty.putlog("initGraphPanelInfo", "graphDatas = null");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        return graphDatas;
    }

    private void initGraphPanelInfo(int graphPanel) {
        List<Map<String, Object>> graphPnlInfo = this.getGraphPanelObject();
        Map<String, Object> graphPnl = graphPnlInfo.get(graphPanel);
        graphPnl.put(KEY_UNIT_TITLE, null);
        graphPnl.put(KEY_OLD_PROT_DATE, null);
    }

    private void initGraphListData(int graphPanel) {
        List<Map<String, Object>> graphDatas = this.getGraphDataObject();
        int datasSize = graphDatas.size();
        for (int cnt = datasSize - 1; cnt >= 0; --cnt) {
            Map<String, Object> graphData = graphDatas.get(cnt);
            Integer dataNo = (Integer)graphData.get(KEY_GRAPH_PANEL_NO);
            if (dataNo == null) {
                this.logUty.putlog("initGraphPanelInfo", "dataNo = null");
                continue;
            }
            if (dataNo != graphPanel) continue;
            graphDatas.remove(cnt);
        }
    }

    private boolean exitChangeGraphTerm(Map<String, List<?>> param) {
        boolean ret = false;
        List<?> termLists = param.get(KEY_CHG_SEL_DISP_TERM);
        if (termLists != null && termLists.size() != 0) {
            this.putCache(KEY_CHG_SEL_DISP_TERM, termLists);
            SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GETDATA_FLG, new Integer(3));
            this.setDirtyAll();
            ret = true;
        }
        return ret;
    }

    private boolean exitAddGraph(Map<String, List<?>> param) {
        boolean ret = false;
        List<?> addLists = param.get(KEY_ADD_SELECT_OBJ);
        if (addLists != null && addLists.size() != 0) {
            this.putCache(KEY_ADD_SELECT_OBJ, addLists);
            List<?> nolist = param.get("KEY_EDT_GRAPH_PANEL_NO");
            this.putCache("KEY_EDT_GRAPH_PANEL_NO", nolist);
            SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
            List<?> modeList = param.get("KEY_DISPLAY_MODE");
            this.putCache("KEY_DISPLAY_MODE", modeList);
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GETDATA_FLG, new Integer(2));
            this.setDirtyAll();
            ret = true;
        }
        return ret;
    }

    private boolean exitEditGraphObject(Map<String, List<?>> param) {
        boolean ret = false;
        List<?> addLists = param.get(KEY_EDIT_SELECT_OBJ);
        if (addLists != null && addLists.size() != 0) {
            this.putCache(KEY_EDIT_SELECT_OBJ, addLists);
            List<?> nolist = param.get("KEY_EDT_GRAPH_PANEL_NO");
            this.putCache("KEY_EDT_GRAPH_PANEL_NO", nolist);
            SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GETDATA_FLG, new Integer(1));
            this.setDirtyAll();
            ret = true;
        }
        return ret;
    }

    private boolean exitMpPropertyDialog(Map<String, List<?>> param) {
        boolean ret = false;
        SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
        ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GETDATA_FLG, new Integer(6));
        this.setDirtyAll();
        ret = true;
        return ret;
    }

    public SJctrSelectDispTermInfo getSelectDispTermInfo() {
        return SJctrMonitorPerformanceUtility.getSelectDispTermInfo(this, this.logUty);
    }

    private void initDataModel() {
        SJctrSimpleDataModel graphInfo = new SJctrSimpleDataModel(){

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                SJctrMonitorWindowDC mwdc = (SJctrMonitorWindowDC)this.getDataController();
                return mwdc.getDataObject();
            }
        };
        graphInfo.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrDataObject data;
                Integer eventType;
                if (setObject instanceof SJctrDataObject && (eventType = (Integer)(data = (SJctrDataObject)setObject).getData(SJctrMonitorWindowDC.KEY_EVENT_TYPE)) != null) {
                    int event = eventType;
                    Integer graphNo = (Integer)data.getData(SJctrMonitorWindowDC.KEY_EDT_GRAPH_PANEL_NO);
                    if (graphNo != null) {
                        SJctrMonitorWindowDC.this.getManageData().setData(SJctrMonitorWindowDC.KEY_EDT_GRAPH_PANEL_NO, graphNo);
                    }
                    SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)SJctrMonitorWindowDC.this.getDataObjectModel(SJctrMonitorWindowDC.KEY_GRAPH_INFO);
                    ((SJctrDataObject)graphInfo.getManageData()).setData(SJctrMonitorWindowDC.KEY_DISPLAY_MODE, data.getData(SJctrMonitorWindowDC.KEY_DISPLAY_MODE));
                    switch (event) {
                        case 1: {
                            SJctrMonitorWindowDC.this.fireMessageEvent(MON_MW_MSG.SELECT_DELETE_GRAPH);
                            break;
                        }
                        case 2: {
                            SJctrMonitorWindowDC.this.fireMessageEvent(MON_MW_MSG.SELECT_EDT_DISPOBJ);
                            break;
                        }
                        case 3: {
                            SJctrMonitorWindowDC.this.fireMessageEvent(MON_MW_MSG.UPD_REALTIME);
                            break;
                        }
                    }
                }
            }
        });
        this.addDataObjectModel(KEY_GRAPH_INFO, graphInfo);
        ArrayList<Map<String, Object>> graphPnlInfo = new ArrayList<Map<String, Object>>();
        graphPnlInfo.add(this.setGraphPanelInfo(null, null));
        graphPnlInfo.add(this.setGraphPanelInfo(null, null));
        graphPnlInfo.add(this.setGraphPanelInfo(null, null));
        graphPnlInfo.add(this.setGraphPanelInfo(null, null));
        ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GRAPH_PANEL, graphPnlInfo);
        for (int comboCnt = 0; comboCnt < graphPnlInfo.size(); ++comboCnt) {
            String keyName = KEY_Y_SCALE + String.valueOf(comboCnt);
            this.addDataObjectModel(keyName, new SJctrComboBoxDataModel());
        }
        ArrayList xtime = new ArrayList();
        ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_X_DATE_LIST, xtime);
        ArrayList graphData = new ArrayList();
        ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GRAPH_DATA, graphData);
        SJctrFooterDataModel footerDataModel = new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE);
        this.addDataObjectModel(KEY_FOOTER, footerDataModel);
        SJctrButtonDataModel chgTermButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_CHG_TERM, chgTermButton);
        chgTermButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                ArrayList param = new ArrayList();
                SJctrMonitorWindowDC.this.fireMessageEvent(MON_MW_MSG.SELECT_CHG_DISPTERM, param);
            }
        });
        SJctrButtonDataModel addGraphButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD_GRAPH, addGraphButton);
        addGraphButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                ArrayList param = new ArrayList();
                SJctrMonitorWindowDC.this.fireMessageEvent(MON_MW_MSG.SELECT_ADD_GRAPH, param);
            }
        });
        SJctrSimpleDataModel mpLinkInfo = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_VIEW_MP_INFO, mpLinkInfo);
        mpLinkInfo.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObj) {
                SJctrDataObject data = (SJctrDataObject)setObj;
                String selectMp = (String)data.getData(SJctrMonitorWindowDC.KEY_VIEW_SELECT_MP);
                if (selectMp != null) {
                    SJctrMonitorWindowDC.this.getManageData().setData(SJctrMonitorWindowDC.KEY_VIEW_SELECT_MP, selectMp);
                }
                SJctrMonitorWindowDC.this.fireMessageEvent(MON_MW_MSG.SELECT_MP_LINK);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = false;
        this.getSelectDispTermInfo();
        SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
        List<?> selList = this.getCache("KEY_SELECT_OBJ");
        if (selList == null || selList.size() == 0) {
            this.logUty.putlog("checkStartData", "KEY_SELECT_OBJ data error");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        ret = true;
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        try {
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
            List<SJctrSelectedObjectInfo> selData = this.getCache("KEY_SELECT_OBJ");
            this.setGraphDispObj(graphInfo, selData, 0);
            MonMonitoringInfoLDKC monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
            int dispType = 0;
            int interval = 0;
            if (!termInfo.isSelectTerm()) {
                dispType = 1;
                interval = monitoringInfo.getInterval() / 60;
            }
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_MONITOR_TYPE, new Integer(dispType));
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_INTERVAL, new Integer(interval));
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GETDATA_FLG, new Integer(0));
            this.setDirtyAll();
            this.updateButton();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107002);
        }
        return ret;
    }

    private void updateButton() {
        SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
        SJctrButtonDataModel chgTermButton = (SJctrButtonDataModel)this.getDataObjectModel(KEY_CHG_TERM);
        boolean chgTermEnable = false;
        if (termInfo.isSelectTerm()) {
            chgTermEnable = true;
        }
        chgTermButton.setEnable(chgTermEnable);
        chgTermButton.setDirty();
        List<Map<String, Object>> panelDatas = this.getGraphPanelObject();
        SJctrButtonDataModel addGraphButton = (SJctrButtonDataModel)this.getDataObjectModel(KEY_ADD_GRAPH);
        boolean addGraphEnable = false;
        for (Map<String, Object> panelData : panelDatas) {
            Object data = panelData.get(KEY_UNIT_TITLE);
            if (data != null) continue;
            addGraphEnable = true;
        }
        addGraphButton.setEnable(addGraphEnable);
        addGraphButton.setDirty();
    }

    private void setGraphDispObj(SJctrSimpleDataModel dispObject, List<SJctrSelectedObjectInfo> selectObjs, int graphPanelNo) {
        String unitTitle = null;
        boolean percent = false;
        this.initGraphListData(graphPanelNo);
        List<Map<String, Object>> graphDatas = this.getGraphDataObject();
        for (int cnt = 0; cnt < selectObjs.size(); ++cnt) {
            SJctrSelectedObjectInfo item = selectObjs.get(cnt);
            if (cnt == 0) {
                unitTitle = item.getUnitType();
                if (item.getComboInfos()[7].equals("true")) {
                    percent = true;
                }
            }
            Map<String, Object> graphObjData = this.setGraphData(graphPanelNo, this.setProtDetail(item.getObject(), item.getMonitorData(), item.getObjectName(), item), null);
            graphDatas.add(graphObjData);
        }
        Comparator<Map<String, Object>> comp = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                int ret = 0;
                Map<String, Object> objMap1 = o1;
                Map item1 = (Map)objMap1.get(SJctrMonitorWindowDC.KEY_LIST_DATA);
                SJctrSelectedObjectInfo obj1 = (SJctrSelectedObjectInfo)item1.get(SJctrMonitorWindowDC.KEY_ROWDATA);
                Map<String, Object> objMap2 = o2;
                Map item2 = (Map)objMap2.get(SJctrMonitorWindowDC.KEY_LIST_DATA);
                SJctrSelectedObjectInfo obj2 = (SJctrSelectedObjectInfo)item2.get(SJctrMonitorWindowDC.KEY_ROWDATA);
                ret = obj1.compareTo(obj2);
                return ret;
            }
        };
        Collections.sort(graphDatas, comp);
        List graphPanels = (List)((SJctrDataObject)dispObject.getManageData()).getData(KEY_GRAPH_PANEL);
        Map graphPanel = (Map)graphPanels.get(graphPanelNo);
        graphPanel.put(KEY_UNIT_TITLE, unitTitle);
        String keyName = KEY_Y_SCALE + String.valueOf(graphPanelNo);
        SJctrComboBoxDataModel combo = (SJctrComboBoxDataModel)this.getDataObjectModel(keyName);
        combo.removeAllItems();
        if (percent) {
            combo.addItem("100", "100");
            combo.addSelection("100");
        } else {
            combo.addItem("1", "1");
            combo.addItem("5", "5");
            combo.addItem("10", "10");
            combo.addItem("50", "50");
            combo.addItem("100", "100");
            combo.addItem("500", "500");
            combo.addItem("1000", "1,000");
            combo.addItem("5000", "5,000");
            combo.addItem("10000", "10,000");
            combo.addItem("50000", "50,000");
            combo.addItem("100000", "100,000");
            combo.addItem("500000", "500,000");
            combo.addItem("1000000", "1,000,000");
            combo.addItem("5000000", "5,000,000");
            combo.addItem("10000000", "10,000,000");
            combo.addItem("50000000", "50,000,000");
            combo.addItem("100000000", "100,000,000");
            combo.addItem("500000000", "500,000,000");
            combo.addItem("1000000000", "1,000,000,000");
        }
    }

    private boolean setPerformanceData(SJctrSimpleDataModel dispObject, List<SJctrPlotDataInfo> datas, Date startDate, Date endDate, SJctrSelectDispTermInfo dispTermInfo, MonMonitoringInfoLDKC monitoringInfo) {
        this.logUty.putlog("setPerformanceData", "start");
        boolean ret = false;
        long interval = 0L;
        if (dispTermInfo.getMonDataType() == 0) {
            interval = dispTermInfo.isSelectTerm() ? (long)(monitoringInfo.getShortRangeInfo().getInterval() * 1000) : (long)(monitoringInfo.getInterval() * 1000);
            if (interval <= 0L) {
                interval = 60000L;
            }
        } else {
            interval = monitoringInfo.getLongRangeInfo().getInterval() * 1000;
        }
        long lastDate = startDate.getTime() + interval;
        Date work = new Date();
        DateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        df = SJctrMonitorPerformanceUtility.setDKCTime(df);
        Date xstartDate = null;
        xstartDate = dispTermInfo.isSelectTerm() ? new Date(lastDate) : new Date(endDate.getTime() - interval * 59L);
        String graphDisplayTerm = "";
        Date fromDate = null;
        Date toDate = null;
        if (dispTermInfo.isSelectTerm()) {
            fromDate = SJctrMonitorPerformanceUtility.getStringToDate(dispTermInfo.getStartDateTerm(), this.logUty);
            toDate = SJctrMonitorPerformanceUtility.getStringToDate(dispTermInfo.getEndDateTerm(), this.logUty);
        } else {
            fromDate = new Date(xstartDate.getTime() - interval);
            toDate = new Date(endDate.getTime());
        }
        graphDisplayTerm = SJctrMonitorPerformanceUtility.getDateToString(fromDate) + " " + SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.BAR) + " " + SJctrMonitorPerformanceUtility.getDateToString(toDate);
        List<Map<String, Object>> graphDatas = this.getGraphDataObject();
        if (graphDatas.size() == 0) {
            ((SJctrDataObject)dispObject.getManageData()).setData(KEY_GRAPH_DISP_TERM, graphDisplayTerm);
            this.logUty.putlog("setPerformanceData", "end non graph Object");
            return ret;
        }
        double[] maxProtDatas = new double[4];
        for (int cntMaxProt = 0; cntMaxProt < 4; ++cntMaxProt) {
            maxProtDatas[cntMaxProt] = -1.0;
        }
        List xdatas = (List)((SJctrDataObject)dispObject.getManageData()).getData(KEY_X_DATE_LIST);
        Date prevEndDate = null;
        if (xdatas != null && xdatas.size() > 0) {
            prevEndDate = SJctrMonitorPerformanceUtility.getStringToDate((String)xdatas.get(xdatas.size() - 1), this.logUty);
        }
        if (datas == null) {
            this.logUty.putlog("setPerformanceData", "end non graph datas");
            return ret;
        }
        this.logUty.putlog("setPerformanceData", "set performance data start");
        block1: for (int cnt = 0; cnt < graphDatas.size(); ++cnt) {
            Map<String, Object> graphData = graphDatas.get(cnt);
            Map dataDetail = (Map)graphData.get(KEY_LIST_DATA);
            SJctrSelectedObjectInfo rowData = (SJctrSelectedObjectInfo)dataDetail.get(KEY_ROWDATA);
            Integer pnlNoObj = (Integer)graphData.get(KEY_GRAPH_PANEL_NO);
            int pnlNo = pnlNoObj;
            List<Map<String, Object>> graphPnls = this.getGraphPanelObject();
            Map<String, Object> graphPnl = graphPnls.get(pnlNo);
            String oldDateObj = (String)graphPnl.get(KEY_OLD_PROT_DATE);
            Date oldDate = SJctrMonitorPerformanceUtility.getStringToDate(oldDateObj, this.logUty);
            for (SJctrPlotDataInfo data : datas) {
                int cntRem;
                long gapNum;
                long gap;
                if (!rowData.equals(data.getRowData()) || pnlNo != data.getPanelNo()) continue;
                ArrayList<String> oldProt = (ArrayList<String>)graphData.get(KEY_PROT_DATA);
                List<String> prots = data.getPlotDatas();
                if (prots.size() == 0) {
                    this.logUty.putlog("getPerformanceData", "prot data size is 0: data" + rowData.getObject() + "_" + rowData.getMonitorData() + "_" + rowData.getObjectName());
                    SJctrError error = new SJctrError(51, 22, 107001);
                    throw error.createException();
                }
                if (oldProt == null || oldProt.size() == 0) {
                    oldProt = new ArrayList<String>();
                    if (dispTermInfo.isSelectTerm()) {
                        oldProt.addAll(prots);
                    } else {
                        gap = endDate.getTime() - oldDate.getTime();
                        gapNum = gap / interval;
                        if (gapNum > 60L) {
                            gapNum = 60L;
                        }
                        cntRem = 0;
                        while ((long)cntRem < gapNum) {
                            oldProt.add(prots.get((int)((long)prots.size() - gapNum + (long)cntRem)));
                            ++cntRem;
                        }
                        int setZero = 60 - oldProt.size();
                        for (int cntZero = 0; cntZero < setZero; ++cntZero) {
                            oldProt.add(0, null);
                        }
                    }
                    graphData.put(KEY_PROT_DATA, oldProt);
                } else {
                    if (dispTermInfo.isSelectTerm()) {
                        oldProt.clear();
                        oldProt.addAll(prots);
                    } else {
                        if (prevEndDate == null) {
                            this.logUty.putlog("getPerformanceData", "prevEndDate = null");
                            SJctrError error = new SJctrError(51, 22, 107001);
                            throw error.createException();
                        }
                        gap = endDate.getTime() - prevEndDate.getTime();
                        gapNum = gap / interval;
                        if (prots.size() >= 60) {
                            oldProt.clear();
                            oldProt.addAll(prots);
                        } else {
                            cntRem = 0;
                            while ((long)cntRem < gapNum) {
                                oldProt.add(prots.get((int)((long)prots.size() - gapNum + (long)cntRem)));
                                ++cntRem;
                            }
                        }
                        while (oldProt.size() > 60) {
                            oldProt.remove(0);
                        }
                    }
                    graphData.put(KEY_PROT_DATA, oldProt);
                }
                if (!(maxProtDatas[pnlNo] < data.getMaxData())) continue block1;
                maxProtDatas[pnlNo] = data.getMaxData();
                continue block1;
            }
        }
        this.logUty.putlog("setPerformanceData", "set performance data end");
        List graphPanels = (List)((SJctrDataObject)dispObject.getManageData()).getData(KEY_GRAPH_PANEL);
        for (int pnlCnt = 0; pnlCnt < graphPanels.size(); ++pnlCnt) {
            Map graphPnl = (Map)graphPanels.get(pnlCnt);
            String unitTitle = (String)graphPnl.get(KEY_UNIT_TITLE);
            String keyName = KEY_Y_SCALE + String.valueOf(pnlCnt);
            SJctrComboBoxDataModel combo = (SJctrComboBoxDataModel)this.getDataObjectModel(keyName);
            if (unitTitle == null || unitTitle.equals(SJctrMonitorPerformanceUtility.KEY_PERCENT)) continue;
            double prot = maxProtDatas[pnlCnt];
            long scale = 10L;
            while (10.0 <= prot) {
                prot /= 10.0;
                scale *= 10L;
            }
            if (maxProtDatas[pnlCnt] < 0.0 || maxProtDatas[pnlCnt] > 1.0E9) {
                scale = 1000000000L;
            } else if (maxProtDatas[pnlCnt] >= 0.0 && maxProtDatas[pnlCnt] < 1.0) {
                scale = 1L;
            } else if (prot < 5.0) {
                scale = scale * 5L / 10L;
            }
            combo.clearSelection();
            combo.addSelection(String.valueOf(scale));
        }
        ArrayList<String> xdate = new ArrayList<String>();
        for (lastDate = xstartDate.getTime(); lastDate <= endDate.getTime(); lastDate += interval) {
            work.setTime(lastDate);
            String dateStr = df.format(work);
            xdate.add(dateStr);
        }
        ((SJctrDataObject)dispObject.getManageData()).setData(KEY_X_DATE_LIST, xdate);
        ((SJctrDataObject)dispObject.getManageData()).setData(KEY_GRAPH_DISP_TERM, graphDisplayTerm);
        Date nowDate = new Date();
        df = SJctrMonitorPerformanceUtility.setMappTime(df);
        String nowDateStr = df.format(nowDate);
        ((SJctrDataObject)dispObject.getManageData()).setData(KEY_LASTUPDATE, nowDateStr);
        ret = true;
        this.logUty.putlog("setPerformanceData", "end");
        return ret;
    }

    private List<SJctrPlotDataInfo> getPlotData(Map<Class<?>, SJctrGetPlotParam> paramMap) {
        ArrayList<SJctrPlotDataInfo> ret = new ArrayList<SJctrPlotDataInfo>();
        for (Map.Entry<Class<?>, SJctrGetPlotParam> entry : paramMap.entrySet()) {
            SJctrGetPlotParam param = entry.getValue();
            param.getModelData();
            ret.addAll(param.getProtData());
        }
        return ret;
    }

    private void addParam(Map<Class<?>, SJctrGetPlotParam> paramMap, SJctrSelectedObjectInfo data, int panelNo, Date startDate, Date endDate, int monDataType) {
        Class<?> paramClass = null;
        SJctrGetPlotParam param = null;
        try {
            paramClass = Class.forName(data.getComboInfos()[9]);
            param = paramMap.get(paramClass);
            if (param == null) {
                param = (SJctrGetPlotParam)paramClass.newInstance();
                param.setMondataType(monDataType);
                param.setStartDate(startDate);
                param.setEndDate(endDate);
                param.setDc(this);
                paramMap.put(paramClass, param);
            }
        }
        catch (ClassNotFoundException e) {
            this.logUty.putlog("addParam", "ClassNotFoundException");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        catch (InstantiationException e) {
            this.logUty.putlog("addParam", "InstantiationException");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        catch (IllegalAccessException e) {
            this.logUty.putlog("addParam", "IllegalAccessException");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        param.addRowData(data, panelNo);
    }

    private void getMonitoringOption() {
        SJctrMonitorPerformanceUtility.reqMonMonitoringModel(this, this.logUty);
    }

    private Map<String, Object> setProtDetail(String object, String monitorData, String objectName, SJctrSelectedObjectInfo rowData) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(KEY_COL_OBJECT, object);
        ret.put(KEY_COL_MON_DATA, monitorData);
        ret.put(KEY_COL_OBJECT_NAME, objectName);
        ret.put(KEY_ROWDATA, rowData);
        return ret;
    }

    private Map<String, Object> setGraphData(int graphNo, Map<String, Object> protDetail, List<String> protData) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(KEY_GRAPH_PANEL_NO, new Integer(graphNo));
        ret.put(KEY_LIST_DATA, protDetail);
        ret.put(KEY_PROT_DATA, protData);
        return ret;
    }

    private Map<String, Object> setGraphPanelInfo(String oldProtData, String unitTitle) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(KEY_OLD_PROT_DATE, oldProtData);
        ret.put(KEY_UNIT_TITLE, unitTitle);
        ret.put(KEY_INIT_YSCALE_FLG, new Boolean(false));
        return ret;
    }

    private List<Map<String, Object>> makeTempGraphData(List<SJctrSelectedObjectInfo> lists, int graphNo) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> graphDatas = this.getGraphDataObject();
        for (Map<String, Object> graphData : graphDatas) {
            Integer panelNoObj = (Integer)graphData.get(KEY_GRAPH_PANEL_NO);
            if (panelNoObj == null) {
                this.logUty.putlog("getPerformanceData", "panelNoObj null");
                SJctrError error = new SJctrError(51, 22, 107001);
                throw error.createException();
            }
            if (graphNo == panelNoObj) continue;
            ret.add(graphData);
        }
        for (SJctrSelectedObjectInfo selData : lists) {
            Map<String, Object> graphObjData = this.setGraphData(graphNo, this.setProtDetail(selData.getObject(), selData.getMonitorData(), selData.getObjectName(), selData), null);
            ret.add(graphObjData);
        }
        return ret;
    }

    private void checkGetData(int chkFlg, List<?> data, String chkLogInfo) {
        if ((chkFlg & 1) == 1 && data == null) {
            this.logUty.putlog("checkGetData", "data is null:" + chkLogInfo);
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        if ((chkFlg & 2) == 2 && data != null && data.size() <= 0) {
            this.logUty.putlog("checkGetData", "data is zero:" + chkLogInfo);
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
    }

    private boolean checkErrChangeConfig(SJcException err) {
        boolean ret = false;
        SJcMessage msgObj = err.getMsg();
        int modID = 0;
        int funcID = 0;
        int msgID = 0;
        try {
            modID = Integer.parseInt(msgObj.getModuleID());
            funcID = Integer.parseInt(msgObj.getFunctionID());
            msgID = Integer.parseInt(msgObj.getMsgID());
        }
        catch (NumberFormatException e) {
            ret = false;
            return ret;
        }
        for (int[] errIDs : SJctrOptionMonitorMessage.ERR_CHANGE_CONFIGS) {
            if (modID != errIDs[0] || funcID != errIDs[1] || msgID != errIDs[2]) continue;
            this.logUty.putlog("checkErrChangeConfig", "Change Config Error:" + msgObj.getModuleID() + msgObj.getFunctionID() + msgObj.getMsgID());
            ret = true;
            break;
        }
        return ret;
    }

    private void updateConstructData(SJctrSimpleDataModel graphInfo) {
        Date startDate = null;
        Date endDate = null;
        Map<String, Object> graphPnl = null;
        List<Map<String, Object>> graphDatas = null;
        List<SJctrPlotDataInfo> datas = null;
        try {
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            List<Map<String, Object>> graphPnls = this.getGraphPanelObject();
            MonMonitoringInfoLDKC monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
            if (termInfo.isSelectTerm()) {
                startDate = SJctrMonitorPerformanceUtility.getStringToDate(termInfo.getStartDateTerm(), this.logUty);
                startDate = SJctrMonitorPerformanceUtility.getGetDataDate(monitoringInfo, startDate, termInfo.getMonDataType());
                endDate = SJctrMonitorPerformanceUtility.getStringToDate(termInfo.getEndDateTerm(), this.logUty);
                endDate = SJctrMonitorPerformanceUtility.getGetDataDate(monitoringInfo, endDate, termInfo.getMonDataType());
            } else {
                this.checkRealTimeUpdate();
                monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
                endDate = monitoringInfo.getShortRangeInfo().getEndDate();
                startDate = new Date(endDate.getTime() - (long)(monitoringInfo.getInterval() * 1000));
            }
            graphPnl = graphPnls.get(0);
            graphPnl.put(KEY_OLD_PROT_DATE, SJctrMonitorPerformanceUtility.getDateToString(startDate));
            graphDatas = this.getGraphDataObject();
            datas = this.getPerformanceData(graphDatas, startDate, endDate, termInfo);
            this.setPerformanceData(graphInfo, datas, startDate, endDate, termInfo, monitoringInfo);
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISPLAY_MODE, new Integer(1));
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_UPDATE_FLG, new Boolean(true));
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISP_UPDATE_FLG, new Boolean(true));
        }
        catch (SJcException excp) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(excp, 107002);
        }
    }

    private void updateEditObjectData(SJctrSimpleDataModel graphInfo) {
        Date startDate = null;
        Date endDate = null;
        List<SJctrPlotDataInfo> datas = null;
        Map<String, Object> graphPnl = null;
        List<SJctrSelectedObjectInfo> addLists = null;
        int graphNo = 0;
        List<Map<String, Object>> graphDatas = null;
        try {
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            List<Map<String, Object>> graphPnls = this.getGraphPanelObject();
            MonMonitoringInfoLDKC monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
            addLists = this.getCache(KEY_EDIT_SELECT_OBJ);
            this.checkGetData(3, addLists, "GETDATAFLG_EDITOBJ addLists");
            List<?> nolist = this.getCache("KEY_EDT_GRAPH_PANEL_NO");
            this.checkGetData(3, nolist, "GETDATAFLG_EDITOBJ nolist");
            Integer graphNoObj = (Integer)nolist.get(0);
            graphNo = graphNoObj;
            graphPnl = graphPnls.get(graphNo);
            String oldDateObj = (String)graphPnl.get(KEY_OLD_PROT_DATE);
            if (termInfo.isSelectTerm()) {
                startDate = SJctrMonitorPerformanceUtility.getStringToDate(termInfo.getStartDateTerm(), this.logUty);
                startDate = SJctrMonitorPerformanceUtility.getGetDataDate(monitoringInfo, startDate, termInfo.getMonDataType());
                endDate = SJctrMonitorPerformanceUtility.getStringToDate(termInfo.getEndDateTerm(), this.logUty);
                endDate = SJctrMonitorPerformanceUtility.getGetDataDate(monitoringInfo, endDate, termInfo.getMonDataType());
            } else {
                this.checkRealTimeUpdate();
                monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
                endDate = monitoringInfo.getShortRangeInfo().getEndDate();
                startDate = SJctrMonitorPerformanceUtility.getStringToDate(oldDateObj, this.logUty);
                Date prevEndDate = this.getPrevEndDate();
                if (prevEndDate != null && prevEndDate.getTime() < startDate.getTime()) {
                    startDate.setTime(prevEndDate.getTime());
                }
                long protStart = endDate.getTime() - (long)(60 * monitoringInfo.getInterval() * 1000);
                if (startDate.getTime() < protStart) {
                    startDate.setTime(protStart);
                }
            }
            graphDatas = this.makeTempGraphData(addLists, graphNo);
            try {
                datas = this.getPerformanceData(graphDatas, startDate, endDate, termInfo);
                ((SJctrDataObject)graphInfo.getManageData()).getDataMap().remove(KEY_LABELVIEW_ERR_MSG);
            }
            catch (SJcException excp) {
                if (this.checkErrChangeConfig(excp)) {
                    SJctrError error = new SJctrError(51, 22, 105247);
                    throw error.createException();
                }
                throw excp;
            }
            String unitType = (String)graphPnl.get(KEY_UNIT_TITLE);
            String newUnitType = addLists.get(0).getUnitType();
            this.setGraphDispObj(graphInfo, addLists, graphNo);
            if (!unitType.equals(newUnitType)) {
                graphPnl.put(KEY_INIT_YSCALE_FLG, new Boolean(true));
            }
            boolean update = this.setPerformanceData(graphInfo, datas, startDate, endDate, termInfo, monitoringInfo);
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_UPDATE_FLG, new Boolean(update));
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISP_UPDATE_FLG, new Boolean(false));
            this.setInitAnchor(graphNo);
        }
        catch (SJcException excp) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(excp, 107015);
        }
    }

    private void updateAddGraphData(SJctrSimpleDataModel graphInfo) {
        Date startDate = null;
        Date endDate = null;
        Date oldDate = null;
        List<SJctrPlotDataInfo> datas = null;
        Map<String, Object> graphPnl = null;
        List<SJctrSelectedObjectInfo> addLists = null;
        List<Map<String, Object>> graphDatas = null;
        List<?> modeList = null;
        int graphNo = 0;
        try {
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            List<Map<String, Object>> graphPnls = this.getGraphPanelObject();
            MonMonitoringInfoLDKC monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
            addLists = this.getCache(KEY_ADD_SELECT_OBJ);
            this.checkGetData(3, addLists, "GETDATAFLG_ADDGRAPH addLists");
            List<?> nolist = this.getCache("KEY_EDT_GRAPH_PANEL_NO");
            this.checkGetData(3, nolist, "GETDATAFLG_ADDGRAPH nolist");
            Integer graphNoObj = (Integer)nolist.get(0);
            graphNo = graphNoObj;
            modeList = this.getCache("KEY_DISPLAY_MODE");
            this.checkGetData(3, modeList, "GETDATAFLG_ADDGRAPH modeList");
            if (termInfo.isSelectTerm()) {
                startDate = SJctrMonitorPerformanceUtility.getStringToDate(termInfo.getStartDateTerm(), this.logUty);
                startDate = SJctrMonitorPerformanceUtility.getGetDataDate(monitoringInfo, startDate, termInfo.getMonDataType());
                endDate = SJctrMonitorPerformanceUtility.getStringToDate(termInfo.getEndDateTerm(), this.logUty);
                endDate = SJctrMonitorPerformanceUtility.getGetDataDate(monitoringInfo, endDate, termInfo.getMonDataType());
                oldDate = new Date(startDate.getTime());
            } else {
                this.checkRealTimeUpdate();
                monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
                endDate = monitoringInfo.getShortRangeInfo().getEndDate();
                startDate = new Date(endDate.getTime() - (long)(monitoringInfo.getInterval() * 1000));
                oldDate = new Date(startDate.getTime());
                Date prevEndDate = this.getPrevEndDate();
                if (prevEndDate != null && prevEndDate.getTime() < startDate.getTime()) {
                    startDate.setTime(prevEndDate.getTime());
                }
                long protStart = endDate.getTime() - (long)(60 * monitoringInfo.getInterval() * 1000);
                if (startDate.getTime() < protStart) {
                    startDate.setTime(protStart);
                }
            }
            graphDatas = this.makeTempGraphData(addLists, graphNo);
            try {
                datas = this.getPerformanceData(graphDatas, startDate, endDate, termInfo);
                ((SJctrDataObject)graphInfo.getManageData()).getDataMap().remove(KEY_LABELVIEW_ERR_MSG);
            }
            catch (SJcException excp) {
                if (this.checkErrChangeConfig(excp)) {
                    SJctrError error = new SJctrError(51, 22, 105247);
                    throw error.createException();
                }
                throw excp;
            }
            graphPnls = this.getGraphPanelObject();
            graphPnl = graphPnls.get(graphNo);
            graphPnl.put(KEY_OLD_PROT_DATE, SJctrMonitorPerformanceUtility.getDateToString(oldDate));
            this.setGraphDispObj(graphInfo, addLists, graphNo);
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISPLAY_MODE, modeList.get(0));
            this.updateButton();
            this.setPerformanceData(graphInfo, datas, startDate, endDate, termInfo, monitoringInfo);
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_UPDATE_FLG, new Boolean(true));
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISP_UPDATE_FLG, new Boolean(true));
        }
        catch (SJcException excp) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(excp, 107015);
        }
    }

    private void updateEditTimeRangeData(SJctrSimpleDataModel graphInfo) {
        Date startDate = null;
        Date endDate = null;
        List<SJctrPlotDataInfo> datas = null;
        List<Map<String, Object>> graphDatas = null;
        MonMonitoringInfoLDKC monitoringInfo = null;
        List<?> termLists = null;
        SJctrSelectDispTermInfo termInfo = null;
        try {
            termLists = this.getCache(KEY_CHG_SEL_DISP_TERM);
            this.checkGetData(3, termLists, "GETDATAFLG_EDITRANGE termLists");
            monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, "KEY_MONITORING_OPTION_EDITRANGE", this.logUty);
            termInfo = (SJctrSelectDispTermInfo)termLists.get(0);
            startDate = SJctrMonitorPerformanceUtility.getStringToDate(termInfo.getStartDateTerm(), this.logUty);
            startDate = SJctrMonitorPerformanceUtility.getGetDataDate(monitoringInfo, startDate, termInfo.getMonDataType());
            endDate = SJctrMonitorPerformanceUtility.getStringToDate(termInfo.getEndDateTerm(), this.logUty);
            endDate = SJctrMonitorPerformanceUtility.getGetDataDate(monitoringInfo, endDate, termInfo.getMonDataType());
            graphDatas = this.getGraphDataObject();
            try {
                datas = this.getPerformanceData(graphDatas, startDate, endDate, termInfo);
                ((SJctrDataObject)graphInfo.getManageData()).getDataMap().remove(KEY_LABELVIEW_ERR_MSG);
            }
            catch (SJcException excp) {
                if (this.checkErrChangeConfig(excp)) {
                    SJctrError error = new SJctrError(51, 22, 105247);
                    throw error.createException();
                }
                throw excp;
            }
            this.putCache("KEY_SEL_DISP_TERM", termLists);
            SJmoThroughRmiData rmiData = new SJmoThroughRmiData();
            rmiData.setObjRmi(monitoringInfo);
            ArrayList<SJmoThroughRmiData> rmiDataList = new ArrayList<SJmoThroughRmiData>();
            rmiDataList.add(rmiData);
            this.putCache("KEY_MONITORING_OPTION", rmiDataList);
            this.setPerformanceData(graphInfo, datas, startDate, endDate, termInfo, monitoringInfo);
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_UPDATE_FLG, new Boolean(true));
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISP_UPDATE_FLG, new Boolean(false));
        }
        catch (SJcException excp) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(excp, 107015);
        }
    }

    private void updateRealTimeUpdateData(SJctrSimpleDataModel graphInfo, int getdataFlg) {
        Date startDate = null;
        Date endDate = null;
        List<SJctrPlotDataInfo> datas = null;
        List<Map<String, Object>> graphDatas = null;
        MonMonitoringInfoLDKC monitoringInfo = null;
        boolean update = false;
        try {
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            this.checkRealTimeUpdate();
            monitoringInfo = SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
            String labelViewErr = "";
            Date prevEndDate = this.getPrevEndDate();
            if (prevEndDate != null) {
                endDate = monitoringInfo.getShortRangeInfo().getEndDate();
                if (prevEndDate.getTime() < endDate.getTime()) {
                    startDate = new Date();
                    startDate.setTime(prevEndDate.getTime());
                    long protStart = endDate.getTime() - (long)(60 * monitoringInfo.getInterval() * 1000);
                    if (startDate.getTime() < protStart) {
                        startDate.setTime(protStart);
                    }
                    graphDatas = this.getGraphDataObject();
                    try {
                        datas = this.getPerformanceData(graphDatas, startDate, endDate, termInfo);
                        ((SJctrDataObject)graphInfo.getManageData()).getDataMap().remove(KEY_LABELVIEW_ERR_MSG);
                    }
                    catch (SJcException excp) {
                        if (this.checkErrChangeConfig(excp)) {
                            labelViewErr = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.CONFIG_CHG_ERR);
                            datas = null;
                        }
                        throw excp;
                    }
                    update = true;
                }
            }
            if (update) {
                update = this.setPerformanceData(graphInfo, datas, startDate, endDate, termInfo, monitoringInfo);
            }
            boolean updateDisp = false;
            if (getdataFlg == 5) {
                List<?> dispList = this.getCache("KEY_DISPLAY_MODE");
                this.checkGetData(3, dispList, "GETDATAFLG_ADDGRAPH modeList");
                ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISPLAY_MODE, dispList.get(0));
                update = true;
                updateDisp = true;
            }
            if (labelViewErr.length() > 0) {
                ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_LABELVIEW_ERR_MSG, labelViewErr);
            }
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_UPDATE_FLG, new Boolean(update));
            ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_DISP_UPDATE_FLG, new Boolean(updateDisp));
        }
        catch (SJcException excp) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(excp, 107015);
        }
    }

    public Object getDataObject() {
        SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
        Integer flgObj = (Integer)((SJctrDataObject)graphInfo.getManageData()).getData(KEY_GETDATA_FLG);
        ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_GETDATA_FLG, null);
        if (flgObj == null) {
            return graphInfo.getManageData();
        }
        int getdataFlg = flgObj;
        switch (getdataFlg) {
            case 0: {
                this.updateConstructData(graphInfo);
                break;
            }
            case 1: {
                this.updateEditObjectData(graphInfo);
                break;
            }
            case 2: {
                this.updateAddGraphData(graphInfo);
                break;
            }
            case 3: {
                this.updateEditTimeRangeData(graphInfo);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.updateRealTimeUpdateData(graphInfo, getdataFlg);
            }
        }
        return graphInfo.getManageData();
    }

    private List<SJctrPlotDataInfo> getPerformanceData(List<Map<String, Object>> graphDatas, Date startDate, Date endDate, SJctrSelectDispTermInfo dispTermInfo) {
        List<SJctrPlotDataInfo> datas = null;
        HashMap paramMap = new HashMap();
        this.logUty.putlog("getPerformanceData", "create param class start");
        for (int cnt = 0; cnt < graphDatas.size(); ++cnt) {
            Map<String, Object> graphData = graphDatas.get(cnt);
            Map dataDetail = (Map)graphData.get(KEY_LIST_DATA);
            SJctrSelectedObjectInfo rowData = (SJctrSelectedObjectInfo)dataDetail.get(KEY_ROWDATA);
            Integer panelNoObj = (Integer)graphData.get(KEY_GRAPH_PANEL_NO);
            if (panelNoObj == null) {
                this.logUty.putlog("getPerformanceData", "panelNoObj null");
                SJctrError error = new SJctrError(51, 22, 107001);
                throw error.createException();
            }
            int panelNo = panelNoObj;
            this.addParam(paramMap, rowData, panelNo, startDate, endDate, dispTermInfo.getMonDataType());
        }
        this.logUty.putlog("getPerformanceData", "create param class end");
        datas = this.getPlotData(paramMap);
        return datas;
    }

    private void setInitAnchor(int initGraphPanelNo) {
        SJctrSimpleDataModel graphInfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_GRAPH_INFO);
        ((SJctrDataObject)graphInfo.getManageData()).setData(KEY_INIT_ANCHOR_PANEL, new Integer(initGraphPanelNo));
    }

    private String changeSelectedStr(String selectedStr) {
        String graphNoObj = "";
        String[] wk = null;
        if (null != selectedStr) {
            wk = selectedStr.split(" \\[");
        }
        if (wk != null && wk.length > 0) {
            graphNoObj = wk[0];
        }
        return graphNoObj;
    }

    private MonMonitoringInfoLDKC getMonitoringInfoNoParam() {
        Map<SJctrGetDirectWrapper, List<?>> map;
        MonMonitoringInfoLDKC monitoringInfo = null;
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetMonMonitoringInfoLDKC kind = new SJmoGetMonMonitoringInfoLDKC();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapperDetail = new SJctrGetDirectWrapper(direct);
        wrapperDetail.setCacheMode(false);
        set.add(wrapperDetail);
        try {
            map = this.getProxy().getDataInf(set);
        }
        catch (SJcException excp) {
            if (this.checkErrChangeConfig(excp)) {
                SJctrError error = new SJctrError(51, 22, 105247);
                throw error.createException();
            }
            throw excp;
        }
        List<SJmoThroughRmiData> monitoringOptionList = map.get(wrapperDetail);
        monitoringInfo = (MonMonitoringInfoLDKC)this.checkMonitoringInfo(monitoringOptionList);
        return monitoringInfo;
    }

    private MonitorInfoCollection getMonitoringInfoInParam(HIHsmPhysicalOwnerUseRateArgInfo ownerParam) {
        Map<SJctrGetDirectWrapper, List<?>> mapOwner;
        Object[] args = new Object[]{ownerParam};
        MonitorInfoCollection ownerInfo = new MonitorInfoCollection();
        SJmoGetMonitorInfoCollection kindOwner = new SJmoGetMonitorInfoCollection(args);
        SJmoGetRange_IF rangeOwner = null;
        ArrayList filterOwnerList = new ArrayList();
        SJmoGetDirect directOwner = new SJmoGetDirect(kindOwner, rangeOwner, filterOwnerList);
        SJctrGetDirectWrapper wrapperOwnerDetail = new SJctrGetDirectWrapper(directOwner);
        HashSet<SJctrGetDirectWrapper> setOwner = new HashSet<SJctrGetDirectWrapper>();
        wrapperOwnerDetail.setCacheMode(false);
        setOwner.add(wrapperOwnerDetail);
        try {
            mapOwner = this.getProxy().getDataInf(setOwner);
        }
        catch (SJcException excp) {
            if (this.checkErrChangeConfig(excp)) {
                SJctrError error = new SJctrError(51, 22, 105247);
                throw error.createException();
            }
            throw excp;
        }
        List<SJmoThroughRmiData> ownerInfoList = mapOwner.get(wrapperOwnerDetail);
        ownerInfo = (MonitorInfoCollection)this.checkMonitoringInfo(ownerInfoList);
        return ownerInfo;
    }

    private List<SJmoLdevNicknameInfo> getLDEVNickName() {
        SJmoGetLdevNicknameInfo kindLdevName = new SJmoGetLdevNicknameInfo();
        SJmoGetRange_IF rangeLdevName = null;
        ArrayList filterLdevNameList = new ArrayList();
        SJmoGetDirect directLdevName = new SJmoGetDirect(kindLdevName, rangeLdevName, filterLdevNameList);
        SJctrGetDirectWrapper wrapperLdevNameDetail = new SJctrGetDirectWrapper(directLdevName);
        HashSet<SJctrGetDirectWrapper> setLdevName = new HashSet<SJctrGetDirectWrapper>();
        setLdevName.add(wrapperLdevNameDetail);
        Map<SJctrGetDirectWrapper, List<?>> mapLdevName = this.getProxy().getDataInf(setLdevName);
        List<SJmoLdevNicknameInfo> ldevNameList = mapLdevName.get(wrapperLdevNameDetail);
        if (ldevNameList == null || ldevNameList.size() <= 0) {
            this.logUty.putlog("getLDEVNickName", "ldevNameList is null or empty");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        return ldevNameList;
    }

    private Object checkMonitoringInfo(List<SJmoThroughRmiData> monitoringOptionList) {
        SJmoThroughRmiData rmiData;
        Object monitoringInfo = null;
        if (monitoringOptionList != null && monitoringOptionList.size() > 0) {
            rmiData = monitoringOptionList.get(0);
            if (rmiData == null) {
                this.logUty.putlog("checkMonitoringInfo", "rmiData is null");
                SJctrError error = new SJctrError(51, 22, 107001);
                throw error.createException();
            }
        } else {
            this.logUty.putlog("checkMonitoringInfo", "monitoringOptionList is null or empty");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        monitoringInfo = rmiData.getObjRmi();
        if (monitoringInfo == null) {
            this.logUty.putlog("checkMonitoringInfo", "monitoringInfo is null");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        return monitoringInfo;
    }

    public static enum MON_MW_MSG implements SJctrNotifyState
    {
        UPD_REALTIME,
        SELECT_EDT_DISPOBJ,
        SELECT_CHG_DISPTERM,
        SELECT_ADD_GRAPH,
        SELECT_DELETE_GRAPH,
        SELECT_MP_LINK;

    }
}

