/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pbtsm.tierproperty;

import sanproject.serverux.dataimpl.TierInfoAtCurrent;
import sanproject.serverux.dataimpl.TierInfoPerPbTSMMonitor;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmGuidance;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmUtility;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrAverageNumberOfIoDataModelBase;

public class SJctrCurrentAverageNumberOfIoDataModel
extends SJctrAverageNumberOfIoDataModelBase {
    protected TierInfoAtCurrent[] tierInfoAtCurrent = null;
    private static final String KEY_CURRENT_IO_TERM_START_END = "COM_CURRENT_IO_TERM_START_END";
    private static final String KEY_CURRENT_AVG_NUM_OF_IO_TOTAL = "COM_CURRENT_AVG_NUM_OF_IO_TOTAL";
    private static final String KEY_CURRENT_AVG_NUM_OF_IO_TIER = "COM_CURRENT_AVG_NUM_OF_IO_TIER";
    private static final String CURRENT_IO_PER_HOUR_NAME = "Current Average Number of I/O(per Hour)";

    @Override
    @Deprecated
    protected long getIoPh(TierInfoPerPbTSMMonitor tierInfo) {
        return -1L;
    }

    @Override
    protected String getKeyAverageNumOfIoTotal() {
        return KEY_CURRENT_AVG_NUM_OF_IO_TOTAL;
    }

    @Override
    protected String getKeyAverageNumOfIoTier() {
        return KEY_CURRENT_AVG_NUM_OF_IO_TIER;
    }

    @Override
    protected String getIoPhNameStr() {
        return CURRENT_IO_PER_HOUR_NAME;
    }

    @Override
    protected void makeDataObject() {
        ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTotal(), "?");
        SJctrPbTsmUtility.initializeTierData(this, this.getKeyAverageNumOfIoTier(), SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), "?", "?"));
        this.pbtsmInfo = SJctrPbTsmUtility.getPbtsmInfoEntirePoolData(this.getDataController());
        this.tierInfoAtCurrent = this.pbtsmInfo.getTierInfoAtCurrent();
        if (null != this.tierInfoAtCurrent && 0 < this.tierInfoAtCurrent.length) {
            long totalIoPh = this.getTotalIoPh();
            this.makeTotalIoph(totalIoPh);
            this.makeIophEachTier(totalIoPh);
            SJctrPbTsmUtility.makeUnmountedTierRmiData(this.tierInfoAtCurrent, (SJctrSimpleDataModel)this, this.getKeyAverageNumOfIoTier(), SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), "-", "-"));
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "makeDataObject", "tierInfoAtCurrent is null or size illegal.");
        }
        ((SJctrDataObject)this.getManageData()).setData(KEY_CURRENT_IO_TERM_START_END, "?");
        this.makeIoTimeStartEnd();
    }

    @Override
    protected long getTotalIoPh() {
        long tierTotalIoPH = -2L;
        for (int tierNum = 0; tierNum < this.tierInfoAtCurrent.length; ++tierNum) {
            TierInfoAtCurrent tierInfo = this.tierInfoAtCurrent[tierNum];
            if (tierInfo != null) {
                long tierIoPH = tierInfo.getLCurrentIOPH();
                if (tierIoPH > -1L) {
                    if (tierTotalIoPH <= -1L) {
                        tierTotalIoPH = 0L;
                    }
                    tierTotalIoPH += tierIoPH;
                    continue;
                }
                if (tierIoPH == -1L) {
                    if (tierTotalIoPH != -2L) continue;
                    tierTotalIoPH = -1L;
                    continue;
                }
                SJctrLogUty.error(this.getClass().getSimpleName(), "getTotalIoPh", "tierIoPH is illegal.");
                continue;
            }
            SJctrLogUty.error(this.getClass().getSimpleName(), "getTotalIoPh", "tierInfo[" + tierNum + "] is null.");
        }
        return tierTotalIoPH;
    }

    @Override
    protected void makeIophEachTier(long tierTotalIoPh) {
        String strFuncName = "makeIophEachTier";
        for (int tierNum = 0; tierNum < this.tierInfoAtCurrent.length; ++tierNum) {
            TierInfoAtCurrent tierInfo = this.tierInfoAtCurrent[tierNum];
            if (tierInfo != null) {
                long tierIoPh = tierInfo.getLCurrentIOPH();
                if (tierIoPh >= 0L) {
                    long tierHitRate = SJctrPbTsmUtility.getTierHitRate(tierIoPh, tierTotalIoPh);
                    String tierIoHitRateStr = SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), String.valueOf(tierIoPh), String.valueOf(tierHitRate));
                    ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTier() + String.valueOf(tierNum + 1), tierIoHitRateStr);
                } else if (tierIoPh == -1L) {
                    ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTier() + String.valueOf(tierNum + 1), SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), "-", "-"));
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), strFuncName, "tierIoPh of tierInfoAtCurrent[" + tierNum + "] is illegal.");
                }
                this.getLogUty().putlog(strFuncName, this.getIoPhNameStr() + " Tier[" + tierNum + "] is " + tierIoPh);
                continue;
            }
            SJctrLogUty.error(this.getClass().getSimpleName(), strFuncName, "tierInfoAtCurrent[" + tierNum + "] is null.");
        }
    }

    protected void makeIoTimeStartEnd() {
        String ioTermStartTime = SJctrPbTsmUtility.getGMTTimeString(this.pbtsmInfo.getIoTermStartTime());
        String ioTermEndTime = SJctrPbTsmUtility.getGMTTimeString(this.pbtsmInfo.getIoTermEndTime());
        SJctrComUtility util = this.getComUtility();
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(util, SJctrPbTsmGuidance.BRACKET_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(util, SJctrPbTsmGuidance.BRACKET_RIGHT);
        String ioStartEndTime = lLeft + ioTermStartTime + " " + "-" + " " + ioTermEndTime + lRight;
        ((SJctrDataObject)this.getManageData()).setData(KEY_CURRENT_IO_TERM_START_END, ioStartEndTime);
    }
}

