/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pbtsm.tierproperty;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import sanproject.serverux.dataimpl.PbTSMFrequencyDistributionPlotInfo;
import sanproject.serverux.dataimpl.TierInfoPerPbTSMMonitor;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmGuidance;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmUtility;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPbTSMFrequencyDistributionInfo;

public class SJctrGraphDataModel
extends SJctrSimpleDataModel {
    private static final String KEY_RMI_ERROR_CODE = "COM_RMI_ERROR_CODE";
    private static final String KEY_START_TOD = "COM_START_TOD";
    private static final String KEY_END_TOD = "COM_END_TOD";
    private static final String KEY_PLOT_DATA_TOTAL = "COM_PLOT_DATA_TOTAL";
    private static final String KEY_PLOT_DATA_TIER = "COM_PLOT_DATA_TIER";
    private static final String KEY_GRAPH_CAP = "COM_GRAPH_CAP";
    private static final String KEY_IO_AVG = "COM_IO_AVG";
    private static final String KEY_IO_AVG_CHIP = "COM_IO_AVG_CHIP";
    private static final String KEY_TOTAL_IO = "COM_TOTAL_IO";
    private static final String KEY_LOWER_TIER = "COM_LOWER_TIER";
    private static final String KEY_DELTA_TIER = "COM_DELTA_TIER";
    private static final String KEY_X_UNIT = "COM_X_UNIT";
    private static final String KEY_X_MAX_VAL = "COM_X_MAX_VAL";
    private static final String KEY_FLG_DISPLAY_PLOT_LEGEND_TOTAL = "COM_FLG_DISPLAY_PLOT_LEGEND_TOTAL";
    private static final String KEY_FLG_DISPLAY_PLOT_LEGEND_TIER = "COM_FLG_DISPLAY_PLOT_LEGEND_TIER";
    private static final String KEY_FLG_DISPLAY_LOWER_LEGEND_TIER = "COM_FLG_DISPLAY_LOWER_LEGEND_TIER";
    private static final String DEFAULT_ERROR_CODE = "0";
    private static final int PLOT_DATA_MAX = 127;
    private static final String GRAPH_DUMMY_VAL = "0.1";
    private static final String DEFAULT_TIER_RANGE_VALUE = "-1";
    private static final long INVALID_TIER_RANGE_VALUE = 0xFFFFFFFFL;
    private static final String DEFAULT_X_ZERO_CAPACITY = "100";
    private static final String X_ZERO_CAPACITY = "0.00";
    private static final String STR_GMT = "GMT";

    @Override
    protected void makeDataObject() {
        SJctrPbTSMFrequencyDistributionInfo pbtsmInfo = SJctrPbTsmUtility.getPbtsmInfo(this.getDataController());
        long lErrorCode = pbtsmInfo.getLErrorCode();
        this.makeErrorCode(lErrorCode);
        Date dStartTime = pbtsmInfo.getMonitorStartTime();
        this.makeMonitorDate(KEY_START_TOD, dStartTime);
        Date dEndTime = pbtsmInfo.getMonitorEndTime();
        this.makeMonitorDate(KEY_END_TOD, dEndTime);
        long lPageSize = pbtsmInfo.getLPageSize();
        PbTSMFrequencyDistributionPlotInfo[] pbtsmPlotInfo = pbtsmInfo.getPbtsmFrequencyDistributionPlotInfo();
        long lMaxCapacity = lPageSize * this.getMaxCapacity(pbtsmPlotInfo);
        SJctrCapacityUtility capUtil = this.getComUtility().getCapacityUtility();
        long lBlock = capUtil.valueOf(lMaxCapacity, SJctrCapacityUtility.UNIT.KB);
        SJctrCapacityUtility.UNIT graphUnitLane = capUtil.getUnit(lBlock);
        this.makePlotData(KEY_PLOT_DATA_TOTAL, pbtsmPlotInfo, lPageSize, graphUnitLane);
        this.makeUnitXaxis(graphUnitLane);
        this.makeXmaxValue(lMaxCapacity, graphUnitLane);
        TierInfoPerPbTSMMonitor[] pbtsmEachTierInfo = pbtsmInfo.getTierInfoPerPbTSMMonitor();
        this.makeTierPlotData(pbtsmEachTierInfo, lPageSize, graphUnitLane);
        this.makeFlgDisplayLegend(pbtsmEachTierInfo);
    }

    private void makeErrorCode(long lErrorCode) {
        String strFuncName = "makeErrorCode";
        String strErrorCode = DEFAULT_ERROR_CODE;
        if (lErrorCode > -1L) {
            strErrorCode = String.valueOf(lErrorCode);
            this.getLogUty().putlog(strFuncName, "pbtsmInfo error code -errorcode:" + lErrorCode);
        } else {
            strErrorCode = "?";
            this.getLogUty().putlog(strFuncName, "lErrorCode is illegal");
            SJctrPbTsmUtility.SJctrErrorDialog(107002);
        }
        ((SJctrDataObject)this.getManageData()).setData(KEY_RMI_ERROR_CODE, strErrorCode);
    }

    private void makeMonitorDate(String key, Date dTime) {
        String strFuncName = "makeMonitorDate";
        String strTime = "";
        if (null != dTime) {
            if (0L < dTime.getTime()) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    sdf.setTimeZone(TimeZone.getTimeZone(STR_GMT));
                    strTime = sdf.format(dTime);
                }
                catch (IllegalArgumentException e) {
                    strTime = "?";
                    this.getLogUty().putlog(strFuncName, "dTime is illegal");
                }
                this.getLogUty().putlog(strFuncName, "dTime is " + dTime.getTime());
            } else {
                this.getLogUty().putlog(strFuncName, "dTime is " + dTime.getTime());
            }
        } else {
            this.getLogUty().putlog(strFuncName, "dTime is null");
        }
        ((SJctrDataObject)this.getManageData()).setData(key, strTime);
    }

    private long getMaxCapacity(PbTSMFrequencyDistributionPlotInfo[] pbtsmPlotInfo) {
        String strFuncName = "getMaxCapacity";
        long lMaxCapacity = 0L;
        if (null != pbtsmPlotInfo && 0 < pbtsmPlotInfo.length) {
            for (int i = 0; i < pbtsmPlotInfo.length && i < 127; ++i) {
                if (null != pbtsmPlotInfo[i]) {
                    long lGraphData = pbtsmPlotInfo[i].getLSumPage();
                    long lIoAvg = pbtsmPlotInfo[i].getLAverageIO();
                    long lTotalIo = pbtsmPlotInfo[i].getLSumIO();
                    if (0L <= lGraphData && 0L <= lIoAvg && 0L <= lTotalIo) {
                        if (lMaxCapacity >= lGraphData) continue;
                        lMaxCapacity = lGraphData;
                        continue;
                    }
                    this.getLogUty().putlog(strFuncName, "pbtsmPlotInfo[" + i + "] is illegal -sumpage:" + lGraphData + " -avgio:" + lIoAvg + " -totalio:" + lTotalIo);
                    continue;
                }
                this.getLogUty().putlog(strFuncName, "pbtsmPlotInfo[" + i + "] is null");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "pbtsmPlotInfo is null or size zero");
        }
        return lMaxCapacity;
    }

    private void makePlotData(String key, PbTSMFrequencyDistributionPlotInfo[] pbtsmPlotInfo, long lPageSize, SJctrCapacityUtility.UNIT graphUnitLane) {
        String strFuncName = "getPlotData";
        ArrayList graphDatas = new ArrayList();
        if (null != pbtsmPlotInfo && 0 < pbtsmPlotInfo.length) {
            for (int i = 0; i < pbtsmPlotInfo.length && i < 127; ++i) {
                if (null != pbtsmPlotInfo[i]) {
                    long lGraphData = pbtsmPlotInfo[i].getLSumPage();
                    long lIoAvg = pbtsmPlotInfo[i].getLAverageIO();
                    long lTotalIo = pbtsmPlotInfo[i].getLSumIO();
                    if (0L <= lGraphData && 0L <= lIoAvg && 0L <= lTotalIo) {
                        HashMap<String, String> graphData = new HashMap<String, String>();
                        long lCapacity = lPageSize * lGraphData;
                        String strGraphData = SJctrPbTsmUtility.getTierCapacity(this.getComUtility(), lCapacity, graphUnitLane);
                        graphData.put(KEY_GRAPH_CAP, strGraphData);
                        String strlIoAvg = GRAPH_DUMMY_VAL;
                        if (0L != lIoAvg) {
                            strlIoAvg = String.valueOf(lIoAvg);
                        }
                        graphData.put(KEY_IO_AVG, strlIoAvg);
                        String strlIoAvgChip = String.valueOf(lIoAvg);
                        graphData.put(KEY_IO_AVG_CHIP, strlIoAvgChip);
                        String strTotalIo = String.valueOf(lTotalIo);
                        graphData.put(KEY_TOTAL_IO, strTotalIo);
                        graphDatas.add(graphData);
                        continue;
                    }
                    this.getLogUty().putlog(strFuncName, "pbtsmPlotInfo[" + i + "] is illegal -sumpage:" + lGraphData + " -avgio:" + lIoAvg + " -totalio:" + lTotalIo);
                    continue;
                }
                this.getLogUty().putlog(strFuncName, "pbtsmPlotInfo[" + i + "] is null");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "pbtsmPlotInfo is null or size zero");
        }
        ((SJctrDataObject)this.getManageData()).setData(key, graphDatas);
    }

    private void makeTierPlotData(TierInfoPerPbTSMMonitor[] pbtsmEachTierInfo, long lPageSize, SJctrCapacityUtility.UNIT graphUnitLane) {
        String strFuncName = "makeTierPlotData";
        if (null != pbtsmEachTierInfo && 0 < pbtsmEachTierInfo.length) {
            for (int iTier = 0; iTier < pbtsmEachTierInfo.length; ++iTier) {
                TierInfoPerPbTSMMonitor pbtsmInfo = pbtsmEachTierInfo[iTier];
                if (null != pbtsmInfo) {
                    PbTSMFrequencyDistributionPlotInfo[] pbtsmPlotInfo = (PbTSMFrequencyDistributionPlotInfo[])pbtsmInfo.getObjFrequencyDistributionPlotInfo();
                    this.makePlotData(KEY_PLOT_DATA_TIER + String.valueOf(iTier + 1), pbtsmPlotInfo, lPageSize, graphUnitLane);
                    long lIoLower = pbtsmInfo.getLTierRangeValue();
                    this.makeStrIoLower(KEY_LOWER_TIER + String.valueOf(iTier + 1), lIoLower);
                    long lIoDelta = pbtsmInfo.getLTierRangeDelta();
                    this.makeStrIoDelta(KEY_DELTA_TIER + String.valueOf(iTier + 1), lIoDelta);
                    continue;
                }
                this.getLogUty().putlog(strFuncName, "pbtsmEachTierInfo[" + iTier + "] is null");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "pbtsmEachTierInfo is null or size zero");
        }
    }

    private void makeStrIoLower(String key, long lIoLower) {
        String strFuncName = "makeStrIoLower";
        String strIoLower = DEFAULT_TIER_RANGE_VALUE;
        if (0xFFFFFFFFL != lIoLower) {
            strIoLower = String.valueOf(lIoLower);
        } else {
            this.getLogUty().putlog(strFuncName, "lIoLower is illegal");
        }
        ((SJctrDataObject)this.getManageData()).setData(key, strIoLower);
    }

    private void makeStrIoDelta(String key, long lIoDelta) {
        String strFuncName = "makeStrIoDelta";
        String strIoDelta = "-";
        if (0xFFFFFFFFL != lIoDelta) {
            String delta = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.DELTA);
            strIoDelta = delta + String.valueOf(lIoDelta);
        } else {
            this.getLogUty().putlog(strFuncName, "lIoLower is illegal");
        }
        ((SJctrDataObject)this.getManageData()).setData(key, strIoDelta);
    }

    private void makeUnitXaxis(SJctrCapacityUtility.UNIT graphUnitLane) {
        String strFuncName = "makeUnitXaxis";
        String strUnit = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.GB);
        List graphDatas = (List)((SJctrDataObject)this.getManageData()).getData(KEY_PLOT_DATA_TOTAL);
        if (null != graphDatas && 0 < graphDatas.size()) {
            SJctrCapacityUtility capUtil = this.getComUtility().getCapacityUtility();
            strUnit = capUtil.getUnitString(graphUnitLane);
        } else {
            this.getLogUty().putlog(strFuncName, "graphDatas is null or size zero");
        }
        ((SJctrDataObject)this.getManageData()).setData(KEY_X_UNIT, strUnit);
    }

    private void makeXmaxValue(long lCapacityMaxLane, SJctrCapacityUtility.UNIT graphUnitLane) {
        String strFuncName = "makeXmaxValue";
        String strMaxCapacity = DEFAULT_X_ZERO_CAPACITY;
        List graphDatas = (List)((SJctrDataObject)this.getManageData()).getData(KEY_PLOT_DATA_TOTAL);
        if (null != graphDatas && 0 < graphDatas.size()) {
            String tmp = SJctrPbTsmUtility.getTierCapacity(this.getComUtility(), lCapacityMaxLane, graphUnitLane);
            if (!X_ZERO_CAPACITY.equals(tmp)) {
                strMaxCapacity = tmp;
            } else {
                this.getLogUty().putlog(strFuncName, "strMaxCapacity is zero value");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "graphDatas is null or size zero");
        }
        ((SJctrDataObject)this.getManageData()).setData(KEY_X_MAX_VAL, strMaxCapacity);
    }

    private void makeFlgDisplayLegend(TierInfoPerPbTSMMonitor[] pbtsmEachTierInfo) {
        int iTier;
        String strFuncName = "makeFlgDisplayLegend";
        ((SJctrDataObject)this.getManageData()).setData(KEY_FLG_DISPLAY_PLOT_LEGEND_TOTAL, false);
        for (iTier = 0; iTier < 3; ++iTier) {
            ((SJctrDataObject)this.getManageData()).setData(KEY_FLG_DISPLAY_PLOT_LEGEND_TIER + String.valueOf(iTier + 1), false);
            ((SJctrDataObject)this.getManageData()).setData(KEY_FLG_DISPLAY_LOWER_LEGEND_TIER + String.valueOf(iTier + 1), false);
        }
        if (null != pbtsmEachTierInfo && 0 < pbtsmEachTierInfo.length) {
            for (iTier = 0; iTier < pbtsmEachTierInfo.length; ++iTier) {
                ((SJctrDataObject)this.getManageData()).setData(KEY_FLG_DISPLAY_PLOT_LEGEND_TOTAL, true);
                ((SJctrDataObject)this.getManageData()).setData(KEY_FLG_DISPLAY_PLOT_LEGEND_TIER + String.valueOf(iTier + 1), true);
                ((SJctrDataObject)this.getManageData()).setData(KEY_FLG_DISPLAY_LOWER_LEGEND_TIER + String.valueOf(iTier + 1), true);
            }
        } else {
            this.getLogUty().putlog(strFuncName, "pbtsmEachTierInfo is null or size zero");
        }
    }
}

