/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pbtsm.tierproperty;

import java.util.ArrayList;
import sanproject.serverux.dataimpl.POOLgetPagesEachTierInfo;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmGuidance;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmUtility;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPoolGetPagesEachPolicyInfo;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolTierInfo;

public class SJctrUsedCapacityRatioTieringPolicyDataModel
extends SJctrSimpleDataModel {
    private static final String KEY_USED_CAPACITY_RATIO_TIERING_POLICY_TOTAL = "COM_USED_CAPACITY_RATIO_TIERING_POLICY_TOTAL";
    private static final String KEY_USED_CAPACITY_RATIO_TIERING_POLICY_TIER = "COM_USED_CAPACITY_RATIO_TIERING_POLICY_TIER";

    public void makeDataObjectForTieringPolicy() {
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        String strInitialize = "? " + lLeft + "?" + " " + percent + lRight;
        ((SJctrDataObject)this.getManageData()).setData(KEY_USED_CAPACITY_RATIO_TIERING_POLICY_TOTAL, strInitialize);
        SJctrPbTsmUtility.initializeTierData(this, KEY_USED_CAPACITY_RATIO_TIERING_POLICY_TIER, strInitialize);
        SJmoPoolDetail poolDetail = SJctrPbTsmUtility.getPoolDetail(this.getDataController());
        ArrayList<SJmoPoolTierInfo> alTierInfo = poolDetail.getAlTierInfo();
        long lPoolPages = poolDetail.getPoolPages();
        long lPoolPageSize = poolDetail.getPageSize();
        SJctrPoolGetPagesEachPolicyInfo pagesEachPolicyInfo = SJctrPbTsmUtility.getPagesEachPolicyInfo(this.getDataController());
        this.makeCapacityTieringPolicyTotal(pagesEachPolicyInfo, lPoolPages, lPoolPageSize);
        POOLgetPagesEachTierInfo[] pagesEachTierInfoList = pagesEachPolicyInfo.getObjTierPagesInfo();
        this.makeCapacityTieringPolicyEachTier(pagesEachTierInfoList, alTierInfo, lPoolPageSize);
        String bar = "-";
        String strUnmounted = bar + " " + lLeft + bar + " " + percent + lRight;
        SJctrPbTsmUtility.makeUnmountedTierData(this, KEY_USED_CAPACITY_RATIO_TIERING_POLICY_TIER, strUnmounted);
    }

    private void makeCapacityTieringPolicyTotal(SJctrPoolGetPagesEachPolicyInfo pagesEachPolicyInfo, long lPoolPages, long lPoolPageSize) {
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        SJctrPoolUtility poolUtility = this.getComUtility().getPoolUtility();
        long lPoolCapa = lPoolPages * lPoolPageSize;
        long lPolicyUsedPages = pagesEachPolicyInfo.getLPolicyUsedPages();
        long lPolicyUsedCapa = lPolicyUsedPages * lPoolPageSize;
        String strPolicyUsed = this.getStrCapacity(lPolicyUsedCapa);
        String strUsedRatio = poolUtility.capaRatioCalculation(lPolicyUsedCapa, lPoolCapa);
        String strUsedCapacityRatio = strPolicyUsed + " " + lLeft + strUsedRatio + percent + lRight;
        ((SJctrDataObject)this.getManageData()).setData(KEY_USED_CAPACITY_RATIO_TIERING_POLICY_TOTAL, strUsedCapacityRatio);
    }

    private void makeCapacityTieringPolicyEachTier(POOLgetPagesEachTierInfo[] pagesEachTierInfoList, ArrayList<SJmoPoolTierInfo> alTierInfo, long lPoolPageSize) {
        String strFuncName = "makeCapacityTieringPolicy";
        String percent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.PERCENT);
        String lLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String lRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(this.getComUtility(), SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        SJctrPoolUtility poolUtility = this.getComUtility().getPoolUtility();
        if (null != pagesEachTierInfoList && null != alTierInfo) {
            for (int iTier = 0; iTier < alTierInfo.size() && iTier < pagesEachTierInfoList.length; ++iTier) {
                POOLgetPagesEachTierInfo pageInfo = pagesEachTierInfoList[iTier];
                SJmoPoolTierInfo tierInfo = alTierInfo.get(iTier);
                if (null != pageInfo && null != tierInfo) {
                    String strTierNum = String.valueOf(iTier + 1);
                    long lTotalTier = tierInfo.getLTotalTier();
                    long lTotalPage = lTotalTier * lPoolPageSize;
                    long lTierUsedPages = pageInfo.getLTierUsedPages();
                    long lTierUsed = lTierUsedPages * lPoolPageSize;
                    String strPolicyUsed = this.getStrCapacity(lTierUsed);
                    String strUsedRatio = poolUtility.capaRatioCalculation(lTierUsed, lTotalPage);
                    String strUsedCapacityRatio = strPolicyUsed + " " + lLeft + strUsedRatio + percent + lRight;
                    ((SJctrDataObject)this.getManageData()).setData(KEY_USED_CAPACITY_RATIO_TIERING_POLICY_TIER + strTierNum, strUsedCapacityRatio);
                    continue;
                }
                this.getLogUty().putlog(strFuncName, "pagesEachTierInfoList[" + iTier + "] or alTierInfo[" + iTier + "] is null");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "pagesEachTierInfoList is null or alTierInfo is null");
        }
    }

    private String getStrCapacity(long lCapacity) {
        String strFuncName = "getStrCapacity";
        String strCapacity = "?";
        if (lCapacity > -1L) {
            SJctrCapacityUtility capaUtility = this.getComUtility().getCapacityUtility();
            long lBlock = capaUtility.valueOf(lCapacity, SJctrCapacityUtility.UNIT.KB);
            strCapacity = capaUtility.toUnitString(lBlock);
        } else {
            this.getLogUty().putlog(strFuncName, "lCapacity is illegal");
        }
        return strCapacity;
    }
}

