/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrAddingPoolVolCapacityColumnFromLdevDetail
extends SJctrCapacityColumn {
    public Map<String, Long> capMap = Collections.emptyMap();

    public SJctrAddingPoolVolCapacityColumnFromLdevDetail(String key) {
        super(key);
        this.setPartsId("YOU_ARE_ADDING");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<Long> retList = new ArrayList<Long>();
        SJmoLdevDetail ldevDtl = (SJmoLdevDetail)index;
        SJmoPgIndex pgIndex = new SJmoPgIndex();
        pgIndex.setFB4(ldevDtl.getIFB4());
        pgIndex.setPG(ldevDtl.getIPG());
        String pgKey = pgIndex.toString();
        Long pgPoolVolCap = this.capMap.get(pgKey);
        if (pgPoolVolCap == null) {
            List<?> pgAddingLdevMapList = basicData.get(SJctrPoolUtility.KEY_PG_SEL_LDEV);
            if (pgAddingLdevMapList == null || pgAddingLdevMapList.isEmpty()) {
                return Collections.emptyList();
            }
            Map pgAddingLdevMap = (Map)pgAddingLdevMapList.get(0);
            List poolVolList = (List)pgAddingLdevMap.get(pgKey);
            if (poolVolList == null || poolVolList.isEmpty()) {
                return Collections.emptyList();
            }
            long lbaSize = 0L;
            for (Object data : poolVolList) {
                SJmoLdevDetail poolVol = (SJmoLdevDetail)data;
                lbaSize += poolVol.getLLDEVLBASize();
            }
            retList.add(lbaSize);
            if (this.capMap == Collections.EMPTY_MAP) {
                int rowCount = this.getTable().getRowCount();
                this.capMap = new HashMap<String, Long>(rowCount);
            }
            this.capMap.put(pgKey, lbaSize);
        } else {
            retList.add(pgPoolVolCap);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (dataList != null && !dataList.isEmpty()) {
            long lbaSize = (Long)dataList.get(0);
            SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
            String select = this.getUnitSelect();
            SJctrCapacityUtility.UNIT unit = SJctrCapacityUtility.UNIT.GB;
            if (select.length() > 0) {
                unit = SJctrCapacityUtility.UNIT.valueOf(select);
            }
            String strCap = capaUtil.toString(lbaSize, unit);
            StringBuilder buf = new StringBuilder();
            buf.append(strCap);
            buf.append(" ");
            buf.append(capaUtil.getUnitString(unit));
            ret = buf.toString();
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long ret = -2L;
        SJmoLdevDetail ldevDtl = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        SJmoPgIndex pgIndex = new SJmoPgIndex();
        pgIndex.setFB4(ldevDtl.getIFB4());
        pgIndex.setPG(ldevDtl.getIPG());
        Long pgPoolVolCap = this.capMap.get(pgIndex.toString());
        if (pgPoolVolCap != null) {
            ret = pgPoolVolCap;
        }
        return ret;
    }
}

