/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.editexternalldevtierrank;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolLdevDetail;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.pool.editexternalldevtierrank.SJctrEditExternalLdevTierRankConfirmData;
import sanproject.sn2.controller.wizard.pool.editexternalldevtierrank.SJctrEditExternalLdevTierRankTableModel;
import sanproject.sn2.controller.wizard.pool.editexternalldevtierrank.SJctrEditTierRankDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrEditExternalLdevTierRankDC
extends SJctrWizardDataController {
    public static final int DISP_ID = 0x1101551;
    public static final String KEY_POOLVOLUME_TABLE = "COM_POOLVOLUME_TABLE";
    public static final String KEY_CHANGE_CMB = "COM_CHANGE_CMB";
    public static final String KEY_FOOTER = "COM_FOOTER";
    private SJctrEditExternalLdevTierRankTableModel editTierRankTable = null;
    private SJctrEditTierRankDataModel editTierRankDataModel = null;
    private SJmoPoolIndex selectPoolIndex = null;
    private List<SJmoLdevIndex> selectLdevIndexList = null;
    private List<SJmoLdevDetail> allLdevDetailList = null;
    private List<SJmoLdevNicknameInfo> allLdevNicknameInfoList = null;
    private List<SJctrPoolLdevDetail> poolLdevDetailConfirmDataList = null;
    private List<SJmoPoolNameInfo> poolNameInfoConfirmDataList = null;
    private List<SJmoLdevNicknameInfo> ldevNameInfoConfirmDataList = null;
    private boolean changeFlg = false;

    public SJctrEditExternalLdevTierRankDC() throws SJcException {
        super(0x1101551);
        this.initDataModel();
    }

    private void initDataModel() {
        this.editTierRankTable = new SJctrEditExternalLdevTierRankTableModel();
        this.addDataObjectModel(KEY_POOLVOLUME_TABLE, this.editTierRankTable);
        this.editTierRankDataModel = new SJctrEditTierRankDataModel();
        this.editTierRankDataModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrEditExternalLdevTierRankDC.this.changeAction();
                }
            }
        });
        this.addDataObjectModel(KEY_CHANGE_CMB, this.editTierRankDataModel);
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel());
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("EDITTIERRANK");
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> retSet = super.getModelDirect();
        SJctrGetDirectWrapper getDrctWrpPoolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        retSet.add(getDrctWrpPoolDtl);
        SJctrGetDirectWrapper getDrctWrpPoolVolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        retSet.add(getDrctWrpPoolVolDtl);
        SJctrGetDirectWrapper getDrctWrpLdevDetl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        retSet.add(getDrctWrpLdevDetl);
        SJctrGetDirectWrapper getDrctWrpLdevNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO);
        retSet.add(getDrctWrpLdevNameInf);
        SJctrGetDirectWrapper getDrctWrpPoolNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        retSet.add(getDrctWrpPoolNameInf);
        return retSet;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) throws SJcException {
        SJctrGetDirectWrapper getDrctWrap = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList search = new ArrayList();
            SJmoGetDirect getDrct = new SJmoGetDirect(kind, range, search);
            getDrctWrap = new SJctrGetDirectWrapper(getDrct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch InstantiationException", insExp);
            SJctrPoolUtility.SJctrErrorDialog(107009);
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch IllegalAccessException", illExp);
            SJctrPoolUtility.SJctrErrorDialog(107009);
        }
        return getDrctWrap;
    }

    @Override
    public boolean checkStartData() {
        boolean bRetChk = true;
        List<?> poolIndexList = this.getCache("KEY_CLASS_POOL_INDEX");
        List<?> ldevIndexList = this.getCache("KEY_CLASS_POOLVOL_INDEX");
        if (null == poolIndexList || 0 == poolIndexList.size() || null == ldevIndexList || 0 == ldevIndexList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "CacheData is null or size 0");
            SJctrPoolUtility.SJctrErrorDialog(107008);
        }
        this.selectPoolIndex = (SJmoPoolIndex)poolIndexList.get(0);
        this.selectLdevIndexList = ldevIndexList;
        return bRetChk;
    }

    @Override
    public boolean checkConstructData() {
        boolean bRetChk = true;
        List<?> allPoolDetailList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        List<?> allPoolVolDetailList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        List<?> allPoolNameInfoList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        this.allLdevDetailList = this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        this.allLdevNicknameInfoList = this.getCache(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO);
        if (null == allPoolDetailList || 0 == allPoolDetailList.size() || null == allPoolVolDetailList || 0 == allPoolVolDetailList.size() || null == allPoolNameInfoList || 0 == allPoolNameInfoList.size() || null == this.allLdevDetailList || 0 == this.allLdevDetailList.size() || null == this.allLdevNicknameInfoList || 0 == this.allLdevNicknameInfoList.size()) {
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        Collections.sort(allPoolDetailList);
        Collections.sort(allPoolVolDetailList);
        Collections.sort(allPoolNameInfoList);
        int iSelectPoolDtlIdx = Collections.binarySearch(allPoolDetailList, this.selectPoolIndex);
        int iSelectPoolVolDtlIdx = Collections.binarySearch(allPoolVolDetailList, this.selectPoolIndex);
        int iSelectPoolNameIdx = Collections.binarySearch(allPoolNameInfoList, this.selectPoolIndex);
        if (0 > iSelectPoolDtlIdx || 0 > iSelectPoolVolDtlIdx || 0 > iSelectPoolNameIdx) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Select Pool is not found");
            SJctrPoolUtility.SJctrErrorDialog(107023);
        }
        SJmoPoolNameInfo selectPoolNameInfo = (SJmoPoolNameInfo)allPoolNameInfoList.get(iSelectPoolNameIdx);
        this.poolNameInfoConfirmDataList = new ArrayList<SJmoPoolNameInfo>();
        this.poolNameInfoConfirmDataList.add(selectPoolNameInfo);
        SJmoPoolDetail selectPoolDetail = (SJmoPoolDetail)allPoolDetailList.get(iSelectPoolDtlIdx);
        SJmoPoolVolDetail selectPoolVolDetail = (SJmoPoolVolDetail)allPoolVolDetailList.get(iSelectPoolVolDtlIdx);
        ArrayList poolVolInfoList = selectPoolVolDetail.getAlPoolInfo();
        byte bPoolKind = selectPoolDetail.getPoolKind();
        if (2 == bPoolKind) {
            int iEmulationType = selectPoolDetail.getEmulationType();
            int iTierControlInfo = selectPoolDetail.getITierControlInfo();
            this.editTierRankLicenseCheck(iEmulationType, iTierControlInfo);
        } else {
            SJctrPoolUtility.SJctrErrorDialog(106164);
        }
        this.makeMainKeyList(selectPoolDetail, poolVolInfoList);
        return bRetChk;
    }

    @Override
    public void makeDataModel() {
        this.editTierRankTable.setBasicData(SJctrPoolLdevDetail.class, this.poolLdevDetailConfirmDataList);
        super.makeDataModel();
    }

    @Override
    public boolean checkFinishData(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        boolean bReturn = true;
        SJcMessage msg = SJctrPoolUtility.getWarningMsg(31, 22, 106169);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrUserController uc = this.getOwner();
        SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditExternalLdevTierRankDC.this.finishEvent(msgEvent, dstModel);
            }
        });
        this.addUpdateDisp(related);
        return bReturn;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        ArrayList<SJctrEditExternalLdevTierRankConfirmData> confirmDataList = new ArrayList<SJctrEditExternalLdevTierRankConfirmData>();
        SJctrEditExternalLdevTierRankConfirmData confirmData = new SJctrEditExternalLdevTierRankConfirmData();
        confirmData.setPoolNameInfoList(this.poolNameInfoConfirmDataList);
        confirmData.setPoolLdevDetailList(this.poolLdevDetailConfirmDataList);
        confirmData.setLdevNameInfoList(this.ldevNameInfoConfirmDataList);
        confirmDataList.add(confirmData);
        this.putCache(SJctrEditExternalLdevTierRankConfirmData.EDIT_EXTERNAL_LDEV_TIER_RANK_DATA, confirmDataList);
        return ret;
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        if (!this.changeFlg) {
            SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel(KEY_FOOTER);
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
        }
    }

    private void editTierRankLicenseCheck(int emulationType, int tierControlInfo) {
        boolean licenseCheackResult = false;
        SJctrAuthorizeContainer AuthorizeContainer = this.getOwner().getAuthorizeContainer();
        SJctrLicenseContainer licensecontainer = AuthorizeContainer.getLisenceContainer();
        boolean iDpLicenseFlg = licensecontainer.checkPP(SJctrLicenseContainer.PPID_DP);
        boolean iMfdpLicenseFlg = licensecontainer.checkPP(SJctrLicenseContainer.PPID_DPFM);
        boolean iDtLicenseFlg = licensecontainer.checkPP(SJctrLicenseContainer.PPID_HDTPM);
        boolean iMfdtLicenseFlg = licensecontainer.checkPP(SJctrLicenseContainer.PPID_MFDT);
        switch (emulationType) {
            case 0: {
                if (0 != (tierControlInfo & 0x80)) {
                    licenseCheackResult = iDpLicenseFlg & iDtLicenseFlg;
                    break;
                }
                licenseCheackResult = iDpLicenseFlg;
                break;
            }
            case 1: {
                if (0 != (tierControlInfo & 0x80)) {
                    licenseCheackResult = iDpLicenseFlg & iMfdpLicenseFlg & iDtLicenseFlg & iMfdtLicenseFlg;
                    break;
                }
                licenseCheackResult = iDpLicenseFlg & iMfdpLicenseFlg;
                break;
            }
            default: {
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
        }
        if (!licenseCheackResult) {
            SJctrPoolUtility.SJctrErrorDialog(106078);
        }
    }

    public void makeMainKeyList(SJmoPoolDetail poolDtl, List<SJmoPoolVolInfo> poolVolInfList) {
        this.poolLdevDetailConfirmDataList = new ArrayList<SJctrPoolLdevDetail>(this.selectLdevIndexList.size());
        this.ldevNameInfoConfirmDataList = new ArrayList<SJmoLdevNicknameInfo>(this.selectLdevIndexList.size());
        if (null == poolDtl || null == poolVolInfList || 0 == poolVolInfList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "makeMainKeyList", "ModelData is null or size 0");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        Collections.sort(poolVolInfList);
        Collections.sort(this.allLdevDetailList);
        Collections.sort(this.allLdevNicknameInfoList);
        for (SJmoLdevIndex ldevIndex : this.selectLdevIndexList) {
            int iPoolVolInfoIdx = Collections.binarySearch(poolVolInfList, ldevIndex);
            int iLdevDtlIdx = Collections.binarySearch(this.allLdevDetailList, ldevIndex);
            int iSelectLdevNameIdx = Collections.binarySearch(this.allLdevNicknameInfoList, ldevIndex);
            if (0 > iPoolVolInfoIdx || 0 > iLdevDtlIdx || 0 > iSelectLdevNameIdx) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makeMainKeyList", "ldevIndex Not Found");
                SJctrPoolUtility.SJctrErrorDialog(107023);
            }
            SJmoLdevNicknameInfo ldevNameInfo = this.allLdevNicknameInfoList.get(iSelectLdevNameIdx);
            this.ldevNameInfoConfirmDataList.add(ldevNameInfo);
            SJmoPoolVolInfo poolVolInfo = poolVolInfList.get(iPoolVolInfoIdx);
            SJmoPoolVolInfo poolVolInfoClone = null;
            try {
                poolVolInfoClone = (SJmoPoolVolInfo)poolVolInfo.clone();
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makeMainKeyList", "SJmoPoolVolInfo cloneError");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
            SJmoLdevDetail ldevDtl = this.allLdevDetailList.get(iLdevDtlIdx);
            if (!ldevDtl.getbExternalVolume()) {
                SJctrPoolUtility.SJctrErrorDialog(106165);
            }
            SJctrPoolLdevDetail poolldevDtl = new SJctrPoolLdevDetail();
            poolldevDtl.setLdevIndex(ldevDtl.getSLdkc(), ldevDtl.getSCu(), ldevDtl.getSLdev());
            poolldevDtl.setPoolLdevDetail(poolDtl, poolVolInfoClone, ldevDtl);
            this.poolLdevDetailConfirmDataList.add(poolldevDtl);
        }
        Collections.sort(this.poolLdevDetailConfirmDataList);
        Collections.sort(this.ldevNameInfoConfirmDataList);
    }

    private void changeAction() {
        List<Object> selectRowDataList = this.editTierRankTable.getSelectedRowData();
        short tierRank = this.editTierRankDataModel.getSelectTierRank();
        if (selectRowDataList != null && !selectRowDataList.isEmpty()) {
            for (Object selectRowData : selectRowDataList) {
                SJctrPoolLdevDetail poolLdevDetail = (SJctrPoolLdevDetail)selectRowData;
                SJmoPoolVolInfo poolVolInfo = poolLdevDetail.getPoolVolInfo();
                poolVolInfo.setSExtLdevAttribute(tierRank);
            }
            this.editTierRankTable.doRefresh();
            this.editTierRankDataModel.clearSelection();
            if (!this.changeFlg) {
                SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel(KEY_FOOTER);
                footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
                this.changeFlg = true;
            }
            this.getWizardWindow().rollback();
        }
    }
}

