/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.addreservevolumes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrEmulationTypeDef;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.local.addreservevolumes.SJctrAddReserveVolumesConfirmData;
import sanproject.sn2.controller.wizard.replication.local.addreservevolumes.SJctrAddReserveVolumesTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;

public class SJctrAddReserveVolumesDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101331;
    private static final String DISP_TITLE = "ADD_RESERVE_VOLS";
    private static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE_LDEV";
    private static final String KEY_TABLE_SELECT = "COM_TABLE_SELECT_LDEV";
    protected static final String KEY_ADD = "COM_ADD";
    protected static final String KEY_REMOVE = "COM_REMOVE";

    public SJctrAddReserveVolumesDC() {
        super(0x1101331);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrAddReserveVolumesTableModel availableTable = new SJctrAddReserveVolumesTableModel();
        availableTable.setNotifyUnitSelect(false);
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, availableTable);
        SJctrAddReserveVolumesTableModel selectedTable = new SJctrAddReserveVolumesTableModel();
        selectedTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SELECT, selectedTable);
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAddReserveVolumesDC.this.fireMessageEvent(ADD_RSV_VOL_MSG.SELECT_ADD);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAddReserveVolumesDC.this.fireMessageEvent(ADD_RSV_VOL_MSG.SELECT_REMOVE);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetLocalReplicationPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoLdevDetail> allLdevInfo = SJctrReplicationUtility.getSJmoLdevDetail(this);
            List<SJmoPortDetail> allPortInfo = SJctrReplicationUtility.getSJmoPortDetail(this);
            List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
            SJmoLocalReplicationPairVolInfoMgr pairVolMgr = SJctrReplicationUtility.getSJmoLocalReplicationPairVolInfoMgr(this);
            List<SJmoRSGgetAllRsgs> allRsgInfo = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            List<SJmoLdevStatusInfo> ldevStatusList = SJctrReplicationUtility.getSJmoLdevStatusInfo(this);
            List<SJmoLdevDetail> ldevExist = this.checkAndGetExistLdevDetailInfo(allLdevInfo, allPortInfo, portLunList, pairVolMgr, allRsgInfo, ldevStatusList);
            if (ldevExist.size() == 0) {
                this.logUty.putlog("ldevExist", "Information of Available Ldev is null.");
                SJctrError err = new SJctrError(209, 22, 106148);
                SJcException exp = err.createException();
                throw exp;
            }
            this.setAvailableTableData(ldevExist);
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrAddReserveVolumesConfirmData confirmData = new SJctrAddReserveVolumesConfirmData();
            SJctrAddReserveVolumesTableModel selectedLDEVsTable = (SJctrAddReserveVolumesTableModel)this.getDataObjectModel(KEY_TABLE_SELECT);
            List<Object> selectedList = selectedLDEVsTable.getAllRowData();
            Collections.sort(selectedList);
            confirmData.setLDEVsInfo(selectedList);
            confirmData.setNeedData(this);
            ArrayList<SJctrAddReserveVolumesConfirmData> confirmDataList = new ArrayList<SJctrAddReserveVolumesConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrAddReserveVolumesConfirmData.class, confirmDataList);
            SJctrReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void setAvailableTableData(List<SJmoLdevDetail> ldevsInfo) {
        SJctrAddReserveVolumesTableModel ldevsTable = (SJctrAddReserveVolumesTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrAddReserveVolumesTableModel selectedLdevsTable = (SJctrAddReserveVolumesTableModel)this.getDataObjectModel(KEY_TABLE_SELECT);
        ldevsTable.setBasicDataList(ldevsInfo);
        SJctrReplicationUtility.makeLdevCapacityUnit(ldevsTable, ldevsInfo);
        SJctrReplicationUtility.makeLdevCapacityUnit(selectedLdevsTable, ldevsInfo);
    }

    protected void initListener() {
        this.addMessageEventListener(ADD_RSV_VOL_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddReserveVolumesDC.this.addAction(event, dstModel);
            }
        });
        this.addMessageEventListener(ADD_RSV_VOL_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddReserveVolumesDC.this.removeAction(event, dstModel);
            }
        });
    }

    protected void addAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrAddReserveVolumesTableModel availableTable = (SJctrAddReserveVolumesTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<Object> addData = availableTable.getSelectedRowData();
        SJctrAddReserveVolumesTableModel selectedTable = (SJctrAddReserveVolumesTableModel)this.getDataObjectModel(KEY_TABLE_SELECT);
        if (selectedTable.getAllRowData().size() + addData.size() > 16384) {
            this.logUty.putlog("addAction", "The setting cannot be done because the number of selected LDEVs exceeds the number that can be set. ");
            SJctrError err = new SJctrError(209, 22, 106153);
            SJcException exp = err.createException();
            throw exp;
        }
        addData = availableTable.removeSelectedRowData();
        selectedTable.addRowDataTop(addData);
        this.updateFooter();
        this.setDirtyAll();
    }

    protected void removeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrAddReserveVolumesTableModel selectedTable = (SJctrAddReserveVolumesTableModel)this.getDataObjectModel(KEY_TABLE_SELECT);
        List<Object> removeData = selectedTable.removeSelectedRowData();
        SJctrAddReserveVolumesTableModel availableTable = (SJctrAddReserveVolumesTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        availableTable.addRowDataTop(removeData);
        this.updateFooter();
        this.setDirtyAll();
    }

    private List<SJmoLdevDetail> checkAndGetExistLdevDetailInfo(List<SJmoLdevDetail> allLdevDetailInfo, List<SJmoPortDetail> allPortDetailInfo, List<SJmoPortLunInfo> allPortLunInfo, SJmoLocalReplicationPairVolInfoMgr pairVolMgr, List<SJmoRSGgetAllRsgs> allRsgInfo, List<SJmoLdevStatusInfo> ldevStatusList) throws SJcException {
        if (allLdevDetailInfo == null || allPortDetailInfo == null || allPortLunInfo == null || pairVolMgr == null || allRsgInfo == null || ldevStatusList == null) {
            return new ArrayList<SJmoLdevDetail>(0);
        }
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>(allLdevDetailInfo.size());
        Collections.sort(ldevStatusList);
        List<SJmoLdevIndex> ficonPortLuList = SJctrReplicationUtility.getFICONPortLUList(allPortDetailInfo, allPortLunInfo);
        SJctrUserController userCtrl = this.getOwner();
        SJctrAuthorizeContainer authorizeContainer = userCtrl.getAuthorizeContainer();
        SJctrLicenseContainer ppcontainer = authorizeContainer.getLisenceContainer();
        boolean ppSIStatus = ppcontainer.checkPP(SJctrReplicationDataMacro.PPID_HOMRCF);
        boolean ppSIMFStatus = ppcontainer.checkPP(SJctrReplicationDataMacro.PPID_HMRCF);
        SJmoRSGgetAllRsgs allRsg = allRsgInfo.get(0);
        if (null == allRsg) {
            this.logUty.putlog("getBasicDataList", "Information of SJmoRSGgetAllRsgs is null.");
            return retList;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(userCtrl, allRsg);
        List<SJmoLdevIndex> rsgLdevList = rsgUtil.extractImpossibleLdev(allLdevDetailInfo);
        for (SJmoLdevDetail selectedVol : allLdevDetailInfo) {
            boolean rsvChkflg = true;
            if (null == selectedVol) continue;
            SJmoLocalReplicationPairVolInfo pairVolInfo = pairVolMgr.getLocalReplicationPairVolInfo(selectedVol);
            if (pairVolInfo != null) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getbLUPathCmdDev()) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getbJNLVolume()) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getbQsVvol()) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getbPoolVol()) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getbSystemDisk()) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getbExternalMfVolume()) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getBLockVolume()) {
                rsvChkflg = false;
                continue;
            }
            if (!(SJctrEmulationTypeDef.SI_USABLE_EMU.contains(selectedVol.getIEmulationType()) || SJctrEmulationTypeDef.SIMF_USABLE_EMU.contains(selectedVol.getIEmulationType()) || SJctrEmulationTypeDef.SS_USABLE_EMU.contains(selectedVol.getIEmulationType()))) {
                rsvChkflg = false;
                continue;
            }
            int ficonsearch = Collections.binarySearch(ficonPortLuList, selectedVol);
            if (ficonsearch >= 0) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getbOdmVol()) {
                rsvChkflg = false;
                continue;
            }
            int rsgsearch = Collections.binarySearch(rsgLdevList, selectedVol);
            if (rsgsearch >= 0) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getbTseVol()) {
                rsvChkflg = false;
                continue;
            }
            if (SJctrLdevUtility.isOpenVolume(selectedVol)) {
                if (!ppSIStatus) {
                    rsvChkflg = false;
                    continue;
                }
                if (selectedVol.getILUPathNumber() == 0) {
                    rsvChkflg = false;
                    continue;
                }
            } else if (SJctrLdevUtility.isMFVolume(selectedVol) && !ppSIMFStatus) {
                rsvChkflg = false;
                continue;
            }
            if (selectedVol.getbHIHSMReserve()) {
                rsvChkflg = false;
                continue;
            }
            if (!SJctrReplicationUtility.checkLdevStatus(selectedVol, ldevStatusList)) {
                rsvChkflg = false;
                continue;
            }
            if (!rsvChkflg) continue;
            retList.add(selectedVol);
        }
        return retList;
    }

    public static enum ADD_RSV_VOL_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

