/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrTiReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairsSubWizard;
import sanproject.sn2.model.connector.kind.SJmoGetPoolVolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetTiPvolStatus;
import sanproject.sn2.model.connector.kind.SJmoGetTiSnapshotPairList;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPair;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPairList;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrItemSelectListenerCreatePairsFromSSGroup
implements SJctrItemSelectListener {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            SJctrDataController dc = event.getSource().getDataController();
            SJctrUserController uc = dc.getOwner();
            SJctrTableDataModel pairsTopTable = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
            List<Object> ssGrpList = pairsTopTable.getSelectedRowData();
            if (ssGrpList == null || ssGrpList.isEmpty()) {
                SJctrCreateTIPairsSubWizard.makeCreateTiPairWizard(dc);
            } else {
                this.checkSelectedResources(pairsTopTable, dc, ssGrpList, uc);
                SJctrCreateTIPairsSubWizard.makeCreateTiPairWizardAtSSGrp(dc, ssGrpList);
            }
        }
    }

    private void checkSelectedResources(SJctrTableDataModel pairsTopTable, SJctrDataController dc, List<SJmoSnapshotSetInfo> ssGrpList, SJctrUserController uc) {
        List<SJmoPoolVolDetail> poolVolDtlList;
        List<?> tiPvolStatus = dc.getModelData(SJmoGetTiPvolStatus.class);
        SJmoTiPvolInfo[] infos = ((SJmoTiPvolStatus)tiPvolStatus.get(0)).getTiPvolInfo();
        List<?> tiSnapshotpairList = dc.getModelData(SJmoGetTiSnapshotPairList.class);
        SJmoTiSnapshotPairList list = (SJmoTiSnapshotPairList)tiSnapshotpairList.get(0);
        HashMap<Integer, SJmoTiSnapshotPair> allSnapshotMap = new HashMap<Integer, SJmoTiSnapshotPair>();
        for (SJmoTiSnapshotPair snapshot : list.getSnapshotPair()) {
            if (snapshot == null) continue;
            allSnapshotMap.put((int)snapshot.getSnapshotID(), snapshot);
        }
        ArrayList<SJmoTiSnapshotPair> targetList = new ArrayList<SJmoTiSnapshotPair>();
        for (SJmoSnapshotSetInfo info : ssGrpList) {
            SJmoTiSnapshotPair pair = (SJmoTiSnapshotPair)allSnapshotMap.get(info.getISnapshotSetId());
            if (pair == null || (long)info.getISnapshotSetId() != pair.getSnapshotID()) continue;
            targetList.add(pair);
        }
        List<SJmoLocalReplicationPairVolInfo> selectedPairsList = SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfoListFromSnapshot(targetList, list, infos);
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        List<Object> allRsgsList = SJctrReplicationUtility.getModelInfoNotUsedCache(dc, kind);
        SJmoRSGgetAllRsgs allRsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, allRsgsList);
        SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(uc, allRsg);
        int copytype = SJctrReplicationUtility.checkCopyTypeForLocalPairVolList(selectedPairsList);
        int[] chkstatus = SJctrReplicationDataMacro.CREATE_PAIR_STATUS_PASS_SNAPSHOT;
        if (!(2 != copytype && 3 != copytype || SJctrReplicationUtility.checkPoolVolListResource(selectedPairsList, rsgUty, poolVolDtlList = dc.getModelData(SJmoGetPoolVolDetail.class)))) {
            uc.getLogUty().putlog("selectChanged", "Pool volume not have permission to access.");
            SJctrError err = new SJctrError(209, 22, 106151);
            SJcException exp = err.createException();
            throw exp;
        }
        if (!SJctrReplicationUtility.checkLocalPairVolListStatus(selectedPairsList, chkstatus)) {
            uc.getLogUty().putlog("selectChanged", "Selected pair is invalid status.");
            SJctrError err = new SJctrError(209, 22, 106147);
            SJcException exp = err.createException();
            throw exp;
        }
    }
}

