/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.selectpvol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrHostGroupNameComparator;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetail_LdevComparator;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetail_PortHgComparator;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetail_PortHgLdevComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrPortHGFilterDataModel
extends SJctrSimpleDataModel {
    private final String KEY_PTFILTER = "COM_PTFILTER";
    private final String KEY_HGFILTER = "COM_HGFILTER";
    private static final String KEY_PORTTYPE = "COM_PTTYPE";
    protected static Map<String, Set<Byte>> portKindMap = Collections.emptyMap();
    protected String strSelObj = null;
    protected SJctrComboBoxDataModel ptFilter = null;
    protected SJctrComboBoxDataModel hgFilter = null;
    protected Map<Short, List<SJmoPortLunDetail>> portLuPathListMap = Collections.emptyMap();
    protected Map<Short, SJmoPortDetail> portDtlMap = Collections.emptyMap();
    protected List<SJmoPortDetail> portDtlList = Collections.emptyList();
    protected List<SJmoPortHostGroupInfo> portHGInfoList = Collections.emptyList();
    protected List<SJmoPortIscsiTargetInfo> portITInfoList = Collections.emptyList();
    protected Set<Integer> selectedLdevSet = Collections.emptySet();
    protected Set<Integer> unDistLdevSet = Collections.emptySet();
    protected SJctrPortLunDetail_PortHgLdevComparator LUPATH_CMP = new SJctrPortLunDetail_PortHgLdevComparator();
    protected SJctrPortLunDetail_PortHgComparator LUPATH_PTHG_CMP = new SJctrPortLunDetail_PortHgComparator();
    protected SJctrHostGroupNameComparator HGNAME_CMP = new SJctrHostGroupNameComparator();
    protected SJctrPortLunDetail_LdevComparator LUPATH_LDEV_CMP = new SJctrPortLunDetail_LdevComparator();
    private Comparator<SJmoPortLunDetail> LUPATH_HGNAME_CMP = null;
    private SJctrItemSelectListener itemSelectListener = null;
    private boolean reserve = false;
    private String hgSelection = null;
    public static final short HG_ANY = -1;
    public static final String GUID_HG_ANY = "ANY";
    protected SJctrPortUtility portUtil = null;

    public SJctrPortHGFilterDataModel() {
        this.ptFilter = new SJctrComboBoxDataModel();
        this.ptFilter.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    if (!SJctrPortHGFilterDataModel.this.reserve) {
                        SJctrPortHGFilterDataModel.this.setSelectPortType();
                    }
                    short portId = SJctrPortHGFilterDataModel.this.getSelectPortId();
                    SJctrPortHGFilterDataModel.this.refHostGroupFilter(portId);
                }
            }
        });
        this.addDataModel("COM_PTFILTER", this.ptFilter);
        this.hgFilter = new SJctrComboBoxDataModel();
        this.addDataModel("COM_HGFILTER", this.hgFilter);
    }

    public void initPortHGFilter(List<SJmoPortDetail> portDtlList, List<SJmoPortHostGroupInfo> portHGInfoList, List<SJmoPortIscsiTargetInfo> portITInfoList, List<SJmoPortLunDetail> luPathList, String strSelObj) {
        this.portDtlList = portDtlList;
        this.portHGInfoList = portHGInfoList;
        this.portITInfoList = portITInfoList;
        this.selectedLdevSet = new HashSet<Integer>(portDtlList.size());
        this.unDistLdevSet = new HashSet<Integer>(portDtlList.size());
        this.portDtlMap = new HashMap<Short, SJmoPortDetail>(portDtlList.size());
        this.portLuPathListMap = this.createPortLuPathMap(portDtlList, luPathList);
        this.portUtil = this.getComUtility().getPortUtility();
        this.makePortFilter(strSelObj);
    }

    protected HashMap<Short, List<SJmoPortLunDetail>> createPortLuPathMap(List<SJmoPortDetail> portDtlList, List<SJmoPortLunDetail> luPathList) {
        HashMap<Short, List<SJmoPortLunDetail>> retMap = new HashMap<Short, List<SJmoPortLunDetail>>(SJctrPortUtility.PORT_MAX);
        SJmoPortIndex searchPort = new SJmoPortIndex();
        for (SJmoPortLunDetail luPath : luPathList) {
            int index;
            short portId = luPath.getSPort();
            List<SJmoPortLunDetail> list = retMap.get(portId);
            if (list == null) {
                list = new ArrayList<SJmoPortLunDetail>(SJctrPortUtility.PORT_LUN_MAX);
                retMap.put(portId, list);
                searchPort.setSPort(portId);
                index = Collections.binarySearch(portDtlList, searchPort);
                if (index < 0) continue;
                SJmoPortDetail portDtl = portDtlList.get(index);
                this.portDtlMap.put(portId, portDtl);
            }
            if ((index = Collections.binarySearch(list, luPath, this.LUPATH_CMP)) >= 0) continue;
            int insertIndex = -(index + 1);
            list.add(insertIndex, luPath);
        }
        return retMap;
    }

    public void makePortFilter(String strSelObj) {
        this.makePortFilter(strSelObj, null);
    }

    protected void makePortFilter(String strSelObj, String selection) {
        this.strSelObj = strSelObj;
        this.ptFilter.clearSelection();
        this.ptFilter.removeAllItems();
        if (strSelObj == null) {
            return;
        }
        ArrayList<Short> portIdList = new ArrayList<Short>(this.portLuPathListMap.keySet());
        Collections.sort(portIdList);
        Set<Byte> portKindSet = portKindMap.get(strSelObj);
        Iterator i$ = portIdList.iterator();
        while (i$.hasNext()) {
            short portId = (Short)i$.next();
            SJmoPortDetail portDtl = this.portDtlMap.get(portId);
            byte byPortKindNo = portDtl.getByPortKindNo();
            if (!portKindSet.contains(byPortKindNo)) continue;
            String name = Short.toString(portId);
            String label = this.portUtil.toPortNameDisplay(portDtl);
            this.ptFilter.addItem(name, label);
        }
        if (selection == null) {
            this.ptFilter.setSelectedIndex(0);
        } else if (!this.ptFilter.setSelection(selection)) {
            this.ptFilter.setSelectedIndex(0);
        }
    }

    protected void refHostGroupFilter(short portId) {
        this.hgFilter.clearSelection();
        this.hgFilter.removeAllItems();
        SJmoPortIndex searchPort = new SJmoPortIndex();
        searchPort.setSPort(portId);
        SJmoPortDetail portDtl = this.portDtlMap.get(portId);
        if (!SJctrPortUtility.isIscsiPort(portDtl)) {
            int index = Collections.binarySearch(this.portHGInfoList, searchPort);
            if (index < 0) {
                return;
            }
            SJmoPortHostGroupInfo portHgInfo = this.portHGInfoList.get(index);
            ArrayList hgInfoList = new ArrayList(portHgInfo.getAlPortHostGroup());
            Collections.sort(hgInfoList, this.HGNAME_CMP);
            HashMap<Short, SJmoHostGroupInfo> hgInfoMap = new HashMap<Short, SJmoHostGroupInfo>(hgInfoList.size());
            for (SJmoHostGroupInfo hgInfo : hgInfoList) {
                short hgId = hgInfo.getSHostGroup();
                hgInfoMap.put(hgId, hgInfo);
            }
            this.LUPATH_HGNAME_CMP = new luPathHGNameComparator(hgInfoMap);
            ArrayList luPathList = new ArrayList(this.portLuPathListMap.get(portId));
            HashSet<Short> hgIDSet = new HashSet<Short>(luPathList.size());
            Collections.sort(luPathList, this.LUPATH_HGNAME_CMP);
            this.hgFilter.addItem(Short.toString((short)-1), this.getComUtility().getGuidance(GUID_HG_ANY));
            for (SJmoPortLunDetail luPath : luPathList) {
                SJmoHostGroupInfo hgInfo;
                short hgId = luPath.getSHostGroup();
                if (!hgIDSet.add(hgId) || (hgInfo = (SJmoHostGroupInfo)hgInfoMap.get(hgId)) == null) continue;
                String name = Short.toString(hgId);
                String label = this.portUtil.toHostGroupNameDisplay(hgInfo);
                this.hgFilter.addItem(name, label);
            }
        } else {
            int index = Collections.binarySearch(this.portITInfoList, searchPort);
            if (index < 0) {
                return;
            }
            SJmoPortIscsiTargetInfo portItInfo = this.portITInfoList.get(index);
            ArrayList<SJmoIscsiTargetInfo> itInfoList = new ArrayList<SJmoIscsiTargetInfo>(portItInfo.getAlPortIscsiTarget());
            Collections.sort(itInfoList, this.HGNAME_CMP);
            HashMap<Short, SJmoIscsiTargetInfo> itInfoMap = new HashMap<Short, SJmoIscsiTargetInfo>(itInfoList.size());
            for (SJmoIscsiTargetInfo itInfo : itInfoList) {
                short itId = itInfo.getSIscsiTarget();
                itInfoMap.put(itId, itInfo);
            }
            this.LUPATH_HGNAME_CMP = new luPathITAliasComparator(itInfoMap);
            ArrayList luPathList = new ArrayList(this.portLuPathListMap.get(portId));
            HashSet<Short> hgIDSet = new HashSet<Short>(luPathList.size());
            Collections.sort(luPathList, this.LUPATH_HGNAME_CMP);
            this.hgFilter.addItem(Short.toString((short)-1), this.getComUtility().getGuidance(GUID_HG_ANY));
            for (SJmoPortLunDetail luPath : luPathList) {
                SJmoIscsiTargetInfo itInfo;
                short hgId = luPath.getSHostGroup();
                if (!hgIDSet.add(hgId) || (itInfo = (SJmoIscsiTargetInfo)itInfoMap.get(hgId)) == null) continue;
                String name = Short.toString(hgId);
                String label = this.portUtil.toIscsiTargetAliasDisplay(itInfo);
                this.hgFilter.addItem(name, label);
            }
        }
        if (this.hgSelection != null) {
            if (!this.hgFilter.setSelection(this.hgSelection)) {
                this.hgFilter.setSelectedIndex(0);
            }
        } else {
            this.hgFilter.setSelectedIndex(0);
        }
    }

    public short getSelectPortId() {
        short ret = -1;
        String selection = this.ptFilter.getSelection();
        if (selection != null && selection.length() > 0) {
            ret = Short.valueOf(selection);
        }
        return ret;
    }

    public short getSelectHGId() {
        short ret = -1;
        String selection = this.hgFilter.getSelection();
        if (selection != null && selection.length() > 0) {
            ret = Short.valueOf(selection);
        }
        return ret;
    }

    public List<SJmoPortLunDetail> getAvailablePathInfo() {
        ArrayList<SJmoPortLunDetail> retList = null;
        short portId = this.getSelectPortId();
        ArrayList pathList = new ArrayList();
        if (this.portLuPathListMap.get(portId) == null) {
            return new ArrayList<SJmoPortLunDetail>();
        }
        pathList = new ArrayList(this.portLuPathListMap.get(portId));
        retList = new ArrayList<SJmoPortLunDetail>(pathList.size());
        Collections.sort(pathList, this.LUPATH_HGNAME_CMP);
        short selectHgId = this.getSelectHGId();
        HashSet<Integer> ldevIdSet = new HashSet<Integer>(pathList.size());
        for (SJmoPortLunDetail luPath : pathList) {
            int ldevKey;
            short hgId;
            if (selectHgId != -1 && selectHgId != (hgId = luPath.getSHostGroup()) || this.selectedLdevSet.contains(ldevKey = SJctrReplicationUtility.getLdevIndexKey(luPath)) || this.unDistLdevSet.contains(ldevKey) || !ldevIdSet.add(ldevKey)) continue;
            retList.add(luPath);
        }
        Collections.sort(retList, this.LUPATH_LDEV_CMP);
        return retList;
    }

    public void addLUPathList(List<SJmoPortLunDetail> addPathList) {
        boolean addPort = false;
        boolean addHg = false;
        SJmoPortIndex portIndex = new SJmoPortIndex();
        for (SJmoPortLunDetail addPath : addPathList) {
            int index;
            short portId = addPath.getSPort();
            List<SJmoPortLunDetail> pathList = this.portLuPathListMap.get(portId);
            if (pathList == null) {
                pathList = new ArrayList<SJmoPortLunDetail>(SJctrPortUtility.PORT_LUN_MAX);
                this.portLuPathListMap.put(portId, pathList);
                portIndex.setSPort(portId);
                index = Collections.binarySearch(this.portDtlList, portIndex);
                if (index < 0) continue;
                SJmoPortDetail portDtl = this.portDtlList.get(index);
                this.portDtlMap.put(portId, portDtl);
                addPort = true;
            }
            if (Collections.binarySearch(pathList, addPath, this.LUPATH_PTHG_CMP) < 0) {
                addHg = true;
            }
            if ((index = Collections.binarySearch(pathList, addPath, this.LUPATH_CMP)) < 0) {
                int insertIndex = -(index + 1);
                pathList.add(insertIndex, addPath);
                continue;
            }
            this.removeUndispLdev(addPath);
        }
        this.hgSelection = this.hgFilter.getSelection();
        if (addPort) {
            String selection = this.ptFilter.getSelection();
            this.makePortFilter(this.strSelObj, selection);
        } else if (addHg) {
            short portId = this.getSelectPortId();
            this.refHostGroupFilter(portId);
        } else {
            this.hgFilter.clearSelection();
            this.hgFilter.setSelection(this.hgSelection);
        }
        this.hgSelection = null;
    }

    public void addSelectedLdev(SJmoPortLunDetail luPath) {
        int ldevKey = SJctrReplicationUtility.getLdevIndexKey(luPath);
        this.selectedLdevSet.add(ldevKey);
    }

    public void addSelectedLdev(List<SJmoPortLunDetail> luPathList) {
        for (SJmoPortLunDetail luPath : luPathList) {
            this.addSelectedLdev(luPath);
        }
    }

    public void removeSelectedLdev(SJmoPortLunDetail luPath) {
        int ldevKey = SJctrReplicationUtility.getLdevIndexKey(luPath);
        this.selectedLdevSet.remove(ldevKey);
    }

    public void addUndispLdev(SJmoPortLunDetail luPath) {
        int ldevKey = SJctrReplicationUtility.getLdevIndexKey(luPath);
        this.unDistLdevSet.add(ldevKey);
    }

    public void removeUndispLdev(SJmoPortLunDetail luPath) {
        int ldevKey = SJctrReplicationUtility.getLdevIndexKey(luPath);
        this.unDistLdevSet.remove(ldevKey);
    }

    private void setSelectPortType() {
        short portId = this.getSelectPortId();
        SJmoPortDetail portDtl = this.portDtlMap.get(portId);
        if (portDtl != null) {
            byte portKind = portDtl.getByPortKindNo();
            String strPortKind = SJctrComUtility.toDecString(portKind);
            ((SJctrDataObject)this.getManageData()).setData(KEY_PORTTYPE, strPortKind);
            this.setDirty();
        }
    }

    public void setDefaultSelection() {
        this.ptFilter.clearSelection();
        this.ptFilter.setSelectedIndex(0);
    }

    public void setReserve(boolean flg) {
        this.reserve = flg;
    }

    public void initListener() {
        if (this.itemSelectListener == null) {
            this.itemSelectListener = new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    if (event.isSelect() && !SJctrPortHGFilterDataModel.this.reserve) {
                        SJctrPortHGFilterDataModel.this.fireMessageEvent(CHGFILTER_MSG.CHG_HGFILTER);
                    }
                }
            };
            this.hgFilter.addItemSelectListener(this.itemSelectListener);
        }
    }

    static {
        portKindMap = new HashMap<String, Set<Byte>>();
        HashSet<Byte> fibreSet = new HashSet<Byte>();
        fibreSet.add((byte)2);
        fibreSet.add((byte)6);
        portKindMap.put("COM_FIBRE", fibreSet);
        HashSet<Byte> iscsiSet = new HashSet<Byte>();
        iscsiSet.add((byte)5);
        portKindMap.put("COM_ISCSI", iscsiSet);
        HashSet<Byte> hnas_UserSet = new HashSet<Byte>();
        hnas_UserSet.add((byte)7);
        portKindMap.put("COM_HNAS_USER", hnas_UserSet);
    }

    protected class luPathITAliasComparator
    implements Comparator<SJmoPortLunDetail> {
        private Map<Short, SJmoIscsiTargetInfo> itInfoMap = Collections.emptyMap();

        public luPathITAliasComparator(Map<Short, SJmoIscsiTargetInfo> itInfoMap) {
            this.itInfoMap = itInfoMap;
        }

        @Override
        public int compare(SJmoPortLunDetail luPath1, SJmoPortLunDetail luPath2) {
            String itAlias1 = this.getITAlias(luPath1);
            String itAlias2 = this.getITAlias(luPath2);
            return itAlias1.compareTo(itAlias2);
        }

        private String getITAlias(SJmoPortLunDetail luPath) {
            String ret = "";
            SJmoIscsiTargetInfo itInfo = this.itInfoMap.get(luPath.getSHostGroup());
            if (itInfo != null) {
                ret = itInfo.getStrIscsiTargetAlias();
            }
            return ret;
        }
    }

    protected class luPathHGNameComparator
    implements Comparator<SJmoPortLunDetail> {
        private Map<Short, SJmoHostGroupInfo> hgInfoMap = Collections.emptyMap();

        public luPathHGNameComparator(Map<Short, SJmoHostGroupInfo> hgInfoMap) {
            this.hgInfoMap = hgInfoMap;
        }

        @Override
        public int compare(SJmoPortLunDetail luPath1, SJmoPortLunDetail luPath2) {
            String hgName1 = this.getHGName(luPath1);
            String hgName2 = this.getHGName(luPath2);
            return hgName1.compareTo(hgName2);
        }

        private String getHGName(SJmoPortLunDetail luPath) {
            String ret = "";
            SJmoHostGroupInfo hgInfo = this.hgInfoMap.get(luPath.getSHostGroup());
            if (hgInfo != null) {
                ret = hgInfo.getStrHostgroupNickName();
            }
            return ret;
        }
    }

    public static enum CHGFILTER_MSG implements SJctrNotifyState
    {
        CHG_HGFILTER;

    }
}

