/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.splitpairs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrLocalPairInfoComparator;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.replication.com.SJctrItemSelectListenerLReplicaBase;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicationDataMacro;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;

public abstract class SJctrItemSelectListenerSplitPairsBase<T extends SJctrSubWizard>
extends SJctrItemSelectListenerLReplicaBase {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            SJctrDataController dc = event.getSource().getDataController();
            List<SJmoLocalReplicationPairVolInfo> selectedPairList = this.getLocalReplicationPairVolInfo(dc);
            if (selectedPairList.isEmpty()) {
                SJctrError err = new SJctrError(209, 22, 106534);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrUserController uc = dc.getOwner();
            this.checkRSGInfoFromSelectedPairList(dc, uc, selectedPairList);
            int copytype = this.checkCopyTypeFromSelectedPairList(uc, selectedPairList);
            if (0 == copytype) {
                this.checkFiconVolFromSelectedPairList(dc, uc, selectedPairList);
            }
            int[] chkstatus = null;
            if (0 == copytype || 1 == copytype) {
                chkstatus = SJctrReplicationDataMacro.SPLIT_PAIR_STATUS_PASS_SI_SIMF;
            } else if (2 == copytype || 3 == copytype) {
                chkstatus = SJctrReplicationDataMacro.SPLIT_PAIR_STATUS_PASS_SNAPSHOT;
            } else {
                uc.getLogUty().putlog("selectChanged", "Copy Type is invalid.");
                SJctrError err = new SJctrError(209, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean bstatus = SJctrReplicationUtility.checkLocalPairVolListStatus(selectedPairList, chkstatus);
            if (!bstatus) {
                uc.getLogUty().putlog("selectChanged", "Selected pair is invalid status.");
                SJctrError err = new SJctrError(209, 22, 106147);
                SJcException exp = err.createException();
                throw exp;
            }
            Collections.sort(selectedPairList, new SJctrLocalPairInfoComparator());
            ArrayList<Serializable> param = new ArrayList<Serializable>();
            HashMap<String, List<SJmoLocalReplicationPairVolInfo>> paramMap = new HashMap<String, List<SJmoLocalReplicationPairVolInfo>>();
            paramMap.put("KEY_SELECTED_SVOL", selectedPairList);
            param.add(this.getSubWizardClass());
            param.add(paramMap);
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_WIZARD, param);
        }
    }

    protected abstract Class<T> getSubWizardClass();

    protected abstract List<SJmoLocalReplicationPairVolInfo> getLocalReplicationPairVolInfo(SJctrDataController var1);
}

