/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.viewpairproperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrTiReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.replication.com.SJctrTIPVolSnapshotGroupInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;
import sanproject.sn2.controller.wizard.replication.local.viewpairproperties.SJctrViewPairPropertiesDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetTiPvolStatus;
import sanproject.sn2.model.connector.kind.SJmoGetTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.replication.local.manager.SJmoSnapshotSetInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrViewTIPairPropertiesDC
extends SJctrViewPairPropertiesDC {
    private List<SJmoTiPvolMu> selectPVolMuList = Collections.emptyList();
    private Map<Long, List<SJmoLocalReplicationPairVolInfo>> tiPairInfoListMap = Collections.emptyMap();
    protected SJmoSnapshotSetInfoMgr ssGrpMgr = null;
    protected SJmoTiSnapshotPairList tiSSPairList = null;
    protected SJmoTiPvolStatus tiPVolStatus = null;
    private boolean showAllTreeFlg = false;

    @Override
    public boolean checkStartData() {
        while (true) {
            List<?> getPVolList;
            if ((getPVolList = this.getCache("KEY_SELECTED_PVOL")) != null) {
                if (getPVolList.isEmpty()) {
                    SJctrCreateTIPairUtility.createError(107001);
                }
                this.selectPVolMuList = new ArrayList<SJmoTiPvolMu>(getPVolList.size());
                for (Object pVol : getPVolList) {
                    if (!(pVol instanceof SJmoLdevIndex)) {
                        SJctrCreateTIPairUtility.createError(107001);
                    }
                    SJmoLdevIndex pVolLdevIndex = (SJmoLdevIndex)pVol;
                    SJmoTiPvolMu tiPVolMu = SJctrCreateTIPairUtility.createTiPVolMuInfo(pVolLdevIndex.getSLdkc(), pVolLdevIndex.getSCu(), pVolLdevIndex.getSLdev(), (short)-1);
                    this.selectPVolMuList.add(tiPVolMu);
                }
                this.showAllTreeFlg = true;
                break;
            }
            List<?> getPVolMuList = this.getCache("KEY_SELECTED_PVOL_MU");
            if (getPVolMuList != null) {
                if (getPVolMuList.isEmpty()) {
                    SJctrCreateTIPairUtility.createError(107001);
                }
                for (Object pVolMu : getPVolMuList) {
                    if (pVolMu instanceof SJmoTiPvolMu) continue;
                    SJctrCreateTIPairUtility.createError(107001);
                }
                this.selectPVolMuList = new ArrayList(getPVolMuList);
                break;
            }
            SJctrCreateTIPairUtility.createError(107001);
        }
        Collections.sort(this.selectPVolMuList);
        return true;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        List<?> pairVolMgrList = this.getCache(SJmoGetLocalReplicationPairVolInfoMgr.class);
        if (pairVolMgrList == null || pairVolMgrList.size() == 0) {
            SJctrCreateTIPairUtility.createError(107002);
        }
        this.pairVolMgr = (SJmoLocalReplicationPairVolInfoMgr)pairVolMgrList.get(0);
        List<?> tiSSPairInfoList = this.getCache(SJmoGetTiSnapshotPairList.class);
        if (tiSSPairInfoList == null || tiSSPairInfoList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoTiSnapshotPairList is null or Empty.");
            SJctrCreateTIPairUtility.createError(107002);
        }
        this.tiSSPairList = (SJmoTiSnapshotPairList)tiSSPairInfoList.get(0);
        List<?> tiPVolStatusList = this.getCache(SJmoGetTiPvolStatus.class);
        if (tiPVolStatusList == null || tiPVolStatusList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoTiPvolStatus is null or Empty.");
            SJctrCreateTIPairUtility.createError(107002);
        }
        this.tiPVolStatus = (SJmoTiPvolStatus)tiPVolStatusList.get(0);
        Object[] tiPVolArray = this.tiPVolStatus.getTiPvolInfo();
        HashSet pVolSet = new HashSet(this.selectPVolMuList.size());
        int pairNum = 0;
        for (SJmoTiPvolMu pVolMu : this.selectPVolMuList) {
            if (this.showAllTreeFlg) {
                int index = Arrays.binarySearch(tiPVolArray, pVolMu);
                if (index >= 0) {
                    Object tiPVolInfo = tiPVolArray[index];
                    pairNum = (int)((long)pairNum + ((SJmoTiPvolInfo)tiPVolInfo).getPairnum());
                    continue;
                }
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "RootVol is not Find. LDEV: " + pVolMu.toString());
                SJctrCreateTIPairUtility.createError(206525);
                continue;
            }
            ++pairNum;
        }
        if (pairNum > 32768) {
            SJctrCreateTIPairUtility.createError(205159);
        }
        return ret;
    }

    @Override
    protected void initProperties() {
        this.tiPairInfoListMap = this.getTiPairMap();
        for (SJmoTiPvolMu pVolMu : this.selectPVolMuList) {
            short mu;
            long pvolMuIndexKey = SJctrTiReplicationUtility.getPvolMuIndexKey(pVolMu);
            List<SJmoLocalReplicationPairVolInfo> pairList = this.tiPairInfoListMap.get(pvolMuIndexKey);
            if (pairList == null || pairList.isEmpty()) {
                SJctrCreateTIPairUtility.createError(106117);
            }
            if ((mu = pVolMu.getMu()) == -1) continue;
            boolean find = false;
            for (SJmoLocalReplicationPairVolInfo pairInfo : pairList) {
                if (pairInfo.getPVolIndex().getIndex() != pVolMu.getIndex() || pairInfo.getSMuNum() != mu) continue;
                find = true;
                break;
            }
            if (find) continue;
            SJctrCreateTIPairUtility.createError(106117);
        }
        this.dispPageIndex = 0;
        this.tortalPageNum = this.selectPVolMuList.size();
        this.selectPairSVolList = new ArrayList(this.tortalPageNum);
        this.relationPairsMap = new HashMap(this.tortalPageNum);
        int pairNum = 0;
        for (int pageIndex = 0; pageIndex < this.tortalPageNum; ++pageIndex) {
            List<SJmoLocalReplicationPairVolInfo> dispPairList = this.getDispPairList(pageIndex);
            SJmoLocalReplicationPairVolInfo dispPair = this.getSummaryPair(pageIndex, dispPairList);
            this.selectPairSVolList.add(dispPair);
            this.relationPairsMap.put(pageIndex, dispPairList);
            pairNum += dispPairList.size();
        }
        this.refDataModel();
    }

    private Map<Long, List<SJmoLocalReplicationPairVolInfo>> getTiPairMap() {
        HashMap<Long, List<SJmoLocalReplicationPairVolInfo>> retMap = new HashMap<Long, List<SJmoLocalReplicationPairVolInfo>>();
        SJmoTiPvolStatus tiPvolStatus = (SJmoTiPvolStatus)this.getProxy().getCache(SJmoGetTiPvolStatus.class).get(0);
        if (null == tiPvolStatus) {
            this.getLogUty().putlog("getSJmoTiPvolStatus", "Information of SJmoTiPvolStatus is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoTiSnapshotPairList ssPairList = (SJmoTiSnapshotPairList)this.getProxy().getCache(SJmoGetTiSnapshotPairList.class).get(0);
        if (null == ssPairList) {
            this.getLogUty().putlog("getSJmoTiSnapshotPairList", "Information of SJmoTiSnapshotPairList is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoLdevIndex> rootLdevList = new ArrayList<SJmoLdevIndex>();
        SJmoTiPvolInfo[] tiPvolInfos = tiPvolStatus.getTiPvolInfo();
        if (this.showAllTreeFlg) {
            for (SJmoLdevIndex sJmoLdevIndex : this.selectPVolMuList) {
                rootLdevList.add(sJmoLdevIndex);
            }
            List<SJmoTiPvolInfo> tiPvolInfoList = SJctrTiReplicationUtility.checkAndGetExistRootLdevInfo(rootLdevList, tiPvolInfos);
            List<SJmoLocalReplicationPairVolInfo> list = SJctrTiReplicationUtility.getTiTreePairInfoListFromModelThrough(tiPvolInfoList, this, ssPairList);
            for (SJmoTiPvolMu pvolMu : this.selectPVolMuList) {
                ArrayList<SJmoLocalReplicationPairVolInfo> treeList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
                int checkIndex = pvolMu.getIndex();
                for (SJmoLocalReplicationPairVolInfo data : list) {
                    if (checkIndex != data.getRootLdev().getIndex()) continue;
                    treeList.add(data);
                }
                retMap.put(SJctrTiReplicationUtility.getPvolMuIndexKey(pvolMu), treeList);
            }
        } else {
            List<SJmoLocalReplicationPairVolInfo> PairList = SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfoListFromTiPvolMu(this.selectPVolMuList, ssPairList, tiPvolStatus.getTiPvolInfo());
            block3: for (SJmoTiPvolMu pVolMu : this.selectPVolMuList) {
                ArrayList<SJmoLocalReplicationPairVolInfo> selectedPairList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
                for (SJmoLocalReplicationPairVolInfo pairData : PairList) {
                    if (pairData.getPVolIndex().getIndex() != pVolMu.getIndex() || pairData.getSMuNum() != pVolMu.getMu()) continue;
                    selectedPairList.add(pairData);
                    retMap.put(SJctrTiReplicationUtility.getPvolMuIndexKey(pVolMu), selectedPairList);
                    continue block3;
                }
            }
        }
        return retMap;
    }

    private List<SJmoLocalReplicationPairVolInfo> getDispPairList(int pageIndex) {
        long pvolMuIndexKey;
        List<SJmoLocalReplicationPairVolInfo> retList = Collections.emptyList();
        SJmoTiPvolMu pvolMu = null;
        if (!this.selectPVolMuList.isEmpty() && this.selectPVolMuList.size() >= pageIndex + 1) {
            pvolMu = this.selectPVolMuList.get(pageIndex);
        }
        if (pvolMu != null && (retList = this.tiPairInfoListMap.get(pvolMuIndexKey = SJctrTiReplicationUtility.getPvolMuIndexKey(pvolMu))) == null) {
            retList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        }
        return retList;
    }

    private SJmoLocalReplicationPairVolInfo getSummaryPair(int pageIndex, List<SJmoLocalReplicationPairVolInfo> pairList) {
        SJmoLocalReplicationPairVolInfo ret = null;
        if (!this.selectPVolMuList.isEmpty() && this.selectPVolMuList.size() >= pageIndex + 1) {
            SJmoTiPvolMu pVolMu = this.selectPVolMuList.get(pageIndex);
            short mu = pVolMu.getMu();
            if (mu == -1) {
                ret = pairList.get(0);
            } else {
                for (SJmoLocalReplicationPairVolInfo pairInfo : pairList) {
                    if (mu != pairInfo.getSMuNum()) continue;
                    ret = pairInfo;
                    break;
                }
            }
        }
        return ret;
    }

    private SJctrTIPVolSnapshotGroupInfo getPVolMuSSGrpInfo(SJmoTiPvolMu pVolMu, List<SJctrTIPVolSnapshotGroupInfo> tiPVolMuSSGrpInfo) {
        SJctrTIPVolSnapshotGroupInfo ret = null;
        int searchIndex = Collections.binarySearch(tiPVolMuSSGrpInfo, pVolMu);
        if (searchIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPVolMuSSGrpInfo", "TI Pair notFound . PVOL:" + pVolMu.toString());
        } else {
            ret = tiPVolMuSSGrpInfo.get(searchIndex);
        }
        return ret;
    }

    private int getUsedPoolId(SJmoLdevIndex pVol, SJmoTiPvolInfo[] tiPVolInfoArray) {
        int poolId = -1;
        int searchIndex = Arrays.binarySearch(tiPVolInfoArray, pVol);
        if (searchIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createAvailablePairList", "PVOL LUPath notFound. PVOL" + pVol.getIndexKey());
        } else {
            SJmoTiPvolInfo tiPVolInfo = tiPVolInfoArray[searchIndex];
            poolId = tiPVolInfo.getPoolid();
        }
        return poolId;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetTiSnapshotPairList();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetTiPvolStatus();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        set.add(wrapper);
        return set;
    }

    public static void makeTIPairPropertiesAtTIPVol(SJctrDataController dc, List<SJmoLdevIndex> pVolList) {
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_PVOL", pVolList);
        SJctrViewTIPairPropertiesDC.makeDialog(dc, param);
    }

    public static void makeTIPairPropertiesAtPVolMu(SJctrDataController dc, List<SJmoTiPvolMu> tiPVolMuList) {
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_PVOL_MU", tiPVolMuList);
        SJctrViewTIPairPropertiesDC.makeDialog(dc, param);
    }

    private static void makeDialog(SJctrDataController dc, Map<String, List<?>> param) {
        SJctrRelatedDispDataObject wizardRelated = dc.createDialog(SJctrViewTIPairPropertiesDC.class, param);
        dc.addUpdateDisp(wizardRelated);
    }
}

