/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.addjournals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrJnlGroupInfoForEXCTG;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.com.SJctrUniversalReplicatorEXCTGJnlGrpInfo;
import sanproject.sn2.controller.wizard.replication.remote.addjournals.SJctrAddJournalsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.addjournals.com.SJctrExctgStorageSystemUtility;
import sanproject.sn2.controller.wizard.replication.remote.addjournals.model.SJctrMirrorIdDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addjournals.model.SJctrStorageSystemDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addjournals.table.SJctrJournalsTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.selectjournals.SJctrSelectJournalsDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTG;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTGJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;

public class SJctrAddJournalsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 16798721;
    private static final String DISP_TITLE = "ADD_JOURNALS";
    private static final String KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO = "COM_ADD_LOCAL_STORAGE_SYS_JNL_RADIO";
    private static final String KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES = "COM_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES";
    private static final String KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO = "COM_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO";
    private static final String KEY_MIRROR_ID_INFO = "COM_MIRROR_ID_INFO";
    private static final String KEY_NUM_OF_JNL_IN_EXCTG = "COM_NUM_OF_JNL_IN_EXCTG";
    private static final String KEY_LOCAL_MODEL_SERIAL_LABEL = "COM_LOCAL_MODEL_SERIAL_LABEL";
    private static final String KEY_FINISH_BUTTON_ENABLE = "COM_FINISH_BUTTON_ENABLE";
    private static final String KEY_SYSTEM_IMAGE_TYPE = "COM_SYSTEM_IMAGE_TYPE";
    private static final String LOCAL_IMAGE_TYPE = "LOCAL_IMAGE_TYPE";
    private static final String REMOTE_IMAGE_TYPE = "REMOTE_IMAGE_TYPE";
    private static final String KEY_CACHE_AVAILABLE_REMOTE_COM_DEV_LIST = "COM_CACHE_AVAILABLE_REMOTE_COM_DEV_LIST";
    private static final String KEY_CACHE_AVAILABLE_LOCAL_JNL_LIST = "COM_CACHE_AVAILABLE_LOCAL_JNL_LIST";
    private static final String KEY_CACHE_AVAILABLE_REMOTE_JNL_LIST = "COM_CACHE_AVAILABLE_REMOTE_JNL_LIST";
    private static final String KEY_CACHE_REMOTE_CMD_DEV_PULLDOWN_ITEM_LIST_HASHMAP = "COM_CACHE_REMOTE_CMD_DEV_PULLDOWN_ITEM_LIST_HASHMAP";
    private static final String KEY_CACHE_REMOTE_CMD_DEV_PULLDOWN_ITEM_LIST_KEY = "COM_CACHE_REMOTE_CMD_DEV_PULLDOWN_ITEM_LIST_KEY";
    private static final String KEY_CACHE_REGISTERED_LOCAL_STORAGE_SYSTEMR = "COM_CACHE_REGISTERED_LOCAL_STORAGE_SYSTEMR";
    private static final String KEY_CACHE_EXCTG_ID = "COM_CACHE_EXCTG_ID";
    private static final String KEY_CACHE_REMOTE_MODEL_NAME_LIST = "COM_REMOTE_MODEL_NAME_LIST";
    private static final String KEY_CACHE_LOCAL_MODEL_SERIAL = "COM_CACHE_LOCAL_MODEL_SERIAL";
    private static final int NUM_OF_STORAGE_IN_EXCTG_0 = 0;
    private static final int NUM_OF_STORAGE_IN_EXCTG_1 = 1;
    private static final String STORAGE_SYSTEM_INFO_PREFIX = "COM_STORAGE_SYSTEM_INFO";
    private static final String KEY_SELECTED_STORAGE_NAME = "COM_SELECTED_STORAGE_NAME";
    private static final String KEY_PREV_SELECTED_STORAGE_MAP = "COM_PREV_SELECTED_STORAGE_MAP";
    private static final String KEY_PREV_SELECTED_STORAGE_NAME = "COM_PREV_SELECTED_STORAGE_NAME";
    private static final String KEY_EVENT_INFORMATION = "COM_EVENT_INFORMATION";
    private static final String KEY_PREV_EVENT_INFORMATION = "COM_PREV_EVENT_INFORMATION";
    private static final String KEY_EVENT_ID = "COM_EVENT_ID";
    private static final int EVENT_SELECT_ADD_CHECKBOX = 0;
    private static final int EVENT_CHANGE_MODEL_COMBOBOX = 1;
    private static final int EVENT_CHANGE_SERIAL_NUMBER = 2;
    private static final int EVENT_PUSH_SELECT_BUTTON = 3;
    private static final int EVENT_PUSH_CLEAR_BUTTON = 4;
    private static final int EVENT_CHANGE_CU_PULLDOWN = 5;
    private static final int EVENT_CHANGE_ADD_LOCAL_STORAGE_SYS_JNL_RADIO = 6;
    private static final int MAX_STORAGE_SYSTEM = 4;
    private static final int MODEL_NAME_MAP_ID = 0;
    private static final int MODEL_NAME_MAP_NAME = 1;
    private static final int LENGTH_HEX = 2;
    private static final String KEY_CACHE_INFO_EXCTG_STORAGE_INFO_MAP = "KEY_CACHE_INFO_EXCTG_STORAGE_INFO_MAP";
    private static final String STORAGE_INFO_MODEL_ID = "STORAGE_INFO_MODEL_ID";
    private static final String STORAGE_INFO_NEW_STORAGE = "STORAGE_INFO_NEW_STORAGE";
    private static final String STORAGE_INFO_MODEL_COMBOBOX_VALUE = "STORAGE_INFO_MODEL_COMBOBOX_VALUE";
    private static final String STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE = "STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE";
    private static final String STORAGE_INFO_JOURNALS_TABLE_LIST = "STORAGE_INFO_JOURNALS_TABLE_LIST";
    private static final String STORAGE_INFO_CU_SELECTED_INDEX = "STORAGE_INFO_CU_SELECTED_INDEX";
    private static final String STORAGE_INFO_DEV_SELECTED_INDEX = "STORAGE_INFO_DEV_SELECTED_INDEX";
    private static final String STORAGE_INFO_MODEL_LABEL = "STORAGE_INFO_MODEL_LABEL";
    private static final String STORAGE_INFO_SERIAL_NUMBER_LABEL = "STORAGE_INFO_SERIAL_NUMBER_LABEL";
    private static final String STORAGE_INFO_REMOTE_COMMAND_DEVICE_LABEL = "STORAGE_INFO_REMOTE_COMMAND_DEVICE_LABEL";
    private static final String STORAGE_INFO_ADD_CHECKBOX_SELECTED = "STORAGE_INFO_ADD_CHECKBOX_SELECTED";
    private static final String STORAGE_INFO_ADD_CHECKBOX_VISIBLE = "STORAGE_INFO_ADD_CHECKBOX_VISIBLE";
    private static final String STORAGE_INFO_ADD_CHECKBOX_ENABLED = "STORAGE_INFO_ADD_CHECKBOX_ENABLED";

    public SJctrAddJournalsDC() throws SJcException {
        super(16798721);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrExctgStorageSystemUtility.StorageSystemInfo[] keyInfo;
        SJctrRadioButtonGroupDataModel addLocalSysJnlRadio = new SJctrRadioButtonGroupDataModel();
        addLocalSysJnlRadio.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                }
            }
        });
        addLocalSysJnlRadio.add(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES);
        addLocalSysJnlRadio.add(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO);
        this.addDataObjectModel(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO, addLocalSysJnlRadio);
        SJctrMirrorIdDataModel mirrorIdModel = new SJctrMirrorIdDataModel();
        this.addDataObjectModel(KEY_MIRROR_ID_INFO, mirrorIdModel);
        for (SJctrExctgStorageSystemUtility.StorageSystemInfo key : keyInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
            this.addDataObjectModel(key.toString(), new SJctrStorageSystemDataModel());
        }
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
        SJctrSimpleDataModel eventDataModel = new SJctrSimpleDataModel();
        eventDataModel.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrDataObject) {
                    SJctrDataObject data = (SJctrDataObject)setObject;
                    String storageName = (String)data.getData(SJctrAddJournalsDC.KEY_SELECTED_STORAGE_NAME);
                    SJctrAddJournalsDC.this.getManageData().setData(SJctrAddJournalsDC.KEY_SELECTED_STORAGE_NAME, storageName);
                    SJctrAddJournalsDC.this.getManageData().setData(SJctrAddJournalsDC.KEY_PREV_SELECTED_STORAGE_NAME, (String)data.getData(SJctrAddJournalsDC.KEY_PREV_SELECTED_STORAGE_NAME));
                    SJctrAddJournalsDC.this.getManageData().setData(SJctrAddJournalsDC.KEY_PREV_EVENT_INFORMATION, (Integer)data.getData(SJctrAddJournalsDC.KEY_PREV_EVENT_INFORMATION));
                    AddJournalsEventMSG eventMsg = null;
                    Integer eventId = (Integer)data.getData(SJctrAddJournalsDC.KEY_EVENT_ID);
                    switch (eventId) {
                        case 0: {
                            eventMsg = AddJournalsEventMSG.CHANGE_ADD_CHECKBOX;
                            break;
                        }
                        case 1: {
                            eventMsg = AddJournalsEventMSG.CHANGE_MODEL_COMBOBOX;
                            break;
                        }
                        case 2: {
                            eventMsg = AddJournalsEventMSG.CHANGE_SERIAL_NUM_TEXTBOX;
                            break;
                        }
                        case 3: {
                            eventMsg = AddJournalsEventMSG.PUSH_SELECT_BUTTON;
                            break;
                        }
                        case 4: {
                            eventMsg = AddJournalsEventMSG.PUSH_CLEAR_BUTTON;
                            break;
                        }
                        case 5: {
                            eventMsg = AddJournalsEventMSG.CHANGE_CU_PULLDOWNLIST;
                            break;
                        }
                        case 6: {
                            eventMsg = AddJournalsEventMSG.CHANGE_ADD_LOCAL_STORAGE_JNL_RADIO;
                        }
                    }
                    if (eventMsg != null) {
                        SJctrAddJournalsDC.this.fireMessageEvent(eventMsg);
                    }
                }
            }
        });
        this.addDataObjectModel(KEY_EVENT_INFORMATION, eventDataModel);
    }

    private void initListener() {
        this.addMessageEventListener(AddJournalsEventMSG.CHANGE_ADD_LOCAL_STORAGE_JNL_RADIO, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddJournalsDC.this.changeAddLocalStorageJnlRadio(event, dstModel);
            }
        });
        this.addMessageEventListener(AddJournalsEventMSG.CHANGE_ADD_CHECKBOX, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddJournalsDC.this.changeAddCheckBox(event, dstModel);
            }
        });
        this.addMessageEventListener(AddJournalsEventMSG.CHANGE_MODEL_COMBOBOX, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddJournalsDC.this.changeModelComboBox(event, dstModel);
            }
        });
        this.addMessageEventListener(AddJournalsEventMSG.CHANGE_SERIAL_NUM_TEXTBOX, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddJournalsDC.this.changeSerialNumberTextBox(event, dstModel);
            }
        });
        this.addMessageEventListener(AddJournalsEventMSG.PUSH_SELECT_BUTTON, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddJournalsDC.this.pushSelectButton(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map param = (Map)event.getNofifyObject();
                SJctrAddJournalsDC.this.exitDialogAction(param);
            }
        });
        this.addMessageEventListener(AddJournalsEventMSG.PUSH_CLEAR_BUTTON, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddJournalsDC.this.pushClearButton(event, dstModel);
            }
        });
        this.addMessageEventListener(AddJournalsEventMSG.CHANGE_CU_PULLDOWNLIST, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddJournalsDC.this.changeCuPullDownList(event, dstModel);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetSubsystemInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorEXCTGMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        List<?> selectedList = this.getCache("KEY_SELECTED_EXCTG");
        if (null == selectedList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (0 == selectedList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoUniversalReplicatorEXCTG selectedData = (SJmoUniversalReplicatorEXCTG)selectedList.get(0);
        if (null == selectedData) {
            this.logUty.putlog("checkStartData", "Information of selected EXCTG is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            this.changeEnableListener(false);
            SJmoUniversalReplicatorEXCTGMgr exctgMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorEXCTGMgr(this);
            List<SJmoUniversalReplicatorEXCTG> selectedList = this.getCache("KEY_SELECTED_EXCTG");
            List<SJmoUniversalReplicatorEXCTG> exctgList = SJctrRemoteReplicationUtility.checkAndGetExistExctgInfo(selectedList, exctgMgr);
            SJmoUniversalReplicatorEXCTG exctg = exctgList.get(0);
            boolean exctgAttri = SJctrRemoteReplicationUtility.isAddExctgAttribute(exctg);
            if (!exctgAttri) {
                this.logUty.putlog("checkConstructData", "The attribute of selected EXCTG is incorrect.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206128);
            }
            ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> exctgJnlGrpList = exctg.getJnlGrpList();
            if (exctgJnlGrpList.size() >= 16) {
                this.logUty.putlog("checkConstructData", "selected EXCTG has max journals");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206132);
            }
            Collections.sort(exctgJnlGrpList);
            Map exctgJnlGrpMap = SJctrExctgStorageSystemUtility.getExctgJnlGrpModelMap(exctgJnlGrpList);
            if (exctgJnlGrpMap.size() > 4) {
                this.logUty.putlog("checkConstructData", "registed storage system is over.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
            this.createRemoteCmdDevList(exctgJnlGrpMap);
            this.createAvailableLocalJnlGrpList(exctg);
            this.checkAddJournalEnable(exctgJnlGrpMap);
            this.createAvailableRemoteJnlGrpList();
            this.createRemoteModelComboBox();
            ArrayList<Integer> exctgIdCache = new ArrayList<Integer>(1);
            exctgIdCache.add(exctg.getIExCtgId());
            this.putCache(KEY_CACHE_EXCTG_ID, exctgIdCache);
            Map<List, Map> existingStorageDataMap = this.createExistingStorageDataMap(exctgJnlGrpMap);
            Map<String, Map> exctgStorageDataMap = this.createExctgStorageDataMap(existingStorageDataMap);
            this.optimizeExctgStorageDataMap(exctgStorageDataMap, existingStorageDataMap);
            this.initialSetupDataModel(exctg, exctgJnlGrpMap);
            this.initialSetupStorageSystemDataModel(exctgStorageDataMap);
            this.setFinishEnable(this.isEnableFinish());
            ArrayList<Map<String, Map>> cacheList = new ArrayList<Map<String, Map>>();
            cacheList.add(exctgStorageDataMap);
            this.putCache(KEY_CACHE_INFO_EXCTG_STORAGE_INFO_MAP, cacheList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        finally {
            this.changeEnableListener(true);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrExctgStorageSystemUtility.StorageSystemInfo[] keyStorageInfo;
            SJctrAddJournalsConfirmData confirmData = new SJctrAddJournalsConfirmData();
            ArrayList<SJctrUniversalReplicatorEXCTGJnlGrpInfo> sendList = new ArrayList<SJctrUniversalReplicatorEXCTGJnlGrpInfo>(16);
            List<Object> exctgIdCache = new ArrayList(1);
            exctgIdCache = this.getCache(KEY_CACHE_EXCTG_ID);
            int exctgId = (Integer)exctgIdCache.get(0);
            SJctrStorageSystemDataModel[] storageSys = new SJctrStorageSystemDataModel[4];
            for (SJctrExctgStorageSystemUtility.StorageSystemInfo keyInfo : keyStorageInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
                SJctrStorageSystemDataModel storageDataModel;
                storageSys[keyInfo.getIndex()] = storageDataModel = this.getStorageSystemInfoDataModel(keyInfo.toString());
            }
            Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
            this.checkRemoteModelSerialNum(storageSys);
            int totalNumOfJnl = this.getTotalNumOfJnlLabel();
            if (totalNumOfJnl > 16) {
                this.logUty.putlog("checkEndData", "There is too much selected Journals.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206141);
            }
            this.checkRemoteCmdDev(storageSys);
            int mirrorId = this.getMirrorId();
            for (int i = 0; i < storageSys.length; ++i) {
                if (!storageSys[i].getAddCheckBoxDataModel().isSelect()) continue;
                SJctrJournalsTableDataModel jnlTbl = storageSys[i].getJnlTblDataModel();
                List<Object> jnlInfoList = jnlTbl.getAllRowData();
                SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.valueOf(STORAGE_SYSTEM_INFO_PREFIX + (i + 1));
                Map storageMap = exctgStorageDataMap.get(storageInfo.toString());
                int modelId = (Integer)storageMap.get(STORAGE_INFO_MODEL_ID);
                String serialNum = this.getSerialNum(storageSys[i], modelId);
                int rmCmdDev = this.getRcmdDev(storageSys[i]);
                for (SJctrJnlGroupInfoForEXCTG sJctrJnlGroupInfoForEXCTG : jnlInfoList) {
                    if (sJctrJnlGroupInfoForEXCTG.getNewJnl() == 0) continue;
                    SJctrUniversalReplicatorEXCTGJnlGrpInfo exctgJnlInfo = new SJctrUniversalReplicatorEXCTGJnlGrpInfo();
                    SJmoUniversalReplicatorEXCTGJnlGrp exctgJnl = new SJmoUniversalReplicatorEXCTGJnlGrp();
                    exctgJnlInfo.setExctgid(exctgId);
                    exctgJnl.setSN(serialNum);
                    exctgJnl.setLdkc(0);
                    exctgJnl.setModelId(modelId);
                    exctgJnl.setJnlGrpId(sJctrJnlGroupInfoForEXCTG.getJnlGrpId());
                    exctgJnl.setIJnlGroupId(sJctrJnlGroupInfoForEXCTG.getJnlGrpId());
                    exctgJnl.setMirrorId(mirrorId);
                    exctgJnl.setRcmdDev(rmCmdDev);
                    exctgJnlInfo.setExctgJnl(exctgJnl);
                    sendList.add(exctgJnlInfo);
                }
            }
            if (sendList.isEmpty()) {
                this.logUty.putlog("checkEndData", "New Journal is not exist");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206134);
            }
            Collections.sort(sendList);
            confirmData.setExctgJnlInfo(sendList);
            confirmData.setNeedData(this);
            ArrayList<SJctrAddJournalsConfirmData> confirmDataList = new ArrayList<SJctrAddJournalsConfirmData>(1);
            confirmDataList.add(confirmData);
            this.putCache(SJctrAddJournalsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void createAvailableLocalJnlGrpList(SJmoUniversalReplicatorEXCTG selectedExctg) {
        ArrayList<SJctrJnlGroupInfoForEXCTG> availableJnlList = new ArrayList<SJctrJnlGroupInfoForEXCTG>();
        SJmoUniversalReplicatorEXCTGMgr exctgMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorEXCTGMgr(this);
        SJmoUniversalReplicatorJnlGrpMgr jnlGrpMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
        SJmoSubsystemInfo systemInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
        SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
        List<SJmoRSGgetAllRsgs> allRsgList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgList.get(0));
        SJmoUniversalReplicatorJnlGrp[] jnlGrpList = jnlGrpMgr.getJnlGroupList();
        SJmoUniversalReplicatorEXCTG[] allExctgInfo = exctgMgr.getExCtGroupList();
        int modelId = remoteReplicaUty.getModelIDfromSubsysInfo(systemInfo);
        String serialNum = systemInfo.getDKCSNString();
        Map<String, SJmoUniversalReplicatorEXCTGJnlGrp> localJnlInEXCTGMap = this.getLocalJnlExistEXCTG(allExctgInfo, modelId, serialNum);
        for (SJmoUniversalReplicatorJnlGrp jnlGrp : jnlGrpList) {
            if (jnlGrp == null || localJnlInEXCTGMap.get(jnlGrp.toString()) != null || jnlGrp.getValidty() != 2 || jnlGrp.getTimerKind() != 0 || !SJctrRemoteReplicationUtility.hasTopJnlVolRs(jnlGrp, rsgUtil)) continue;
            SJctrJnlGroupInfoForEXCTG jnlInfoExctg = new SJctrJnlGroupInfoForEXCTG();
            jnlInfoExctg.setJnlGrpId(jnlGrp.getIJnlGroupId());
            jnlInfoExctg.setNewJnl(0);
            availableJnlList.add(jnlInfoExctg);
        }
        this.putCache(KEY_CACHE_AVAILABLE_LOCAL_JNL_LIST, availableJnlList);
    }

    private void createAvailableRemoteJnlGrpList() {
        ArrayList<SJctrJnlGroupInfoForEXCTG> availableJnlList = new ArrayList<SJctrJnlGroupInfoForEXCTG>();
        for (int id = 0; id <= 255; ++id) {
            SJctrJnlGroupInfoForEXCTG jnlGrpInfo = new SJctrJnlGroupInfoForEXCTG();
            jnlGrpInfo.setJnlGrpId(id);
            jnlGrpInfo.setNewJnl(1);
            availableJnlList.add(jnlGrpInfo);
        }
        this.putCache(KEY_CACHE_AVAILABLE_REMOTE_JNL_LIST, availableJnlList);
    }

    private void checkAddJournalEnable(Map<List, List> exctgJnlGrpMap) {
        List<?> availableLocalJnlGrpList = this.getCache(KEY_CACHE_AVAILABLE_LOCAL_JNL_LIST);
        List<?> remoteCmdDevsList = this.getCache(KEY_CACHE_AVAILABLE_REMOTE_COM_DEV_LIST);
        if (availableLocalJnlGrpList.size() == 0 && remoteCmdDevsList.size() == 0 && !this.isExistRemoteSysInEXCTG(exctgJnlGrpMap)) {
            this.logUty.putlog("checkAddJournalEnable", "There is no journal which can be added to selected EXCTG.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206133);
        }
    }

    private boolean isExistRemoteSysInEXCTG(Map<List, List> exctgJnlGrpMap) {
        boolean ret = false;
        List localKeyList = this.getCacheLocalKey();
        List[] keysList = SJctrExctgStorageSystemUtility.getSortedExctgJnlGrpMapKeysList(exctgJnlGrpMap, localKeyList);
        switch (keysList.length) {
            case 0: {
                ret = false;
                break;
            }
            case 1: {
                if (keysList[0].equals(localKeyList)) {
                    ret = false;
                    break;
                }
                ret = true;
                break;
            }
            default: {
                ret = true;
            }
        }
        return ret;
    }

    private void createRemoteCmdDevList(Map<List, List> exctgJnlGrpMap) {
        SJctrExctgStorageSystemUtility.StorageSystemInfo[] keyStorageInfo;
        List<SJmoRSGgetAllRsgs> allRsgList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgList.get(0));
        List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
        List<SJmoLdevStatusInfo> ldevStatusInfoList = SJctrReplicationUtility.getSJmoLdevStatusInfo(this);
        List<SJmoLdevDetail> remoteCmdDevsList = SJctrRemoteReplicationUtility.getRemoteCommadDevices(ldevDetailList, rsgUtil, ldevStatusInfoList);
        List localKeyList = this.getCacheLocalKey();
        List[] keysList = SJctrExctgStorageSystemUtility.getSortedExctgJnlGrpMapKeysList(exctgJnlGrpMap, localKeyList);
        for (SJctrExctgStorageSystemUtility.StorageSystemInfo keyInfo : keyStorageInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
            List exctgJnlGrpList;
            SJmoLdevIndex exctgRcmdDev;
            int index;
            List key = SJctrExctgStorageSystemUtility.getKey(keysList, keyInfo.getIndex());
            if (key == null || (index = Collections.binarySearch(remoteCmdDevsList, exctgRcmdDev = SJctrRemoteReplicationUtility.convertToLdevIndexFromInt(((SJmoUniversalReplicatorEXCTGJnlGrp)(exctgJnlGrpList = exctgJnlGrpMap.get(key)).get(0)).getRcmdDev()))) < 0) continue;
            remoteCmdDevsList.remove(index);
        }
        this.putCache(KEY_CACHE_AVAILABLE_REMOTE_COM_DEV_LIST, remoteCmdDevsList);
    }

    private void initialSetupDataModel(SJmoUniversalReplicatorEXCTG exctg, Map<List, List> exctgJnlGrpMap) {
        SJctrComUtility comUty = this.getOwner().getComUtility();
        SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
        SJmoSubsystemInfo systemInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
        List[] keysList = SJctrExctgStorageSystemUtility.getSortedExctgJnlGrpMapKeysList(exctgJnlGrpMap, this.getCacheLocalKey());
        List localKey = this.getCacheLocalKey();
        List<SJmoLdevDetail> remoteCmdDevsList = this.getCache(KEY_CACHE_AVAILABLE_REMOTE_COM_DEV_LIST);
        this.setupAddLocalStorageJnlRadioDataModel(exctgJnlGrpMap, keysList, remoteCmdDevsList);
        this.setupMirrorIdDataModel(exctgJnlGrpMap, keysList);
        this.createRemoteCmdDevPullDownItemList(remoteCmdDevsList);
        this.getManageData().setData(KEY_LOCAL_MODEL_SERIAL_LABEL, remoteReplicaUty.getModelSNoString(systemInfo));
        this.setTotalNumofJnlLabel(exctg.getJnlGrpList().size());
        this.setupImageType(this.getAddLocalSysJnlRadioDataModel().getSelect());
    }

    private void initialSetupStorageSystemDataModel(Map<String, Map> exctgStorageDataMap) {
        SJctrExctgStorageSystemUtility.StorageSystemInfo[] storageInfoArray;
        SJctrComUtility comUtil = this.getComUtility();
        SJctrRadioButtonGroupDataModel addLocalSysJnlRadio = this.getAddLocalSysJnlRadioDataModel();
        String addLocalJnl = addLocalSysJnlRadio.getSelect();
        int remoteCnt = 0;
        for (SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo : storageInfoArray = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
            SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemInfoDataModel(storageInfo.toString());
            Map entryStorageMap = exctgStorageDataMap.get(storageInfo.toString());
            boolean addCheckBoxSelected = (Boolean)entryStorageMap.get(STORAGE_INFO_ADD_CHECKBOX_SELECTED);
            if (!addCheckBoxSelected) {
                entryStorageMap = this.getHiddenStorageDataMap();
            }
            if (addLocalJnl.equals(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES) && storageInfo == SJctrExctgStorageSystemUtility.StorageSystemInfo.COM_STORAGE_SYSTEM_INFO1) {
                storageDataModel.setTitleLabel(comUtil.getGuidance("LOCAL_STORAGE_SYS"));
                storageDataModel.setStorageSysps(SJctrStorageSystemDataModel.StoragePosition.LOCAL_POSITION);
            } else {
                storageDataModel.setTitleLabel(comUtil.getGuidance("STORAGE_SYSTEM") + " " + ++remoteCnt);
                storageDataModel.setStorageSysps(SJctrStorageSystemDataModel.StoragePosition.REMOTE_POSITION);
            }
            this.updateStorageSystemDataModel(entryStorageMap, storageDataModel);
        }
        this.hiddenStorageSystem1CheckBox();
    }

    private void updateStorageSystemDataModel(Map storageMap, SJctrStorageSystemDataModel storageDataModel) {
        int newStorage = (Integer)storageMap.get(STORAGE_INFO_NEW_STORAGE);
        storageDataModel.setNewStorageSysFlag(newStorage);
        storageDataModel.setJournalsBasicDataList((List)storageMap.get(STORAGE_INFO_JOURNALS_TABLE_LIST));
        SJctrJournalsTableDataModel journalsTable = storageDataModel.getJnlTblDataModel();
        journalsTable.makeDataObject();
        if (newStorage == 0 || storageDataModel.getStorageSysps() == SJctrStorageSystemDataModel.StoragePosition.LOCAL_POSITION) {
            storageDataModel.setModelLabel((String)storageMap.get(STORAGE_INFO_MODEL_LABEL));
            storageDataModel.setSerialNumLabel((String)storageMap.get(STORAGE_INFO_SERIAL_NUMBER_LABEL));
            storageDataModel.setRemoteCommandDeviceLabel((String)storageMap.get(STORAGE_INFO_REMOTE_COMMAND_DEVICE_LABEL));
        } else {
            storageDataModel.setModelComboBoxValue((String)storageMap.get(STORAGE_INFO_MODEL_COMBOBOX_VALUE));
            storageDataModel.setSerialNumberTextBoxValue((String)storageMap.get(STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE));
            boolean addSelected = (Boolean)storageMap.get(STORAGE_INFO_ADD_CHECKBOX_SELECTED);
            this.setupModelComboBox(storageDataModel, addSelected);
            if (addSelected) {
                this.setupCUPullDown(storageDataModel, (Integer)storageMap.get(STORAGE_INFO_CU_SELECTED_INDEX));
                this.setupDEVPullDown(storageDataModel, (Integer)storageMap.get(STORAGE_INFO_DEV_SELECTED_INDEX));
                storageDataModel.changeCompoEnable(true);
            } else {
                storageDataModel.removeCuPulldownAllItems();
                storageDataModel.removeDevPulldownAllItems();
                storageDataModel.changeCompoEnable(false);
            }
        }
        storageDataModel.setAddCheckBoxSelected((Boolean)storageMap.get(STORAGE_INFO_ADD_CHECKBOX_SELECTED));
        this.setCheckboxVisibleActiveStatus(storageDataModel, storageMap);
        int modelId = (Integer)storageMap.get(STORAGE_INFO_MODEL_ID);
        storageDataModel.setModelId(modelId);
        this.setupSerialNumTextBoxRange(storageDataModel, modelId);
    }

    private Map<List, Map> createExistingStorageDataMap(Map<List, List> exctgJnlGrpMap) {
        HashMap<List, Map> storageDataMap = new HashMap<List, Map>(4);
        if (exctgJnlGrpMap.isEmpty()) {
            return storageDataMap;
        }
        SJctrComUtility comUtil = this.getComUtility();
        SJctrRemoteReplicationUtility remoteReplicaUty = comUtil.getRemoteReplicationUtility();
        SJctrLdevUtility ldevUtil = comUtil.getLdevUtility();
        SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
        List localKey = this.getCacheLocalKey();
        for (Map.Entry<List, List> entryJnl : exctgJnlGrpMap.entrySet()) {
            int modelId;
            List entryKey = entryJnl.getKey();
            HashMap<String, Object> entryValueMap = new HashMap<String, Object>();
            List entryJnlGrpList = entryJnl.getValue();
            SJmoUniversalReplicatorEXCTGJnlGrp exctgJnlGrp = (SJmoUniversalReplicatorEXCTGJnlGrp)entryJnlGrpList.get(0);
            entryValueMap.put(STORAGE_INFO_NEW_STORAGE, 0);
            if (localKey.equals(entryKey)) {
                modelId = remoteReplicaUty.getModelIDfromSubsysInfo(subsysInfo);
                entryValueMap.put(STORAGE_INFO_MODEL_ID, modelId);
                entryValueMap.put(STORAGE_INFO_MODEL_LABEL, comUtil.getGuidance(remoteReplicaUty.getModelGuidancekey(modelId)));
                int sn = Integer.parseInt(subsysInfo.getDKCSNString());
                entryValueMap.put(STORAGE_INFO_SERIAL_NUMBER_LABEL, SJctrComUtility.toPaddingZeroString(sn, SJctrExctgStorageSystemUtility.getSerialNumberDigitNumber(modelId)));
                List<SJmoUniversalReplicatorEXCTGJnlGrp> enableLocalJnlList = SJctrExctgStorageSystemUtility.checkAndGetSJmoUniversalReplicatorExctgJnlGrp(entryJnlGrpList, this);
                entryValueMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, this.getJournalsBasicDataList(enableLocalJnlList));
            } else {
                modelId = exctgJnlGrp.getModelId();
                entryValueMap.put(STORAGE_INFO_MODEL_ID, modelId);
                entryValueMap.put(STORAGE_INFO_MODEL_LABEL, SJctrRemoteReplicationUtility.getModelNameString(modelId, comUtil));
                entryValueMap.put(STORAGE_INFO_SERIAL_NUMBER_LABEL, exctgJnlGrp.getSN());
                entryValueMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, this.getJournalsBasicDataList(entryJnlGrpList));
                entryValueMap.put(STORAGE_INFO_REMOTE_COMMAND_DEVICE_LABEL, SJctrRemoteReplicationUtility.getExctgRemComDevString(exctgJnlGrp.getRcmdDev(), ldevUtil));
            }
            entryValueMap.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, true);
            entryValueMap.put(STORAGE_INFO_ADD_CHECKBOX_VISIBLE, false);
            entryValueMap.put(STORAGE_INFO_ADD_CHECKBOX_ENABLED, false);
            storageDataMap.put(entryKey, entryValueMap);
        }
        return storageDataMap;
    }

    private Map<String, Map> createExctgStorageDataMap(Map<List, Map> storageDataMap) {
        SJctrExctgStorageSystemUtility.StorageSystemInfo[] storageInfoArray;
        List[] keys = SJctrExctgStorageSystemUtility.getSortedExctgJnlGrpMapKeysList(storageDataMap, this.getCacheLocalKey());
        HashMap<String, Map> exctgStorageDataMap = new HashMap<String, Map>();
        for (SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo : storageInfoArray = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
            List key = SJctrExctgStorageSystemUtility.getKey(keys, storageInfo.getIndex());
            if (key != null) {
                Map dataMap = storageDataMap.get(key);
                exctgStorageDataMap.put(storageInfo.toString(), dataMap);
                continue;
            }
            exctgStorageDataMap.put(storageInfo.toString(), this.getNewRemoteStorageDataMap());
        }
        return exctgStorageDataMap;
    }

    private void optimizeExctgStorageDataMap(Map<String, Map> exctgStorageDataMap, Map<List, Map> existingStorageDataMap) {
        List<?> remoteCmdDevsList = this.getCache(KEY_CACHE_AVAILABLE_REMOTE_COM_DEV_LIST);
        if (existingStorageDataMap.isEmpty()) {
            if (remoteCmdDevsList.isEmpty()) {
                exctgStorageDataMap.put(SJctrExctgStorageSystemUtility.StorageSystemInfo.COM_STORAGE_SYSTEM_INFO1.toString(), this.getNewLocalStorageDataMap());
            }
            Map storageDataMap1 = exctgStorageDataMap.get(SJctrExctgStorageSystemUtility.StorageSystemInfo.COM_STORAGE_SYSTEM_INFO1.toString());
            storageDataMap1.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, true);
        }
    }

    private List getJournalsBasicDataList(List<SJmoUniversalReplicatorEXCTGJnlGrp> exctgJnlGrpList) {
        ArrayList<SJctrJnlGroupInfoForEXCTG> jnlList = new ArrayList<SJctrJnlGroupInfoForEXCTG>();
        for (SJmoUniversalReplicatorEXCTGJnlGrp jnlGrp : exctgJnlGrpList) {
            SJctrJnlGroupInfoForEXCTG jnlGrpInfo = new SJctrJnlGroupInfoForEXCTG();
            jnlGrpInfo.setJnlGrpId(jnlGrp.getIJnlGroupId());
            jnlList.add(jnlGrpInfo);
        }
        return jnlList;
    }

    private Map getNewLocalStorageDataMap() {
        SJctrComUtility comUtil = this.getComUtility();
        SJctrRemoteReplicationUtility remoteReplicaUty = comUtil.getRemoteReplicationUtility();
        SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
        HashMap<String, Object> localStorageDataMap = new HashMap<String, Object>();
        localStorageDataMap.put(STORAGE_INFO_NEW_STORAGE, 1);
        localStorageDataMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, Collections.EMPTY_LIST);
        int modelId = remoteReplicaUty.getModelIDfromSubsysInfo(subsysInfo);
        localStorageDataMap.put(STORAGE_INFO_MODEL_ID, modelId);
        localStorageDataMap.put(STORAGE_INFO_MODEL_LABEL, comUtil.getGuidance(remoteReplicaUty.getModelGuidancekey(modelId)));
        int sn = Integer.parseInt(subsysInfo.getDKCSNString());
        localStorageDataMap.put(STORAGE_INFO_SERIAL_NUMBER_LABEL, SJctrComUtility.toPaddingZeroString(sn, SJctrExctgStorageSystemUtility.getSerialNumberDigitNumber(modelId)));
        localStorageDataMap.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, true);
        localStorageDataMap.put(STORAGE_INFO_ADD_CHECKBOX_VISIBLE, false);
        localStorageDataMap.put(STORAGE_INFO_ADD_CHECKBOX_ENABLED, true);
        return localStorageDataMap;
    }

    private Map getNewRemoteStorageDataMap() {
        HashMap<String, Object> storageMap = new HashMap<String, Object>();
        storageMap.put(STORAGE_INFO_NEW_STORAGE, 1);
        int modelId = 7;
        storageMap.put(STORAGE_INFO_MODEL_ID, modelId);
        String modelComboValue = SJctrRemoteReplicationUtility.getModelNameString(modelId, this.getComUtility());
        storageMap.put(STORAGE_INFO_MODEL_COMBOBOX_VALUE, modelComboValue);
        storageMap.put(STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE, "");
        storageMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, Collections.EMPTY_LIST);
        storageMap.put(STORAGE_INFO_CU_SELECTED_INDEX, 0);
        storageMap.put(STORAGE_INFO_DEV_SELECTED_INDEX, 0);
        storageMap.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, false);
        storageMap.put(STORAGE_INFO_ADD_CHECKBOX_VISIBLE, true);
        storageMap.put(STORAGE_INFO_ADD_CHECKBOX_ENABLED, true);
        return storageMap;
    }

    private Map getHiddenStorageDataMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STORAGE_INFO_NEW_STORAGE, 1);
        map.put(STORAGE_INFO_MODEL_COMBOBOX_VALUE, "");
        map.put(STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE, "");
        map.put(STORAGE_INFO_JOURNALS_TABLE_LIST, Collections.EMPTY_LIST);
        map.put(STORAGE_INFO_CU_SELECTED_INDEX, 0);
        map.put(STORAGE_INFO_DEV_SELECTED_INDEX, 0);
        List<?> remoteCmdDevsList = this.getCache(KEY_CACHE_AVAILABLE_REMOTE_COM_DEV_LIST);
        map.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, false);
        map.put(STORAGE_INFO_ADD_CHECKBOX_VISIBLE, true);
        if (remoteCmdDevsList.isEmpty()) {
            map.put(STORAGE_INFO_ADD_CHECKBOX_ENABLED, false);
        } else {
            map.put(STORAGE_INFO_ADD_CHECKBOX_ENABLED, true);
        }
        map.put(STORAGE_INFO_MODEL_ID, -1);
        return map;
    }

    private void setupAddLocalStorageJnlRadioDataModel(Map<List, List> exctgJnlGrpMap, List[] keysList, List<SJmoLdevDetail> remoteCmdDevsList) {
        SJctrRadioButtonGroupDataModel addLocalSysJnlRadio = this.getAddLocalSysJnlRadioDataModel();
        List localKeyList = this.getCacheLocalKey();
        if (exctgJnlGrpMap.get(localKeyList) != null) {
            addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES, true);
            addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO, false);
            addLocalSysJnlRadio.setSelect(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES);
        } else {
            switch (keysList.length) {
                case 4: {
                    addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES, false);
                    addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO, true);
                    addLocalSysJnlRadio.setSelect(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO);
                    break;
                }
                case 0: {
                    if (remoteCmdDevsList.size() == 0) {
                        addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES, true);
                        addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO, false);
                        addLocalSysJnlRadio.setSelect(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES);
                        break;
                    }
                    addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES, true);
                    addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO, true);
                    addLocalSysJnlRadio.setSelect(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO);
                    break;
                }
                default: {
                    addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES, true);
                    addLocalSysJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO, true);
                    addLocalSysJnlRadio.setSelect(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO);
                }
            }
        }
        boolean registerLocalStorage = false;
        if (exctgJnlGrpMap.get(localKeyList) != null) {
            registerLocalStorage = true;
        }
        ArrayList<Boolean> cacheRegisterLocalStorageList = new ArrayList<Boolean>(1);
        cacheRegisterLocalStorageList.add(registerLocalStorage);
        this.putCache(KEY_CACHE_REGISTERED_LOCAL_STORAGE_SYSTEMR, cacheRegisterLocalStorageList);
    }

    private void setupImageType(String selectedAddLocalRadio) {
        if (selectedAddLocalRadio.equals(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES)) {
            this.setImageType(LOCAL_IMAGE_TYPE);
        } else {
            this.setImageType(REMOTE_IMAGE_TYPE);
        }
    }

    private void setupMirrorIdDataModel(Map<List, List> exctgJnlGrpMap, List[] keysList) {
        SJctrMirrorIdDataModel mirrorIdInfo = this.getMirrorIdDataModel();
        if (exctgJnlGrpMap.isEmpty()) {
            mirrorIdInfo.setupMirrorIdPullDown();
        } else {
            List jnlList = exctgJnlGrpMap.get(keysList[0]);
            int mirrorId = ((SJmoUniversalReplicatorEXCTGJnlGrp)jnlList.get(0)).getMirrorId();
            mirrorIdInfo.setupMirrorIdLabel(mirrorId);
        }
    }

    private void createRemoteCmdDevPullDownItemList(List<SJmoLdevDetail> remoteCmdDevsList) {
        SJctrComUtility comUtil = this.getComUtility();
        HashMap<String, List> remoteCmdDevHashMap = new HashMap<String, List>();
        ArrayList<String> cuList = new ArrayList<String>();
        for (SJmoLdevDetail remoteCmdDev : remoteCmdDevsList) {
            short cu = remoteCmdDev.getSCu();
            String cuHexSt = SJctrComUtility.toHexString(cu, 2, true);
            if (!cuList.contains(cuHexSt)) {
                cuList.add(cuHexSt);
            }
            short dev = remoteCmdDev.getSLdev();
            String devHexSt = SJctrComUtility.toHexString(dev, 2, true);
            List devList = (List)remoteCmdDevHashMap.get(cuHexSt);
            if (devList == null) {
                ArrayList<String> newDevList = new ArrayList<String>();
                newDevList.add(devHexSt);
                remoteCmdDevHashMap.put(cuHexSt, newDevList);
                continue;
            }
            devList.add(devHexSt);
            remoteCmdDevHashMap.put(cuHexSt, devList);
        }
        Collections.sort(cuList);
        this.putCache(KEY_CACHE_REMOTE_CMD_DEV_PULLDOWN_ITEM_LIST_KEY, cuList);
        ArrayList<HashMap<String, List>> cacheList = new ArrayList<HashMap<String, List>>(1);
        cacheList.add(remoteCmdDevHashMap);
        this.putCache(KEY_CACHE_REMOTE_CMD_DEV_PULLDOWN_ITEM_LIST_HASHMAP, cacheList);
    }

    private void checkRemoteModelSerialNum(SJctrStorageSystemDataModel[] storageSys) {
        Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
        SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
        ArrayList<String> modelSerialList = new ArrayList<String>(4);
        for (int i = 0; i < storageSys.length; ++i) {
            if (!storageSys[i].getStorageSysps().equals((Object)SJctrStorageSystemDataModel.StoragePosition.REMOTE_POSITION) || !storageSys[i].getAddCheckBoxDataModel().isSelect()) continue;
            SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.valueOf(STORAGE_SYSTEM_INFO_PREFIX + (i + 1));
            Map storageMap = exctgStorageDataMap.get(storageInfo.toString());
            int modelId = (Integer)storageMap.get(STORAGE_INFO_MODEL_ID);
            String serialNum = this.getSerialNum(storageSys[i], modelId);
            modelSerialList.add(Integer.toString(modelId).concat(serialNum));
        }
        List localModelSerialList = this.getCacheLocalKey();
        int modelIdLocal = (Integer)localModelSerialList.get(0);
        String serialNumLocal = remoteReplicaUty.toPaddingZeroSerialNumber(modelIdLocal, (String)localModelSerialList.get(1));
        String localModelSerial = Integer.toString(modelIdLocal).concat(serialNumLocal);
        for (int i = 0; i < modelSerialList.size(); ++i) {
            String modelSerial = (String)modelSerialList.get(i);
            if (modelSerial.equals(localModelSerial)) {
                this.logUty.putlog("checkRemoteModelSerialNum", "Remote Storage Model ID / Serial Number is duplication of Local Storage");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206135);
            }
            for (int j = i + 1; j < modelSerialList.size(); ++j) {
                String modelSerialTmp = (String)modelSerialList.get(j);
                if (!modelSerial.equals(modelSerialTmp)) continue;
                this.logUty.putlog("checkRemoteModelSerialNum", "Remote Storage Model ID / Serial Number is duplicated");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206136);
            }
        }
    }

    private void checkRemoteCmdDev(SJctrStorageSystemDataModel[] storageSys) {
        int i;
        ArrayList<Integer> rcmdDevList = new ArrayList<Integer>(4);
        for (i = 0; i < storageSys.length; ++i) {
            if (!storageSys[i].getAddCheckBoxDataModel().isSelect()) continue;
            rcmdDevList.add(this.getRcmdDev(storageSys[i]));
        }
        for (i = 0; i < rcmdDevList.size() - 1; ++i) {
            int rcmdDev = (Integer)rcmdDevList.get(i);
            for (int j = i + 1; j < rcmdDevList.size(); ++j) {
                int rcmdDevTmp = (Integer)rcmdDevList.get(j);
                if (rcmdDev != rcmdDevTmp) continue;
                this.logUty.putlog("checkRemoteCmdDev", "Remote Command Device is duplicated");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206137);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeAddLocalStorageJnlRadio(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrExctgStorageSystemUtility.StorageSystemInfo[] storageInfoArray;
            this.changeEnableListener(false);
            Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
            ArrayList<Map> storageList = new ArrayList<Map>(4);
            for (SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo : storageInfoArray = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
                SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemInfoDataModel(storageInfo.toString());
                if (!storageDataModel.isSelectAddCheckBox()) continue;
                Map map = exctgStorageDataMap.get(storageInfo.toString());
                if (storageDataModel.getStorageSysps() != SJctrStorageSystemDataModel.StoragePosition.LOCAL_POSITION && storageDataModel.getNewStorageSysFlag() == 1) {
                    String modelValue = storageDataModel.getModelComboBoxValue();
                    map.put(STORAGE_INFO_MODEL_ID, this.getModelIdFromModelName(modelValue));
                    map.put(STORAGE_INFO_MODEL_COMBOBOX_VALUE, storageDataModel.getModelComboBoxValue());
                    map.put(STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE, storageDataModel.getSerialNumberTextBoxValue());
                    map.put(STORAGE_INFO_DEV_SELECTED_INDEX, storageDataModel.getDevPulldownSelectIndex());
                }
                SJctrJournalsTableDataModel journalsTable = storageDataModel.getJnlTblDataModel();
                map.put(STORAGE_INFO_JOURNALS_TABLE_LIST, journalsTable.getAllRowData());
                storageList.add(map);
            }
            int localRowCount = 0;
            SJctrRadioButtonGroupDataModel addLocalSysJnlRadio = this.getAddLocalSysJnlRadioDataModel();
            String addLocalJnl = addLocalSysJnlRadio.getSelect();
            if (addLocalJnl.equals(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES)) {
                storageList.add(0, this.getNewLocalStorageDataMap());
            } else {
                Map localStorageMap = (Map)storageList.get(0);
                List journalList = (List)localStorageMap.get(STORAGE_INFO_JOURNALS_TABLE_LIST);
                localRowCount = -journalList.size();
                storageList.remove(0);
            }
            int unregisteredSize = 4 - storageList.size();
            for (int i = 0; i < unregisteredSize; ++i) {
                storageList.add(this.getNewRemoteStorageDataMap());
            }
            exctgStorageDataMap.clear();
            for (SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo : storageInfoArray) {
                exctgStorageDataMap.put(storageInfo.toString(), (Map)storageList.get(storageInfo.getIndex()));
            }
            Map storageMap1 = exctgStorageDataMap.get(SJctrExctgStorageSystemUtility.StorageSystemInfo.COM_STORAGE_SYSTEM_INFO1.toString());
            storageMap1.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, true);
            this.initialSetupStorageSystemDataModel(exctgStorageDataMap);
            this.setupImageType(this.getAddLocalSysJnlRadioDataModel().getSelect());
            this.setFinishEnable(this.isEnableFinish());
            int numOfJnl = this.getTotalNumOfJnlLabel();
            this.setTotalNumofJnlLabel(numOfJnl += localRowCount);
        }
        finally {
            this.changeEnableListener(true);
        }
        this.setDirtyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeAddCheckBox(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            this.changeEnableListener(false);
            String storageName = this.getStorageName();
            SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemInfoDataModel(storageName);
            Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
            Map storageMap = exctgStorageDataMap.get(storageName);
            int jnlTblRowCount = 0;
            storageMap.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, storageDataModel.isSelectAddCheckBox());
            storageMap.put(STORAGE_INFO_ADD_CHECKBOX_VISIBLE, storageDataModel.isVisibleAddCheckBox());
            storageMap.put(STORAGE_INFO_ADD_CHECKBOX_ENABLED, storageDataModel.isEnabledAddCheckBox());
            if (storageDataModel.isSelectAddCheckBox()) {
                this.setupCUPullDown(storageDataModel, (Integer)storageMap.get(STORAGE_INFO_CU_SELECTED_INDEX));
                this.setupDEVPullDown(storageDataModel, (Integer)storageMap.get(STORAGE_INFO_DEV_SELECTED_INDEX));
                this.updateStorageSystemDataModel(storageMap, storageDataModel);
                storageDataModel.changeCompoEnable(true);
                List<Object> journalsList = storageDataModel.getJnlTblDataModel().getAllRowData();
                jnlTblRowCount = journalsList.size();
            } else {
                String modelValue = storageDataModel.getModelComboBoxValue();
                storageMap.put(STORAGE_INFO_MODEL_ID, this.getModelIdFromModelName(modelValue));
                storageMap.put(STORAGE_INFO_MODEL_COMBOBOX_VALUE, modelValue);
                storageMap.put(STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE, storageDataModel.getSerialNumberTextBoxValue());
                storageMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, storageDataModel.getJnlTblDataModel().getAllRowData());
                storageMap.put(STORAGE_INFO_CU_SELECTED_INDEX, storageDataModel.getCuPulldownSelectIndex());
                storageMap.put(STORAGE_INFO_DEV_SELECTED_INDEX, storageDataModel.getDevPulldownSelectIndex());
                storageDataModel.removeCuPulldownAllItems();
                storageDataModel.removeDevPulldownAllItems();
                Map map = this.getHiddenStorageDataMap();
                this.updateStorageSystemDataModel(map, storageDataModel);
                storageDataModel.changeCompoEnable(false);
                List journalsList = (List)storageMap.get(STORAGE_INFO_JOURNALS_TABLE_LIST);
                jnlTblRowCount = -journalsList.size();
            }
            int numOfJnl = this.getTotalNumOfJnlLabel();
            this.setTotalNumofJnlLabel(numOfJnl += jnlTblRowCount);
            this.hiddenStorageSystem1CheckBox();
            this.setFinishEnable(this.isEnableFinish());
            List<?> cacheRegisteredLocal = this.getCache(KEY_CACHE_REGISTERED_LOCAL_STORAGE_SYSTEMR);
            boolean registerLocalStorage = (Boolean)cacheRegisteredLocal.get(0);
            if (!registerLocalStorage) {
                this.changeAddLocalStorageJnlRadioEnable();
            }
        }
        finally {
            this.changeEnableListener(true);
        }
        this.setDirtyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeModelComboBox(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String storageName = this.getStorageName();
        SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemInfoDataModel(storageName);
        if (storageDataModel.isSelectAddCheckBox()) {
            try {
                this.changeEnableListener(false);
                String modelValue = storageDataModel.getModelComboBoxValue();
                int allRowCount = storageDataModel.getJnlTblDataModel().getRowCount();
                Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
                Map storageMap = exctgStorageDataMap.get(storageName);
                int modelId = this.getModelIdFromModelName(modelValue);
                storageMap.put(STORAGE_INFO_MODEL_ID, modelId);
                storageMap.put(STORAGE_INFO_MODEL_COMBOBOX_VALUE, modelValue);
                storageMap.put(STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE, "");
                storageMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, Collections.EMPTY_LIST);
                storageMap.put(STORAGE_INFO_CU_SELECTED_INDEX, 0);
                storageMap.put(STORAGE_INFO_DEV_SELECTED_INDEX, 0);
                storageMap.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, storageDataModel.isSelectAddCheckBox());
                storageMap.put(STORAGE_INFO_ADD_CHECKBOX_VISIBLE, storageDataModel.isVisibleAddCheckBox());
                storageMap.put(STORAGE_INFO_ADD_CHECKBOX_ENABLED, storageDataModel.isEnabledAddCheckBox());
                this.updateStorageSystemDataModel(storageMap, storageDataModel);
                this.hiddenStorageSystem1CheckBox();
                this.setFinishEnable(false);
                int numOfJnl = this.getTotalNumOfJnlLabel();
                this.setTotalNumofJnlLabel(numOfJnl -= allRowCount);
            }
            finally {
                this.changeEnableListener(true);
            }
            this.setDirtyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSerialNumberTextBox(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String storageName = this.getStorageName();
        SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemInfoDataModel(storageName);
        if (storageDataModel.isSelectAddCheckBox()) {
            try {
                this.changeEnableListener(false);
                int allRowCount = storageDataModel.getJnlTblDataModel().getRowCount();
                Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
                Map storageMap = exctgStorageDataMap.get(storageName);
                String modelValue = storageDataModel.getModelComboBoxValue();
                storageMap.put(STORAGE_INFO_MODEL_ID, this.getModelIdFromModelName(modelValue));
                storageMap.put(STORAGE_INFO_MODEL_COMBOBOX_VALUE, modelValue);
                storageMap.put(STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE, storageDataModel.getSerialNumberTextBoxValue());
                storageMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, Collections.EMPTY_LIST);
                storageMap.put(STORAGE_INFO_CU_SELECTED_INDEX, 0);
                storageMap.put(STORAGE_INFO_DEV_SELECTED_INDEX, 0);
                storageMap.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, storageDataModel.isSelectAddCheckBox());
                storageMap.put(STORAGE_INFO_ADD_CHECKBOX_VISIBLE, storageDataModel.isVisibleAddCheckBox());
                storageMap.put(STORAGE_INFO_ADD_CHECKBOX_ENABLED, storageDataModel.isEnabledAddCheckBox());
                this.updateStorageSystemDataModel(storageMap, storageDataModel);
                this.hiddenStorageSystem1CheckBox();
                this.setFinishEnable(false);
                int numOfJnl = this.getTotalNumOfJnlLabel();
                this.setTotalNumofJnlLabel(numOfJnl -= allRowCount);
            }
            finally {
                this.changeEnableListener(true);
            }
            this.setDirtyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCuPullDownList(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            this.changeEnableListener(false);
            String storageName = this.getStorageName();
            SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemInfoDataModel(storageName);
            Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
            Map storageMap = exctgStorageDataMap.get(storageName);
            storageMap.put(STORAGE_INFO_CU_SELECTED_INDEX, storageDataModel.getCuPulldownSelectIndex());
            storageMap.put(STORAGE_INFO_DEV_SELECTED_INDEX, 0);
            this.setupCUPullDown(storageDataModel, storageDataModel.getCuPulldownSelectIndex());
            this.setupDEVPullDown(storageDataModel, 0);
            this.hiddenStorageSystem1CheckBox();
        }
        finally {
            this.changeEnableListener(true);
        }
        this.setDirtyAll();
    }

    private void pushSelectButton(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        block12: {
            Map prevStorageMap = this.getPrevStorageDataMap();
            this.prevEventAction(event, dstModel);
            SJctrDataObject manageData = this.getManageData();
            String storageName = (String)manageData.getData(KEY_SELECTED_STORAGE_NAME);
            String prevStorageName = (String)manageData.getData(KEY_PREV_SELECTED_STORAGE_NAME);
            if (!prevStorageName.equals("") && !storageName.equals(prevStorageName)) {
                return;
            }
            try {
                int totalNumOfJnl = this.getTotalNumOfJnlLabel();
                if (totalNumOfJnl >= 16) {
                    this.logUty.putlog("pushSelectButton", "Journal is already added to the maximum.");
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206131);
                }
                this.changeEnableListener(false);
                SJctrStorageSystemDataModel storageSys = this.getChangedStorageSystemInfoDataModel();
                List<Object> availableJnlList = new ArrayList();
                SJctrStorageSystemDataModel.StoragePosition ps = storageSys.getStorageSysps();
                if (ps != null) {
                    if (ps == SJctrStorageSystemDataModel.StoragePosition.LOCAL_POSITION) {
                        availableJnlList = this.createAvailableJnlList(this.getCache(KEY_CACHE_AVAILABLE_LOCAL_JNL_LIST), storageSys.getJnlTblDataModel());
                    } else if (ps == SJctrStorageSystemDataModel.StoragePosition.REMOTE_POSITION) {
                        availableJnlList = this.createAvailableJnlList(this.getCache(KEY_CACHE_AVAILABLE_REMOTE_JNL_LIST), storageSys.getJnlTblDataModel());
                    }
                    if (availableJnlList.isEmpty()) {
                        this.logUty.putlog("pushSelectButton", "available Jnl is not exist.");
                        throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206139);
                    }
                    int enableAddJnlNum = 16 - totalNumOfJnl;
                    ArrayList<Integer> cacheEnableAddJnlNum = new ArrayList<Integer>(1);
                    cacheEnableAddJnlNum.add(enableAddJnlNum);
                    HashMap param = new HashMap();
                    param.put("COM_AVAILABLE_JNL_LIST_EXCTG", availableJnlList);
                    param.put("COM_ENABLE_SELECT_JNL_NUM_EXCTG", cacheEnableAddJnlNum);
                    ArrayList<Map> putList = new ArrayList<Map>(1);
                    putList.add(prevStorageMap);
                    this.putCache(KEY_PREV_SELECTED_STORAGE_MAP, putList);
                    SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrSelectJournalsDC.class, param);
                    this.addUpdateDisp(dialogRelated);
                    break block12;
                }
                this.logUty.putlog("pushSelectButton", "StoragePosition is null");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
            catch (SJcException e) {
                this.rollbackPrevEventAction(prevStorageMap);
                throw e;
            }
            finally {
                this.changeEnableListener(true);
            }
        }
    }

    private List<SJctrJnlGroupInfoForEXCTG> createAvailableJnlList(List<SJctrJnlGroupInfoForEXCTG> jnlList, SJctrJournalsTableDataModel jnlTbl) {
        ArrayList<SJctrJnlGroupInfoForEXCTG> availableList = new ArrayList<SJctrJnlGroupInfoForEXCTG>();
        availableList.addAll(jnlList);
        List<Object> jnlGrpList = jnlTbl.getAllRowData();
        for (SJctrJnlGroupInfoForEXCTG sJctrJnlGroupInfoForEXCTG : jnlGrpList) {
            int index = Collections.binarySearch(availableList, sJctrJnlGroupInfoForEXCTG, new Comparator<SJctrJnlGroupInfoForEXCTG>(){

                @Override
                public int compare(SJctrJnlGroupInfoForEXCTG info1, SJctrJnlGroupInfoForEXCTG info2) {
                    int jnl1 = info1.getJnlGrpId();
                    int jnl2 = info2.getJnlGrpId();
                    return jnl1 - jnl2;
                }
            });
            if (index < 0) continue;
            availableList.remove(index);
        }
        return availableList;
    }

    private void exitDialogAction(Map<String, List<?>> carryMap) {
        List<?> pushKeyList = carryMap.get("SELECT_JNL_PUSH_KEY");
        SJctrRemoteReplicationDataMacro.PushKey pushKey = (SJctrRemoteReplicationDataMacro.PushKey)((Object)pushKeyList.get(0));
        switch (pushKey) {
            case OK: {
                List<?> param = carryMap.get("COM_SELECTED_JNL_LIST_EXCTG");
                SJctrStorageSystemDataModel storageSys = this.getChangedStorageSystemInfoDataModel();
                SJctrJournalsTableDataModel jnlTbl = storageSys.getJnlTblDataModel();
                if (param == null || param.size() <= 0) break;
                jnlTbl.addRowDataTop(param);
                Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
                Map storageMap = exctgStorageDataMap.get(this.getStorageName());
                storageMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, jnlTbl.getAllRowData());
                int numOfJnl = this.getTotalNumOfJnlLabel();
                this.setTotalNumofJnlLabel(numOfJnl += param.size());
                this.setFinishEnable(this.isEnableFinish());
                SJctrRemoteReplicationUtility.setFinishChangeCheck(this, true);
                this.hiddenStorageSystem1CheckBox();
                this.setDirtyAll();
                break;
            }
            case CANCEL: 
            case CLOSE: {
                List<?> cacheList = this.getCache(KEY_PREV_SELECTED_STORAGE_MAP);
                Map prevStorageMap = (Map)cacheList.get(0);
                this.rollbackPrevEventAction(prevStorageMap);
                break;
            }
        }
    }

    private void pushClearButton(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Map prevStorageMap = this.getPrevStorageDataMap();
        try {
            this.changeEnableListener(false);
            SJctrStorageSystemDataModel storageSys = this.getChangedStorageSystemInfoDataModel();
            SJctrJournalsTableDataModel jnlTbl = storageSys.getJnlTblDataModel();
            List<Object> selectedRowList = jnlTbl.getSelectedRowDataOrder();
            if (selectedRowList.isEmpty()) {
                this.logUty.putlog("pushClearButton", "not selected");
                return;
            }
            this.removeSelectedRow(jnlTbl);
            Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
            Map storageMap = exctgStorageDataMap.get(this.getStorageName());
            storageMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, jnlTbl.getAllRowData());
            int numOfJnl = this.getTotalNumOfJnlLabel();
            this.setTotalNumofJnlLabel(numOfJnl -= selectedRowList.size());
            this.hiddenStorageSystem1CheckBox();
            this.setFinishEnable(this.isEnableFinish());
        }
        catch (SJcException e) {
            this.rollbackPrevEventAction(prevStorageMap);
            throw e;
        }
        finally {
            this.changeEnableListener(true);
        }
    }

    private void prevEventAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrDataObject manageData = this.getManageData();
        String storageName = (String)manageData.getData(KEY_SELECTED_STORAGE_NAME);
        String prevStorageName = (String)manageData.getData(KEY_PREV_SELECTED_STORAGE_NAME);
        int prevEventID = (Integer)manageData.getData(KEY_PREV_EVENT_INFORMATION);
        manageData.setData(KEY_SELECTED_STORAGE_NAME, prevStorageName);
        switch (prevEventID) {
            case 2: {
                this.changeSerialNumberTextBox(event, dstModel);
            }
        }
        manageData.setData(KEY_SELECTED_STORAGE_NAME, storageName);
    }

    private Map getPrevStorageDataMap() {
        String prevStorageName = (String)this.getManageData().getData(KEY_PREV_SELECTED_STORAGE_NAME);
        if (prevStorageName == null || prevStorageName.equals("")) {
            return null;
        }
        Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
        HashMap<String, Object> prevStorageMap = new HashMap<String, Object>(exctgStorageDataMap.get(prevStorageName));
        SJctrStorageSystemDataModel prevStorageDataModel = this.getStorageSystemInfoDataModel(prevStorageName);
        prevStorageMap.put(STORAGE_INFO_ADD_CHECKBOX_ENABLED, prevStorageDataModel.isEnabledAddCheckBox());
        prevStorageMap.put(STORAGE_INFO_ADD_CHECKBOX_SELECTED, prevStorageDataModel.isSelectAddCheckBox());
        prevStorageMap.put(STORAGE_INFO_ADD_CHECKBOX_VISIBLE, prevStorageDataModel.isVisibleAddCheckBox());
        String modelValue = prevStorageDataModel.getModelComboBoxValue();
        prevStorageMap.put(STORAGE_INFO_MODEL_COMBOBOX_VALUE, modelValue);
        prevStorageMap.put(STORAGE_INFO_MODEL_ID, this.getModelIdFromModelName(modelValue));
        prevStorageMap.put(STORAGE_INFO_SERIAL_NUMBER_TEXTBOX_VALUE, prevStorageDataModel.getSerialNumberTextBoxValue());
        prevStorageMap.put(STORAGE_INFO_JOURNALS_TABLE_LIST, prevStorageDataModel.getJnlTblDataModel().getAllRowData());
        prevStorageMap.put(STORAGE_INFO_CU_SELECTED_INDEX, prevStorageDataModel.getCuPulldownSelectIndex());
        prevStorageMap.put(STORAGE_INFO_DEV_SELECTED_INDEX, prevStorageDataModel.getDevPulldownSelectIndex());
        return prevStorageMap;
    }

    private void rollbackPrevEventAction(Map prevStorageDataMap) {
        if (prevStorageDataMap != null) {
            String prevStorageName = (String)this.getManageData().getData(KEY_PREV_SELECTED_STORAGE_NAME);
            SJctrStorageSystemDataModel prevStorageDataModel = this.getStorageSystemInfoDataModel(prevStorageName);
            this.updateStorageSystemDataModel(prevStorageDataMap, prevStorageDataModel);
            Map<String, Map> exctgStorageDataMap = this.getCacheExctgStorageDataMap();
            exctgStorageDataMap.put(prevStorageName, prevStorageDataMap);
            this.setFinishEnable(this.isEnableFinish());
            List prevJnlList = (List)prevStorageDataMap.get(STORAGE_INFO_JOURNALS_TABLE_LIST);
            int numOfJnl = this.getTotalNumOfJnlLabel();
            this.setTotalNumofJnlLabel(numOfJnl += prevJnlList.size());
        }
    }

    public void removeSelectedRow(SJctrJournalsTableDataModel jnlTbl) {
        List<Object> selectedRowList = jnlTbl.getSelectedRowDataOrder();
        boolean isSelectExistJnl = false;
        for (SJctrJnlGroupInfoForEXCTG sJctrJnlGroupInfoForEXCTG : selectedRowList) {
            if (sJctrJnlGroupInfoForEXCTG.getNewJnl() != 0) continue;
            isSelectExistJnl = true;
            break;
        }
        if (isSelectExistJnl) {
            this.logUty.putlog("removeSelectedRow", "Contained not new journal.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206138);
        }
        jnlTbl.removeSelectedRowData();
    }

    private void changeEnableListener(boolean isEnable) {
        SJctrExctgStorageSystemUtility.StorageSystemInfo[] keyStorageInfo;
        SJctrRadioButtonGroupDataModel addLocalSysJnlRadio = this.getAddLocalSysJnlRadioDataModel();
        addLocalSysJnlRadio.setEnableListener(isEnable);
        for (SJctrExctgStorageSystemUtility.StorageSystemInfo keyInfo : keyStorageInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
            SJctrStorageSystemDataModel storageSys = this.getStorageSystemInfoDataModel(keyInfo.toString());
            SJctrCheckBoxDataModel addCheckBox = storageSys.getAddCheckBoxDataModel();
            addCheckBox.setEnableListener(isEnable);
            SJctrComboBoxDataModel modelIdComboBox = storageSys.getModelIdComboBoxDataModel();
            modelIdComboBox.setEnableListener(isEnable);
            SJctrTextBoxDataModel serialNumTextBox = storageSys.getSerialNumTextBoxDataModel();
            serialNumTextBox.setEnableListener(isEnable);
            SJctrButtonDataModel selectButton = storageSys.getSelectButtonDataModel();
            selectButton.setEnableListener(isEnable);
            SJctrButtonDataModel clearButton = storageSys.getClearButtonDataModel();
            clearButton.setEnableListener(isEnable);
            SJctrComboBoxDataModel cuPullDown = storageSys.getCuPullDownDataModel();
            cuPullDown.setEnableListener(isEnable);
        }
    }

    private Map<String, SJmoUniversalReplicatorEXCTGJnlGrp> getLocalJnlExistEXCTG(SJmoUniversalReplicatorEXCTG[] exctginfoArray, int modelId, String serialNo) {
        HashMap<String, SJmoUniversalReplicatorEXCTGJnlGrp> retMap = new HashMap<String, SJmoUniversalReplicatorEXCTGJnlGrp>();
        SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
        for (SJmoUniversalReplicatorEXCTG exctgInfo : exctginfoArray) {
            if (exctgInfo == null) continue;
            ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> exctgJnlGrpList = exctgInfo.getJnlGrpList();
            for (SJmoUniversalReplicatorEXCTGJnlGrp exctgJnlGrp : exctgJnlGrpList) {
                if (!remoteReplicaUty.isUsedStorageSystemFromExctgJnl(modelId, serialNo, exctgJnlGrp)) continue;
                retMap.put(exctgJnlGrp.toString(), exctgJnlGrp);
            }
        }
        return retMap;
    }

    private void createRemoteModelComboBox() {
        HashMap<Integer, String[]> modelNameMap = new HashMap<Integer, String[]>();
        String[] modelNameRAID600 = new String[]{Integer.toString(5), SJctrRemoteReplicationUtility.getModelNameString(5, this.getComUtility())};
        modelNameMap.put(5, modelNameRAID600);
        String[] modelNameRAID700 = new String[]{Integer.toString(6), SJctrRemoteReplicationUtility.getModelNameString(6, this.getComUtility())};
        modelNameMap.put(6, modelNameRAID700);
        String[] modelNameHM700 = new String[]{Integer.toString(19), SJctrRemoteReplicationUtility.getModelNameString(19, this.getComUtility())};
        modelNameMap.put(19, modelNameHM700);
        String[] modelNameRAID800 = new String[]{Integer.toString(7), SJctrRemoteReplicationUtility.getModelNameString(7, this.getComUtility())};
        modelNameMap.put(7, modelNameRAID800);
        ArrayList<HashMap<Integer, String[]>> modelList = new ArrayList<HashMap<Integer, String[]>>();
        modelList.add(modelNameMap);
        this.putCache(KEY_CACHE_REMOTE_MODEL_NAME_LIST, modelList);
    }

    private void setupModelComboBox(SJctrStorageSystemDataModel storageDataModel, boolean selectCheckbox) {
        if (selectCheckbox) {
            List<?> modelNameList = this.getCache(KEY_CACHE_REMOTE_MODEL_NAME_LIST);
            HashMap modelNameMap = (HashMap)modelNameList.get(0);
            SJctrComboBoxDataModel remoteModelCombo = storageDataModel.getModelIdComboBoxDataModel();
            remoteModelCombo.addItem(((String[])modelNameMap.get(5))[0], ((String[])modelNameMap.get(5))[1]);
            remoteModelCombo.addItem(((String[])modelNameMap.get(6))[0], ((String[])modelNameMap.get(6))[1]);
            remoteModelCombo.addItem(((String[])modelNameMap.get(7))[0], ((String[])modelNameMap.get(7))[1]);
            String modelMinMax = "(6-255)";
            storageDataModel.setModelMinMaxLabel(modelMinMax);
        } else {
            storageDataModel.setModelMinMaxLabel("(-)");
        }
    }

    private void setupSerialNumTextBoxRange(SJctrStorageSystemDataModel storageDataModel, int modelId) {
        String snMin = "";
        String snMax = "";
        if (storageDataModel.isSelectAddCheckBox()) {
            switch (modelId) {
                case 5: 
                case 6: 
                case 7: {
                    snMin = String.valueOf(1);
                    snMax = String.valueOf(99999);
                    break;
                }
                case 19: {
                    snMin = String.valueOf(200001);
                    snMax = String.valueOf(265535);
                    break;
                }
                default: {
                    snMin = String.valueOf(0);
                    snMax = String.valueOf(99999);
                }
            }
        }
        storageDataModel.setSerialNumberTextBoxMin(snMin);
        storageDataModel.setSerialNumberTextBoxMax(snMax);
    }

    private void setupCUPullDown(SJctrStorageSystemDataModel storageDataModel, int selectIndex) {
        SJctrComboBoxDataModel cuPullDown = storageDataModel.getCuPullDownDataModel();
        List<?> cuList = this.getCache(KEY_CACHE_REMOTE_CMD_DEV_PULLDOWN_ITEM_LIST_KEY);
        for (String cuHexst : cuList) {
            cuPullDown.addItem(cuHexst);
        }
        if (selectIndex == -1) {
            selectIndex = 0;
        }
        cuPullDown.setSelectedIndex(selectIndex);
    }

    private void setupDEVPullDown(SJctrStorageSystemDataModel storageDataModel, int selectIndex) {
        SJctrComboBoxDataModel cuPullDown = storageDataModel.getCuPullDownDataModel();
        SJctrComboBoxDataModel devPullDown = storageDataModel.getDevPullDownDataModel();
        List<?> remoteCmdDevHashMapList = this.getCache(KEY_CACHE_REMOTE_CMD_DEV_PULLDOWN_ITEM_LIST_HASHMAP);
        HashMap remoteCmdDevHashMap = (HashMap)remoteCmdDevHashMapList.get(0);
        String cuHexst = cuPullDown.getSelection();
        if (cuHexst != null) {
            devPullDown.removeAllItems();
            List devList = (List)remoteCmdDevHashMap.get(cuHexst);
            for (String devHexst : devList) {
                devPullDown.addItem(devHexst);
            }
            if (selectIndex == -1) {
                selectIndex = 0;
            }
            devPullDown.setSelectedIndex(selectIndex);
        }
    }

    private void changeAddLocalStorageJnlRadioEnable() {
        boolean isEnableChangeRadio = false;
        SJctrRadioButtonGroupDataModel addLocalJnlRadio = this.getAddLocalSysJnlRadioDataModel();
        if (!addLocalJnlRadio.getSelect().equals(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES)) {
            if (addLocalJnlRadio.getSelect().equals(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_NO)) {
                SJctrExctgStorageSystemUtility.StorageSystemInfo[] keyInfo;
                for (SJctrExctgStorageSystemUtility.StorageSystemInfo key : keyInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
                    SJctrStorageSystemDataModel storageSysInfo = this.getStorageSystemInfoDataModel(key.toString());
                    if (storageSysInfo.isSelectAddCheckBox()) continue;
                    isEnableChangeRadio = true;
                    break;
                }
                if (isEnableChangeRadio) {
                    addLocalJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES, true);
                } else {
                    addLocalJnlRadio.setEnable(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO_YES, false);
                }
            } else {
                this.logUty.putlog("changeAddLocalStorageJnlRadioEnable", "Selected item of add local storage system's journals radio button is invalid.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
        }
    }

    private boolean isEnableFinish(SJctrStorageSystemDataModel storageSys) {
        int numOfJnlTblRow;
        boolean isEnableFinish = true;
        boolean isAddCheck = storageSys.getAddCheckBoxDataModel().isSelect();
        int isNewStorageFlag = storageSys.getNewStorageSysFlag();
        if (isAddCheck && (numOfJnlTblRow = storageSys.getJnlTblDataModel().getRowCount()) <= 0 && isNewStorageFlag == 1) {
            isEnableFinish = false;
        }
        return isEnableFinish;
    }

    private boolean isEnableFinish() {
        SJctrExctgStorageSystemUtility.StorageSystemInfo[] keyInfo;
        boolean ret = true;
        for (SJctrExctgStorageSystemUtility.StorageSystemInfo key : keyInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
            SJctrStorageSystemDataModel storageSysInfo = this.getStorageSystemInfoDataModel(key.toString());
            if (this.isEnableFinish(storageSysInfo)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private SJctrStorageSystemDataModel getChangedStorageSystemInfoDataModel() {
        String storageName = this.getStorageName();
        return this.getStorageSystemInfoDataModel(storageName);
    }

    private int getModelIdFromModelName(String modelName) {
        HashMap modelNameMap;
        int modelID = -1;
        SJctrComUtility comUty = this.getComUtility();
        List<?> modelNameList = this.getCache(KEY_CACHE_REMOTE_MODEL_NAME_LIST);
        if (modelNameList != null && (modelNameMap = (HashMap)modelNameList.get(0)) != null) {
            if (modelName.equals(((String[])modelNameMap.get(5))[0]) || modelName.equals(((String[])modelNameMap.get(5))[1]) || modelName.equals(comUty.getGuidance("DKC_MODEL_5"))) {
                modelID = 5;
            } else if (modelName.equals(((String[])modelNameMap.get(6))[0]) || modelName.equals(((String[])modelNameMap.get(6))[1]) || modelName.equals(comUty.getGuidance("DKC_MODEL_6"))) {
                modelID = 6;
            } else if (modelName.equals(((String[])modelNameMap.get(19))[0]) || modelName.equals(((String[])modelNameMap.get(19))[1]) || modelName.equals(comUty.getGuidance("DKC_MODEL_19"))) {
                modelID = 19;
            } else if (modelName.equals(((String[])modelNameMap.get(7))[0]) || modelName.equals(((String[])modelNameMap.get(7))[1]) || modelName.equals(comUty.getGuidance("DKC_MODEL_7"))) {
                modelID = 7;
            } else {
                try {
                    modelID = Integer.parseInt(modelName);
                }
                catch (NumberFormatException ne) {
                    modelID = -1;
                }
            }
        }
        return modelID;
    }

    private String getSerialNum(SJctrStorageSystemDataModel storageSys, int modelId) {
        SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
        String serialNum = "";
        int newFlg = storageSys.getNewStorageSysFlag();
        SJctrStorageSystemDataModel.StoragePosition ps = storageSys.getStorageSysps();
        if (newFlg == 0 || ps.equals((Object)SJctrStorageSystemDataModel.StoragePosition.LOCAL_POSITION)) {
            serialNum = storageSys.getSerialNumLabel();
        } else if (newFlg == 1) {
            serialNum = storageSys.getSerialNumberTextBoxValue();
        } else {
            this.logUty.putlog("getSerialNum", "New Storage System Flag is invalid");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return remoteReplicaUty.toPaddingZeroSerialNumber(modelId, serialNum);
    }

    private int getMirrorId() {
        int mirrorId = -1;
        String mirrorIdst = "";
        SJctrMirrorIdDataModel mirrorIdDataModel = this.getMirrorIdDataModel();
        int useCompo = mirrorIdDataModel.getUseComponent();
        if (useCompo == 0) {
            mirrorId = mirrorIdDataModel.getMirrorIdLabelValue();
        } else if (useCompo == 1) {
            SJctrComboBoxDataModel mirrorIdComboBox = mirrorIdDataModel.getMirrorIdPullDownDataModel();
            mirrorIdst = mirrorIdComboBox.getSelection();
            mirrorId = Integer.parseInt(mirrorIdst);
        } else {
            this.logUty.putlog("getMirrorId", "Use Component Flag is invalid");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return mirrorId;
    }

    private int getRcmdDev(SJctrStorageSystemDataModel storageSys) {
        int rcmdDev = -1;
        SJctrStorageSystemDataModel.StoragePosition storageps = storageSys.getStorageSysps();
        if (!storageps.equals((Object)SJctrStorageSystemDataModel.StoragePosition.LOCAL_POSITION) && storageps.equals((Object)SJctrStorageSystemDataModel.StoragePosition.REMOTE_POSITION)) {
            int newFlg = storageSys.getNewStorageSysFlag();
            if (newFlg == 0) {
                String rmcmdDevst = storageSys.getRemoteCmdDevLabel();
                rcmdDev = this.convertToIntFromStringRmcmdDev(rmcmdDevst);
            } else if (newFlg == 1) {
                SJctrComboBoxDataModel cuPullDown = storageSys.getCuPullDownDataModel();
                short cu = Short.parseShort(cuPullDown.getSelection(), 16);
                SJctrComboBoxDataModel devPullDown = storageSys.getDevPullDownDataModel();
                short dev = Short.parseShort(devPullDown.getSelection(), 16);
                SJmoLdevIndex ldev = new SJmoLdevIndex();
                ldev.setLdevIndex((short)0, cu, dev);
                rcmdDev = ldev.getIndex();
            }
        }
        return rcmdDev;
    }

    private int convertToIntFromStringRmcmdDev(String rmcmdDevst) {
        int SEPARATE_SIZE = 3;
        boolean LDKC_INDEX = false;
        boolean CU_INDEX = true;
        int DEV_INDEX = 2;
        int rmcmdDev = -1;
        if (rmcmdDevst != null) {
            String[] strArray = rmcmdDevst.split(":");
            if (!(strArray.length != 3 || strArray[0].isEmpty() || strArray[1].isEmpty() || strArray[2].isEmpty())) {
                try {
                    short ldkc = Short.parseShort(strArray[0], 16);
                    short cu = Short.parseShort(strArray[1], 16);
                    short dev = Short.parseShort(strArray[2], 16);
                    SJmoLdevIndex ldev = new SJmoLdevIndex();
                    ldev.setLdevIndex(ldkc, cu, dev);
                    rmcmdDev = ldev.getIndex();
                }
                catch (NumberFormatException e) {
                    this.logUty.putlog("convertToIntFromStringRmcmdDev", "Parse error occured.");
                }
            } else {
                this.logUty.putlog("convertToIntFromStringRmcmdDev", "Remote Command Device Label String is invalid.");
            }
        }
        return rmcmdDev;
    }

    private void hiddenStorageSystem1CheckBox() {
        SJctrStorageSystemDataModel storageSystem = this.getStorageSystemInfoDataModel(SJctrExctgStorageSystemUtility.StorageSystemInfo.COM_STORAGE_SYSTEM_INFO1.toString());
        storageSystem.setAddCheckBoxVisible(false);
    }

    private void setCheckboxVisibleActiveStatus(SJctrStorageSystemDataModel storageDataModel, Map storageMap) {
        boolean visibleStatus = (Boolean)storageMap.get(STORAGE_INFO_ADD_CHECKBOX_VISIBLE);
        boolean enabledStatus = (Boolean)storageMap.get(STORAGE_INFO_ADD_CHECKBOX_ENABLED);
        if (visibleStatus) {
            storageDataModel.setAddCheckBoxEnabled(enabledStatus);
        } else {
            storageDataModel.setAddCheckBoxVisible(visibleStatus);
        }
    }

    private Map<String, Map> getCacheExctgStorageDataMap() {
        List<?> cacheList = this.getCache(KEY_CACHE_INFO_EXCTG_STORAGE_INFO_MAP);
        Map map = (Map)cacheList.get(0);
        return map;
    }

    private List getCacheLocalKey() {
        List localKey = this.getCache(KEY_CACHE_LOCAL_MODEL_SERIAL);
        if (localKey == null) {
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
            localKey = SJctrExctgStorageSystemUtility.createExctgJnlGrpMapLocalKey(subsysInfo, remoteReplicaUty);
            this.putCache(KEY_CACHE_LOCAL_MODEL_SERIAL, localKey);
        }
        return localKey;
    }

    private SJctrRadioButtonGroupDataModel getAddLocalSysJnlRadioDataModel() {
        return (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_ADD_LOCAL_STORAGE_SYS_JNL_RADIO);
    }

    private SJctrMirrorIdDataModel getMirrorIdDataModel() {
        return (SJctrMirrorIdDataModel)this.getDataObjectModel(KEY_MIRROR_ID_INFO);
    }

    private SJctrStorageSystemDataModel getStorageSystemInfoDataModel(String keyString) {
        return (SJctrStorageSystemDataModel)this.getDataObjectModel(keyString);
    }

    private String getStorageName() {
        return (String)this.getManageData().getData(KEY_SELECTED_STORAGE_NAME);
    }

    private Integer getTotalNumOfJnlLabel() {
        return (Integer)this.getManageData().getData(KEY_NUM_OF_JNL_IN_EXCTG);
    }

    private void setTotalNumofJnlLabel(int numOfJnl) {
        this.getManageData().setData(KEY_NUM_OF_JNL_IN_EXCTG, numOfJnl);
    }

    private void setFinishEnable(boolean isEnable) {
        this.getManageData().setData(KEY_FINISH_BUTTON_ENABLE, isEnable);
    }

    private void setImageType(String imageType) {
        this.getManageData().setData(KEY_SYSTEM_IMAGE_TYPE, imageType);
    }

    private static enum AddJournalsEventMSG implements SJctrNotifyState
    {
        CHANGE_ADD_LOCAL_STORAGE_JNL_RADIO,
        CHANGE_ADD_CHECKBOX,
        CHANGE_MODEL_COMBOBOX,
        CHANGE_SERIAL_NUM_TEXTBOX,
        PUSH_SELECT_BUTTON,
        PUSH_CLEAR_BUTTON,
        CHANGE_CU_PULLDOWNLIST;

    }
}

