/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.assignrcmddevs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.assignrcmddevs.SJctrAssignRCmdDevAvailableTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.assignrcmddevs.SJctrAssignRCmdDevConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.assignrcmddevs.SJctrAssignRCmdDevConfirmTableDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.SJmoMirrorIndex;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;

public class SJctrAssignRCmdDevDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831057;
    private static final String DISP_TITLE = "ASSIGN_RCMD_DEVS";
    private static final String KEY_AVA_TABLE = "COM_AVA_TABLE";
    private static final String KEY_SEL_TABLE = "COM_SEL_TABLE";
    private static final String KEY_CMB_RCMD_DEV = "COM_CMB_R_CMD_DEV";
    private static final String KEY_BTN_ADD = "COM_BTN_ADD";
    private static final String KEY_BTN_REMOVE = "COM_BTN_REMOVE";
    private static final int NUM_OF_USE_MIRROR_MAX = 2;

    public SJctrAssignRCmdDevDC() throws SJcException {
        super(17831057);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_AVA_TABLE, new SJctrAssignRCmdDevAvailableTableDataModel());
        this.addDataObjectModel(KEY_CMB_RCMD_DEV, new SJctrComboBoxDataModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                if (event.isSelect()) {
                    SJctrAssignRCmdDevDC.this.fireMessageEvent(ASSIGN_R_CMD_DEVS_MSG.SELECT_ADD);
                }
            }
        });
        this.addDataObjectModel(KEY_BTN_ADD, addButton);
        SJctrAssignRCmdDevConfirmTableDataModel selTbl = new SJctrAssignRCmdDevConfirmTableDataModel();
        selTbl.setPaging(false);
        this.addDataObjectModel(KEY_SEL_TABLE, selTbl);
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                if (event.isSelect()) {
                    SJctrAssignRCmdDevDC.this.fireMessageEvent(ASSIGN_R_CMD_DEVS_MSG.SELECT_REMOVE);
                }
            }
        });
        this.addDataObjectModel(KEY_BTN_REMOVE, removeButton);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_WIZARD));
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initListener() {
        this.addMessageEventListener(ASSIGN_R_CMD_DEVS_MSG.SELECT_ADD, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAssignRCmdDevDC.this.addAction();
            }
        });
        this.addMessageEventListener(ASSIGN_R_CMD_DEVS_MSG.SELECT_REMOVE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAssignRCmdDevDC.this.removeAction();
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> inheritedList = this.getProxy().getCache("KEY_SELECTED_MIRROR");
        if (null == inheritedList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == inheritedList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoUniversalReplicatorJnlGrpMgr jnlMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            jnlMgr = (SJmoUniversalReplicatorJnlGrpMgr)jnlMgr.clone();
            ArrayList<SJmoUniversalReplicatorJnlGrpMgr> jnlMgrList = new ArrayList<SJmoUniversalReplicatorJnlGrpMgr>(1);
            jnlMgrList.add(jnlMgr);
            this.putCache(SJmoGetUniversalReplicatorJnlGrpMgr.class, jnlMgrList);
            List<SJmoMirrorIndex> inheritedList = this.getProxy().getCache("KEY_SELECTED_MIRROR");
            if (null == inheritedList) {
                this.logUty.putlog("checkConstructData", "Inherited data list is null.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == inheritedList.size()) {
                this.logUty.putlog("checkConstructData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoUniversalReplicatorJnlGrpMirror> mirrorExist = SJctrRemoteReplicationUtility.checkAndGetExistMirrorInfo(inheritedList, jnlMgr);
            SJctrRemoteReplicationUtility.checkTopJnlVolRsSelectedMirror(this, mirrorExist);
            int jnlType = SJctrRemoteReplicationUtility.checkCopyTypeForMirror(mirrorExist, jnlMgr);
            if (jnlType == -1) {
                this.logUty.putlog("checkConstructData", "Journal type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206010);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean bAttri = this.checkJnlAttribute(mirrorExist, jnlMgr);
            if (!bAttri) {
                this.logUty.putlog("checkConstructData", "Journal attribute is initial.");
                SJctrError err = new SJctrError(210, 22, 206083);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean st = this.checkMirrorStatusForJournal(mirrorExist, jnlMgr);
            if (!st) {
                this.logUty.putlog("checkConstructData", "Contained invalid mirror status.");
                SJctrError err = new SJctrError(210, 22, 206070);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean bAssign = this.checkAssigndCommandDev(mirrorExist, jnlMgr);
            if (!bAssign) {
                this.logUty.putlog("checkConstructData", "Selected Mirror already assigned remote command device.");
                SJctrError err = new SJctrError(210, 22, 206293);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean bStatus = this.checkMirrorStatus(mirrorExist, jnlMgr);
            if (!bStatus) {
                this.logUty.putlog("checkConstructData", "invalid mirror status.");
                SJctrError err = new SJctrError(210, 22, 206050);
                SJcException exp = err.createException();
                throw exp;
            }
            this.setCmbRemotecmdDev();
            SJctrAssignRCmdDevAvailableTableDataModel table = (SJctrAssignRCmdDevAvailableTableDataModel)this.getDataObjectModel(KEY_AVA_TABLE);
            table.setBasicDataList(mirrorExist);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        catch (CloneNotSupportedException e) {
            this.logUty.putlog("checkConstructData", "Catch CloneNotSupportedException.");
            SJctrError err = new SJctrError(210, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            List<Object> selectedList;
            SJctrAssignRCmdDevConfirmData confirmData = new SJctrAssignRCmdDevConfirmData();
            SJctrAssignRCmdDevConfirmTableDataModel selTbl = (SJctrAssignRCmdDevConfirmTableDataModel)this.getDataObjectModel(KEY_SEL_TABLE);
            List<Object> confirmMirrorList = selectedList = selTbl.getAllRowData();
            Collections.sort(confirmMirrorList);
            confirmData.setMirrorsInfo(confirmMirrorList);
            confirmData.setNeedData(this);
            ArrayList<SJctrAssignRCmdDevConfirmData> confirmDataList = new ArrayList<SJctrAssignRCmdDevConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrAssignRCmdDevConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void addAction() {
        SJctrAssignRCmdDevAvailableTableDataModel avaTbl = (SJctrAssignRCmdDevAvailableTableDataModel)this.getDataObjectModel(KEY_AVA_TABLE);
        SJctrAssignRCmdDevConfirmTableDataModel selTbl = (SJctrAssignRCmdDevConfirmTableDataModel)this.getDataObjectModel(KEY_SEL_TABLE);
        SJmoUniversalReplicatorJnlGrpMgr jnlMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
        List<Object> selAvaMirrors = avaTbl.removeSelectedRowData();
        this.setRcmdDevToMirror(selAvaMirrors, jnlMgr);
        ArrayList<SJmoUniversalReplicatorJnlGrpMgr> jnlMgrList = new ArrayList<SJmoUniversalReplicatorJnlGrpMgr>(1);
        jnlMgrList.add(jnlMgr);
        selTbl.setBasicData(SJmoGetUniversalReplicatorJnlGrpMgr.class, jnlMgrList);
        selTbl.addRowDataTop(selAvaMirrors);
        this.setDirtyAll();
        this.updateFooter();
    }

    private void setRcmdDevToMirror(List<SJmoUniversalReplicatorJnlGrpMirror> selAvaMirror, SJmoUniversalReplicatorJnlGrpMgr allJnlInfo) {
        SJctrComboBoxDataModel rcmdDevCmb = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_RCMD_DEV);
        for (SJmoUniversalReplicatorJnlGrpMirror selAvaMirrorInfo : selAvaMirror) {
            int jnlIndex = selAvaMirrorInfo.getIJnlGroupId();
            SJmoUniversalReplicatorJnlGrp jnlInfo = allJnlInfo.getJnlGroup(jnlIndex);
            this.setValueCmbData(rcmdDevCmb, jnlInfo, selAvaMirrorInfo);
        }
    }

    private void removeAction() {
        SJmoUniversalReplicatorJnlGrpMgr allJnlInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
        SJctrAssignRCmdDevAvailableTableDataModel avaTbl = (SJctrAssignRCmdDevAvailableTableDataModel)this.getDataObjectModel(KEY_AVA_TABLE);
        List<Object> avaAllRowData = avaTbl.getAllRowData();
        SJctrAssignRCmdDevConfirmTableDataModel selTbl = (SJctrAssignRCmdDevConfirmTableDataModel)this.getDataObjectModel(KEY_SEL_TABLE);
        List<Object> selectedRowList = selTbl.removeSelectedRowData();
        for (Object rowData : selectedRowList) {
            SJmoUniversalReplicatorJnlGrpMirror mirrorInfo = (SJmoUniversalReplicatorJnlGrpMirror)rowData;
            SJmoUniversalReplicatorJnlGrp jnlInfo = allJnlInfo.getJnlGroup(mirrorInfo.getIJnlGroupId());
            this.crearRcmdDevToMirror(jnlInfo, mirrorInfo);
        }
        avaAllRowData.addAll(selectedRowList);
        Collections.sort(avaAllRowData);
        avaTbl.setBasicDataList(avaAllRowData);
        avaTbl.doRefresh();
        selTbl.setDirty();
        this.updateFooter();
    }

    private void crearRcmdDevToMirror(SJmoUniversalReplicatorJnlGrp jnlInfo, SJmoUniversalReplicatorJnlGrpMirror mirrorInfo) {
        if (mirrorInfo.getStatus() == 0) {
            jnlInfo.setUcPathForTC(0);
            jnlInfo.setRcmdDevForTC(-1);
        } else {
            mirrorInfo.setUcPath(0);
            mirrorInfo.setRcmdDev(-1);
        }
    }

    private void setCmbRemotecmdDev() {
        List<SJmoRSGgetAllRsgs> allRsgInfo = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgInfo.get(0));
        SJctrComboBoxDataModel rcmdDevCmb = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_RCMD_DEV);
        SJctrLdevUtility ldevUtil = this.getComUtility().getLdevUtility();
        List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
        List<SJmoLdevStatusInfo> ldevStatusList = SJctrRemoteReplicationUtility.getSJmoLdevStatusInfo(this);
        List<SJmoLdevDetail> remoteCmdDevsList = SJctrRemoteReplicationUtility.getRemoteCommadDevices(ldevDetailList, rsgUtil, ldevStatusList);
        SJctrUserController uc = this.getOwner();
        SJctrAuthorizeContainer ac = uc.getAuthorizeContainer();
        SJctrSystemParamContainer spc = ac.getSystemParamContainer();
        if (null == remoteCmdDevsList || !spc.isLocalHost() && 0 == remoteCmdDevsList.size()) {
            this.logUty.putlog("setCmbRemotecmdDev", "Candidate of the remote command device does not exist.");
            SJctrError err = new SJctrError(210, 22, 206071);
            SJcException exp = err.createException();
            throw exp;
        }
        this.setCmbRcmdDev(rcmdDevCmb, remoteCmdDevsList, ldevUtil, spc);
    }

    private boolean checkMirrorStatus(List<SJmoUniversalReplicatorJnlGrpMirror> avaMirrorList, SJmoUniversalReplicatorJnlGrpMgr jnlMgr) {
        boolean ret = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : avaMirrorList) {
            SJmoUniversalReplicatorJnlGrp jnlInfo = jnlMgr.getJnlGroup(mirrorInfo);
            ArrayList<SJmoUniversalReplicatorJnlGrpMirror> jnlMirrorList = jnlInfo.getMirrors();
            int numOfUsedMirror = this.getNumOfMirrorNotInitial(jnlMirrorList);
            if (0 == mirrorInfo.getMirrorId() && 1 == jnlInfo.getAttribute() && numOfUsedMirror < 2 || 0 != mirrorInfo.getStatus()) continue;
            this.logUty.putlog("checkMirrorStatus", "Can Not Use Mirror Status. Journal ID = :" + jnlInfo.getIndex() + " , Mirror ID : " + mirrorInfo.getMirrorId());
            ret = false;
            break;
        }
        return ret;
    }

    private boolean checkJnlAttribute(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList, SJmoUniversalReplicatorJnlGrpMgr jnlMgr) {
        boolean ret = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorList) {
            SJmoUniversalReplicatorJnlGrp jnlInfo = jnlMgr.getJnlGroup(mirrorInfo);
            if (jnlInfo.getAttribute() != 0) continue;
            ret = false;
            this.logUty.putlog("checkJnlAttribute", "Can Not Jouranl Attribute. Journal ID = :" + jnlInfo.getIndex() + " , Mirror ID : " + mirrorInfo.getMirrorId());
            break;
        }
        return ret;
    }

    private boolean checkMirrorStatusForJournal(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList, SJmoUniversalReplicatorJnlGrpMgr jnlMgr) {
        boolean rtn = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorList) {
            SJmoUniversalReplicatorJnlGrp jnlInfo = jnlMgr.getJnlGroup(mirrorInfo);
            ArrayList<SJmoUniversalReplicatorJnlGrpMirror> jnlMirrorList = jnlInfo.getMirrors();
            for (SJmoUniversalReplicatorJnlGrpMirror jnlMirror : jnlMirrorList) {
                if (jnlMirror.getDelta() != 0 || SJctrRemoteReplicationDataMacro.ASSGIN_R_CMD_PERMISSION_STATUS_MIRROR.contains(mirrorInfo.getStatus())) continue;
                rtn = false;
                break;
            }
            if (rtn) continue;
            break;
        }
        return rtn;
    }

    private boolean checkAssigndCommandDev(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList, SJmoUniversalReplicatorJnlGrpMgr jnlMgr) {
        boolean ret = true;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorList) {
            SJmoUniversalReplicatorJnlGrp jnlInfo;
            int assignFlg = SJctrRemoteReplicationUtility.checkAssignRCmdDevs(mirrorInfo, jnlInfo = jnlMgr.getJnlGroup(mirrorInfo));
            if (1 == assignFlg) {
                this.logUty.putlog("checkassigndCommandDev", "Mirror is assigned Command Device. Journal ID = :" + jnlInfo.getIndex() + " , Mirror ID : " + mirrorInfo.getMirrorId());
                ret = false;
                break;
            }
            if (0 == assignFlg) continue;
            this.logUty.putlog("checkassigndCommandDev", "Invalid value has returned checkAssignRCmdDevs.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    private void setValueCmbData(SJctrComboBoxDataModel cmbRcmd, SJmoUniversalReplicatorJnlGrp jnlInfo, SJmoUniversalReplicatorJnlGrpMirror mirrorInfo) {
        if (mirrorInfo.getStatus() == 0) {
            jnlInfo.setUcPathForTC(1);
            jnlInfo.setRcmdDevForTC(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cmbRcmd));
        } else {
            mirrorInfo.setUcPath(1);
            mirrorInfo.setRcmdDev(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cmbRcmd));
        }
    }

    private int getNumOfMirrorNotInitial(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList) {
        int numOfMirror = 0;
        for (SJmoUniversalReplicatorJnlGrpMirror mirrorInfo : mirrorList) {
            if (0 == mirrorInfo.getStatus()) continue;
            ++numOfMirror;
        }
        return numOfMirror;
    }

    private void setCmbRcmdDev(SJctrComboBoxDataModel cmbRCMD, List<SJmoLdevDetail> remoteCmdDevsList, SJctrLdevUtility ldevUtil, SJctrSystemParamContainer spc) {
        for (SJmoLdevDetail ldevInfo : remoteCmdDevsList) {
            cmbRCMD.addItem(String.valueOf(ldevInfo.getIndex()), ldevUtil.toLdevDisplay(ldevInfo));
        }
        if (spc.isLocalHost()) {
            cmbRCMD.addItem(Integer.toString(-1), this.getComUtility().getGuidance("NOT_TO_USE"));
        }
    }

    private static enum ASSIGN_R_CMD_DEVS_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

