/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.edittcpairopts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrTrueCopyPairInfoComparator;
import sanproject.sn2.controller.com.comparator.SJctrUniversalReplicatorPairInfoComparator;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.replication.remote.tcpairs.SJctrRemoteReplicationTcPairsTopTableModel;
import sanproject.sn2.controller.topwindow.replication.remote.urpairs.SJctrRemoteReplicationUrPairsTopTableModel;
import sanproject.sn2.controller.wizard.replication.remote.edittcpairopts.SJctrEditTcPairOptionsSubWizard;
import sanproject.sn2.controller.wizard.replication.remote.editurpairopts.SJctrEditUrPairOptionsSubWizard;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;

public class SJctrItemSelectListenerEditPairOptions
implements SJctrItemSelectListener {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            SJctrDataController dc = event.getSource().getDataController();
            ArrayList<Object> param = new ArrayList();
            int dispId = dc.getDisplayId();
            if (dispId == 13313) {
                param = this.makeParamFromTcPairs(dc);
            } else if (dispId == 13314) {
                param = this.makeParamFromUrPairs(dc);
            } else {
                SJctrUserController uc = dc.getOwner();
                uc.getLogUty().putlog("selectChanged", "Invalid Display ID.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_WIZARD, param);
        }
    }

    private ArrayList<Object> makeParamFromTcPairs(SJctrDataController dc) {
        SJctrUserController uc = dc.getOwner();
        SJctrRemoteReplicationTcPairsTopTableModel pairsTopTable = (SJctrRemoteReplicationTcPairsTopTableModel)dc.getDataObjectModel("COM_TABLE");
        if (pairsTopTable == null) {
            uc.getLogUty().putlog("makeParamFromTcPairs", "SJctrRemoteReplicationTcPairsTopTableModel is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedPairsList = pairsTopTable.getSelectedRowData();
        if (selectedPairsList == null || selectedPairsList.size() == 0) {
            uc.getLogUty().putlog("makeParamFromTcPairs", "Selected pairs table data is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForTcPairVol(selectedPairsList);
        if (-1 == copytype) {
            uc.getLogUty().putlog("makeParamFromTcPairs", "Selected pairs copytype are mixed.");
            SJctrError err = new SJctrError(210, 22, 206009);
            SJcException sJcException = err.createException();
            throw sJcException;
        }
        for (SJmoTrueCopyPairVolInfo sJmoTrueCopyPairVolInfo : selectedPairsList) {
            this.checkTCPairPosition(sJmoTrueCopyPairVolInfo, uc);
            this.checkTCPairStatus(sJmoTrueCopyPairVolInfo, uc);
        }
        ArrayList<Object> param = new ArrayList<Object>();
        HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>();
        Collections.sort(selectedPairsList, new SJctrTrueCopyPairInfoComparator());
        hashMap.put("KEY_SELECTED_REMOTE_VOL", selectedPairsList);
        param.add(SJctrEditTcPairOptionsSubWizard.class);
        param.add(hashMap);
        return param;
    }

    private ArrayList<Object> makeParamFromUrPairs(SJctrDataController dc) {
        SJctrUserController uc = dc.getOwner();
        SJctrRemoteReplicationUrPairsTopTableModel pairsTopTable = (SJctrRemoteReplicationUrPairsTopTableModel)dc.getDataObjectModel("COM_TABLE");
        if (pairsTopTable == null) {
            uc.getLogUty().putlog("makeParamFromUrPairs", "SJctrRemoteReplicationUrPairsTopTableModel is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedPairsList = pairsTopTable.getSelectedRowData();
        if (selectedPairsList == null || selectedPairsList.size() == 0) {
            uc.getLogUty().putlog("makeParamFromUrPairs", "Selected pairs table data is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVol(selectedPairsList);
        if (-1 == copytype) {
            uc.getLogUty().putlog("makeParamFromUrPairs", "Selected pairs copytype are mixed.");
            SJctrError err = new SJctrError(210, 22, 206009);
            SJcException sJcException = err.createException();
            throw sJcException;
        }
        for (SJmoUniversalReplicatorPairVolInfo sJmoUniversalReplicatorPairVolInfo : selectedPairsList) {
            this.checkURPairPosition(sJmoUniversalReplicatorPairVolInfo, uc);
            this.checkURPairStatus(sJmoUniversalReplicatorPairVolInfo, uc);
        }
        ArrayList<Object> param = new ArrayList<Object>();
        HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>();
        Collections.sort(selectedPairsList, new SJctrUniversalReplicatorPairInfoComparator());
        hashMap.put("KEY_SELECTED_REMOTE_VOL", selectedPairsList);
        param.add(SJctrEditUrPairOptionsSubWizard.class);
        param.add(hashMap);
        return param;
    }

    private void checkTCPairPosition(SJmoTrueCopyPairVolInfo pairInfo, SJctrUserController uc) {
        if (SJctrRemoteReplicationUtility.getPairPos(pairInfo) != 0) {
            uc.getLogUty().putlog("checkTCPairPosition", "Contained SVOL.");
            SJctrError err = new SJctrError(210, 22, 206005);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private void checkTCPairStatus(SJmoTrueCopyPairVolInfo pairInfo, SJctrUserController uc) {
        if (!SJctrRemoteReplicationUtility.checkEditTCPairOptionsStatus(pairInfo)) {
            uc.getLogUty().putlog("checkTCPairStatus", "Contained invaid Status.");
            SJctrError err = new SJctrError(210, 22, 206014);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private void checkURPairPosition(SJmoUniversalReplicatorPairVolInfo pairInfo, SJctrUserController uc) {
        if (SJctrRemoteReplicationUtility.getPairPos(pairInfo) != 0) {
            uc.getLogUty().putlog("checkURPairPosition", "Contained SVOL.");
            SJctrError err = new SJctrError(210, 22, 206005);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private void checkURPairStatus(SJmoUniversalReplicatorPairVolInfo pairInfo, SJctrUserController uc) {
        if (!SJctrRemoteReplicationUtility.checkEditURPairOptionsStatus(pairInfo)) {
            uc.getLogUty().putlog("checkURPairStatus", "Contained invaid Status.");
            SJctrError err = new SJctrError(210, 22, 206014);
            SJcException exp = err.createException();
            throw exp;
        }
    }
}

