/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resynchactgs;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.common.Robj_interface_RJiHAsetReconstructPair;
import sanproject.serverux.dataimpl.RCErrorDetail;
import sanproject.serverux.dataimpl.RCErrorInf;
import sanproject.serverux.dataimpl.RJiHAsetReconstructPair;
import sanproject.serverux.dataimpl.RJiHAsetReconstructPair_IN;
import sanproject.serverux.dataimpl.RJiHAsetReconstructPair_OUT;
import sanproject.serverux.dataimpl.RJiHAsetReconstructPairsList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationHaPairBaseAC;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationError;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationErrorForCtg;
import sanproject.sn2.controller.wizard.replication.remote.resynchactgs.SJctrResyncHaCtgsConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;

public class SJctrResyncHaCtgsAC
extends SJctrOperationHaPairBaseAC {
    private static final long serialVersionUID = -6829260778594720401L;
    private Map<Integer, List<SJmoPortLunDetail>> portLunMap = null;
    private int modelID = 0;
    private List<SJmoSubsystemInfo> subsystemInfoList = null;
    private List<SJmoSsidDetail> ssidList = null;
    private int aluaModeSelection;
    private List<SJmoLdevDetail> confirmLdevDetails = null;
    private HashMap<String, Integer> mapLdevCtg = null;

    public void setApplyData(SJctrResyncHaCtgsConfirmData confirmData) {
        this.applyInfo = confirmData.getPairsInfo();
        this.portLunMap = confirmData.getLUPathMap();
        this.modelID = confirmData.getModelID();
        this.subsystemInfoList = confirmData.getNeedDataMap().get(SJmoGetSubsystemInfo.class.getName());
        this.ssidList = confirmData.getNeedDataMap().get(SJmoGetSsidDetail.class.getName());
        this.aluaModeSelection = confirmData.getAluaModeSelection();
        this.confirmLdevDetails = confirmData.getConfirmLdevDetails();
        this.mapLdevCtg = confirmData.getMapLdevCtg();
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        String METHOD = "applyStart";
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            HashMap<Integer, SJctrRcOperationErrorForCtg> mapError = new HashMap<Integer, SJctrRcOperationErrorForCtg>();
            if (this.aluaModeSelection != 0) {
                ArrayList<?> aluaSetList = this.getSetList();
                SanResponse aluaResult = null;
                if (aluaSetList.size() > 0) {
                    SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateAluaMode)");
                    aluaResult = (SanResponse)supplier.applyStart(this.getLockId(), aluaSetList);
                    SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateAluaMode)");
                }
                this.putAluaErrorCtg(mapError, aluaResult);
            }
            Object resyncPairResult = null;
            if (this.applyInfo.size() == mapError.size()) {
                SJctrLogUty.info(this.title, "applyStart", "GAD Resync CTG do not apply, because All AluaMode update include an error.");
            } else {
                ArrayList<?> resyncPairSetList = this.getSetList(mapError);
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (RJiHAsetReconstructPair)");
                resyncPairResult = supplier.applyStart(this.getLockId(), resyncPairSetList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (RJiHAsetReconstructPair)");
                if (resyncPairResult instanceof RJiHAsetReconstructPair_OUT) {
                    RCErrorInf errInfo = (RCErrorInf)((RJiHAsetReconstructPair_OUT)resyncPairResult).getDataObject();
                    this.putPairErrorCtg(mapError, errInfo);
                } else {
                    SJctrLogUty.info(this.title, "applyStart", "instance of resyncPairResult is invalid.");
                    SJctrError error = new SJctrError(210, 22, 107001);
                    this.setError(error);
                    return;
                }
            }
            this.setApplyResultCtg(mapError);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        int applyCount = 0;
        SJdsSupplierAgent supplierAgent = SJdsSupplierMgr.getSupplierMgr().getAgent();
        SanRequest sanRequest = supplierAgent.newRequest("LUNMupdateAluaMode");
        try {
            SanList ldevs = sanRequest.newList("Ldevs");
            for (SJmoLdevDetail ldevDetail : this.confirmLdevDetails) {
                SanObject ldev = ldevs.addObj();
                int[] idArray = new int[]{ldevDetail.getSLdkc(), ldevDetail.getSCu(), ldevDetail.getSLdev()};
                ldev.putIntArray("Id", idArray);
                boolean aluaMode = this.aluaModeSelection == 1;
                ldev.putBoolean("AluaMode", aluaMode);
                ++applyCount;
            }
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error("SJctrResyncHaCtgsAC", "getSetList", "The error occurred during request parameter generation processing of Key-Value." + sdEx.getMessage());
            SJctrError err = new SJctrError(210, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        if (applyCount > 0) {
            applyList.add(sanRequest);
        }
        return applyList;
    }

    public ArrayList<?> getSetList(HashMap<Integer, SJctrRcOperationErrorForCtg> mapError) {
        ArrayList<RJiHAsetReconstructPair> rmiPairList = new ArrayList<RJiHAsetReconstructPair>();
        for (SJmoHAPairVolInfo pairInfo : this.applyInfo) {
            if (mapError != null && mapError.containsKey(pairInfo.getIGroup())) continue;
            RJiHAsetReconstructPair resync1Pair = new RJiHAsetReconstructPair();
            SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(pairInfo);
            int localSsid = SJctrHaUtility.getLocalExistenceSsid(localVol, this.ssidList);
            resync1Pair.setAttr(pairInfo.getIAttribute());
            if (SJctrHaUtility.isSvol(pairInfo)) {
                if (pairInfo.getISSWS() == 1) {
                    this.setRemoteStorageInfoToPrimary(resync1Pair, pairInfo);
                    this.setLocalStorageInfoToSecondary(resync1Pair, localVol, localSsid);
                } else {
                    this.setLocalStorageInfoToPrimary(resync1Pair, localVol, localSsid);
                    this.setRemoteStorageInfoToSecondary(resync1Pair, pairInfo);
                }
            } else if (pairInfo.getISSWS() == 1) {
                this.setLocalStorageInfoToPrimary(resync1Pair, localVol, localSsid);
                this.setRemoteStorageInfoToSecondary(resync1Pair, pairInfo);
            } else {
                this.setRemoteStorageInfoToPrimary(resync1Pair, pairInfo);
                this.setLocalStorageInfoToSecondary(resync1Pair, localVol, localSsid);
            }
            resync1Pair.setPathGrp(pairInfo.getIPathGroup());
            resync1Pair.setMirror(pairInfo.getIMuNo());
            boolean bSwap = false;
            if (pairInfo.getISSWS() == 1) {
                bSwap = true;
            }
            resync1Pair.setSwap(bSwap);
            resync1Pair.setCopyPace(pairInfo.getICopyPace());
            boolean bQuorumDisable = pairInfo.isQuorumDisabled();
            resync1Pair.setQuorumDisable(bQuorumDisable);
            if (!bQuorumDisable) {
                resync1Pair.setQuorumID(pairInfo.getIQuorumID());
            }
            boolean bGroupEnable = true;
            resync1Pair.setGroupEnable(bGroupEnable);
            if (bGroupEnable) {
                resync1Pair.setGroup(pairInfo.getIGroup());
            }
            resync1Pair.setRange(1);
            resync1Pair.setSuspended(pairInfo.getISuspended());
            rmiPairList.add(resync1Pair);
        }
        Robj_interface_RJiHAsetReconstructPair[] resyncPairList = rmiPairList.toArray(new RJiHAsetReconstructPair[rmiPairList.size()]);
        RJiHAsetReconstructPairsList rJiHAsetReconstructPairsList = new RJiHAsetReconstructPairsList();
        rJiHAsetReconstructPairsList.setPairParam(resyncPairList);
        RJiHAsetReconstructPair_IN inputIF = new RJiHAsetReconstructPair_IN();
        inputIF.setPairParam(rJiHAsetReconstructPairsList);
        ArrayList<RJiHAsetReconstructPair_IN> applyList = new ArrayList<RJiHAsetReconstructPair_IN>(1);
        applyList.add(inputIF);
        return applyList;
    }

    protected void putAluaErrorCtg(HashMap<Integer, SJctrRcOperationErrorForCtg> mapError, SanResponse aluaResult) throws SanDataException {
        if (mapError != null && aluaResult != null) {
            SanList ldevs = aluaResult.getList("Ldevs");
            for (SanObject ldev : ldevs) {
                SJctrRcOperationError errLdev;
                ArrayList<SJctrRcOperationError> errLdevs;
                SanObject errorInfo = ldev.getObj("ErrorInfo");
                int errorCode = errorInfo.getInt("ErrorCode");
                if (0 == errorCode) continue;
                int[] id = ldev.getIntArray("Id");
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setLdevIndex((short)id[0], (short)id[1], (short)id[2]);
                int key = this.mapLdevCtg.get(ldevIndex.getIndexKey());
                int[] messageId = errorInfo.getIntArray("MessageId");
                SJctrRcOperationErrorForCtg errCtg = mapError.get(key);
                if (errCtg == null) {
                    errCtg = new SJctrRcOperationErrorForCtg(messageId[0] / 100, messageId[0] % 100, messageId[1], key);
                    errLdevs = errCtg.getErrLdevs();
                    errLdev = new SJctrRcOperationError(messageId[0] / 100, messageId[0] % 100, messageId[1], ldevIndex.getIndex());
                    errLdevs.add(errLdev);
                    errCtg.setErrLdevs(errLdevs);
                    mapError.put(key, errCtg);
                    continue;
                }
                errLdevs = errCtg.getErrLdevs();
                errLdev = new SJctrRcOperationError(messageId[0] / 100, messageId[0] % 100, messageId[1], ldevIndex.getIndex());
                errLdevs.add(errLdev);
            }
        }
    }

    protected void putPairErrorCtg(HashMap<Integer, SJctrRcOperationErrorForCtg> mapError, RCErrorInf errInfo) {
        if (mapError != null && errInfo != null) {
            RCErrorDetail[] details;
            int func = errInfo.ErrorPart / 100;
            int module = errInfo.ErrorPart % 100;
            for (RCErrorDetail detail : details = errInfo.tDetail) {
                int errorCode = detail.ErrCode;
                if (0 == errorCode) continue;
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setLdevIndex(detail.pLDKC, (short)detail.pCu, (short)detail.pLdev);
                int key = this.mapLdevCtg.get(ldevIndex.getIndexKey());
                SJctrRcOperationErrorForCtg error = new SJctrRcOperationErrorForCtg(func, module, errorCode, key);
                mapError.put(key, error);
            }
        }
    }

    protected void setApplyResultCtg(HashMap<Integer, SJctrRcOperationErrorForCtg> mapError) {
        SJctrError normal = new SJctrError(210, 22, 0);
        this.resultData = new ArrayList();
        int line = 0;
        for (SJmoHAPairVolInfo haPair : this.applyInfo) {
            SJctrRcOperationErrorForCtg error = mapError.get(haPair.getIGroup());
            if (error != null) {
                error.setIndex(line);
                this.resultData.add(error);
            }
            ++line;
        }
        if (this.resultData.size() > 0) {
            SJctrError firstErr = (SJctrError)this.resultData.get(0);
            SJctrError representErr = new SJctrError(firstErr.getFunc(), firstErr.getModule(), firstErr.getError());
            this.setError(representErr);
        } else {
            this.setError(normal);
        }
    }

    private void setRemoteStorageInfoToPrimary(RJiHAsetReconstructPair resync1Pair, SJmoHAPairVolInfo pairInfo) {
        resync1Pair.setSN_P(pairInfo.getStrPairSN());
        resync1Pair.setSSID_P(pairInfo.getIPairSSID());
        resync1Pair.setLU_P(SJctrHaUtility.getRemoteRJiHAsetLU(pairInfo));
    }

    private void setLocalStorageInfoToSecondary(RJiHAsetReconstructPair resync1Pair, SJmoReplicationPairVolInfo localVol, int localSsid) {
        resync1Pair.setSN_S(SJctrComUtility.toPaddingZeroString(Integer.parseInt(this.subsystemInfoList.get(0).getDKCSNString()), 5));
        resync1Pair.setModel_S(this.modelID);
        resync1Pair.setSSID_S(localSsid);
        resync1Pair.setLU_S(SJctrHaUtility.getLocalRJiHAsetLU(localVol, this.portLunMap));
    }

    private void setLocalStorageInfoToPrimary(RJiHAsetReconstructPair resync1Pair, SJmoReplicationPairVolInfo localVol, int localSsid) {
        resync1Pair.setSN_P(SJctrComUtility.toPaddingZeroString(Integer.parseInt(this.subsystemInfoList.get(0).getDKCSNString()), 5));
        resync1Pair.setSSID_P(localSsid);
        resync1Pair.setLU_P(SJctrHaUtility.getLocalRJiHAsetLU(localVol, this.portLunMap));
    }

    private void setRemoteStorageInfoToSecondary(RJiHAsetReconstructPair resync1Pair, SJmoHAPairVolInfo pairInfo) {
        resync1Pair.setSN_S(pairInfo.getStrPairSN());
        resync1Pair.setModel_S(pairInfo.getIPairModel());
        resync1Pair.setSSID_S(pairInfo.getIPairSSID());
        resync1Pair.setLU_S(SJctrHaUtility.getRemoteRJiHAsetLU(pairInfo));
    }
}

