/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resynchapairs;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.common.Robj_interface_RJiHAsetReconstructPair;
import sanproject.serverux.dataimpl.RCErrorInf;
import sanproject.serverux.dataimpl.RJiHAsetReconstructPair;
import sanproject.serverux.dataimpl.RJiHAsetReconstructPair_IN;
import sanproject.serverux.dataimpl.RJiHAsetReconstructPair_OUT;
import sanproject.serverux.dataimpl.RJiHAsetReconstructPairsList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationHaPairBaseAC;
import sanproject.sn2.controller.wizard.replication.remote.resynchapairs.SJctrResyncHaPairsConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;

public class SJctrResyncHaPairsAC
extends SJctrOperationHaPairBaseAC {
    private static final long serialVersionUID = -133102274732495424L;
    private Map<Integer, List<SJmoPortLunDetail>> portLunMap = null;
    private int modelID;
    private List<SJmoSubsystemInfo> subsystemInfoList = null;
    private List<SJmoSsidDetail> ssidList = null;
    private int aluaModeSelection;

    public void setApplyData(SJctrResyncHaPairsConfirmData confirmData) {
        this.applyInfo = confirmData.getPairsInfo();
        this.portLunMap = confirmData.getLUPathMap();
        this.modelID = confirmData.getModelID();
        this.subsystemInfoList = confirmData.getNeedDataMap().get(SJmoGetSubsystemInfo.class.getName());
        this.ssidList = confirmData.getNeedDataMap().get(SJmoGetSsidDetail.class.getName());
        this.aluaModeSelection = confirmData.getAluaModeSelection();
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        String METHOD = "applyStart";
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            HashMap<String, SJctrError> mapError = new HashMap<String, SJctrError>();
            if (this.aluaModeSelection != 0) {
                ArrayList<?> aluaSetList = this.getSetList();
                SanResponse aluaResult = null;
                if (aluaSetList.size() > 0) {
                    SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateAluaMode)");
                    aluaResult = (SanResponse)supplier.applyStart(this.getLockId(), aluaSetList);
                    SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateAluaMode)");
                }
                this.putAluaError(mapError, aluaResult);
            }
            Object resyncPairResult = null;
            if (this.applyInfo.size() == mapError.size()) {
                SJctrLogUty.info(this.title, "applyStart", "GAD Resync Pair do not apply, because All AluaMode update was errors.");
            } else {
                ArrayList<?> resyncPairSetList = this.getSetList(mapError);
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (RJiHAsetReconstructPair)");
                resyncPairResult = supplier.applyStart(this.getLockId(), resyncPairSetList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (RJiHAsetReconstructPair)");
                if (resyncPairResult instanceof RJiHAsetReconstructPair_OUT) {
                    RCErrorInf errInfo = (RCErrorInf)((RJiHAsetReconstructPair_OUT)resyncPairResult).getDataObject();
                    this.putPairError(mapError, errInfo);
                } else {
                    SJctrLogUty.info(this.title, "applyStart", "instance of resyncPairResult is invalid.");
                    SJctrError error = new SJctrError(210, 22, 107001);
                    this.setError(error);
                    return;
                }
            }
            this.setApplyResult(mapError);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        int applyCount = 0;
        SJdsSupplierAgent supplierAgent = SJdsSupplierMgr.getSupplierMgr().getAgent();
        SanRequest sanRequest = supplierAgent.newRequest("LUNMupdateAluaMode");
        try {
            SanList ldevs = sanRequest.newList("Ldevs");
            for (SJmoHAPairVolInfo pairInfo : this.applyInfo) {
                SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(pairInfo);
                if (localVol == null) continue;
                SanObject ldev = ldevs.addObj();
                int[] idArray = new int[]{localVol.getSLdkc(), localVol.getSCu(), localVol.getSLdev()};
                ldev.putIntArray("Id", idArray);
                boolean aluaMode = this.aluaModeSelection == 1;
                ldev.putBoolean("AluaMode", aluaMode);
                ++applyCount;
            }
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error("SJctrResyncHaPairsAC", "getSetList", "The error occurred during request parameter generation processing of Key-Value." + sdEx.getMessage());
            SJctrError err = new SJctrError(210, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        if (applyCount > 0) {
            applyList.add(sanRequest);
        }
        return applyList;
    }

    public ArrayList<?> getSetList(Map<String, SJctrError> mapError) {
        ArrayList<RJiHAsetReconstructPair> rmiPairList = new ArrayList<RJiHAsetReconstructPair>();
        for (SJmoHAPairVolInfo pairInfo : this.applyInfo) {
            SJmoReplicationPairVolInfo ldevIndex;
            if (mapError != null && mapError.containsKey((ldevIndex = SJctrHaUtility.getLocalVolume(pairInfo)).getIndexKey())) continue;
            RJiHAsetReconstructPair resync1Pair = new RJiHAsetReconstructPair();
            SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(pairInfo);
            int localSsid = SJctrHaUtility.getLocalExistenceSsid(localVol, this.ssidList);
            resync1Pair.setAttr(pairInfo.getIAttribute());
            if (SJctrHaUtility.isSvol(pairInfo)) {
                if (pairInfo.getISSWS() == 1) {
                    this.setRemoteStorageInfoToPrimaryStorageInfo(resync1Pair, pairInfo);
                    this.setLocalStorageInfoToSecondaryStorageInfo(resync1Pair, localVol, localSsid);
                } else {
                    this.setLocalStorageInfoToPrimaryStorageInfo(resync1Pair, localVol, localSsid);
                    this.setRemoteStorageInfoToSecondaryStorageInfo(resync1Pair, pairInfo);
                }
            } else if (pairInfo.getISSWS() == 1) {
                this.setLocalStorageInfoToPrimaryStorageInfo(resync1Pair, localVol, localSsid);
                this.setRemoteStorageInfoToSecondaryStorageInfo(resync1Pair, pairInfo);
            } else {
                this.setRemoteStorageInfoToPrimaryStorageInfo(resync1Pair, pairInfo);
                this.setLocalStorageInfoToSecondaryStorageInfo(resync1Pair, localVol, localSsid);
            }
            resync1Pair.setPathGrp(pairInfo.getIPathGroup());
            resync1Pair.setMirror(pairInfo.getIMuNo());
            boolean bSwap = false;
            if (pairInfo.getISSWS() == 1) {
                bSwap = true;
            }
            resync1Pair.setSwap(bSwap);
            resync1Pair.setCopyPace(pairInfo.getICopyPace());
            boolean bQuorumDisable = pairInfo.isQuorumDisabled();
            resync1Pair.setQuorumDisable(bQuorumDisable);
            if (!bQuorumDisable) {
                resync1Pair.setQuorumID(pairInfo.getIQuorumID());
            }
            boolean bGroupEnable = pairInfo.hasGroup();
            resync1Pair.setGroupEnable(bGroupEnable);
            if (bGroupEnable) {
                resync1Pair.setGroup(pairInfo.getIGroup());
            }
            resync1Pair.setRange(0);
            resync1Pair.setSuspended(pairInfo.getISuspended());
            rmiPairList.add(resync1Pair);
        }
        Robj_interface_RJiHAsetReconstructPair[] resyncPairList = rmiPairList.toArray(new RJiHAsetReconstructPair[rmiPairList.size()]);
        RJiHAsetReconstructPairsList rJiHAsetReconstructPairsList = new RJiHAsetReconstructPairsList();
        rJiHAsetReconstructPairsList.setPairParam(resyncPairList);
        RJiHAsetReconstructPair_IN inputIF = new RJiHAsetReconstructPair_IN();
        inputIF.setPairParam(rJiHAsetReconstructPairsList);
        ArrayList<RJiHAsetReconstructPair_IN> applyList = new ArrayList<RJiHAsetReconstructPair_IN>(1);
        applyList.add(inputIF);
        return applyList;
    }

    private void setRemoteStorageInfoToPrimaryStorageInfo(RJiHAsetReconstructPair resync1Pair, SJmoHAPairVolInfo pairInfo) {
        resync1Pair.setSN_P(pairInfo.getStrPairSN());
        resync1Pair.setSSID_P(pairInfo.getIPairSSID());
        resync1Pair.setLU_P(SJctrHaUtility.getRemoteRJiHAsetLU(pairInfo));
    }

    private void setLocalStorageInfoToSecondaryStorageInfo(RJiHAsetReconstructPair resync1Pair, SJmoReplicationPairVolInfo localVol, int localSsid) {
        resync1Pair.setSN_S(SJctrComUtility.toPaddingZeroString(Integer.parseInt(this.subsystemInfoList.get(0).getDKCSNString()), 5));
        resync1Pair.setModel_S(this.modelID);
        resync1Pair.setSSID_S(localSsid);
        resync1Pair.setLU_S(SJctrHaUtility.getLocalRJiHAsetLU(localVol, this.portLunMap));
    }

    private void setLocalStorageInfoToPrimaryStorageInfo(RJiHAsetReconstructPair resync1Pair, SJmoReplicationPairVolInfo localVol, int localSsid) {
        resync1Pair.setSN_P(SJctrComUtility.toPaddingZeroString(Integer.parseInt(this.subsystemInfoList.get(0).getDKCSNString()), 5));
        resync1Pair.setSSID_P(localSsid);
        resync1Pair.setLU_P(SJctrHaUtility.getLocalRJiHAsetLU(localVol, this.portLunMap));
    }

    private void setRemoteStorageInfoToSecondaryStorageInfo(RJiHAsetReconstructPair resync1Pair, SJmoHAPairVolInfo pairInfo) {
        resync1Pair.setSN_S(pairInfo.getStrPairSN());
        resync1Pair.setModel_S(pairInfo.getIPairModel());
        resync1Pair.setSSID_S(pairInfo.getIPairSSID());
        resync1Pair.setLU_S(SJctrHaUtility.getRemoteRJiHAsetLU(pairInfo));
    }
}

