/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.selectjournalvols;

import java.util.HashSet;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.remote.selectjournalvols.SJctrSelectJournalVolumesTableModel;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrSelectJournalVolumesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595492;
    private static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    private static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";
    public static final String KEY_AVAILABLE_LDEVS = "AVAILABLE_LDEVS";
    public static final String KEY_KEEPING_JNL_VOLS = "KEEPING_JNL_VOLS";

    public SJctrSelectJournalVolumesDC() {
        super(33595492);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrSelectJournalVolumesTableModel availableTable = new SJctrSelectJournalVolumesTableModel();
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, availableTable);
        SJctrSelectJournalVolumesTableModel selectedTable = new SJctrSelectJournalVolumesTableModel();
        selectedTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SELECTED, selectedTable);
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectJournalVolumesDC.this.fireMessageEvent(SELECT_JNL_VOLS_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectJournalVolumesDC.this.fireMessageEvent(SELECT_JNL_VOLS_MSG.SELECT_REMOVE);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_JNL_VOLS_MSG.SELECT_ADD, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSelectJournalVolumesDC.this.addAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SELECT_JNL_VOLS_MSG.SELECT_REMOVE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSelectJournalVolumesDC.this.removeAction(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> availableTableList = this.getCache(KEY_AVAILABLE_LDEVS);
        List<?> selectedTableList = this.getCache(KEY_KEEPING_JNL_VOLS);
        if (null == availableTableList || null == selectedTableList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            throw this.createRemoteReplicationException(107001);
        }
        if (0 == availableTableList.size() && 0 == selectedTableList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            throw this.createRemoteReplicationException(107001);
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        List<?> availableTableList = this.getCache(KEY_AVAILABLE_LDEVS);
        SJctrSelectJournalVolumesTableModel availableTable = (SJctrSelectJournalVolumesTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        availableTable.setBasicDataList(availableTableList);
        List<?> selectedTableList = this.getCache(KEY_KEEPING_JNL_VOLS);
        SJctrSelectJournalVolumesTableModel selectedTable = (SJctrSelectJournalVolumesTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        selectedTable.setBasicDataList(selectedTableList);
        return true;
    }

    @Override
    public boolean checkEndData() {
        SJctrSelectJournalVolumesTableModel selectedTable = (SJctrSelectJournalVolumesTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> selectedList = selectedTable.getAllRowData();
        this.putCache(KEY_KEEPING_JNL_VOLS, selectedList);
        return true;
    }

    private void addAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrSelectJournalVolumesTableModel availableTable = (SJctrSelectJournalVolumesTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<Object> availavleRows = availableTable.getSelectedRowData();
        if (availavleRows.size() == 0) {
            this.logUty.putlog("addAction", "not selected");
            return;
        }
        SJctrSelectJournalVolumesTableModel selectedTable = (SJctrSelectJournalVolumesTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> selectedRows = selectedTable.getAllRowData();
        if (selectedRows.size() + availavleRows.size() > 2) {
            this.logUty.putlog("addAction", "Journal exceeds the maximum value.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206077);
        }
        List<SJmoRSGgetAllRsgs> allRsgs = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
        SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(this.getOwner(), allRsgs.get(0));
        HashSet<String> clprSet = new HashSet<String>();
        HashSet<String> rsgIdSet = new HashSet<String>();
        for (Object availavleRow : availavleRows) {
            clprSet.add(Short.toString(((SJmoLdevDetail)availavleRow).getSCLPR()));
            rsgIdSet.add(Integer.toString(rsgUty.getRsgId((SJmoLdevDetail)availavleRow)));
        }
        for (Object selectedRow : selectedRows) {
            clprSet.add(Short.toString(((SJmoLdevDetail)selectedRow).getSCLPR()));
            rsgIdSet.add(Integer.toString(rsgUty.getRsgId((SJmoLdevDetail)selectedRow)));
        }
        if (clprSet.size() != 1) {
            this.logUty.putlog("addAction", "Contains two or more CLPR.");
            throw this.createRemoteReplicationException(206001);
        }
        if (rsgIdSet.size() != 1) {
            this.logUty.putlog("addAction", "Contains two or more RSG ID.");
            throw this.createRemoteReplicationException(206002);
        }
        List<Object> addRows = availableTable.removeSelectedRowData();
        selectedTable.addRowDataTop(addRows);
        List<Object> selectingList = selectedTable.getFilterData(addRows);
        selectedTable.setRowSelectionList(selectingList);
        selectedTable.setCurrentPage(Integer.toString(1));
        selectedTable.setVScrollReset(true);
        selectedTable.setSortColumn(null, Boolean.TRUE);
        this.updateFooter();
        this.setDirtyAll();
    }

    private void removeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrSelectJournalVolumesTableModel selectedTable = (SJctrSelectJournalVolumesTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> selectedRows = selectedTable.getSelectedRowData();
        if (selectedRows.size() == 0) {
            this.logUty.putlog("removeAction", "not selected");
            return;
        }
        SJctrSelectJournalVolumesTableModel availableTable = (SJctrSelectJournalVolumesTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<Object> removeData = selectedTable.removeSelectedRowData();
        availableTable.addRowDataTop(removeData);
        List<Object> selectingList = availableTable.getFilterData(removeData);
        availableTable.setRowSelectionList(selectingList);
        availableTable.setCurrentPage(Integer.toString(1));
        availableTable.setVScrollReset(true);
        availableTable.setSortColumn(null, Boolean.TRUE);
        this.updateFooter();
        this.setDirtyAll();
    }

    private SJcException createRemoteReplicationException(int err) {
        return new SJctrError(210, 22, err).createException();
    }

    public static enum SELECT_JNL_VOLS_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

