/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.splittcpairs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcPairTableDataModelBase;
import sanproject.sn2.controller.wizard.replication.remote.splittcpairs.SJctrSplitTCPairsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.splittcpairs.SJctrSplitTCPairsDataModel;
import sanproject.sn2.controller.wizard.replication.remote.splittcpairs.SJctrSplitTCPairsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrSplitTCPairsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17830945;
    private static final String DISP_TITLE = "SPLIT_PAIR";
    private static final String KEY_TABLE = "COM_SPLIT_TC_TABLE";
    private static final String KEY_SPLIT_TC_PAIR_MODEL = "COM_SPLIT_TC_PAIR_MODEL";

    public SJctrSplitTCPairsDC() {
        super(17830945);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetTrueCopyPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrSplitTCPairsTableModel());
        this.addDataObjectModel(KEY_SPLIT_TC_PAIR_MODEL, new SJctrSplitTCPairsDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoTrueCopyPairVolInfoMgr allTCPairInfo = SJctrRemoteReplicationUtility.getSJmoTrueCopyPairVolInfoMgr(this);
            List<SJmoTrueCopyPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            SJctrRemoteReplicationUtility.chkCacheTrueCopyPairsDetailData(this);
            List<SJmoTrueCopyPairVolInfo> pairExist = SJctrRemoteReplicationUtility.checkAndGetExistTCPairVolInfo(viewData, allTCPairInfo);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForTcPairVol(pairExist);
            if (copytype != 1 && copytype != 0) {
                this.logUty.putlog("checkConstructData", "mixed copytype.");
                SJctrError err = new SJctrError(210, 22, 206008);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean st = SJctrRemoteReplicationUtility.checkSplitTCPairStatus(pairExist);
            if (!st) {
                this.logUty.putlog("checkPairStatus", "Contained invaid Status.");
                SJctrError err = new SJctrError(210, 22, 206013);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrSplitTCPairsDataModel dataModel = (SJctrSplitTCPairsDataModel)this.getDataObjectModel(KEY_SPLIT_TC_PAIR_MODEL);
            dataModel.setCopyType(copytype);
            SJctrSplitTCPairsTableModel table = (SJctrSplitTCPairsTableModel)this.getDataObjectModel(KEY_TABLE);
            table.setBasicDataList(pairExist);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public void makeDataModel() {
        SJctrSplitTCPairsDataModel dataModel = (SJctrSplitTCPairsDataModel)this.getDataObjectModel(KEY_SPLIT_TC_PAIR_MODEL);
        int copyType = dataModel.getCopyType();
        SJctrSplitTCPairsTableModel tbl = (SJctrSplitTCPairsTableModel)this.getDataObjectModel(KEY_TABLE);
        Set<String> inVisibleKeySet = tbl.getinvisibleKeySet(copyType);
        SJctrRemoteReplicationUtility.setColumnVisible(tbl, inVisibleKeySet);
        super.makeDataModel();
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrSplitTCPairsConfirmData confirmData = new SJctrSplitTCPairsConfirmData();
            SJctrRcPairTableDataModelBase table = (SJctrRcPairTableDataModelBase)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedList = table.getAllRowData();
            SJmoTrueCopyPairVolInfo pairInfo = (SJmoTrueCopyPairVolInfo)selectedList.get(0);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForTcPairVolInfo(pairInfo);
            SJctrSplitTCPairsDataModel dataModel = (SJctrSplitTCPairsDataModel)this.getDataObjectModel(KEY_SPLIT_TC_PAIR_MODEL);
            SJctrRadioButtonGroupDataModel pvolWrite = (SJctrRadioButtonGroupDataModel)dataModel.getDataModel("COM_PVOL_WRITE");
            if (copytype == 1) {
                SJctrRadioButtonGroupDataModel svolWrite = (SJctrRadioButtonGroupDataModel)dataModel.getDataModel("COM_SVOL_WRITE");
                if (svolWrite.getSelect().equals("1") && pvolWrite.getSelect().equals("0")) {
                    SJctrError err = new SJctrError(210, 22, 206063);
                    SJcException exp = err.createException();
                    throw exp;
                }
                int sWrite = SJctrRemoteReplicationUtility.getSelectedRadioButtonKeyNum(svolWrite);
                confirmData.setSvolWrite(sWrite);
            } else if (copytype == 0) {
                SJctrRadioButtonGroupDataModel ssbTransfer = (SJctrRadioButtonGroupDataModel)dataModel.getDataModel("COM_SSB_TRANSFER");
                int ssb = SJctrRemoteReplicationUtility.getSelectedRadioButtonKeyNum(ssbTransfer);
                confirmData.setSSBTransfer(ssb);
            } else {
                this.logUty.putlog("checkEndData", "Copy type is invaid.");
            }
            confirmData.setPairsInfo(selectedList);
            int pWrite = SJctrRemoteReplicationUtility.getSelectedRadioButtonKeyNum(pvolWrite);
            confirmData.setPvolWrite(pWrite);
            List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
            Map<Integer, List<SJmoPortLunDetail>> ldevLUPathMap = SJctrReplicationUtility.createLDEVLUPathMap(portLunList, ldevDetailList);
            confirmData.setLUPathMap(ldevLUPathMap);
            confirmData.setCopyType(copytype);
            confirmData.setNeedData(this);
            ArrayList<SJctrSplitTCPairsConfirmData> confirmDataList = new ArrayList<SJctrSplitTCPairsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrSplitTCPairsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }
}

