/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.addextvols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.dataimpl.EXDDiscoveryDevice;
import sanproject.serverux.dataimpl.EXDExternalDevice;
import sanproject.serverux.dataimpl.EXDExternalDeviceEx;
import sanproject.serverux.dataimpl.EXDExternalVolumeEx;
import sanproject.serverux.dataimpl.EXDLogicalPath;
import sanproject.serverux.dataimpl.EXDPathGroup;
import sanproject.serverux.dataimpl.EXDgetDiscoveryDevice_IN;
import sanproject.serverux.dataimpl.EXDgetDiscoveryDevice_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.exstorage.system.pathgroup.volume.SJctrExsPathGrpMappedVolsDC;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddExtVolsSubWizard;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddVolumeInfo;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrDiscoveryResultInfo;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrExtPathGrpsTableModel;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrPathGroupErrorTableModel;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrPathGroupSelectDataModel;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrSubsystemErrorTableModel;
import sanproject.sn2.controller.wizard.uvm.com.SJctrGetExdDiscoveryDevice;
import sanproject.sn2.controller.wizard.uvm.com.SJctrSelectedDataModel;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmWizardDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrPathGroupManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrPhysicalPathManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrPortManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrSubsytemManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrTargetPortManager;
import sanproject.sn2.controller.wizard.uvm.comdialog.createextpathgrp.SJctrCreateExtPathGrpDialogDC;
import sanproject.sn2.controller.wizard.uvm.comdialog.createextpathgrp.SJctrCreatePathGrpData;
import sanproject.sn2.controller.wizard.uvm.editpolicy.SJctrExdPolicyData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilExdPathGrp;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilLdev;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilPg;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilSsid;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.modelrc.util.SJmoRscUtilExPathGrp;
import sanproject.sn2.modelrc.util.SJmoRscUtilLdev;
import sanproject.sn2.modelrc.util.SJmoRscUtilPg;
import sanproject.sn2.modelrc.util.SJmoRscUtilSsid;

public class SJctrExtPathGrpsDC
extends SJctrUvmWizardDataController {
    protected final int PROF_ID_OTHER = 10;
    private SJctrResourceGroupUtility rsgUtil = null;
    private static final int DISP_ID = 0x1004101;
    public static final String GUID_TITLE = "DISP_ME1_TITLE";
    public static final String GUID_SEL_CREATE_EXTPATHGRP = "SEL_CREATE_EXTPATHGRP";
    private static final String KEY_EXTPATHGPINF = "COM_EXTPATHGPINF";
    private static final String KEY_EXTPATHGPID = "COM_EXTPATHGPID";
    private static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_CREATED_PATHPROUP = "COM_CREATED_PATHPROUP";
    public static final String KEY_NEW_PATHPROUPDATA = "COM_NEW_PATHPROUPDATA";
    public static final String KEY_CREATE_EXTPATHGRP = "COM_PATH_BTN";
    public static final String KEY_SELECTROLLBACK = "COM_SELECTROLLBACK";
    private static final String KEY_EXTPATHNUM = "COM_EXTPATHNUM";
    public SJctrExdPolicyData policyData = null;
    List<Object> selectRows = null;
    private SJctrCreatePathGrpData backUpPathGrpData = null;
    private static final int COM_TURN_AROUND_TIME = 240;
    private List<PortWwnInfo> portWwnList = null;
    private SJmoExdPathGroupInfo carryPathGrp = null;
    private SJctrGetDirectWrapper asynWwrapper = null;
    private boolean setDiscoveryFlg = false;
    private SJctrMessageEvent discoveryEvent = null;
    private SJctrDataObjectModel<?> discoveryDstModel = null;
    private List<SJmoExdSubsystemInfo> subsystemInfo = null;
    private List<SJmoExdPathGroupInfo> pathGrpInfo = null;
    private List<SJmoExdPathGroupInfo> availableTableKeyList = null;

    public SJctrExtPathGrpsDC() throws SJcException {
        super(0x1004101);
        this.initDataModel();
        this.initListener();
        this.initManager();
    }

    @Override
    public boolean checkStartData() {
        List<?> selectList = null;
        selectList = this.getCache("SELECT_SUBSYSTEM_DATA");
        if (selectList != null) {
            for (Object obj : selectList) {
                if (obj instanceof SJmoExdSubsystemInfo) continue;
                this.logUty.putlog("checkStartData", "UnMach Class.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            this.subsystemInfo = selectList;
            return true;
        }
        selectList = this.getCache("SELECT_PATHGRPS_DATA");
        if (selectList != null) {
            for (Object obj : selectList) {
                if (obj instanceof SJmoExdPathGroupInfo) continue;
                this.logUty.putlog("checkStartData", "UnMach Class.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            this.pathGrpInfo = selectList;
            return true;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        boolean result = true;
        SJmoRSGgetAllRsgs allRsgInfo = (SJmoRSGgetAllRsgs)this.getCache(SJmoGetRSGgetAllRsgs.class).get(0);
        this.rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgInfo);
        SJctrSubsytemManager subsystemMgr = this.getManager(SJctrSubsytemManager.class);
        SJctrPathGroupManager pathGrpMgr = this.getManager(SJctrPathGroupManager.class);
        if (this.subsystemInfo != null) {
            this.availableTableKeyList = new ArrayList<SJmoExdPathGroupInfo>(subsystemMgr.getAllSubsystemList().size());
            ArrayList<SJctrError> errlist = new ArrayList<SJctrError>(this.subsystemInfo.size());
            for (SJmoExdSubsystemInfo subsystem : this.subsystemInfo) {
                SJctrError err = new SJctrError(0, 0, 0);
                int subsystemId = subsystem.getRmiExdSubsystemInfo().getId();
                if (subsystemMgr.getSubsystemInfo(subsystemId) != null) {
                    this.availableTableKeyList.addAll(pathGrpMgr.getPathGroupListOfSubsystemId(subsystemId));
                    continue;
                }
                this.logUty.putlog("checkConstructData", "Subsystem No." + subsystemId + "is Not Equip");
                err.setFunc(6);
                err.setModule(22);
                err.setError(106525);
                result = false;
                errlist.add(err);
            }
            if (!result) {
                ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errlist.size());
                ArrayList<SJmoExdSubsystemInfo> tableKeyList = new ArrayList<SJmoExdSubsystemInfo>(errlist.size());
                for (int errCnt = 0; errCnt < errlist.size(); ++errCnt) {
                    SJctrError oneError = (SJctrError)errlist.get(errCnt);
                    if (oneError.getError() == 0) continue;
                    SJmoExdSubsystemInfo subsystem = this.subsystemInfo.get(errCnt);
                    SJctrErrorColumnData oneErrorColumn = new SJctrErrorColumnData(subsystem, oneError);
                    errColumnList.add(oneErrorColumn);
                    tableKeyList.add(subsystem);
                }
                SJctrError errInfo = ((SJctrErrorColumnData)errColumnList.get(0)).getError();
                SJctrSubsystemErrorTableModel errTable = new SJctrSubsystemErrorTableModel();
                errTable.setDataController(this);
                errTable.initGuidance(this.getComUtility());
                errTable.createModelDirect();
                errTable.divideModelData(this.getProxy().getModelDataMap());
                errTable.setBasicDataList(tableKeyList);
                errTable.makeDataModel();
                SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
                SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
                errDc.setParameter(errTable, errColumnList);
                SJcException exp = errInfo.createException();
                exp.setErrDisp(rel);
                throw exp;
            }
        } else if (this.pathGrpInfo != null) {
            this.availableTableKeyList = new ArrayList<SJmoExdPathGroupInfo>(this.pathGrpInfo.size());
            ArrayList<SJctrError> errlist = new ArrayList<SJctrError>(this.pathGrpInfo.size());
            for (SJmoExdPathGroupInfo pathGrp : this.pathGrpInfo) {
                SJctrError err = new SJctrError(0, 0, 0);
                int pathGrpId = pathGrp.getRmiExdPathGroupInfo().getPathGroupID();
                SJmoExdPathGroupInfo pathGrpInfo = pathGrpMgr.getPathGroupInfo(pathGrpId);
                if (pathGrpInfo != null) {
                    this.availableTableKeyList.add(pathGrpInfo);
                    if (this.isUsablePathGroupRSG(pathGrpInfo)) continue;
                    this.logUty.putlog("checkConstructData", "PathGroup No." + pathGrpId + "is Not Usable");
                    err.setFunc(6);
                    err.setModule(22);
                    err.setError(105268);
                    result = false;
                    errlist.add(err);
                    continue;
                }
                this.logUty.putlog("checkConstructData", "PathGroup No." + pathGrpId + "is Not Equip");
                err.setFunc(6);
                err.setModule(22);
                err.setError(106527);
                result = false;
                errlist.add(err);
            }
            if (!result) {
                ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errlist.size());
                ArrayList<SJmoExdPathGroupInfo> tableKeyList = new ArrayList<SJmoExdPathGroupInfo>(errlist.size());
                for (int errCnt = 0; errCnt < errlist.size(); ++errCnt) {
                    SJctrError oneError = (SJctrError)errlist.get(errCnt);
                    if (oneError.getError() == 0) continue;
                    SJmoExdPathGroupInfo pathGrp = this.pathGrpInfo.get(errCnt);
                    SJctrErrorColumnData oneErrorColumn = new SJctrErrorColumnData(pathGrp, oneError);
                    errColumnList.add(oneErrorColumn);
                    tableKeyList.add(pathGrp);
                }
                SJctrError errInfo = ((SJctrErrorColumnData)errColumnList.get(0)).getError();
                SJctrPathGroupErrorTableModel errTable = new SJctrPathGroupErrorTableModel();
                errTable.setDataController(this);
                errTable.initGuidance(this.getComUtility());
                errTable.createModelDirect();
                errTable.divideModelData(this.getProxy().getModelDataMap());
                errTable.setBasicDataList(tableKeyList);
                errTable.makeDataModel();
                SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
                SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
                errDc.setParameter(errTable, errColumnList);
                SJcException exp = errInfo.createException();
                exp.setErrDisp(rel);
                throw exp;
            }
        } else {
            this.availableTableKeyList = pathGrpMgr.getPathGroupList();
        }
        this.changePathGroupRagio();
        return true;
    }

    public void setDiscoveryData() {
        boolean ret = true;
        SJctrSelectedDataModel rollback = (SJctrSelectedDataModel)this.getDataObjectModel(KEY_SELECTROLLBACK);
        List<?> cacheData = this.getCache("COM_DISCOVERY_DEVICE");
        if (!rollback.isSelect() && cacheData != null) {
            this.nextEvent(this.discoveryEvent, this.discoveryDstModel);
            return;
        }
        SJctrPathGroupSelectDataModel pathGrpSelect = (SJctrPathGroupSelectDataModel)this.getDataObjectModel(KEY_EXTPATHGPINF);
        String select = pathGrpSelect.getSelect();
        SJctrExtPathGrpsTableModel table = (SJctrExtPathGrpsTableModel)this.getDataObjectModel(KEY_TABLE);
        this.selectRows = table.getSelectedRowData();
        if (select.equals("COM_BY_NEW")) {
            SJctrTextBoxDataModel pathGrptextbox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_EXTPATHGPID);
            List<?> list = this.getCache("COM_NEW_PATHGRP");
            if (list == null) {
                SJctrError err = new SJctrError(6, 22, 105237);
                SJcException exp = err.createException();
                throw exp;
            }
            this.carryPathGrp = (SJmoExdPathGroupInfo)list.get(0);
        } else {
            if (this.selectRows == null || this.selectRows.size() != 1) {
                SJctrError err = new SJctrError(6, 22, 105235);
                SJcException exp = err.createException();
                throw exp;
            }
            this.carryPathGrp = (SJmoExdPathGroupInfo)this.selectRows.get(0);
        }
        this.portWwnList = this.getPortwwnList(this.carryPathGrp);
        SJctrRelatedDispDataObject astbcRelated = this.createAsyncGet(this);
        this.addUpdateDisp(astbcRelated);
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        footer.setRollBackCheck(SJctrFooterDataModel.Button.NEXT, true);
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("UVM", GUID_TITLE);
    }

    private void initDataModel() {
        SJctrPathGroupSelectDataModel radio = new SJctrPathGroupSelectDataModel();
        this.addDataObjectModel(KEY_EXTPATHGPINF, radio);
        SJctrTextBoxDataModel pathGrptextbox = new SJctrTextBoxDataModel(){

            @Override
            public void makeDataModel() {
                super.makeDataModel();
                this.setFixed(true);
                this.setValue(this.getComUtility().getGuidance("UVM", SJctrExtPathGrpsDC.GUID_SEL_CREATE_EXTPATHGRP));
                this.setValueDefault(true);
            }
        };
        this.addDataObjectModel(KEY_EXTPATHGPID, pathGrptextbox);
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_CREATE_EXTPATHGRP, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrExtPathGrpsDC.this.makeCreateExtPathGrp();
            }
        });
        SJctrExtPathGrpsTableModel table = new SJctrExtPathGrpsTableModel();
        this.addDataObjectModel(KEY_TABLE, table);
        SJctrSelectedDataModel selectRollback = new SJctrSelectedDataModel();
        this.addDataObjectModel(KEY_SELECTROLLBACK, selectRollback);
        this.addDataObjectModel(KEY_EXTPATHNUM, new SJctrTextBoxDataModel());
        SJctrFooterDataModel footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footer);
    }

    public List<SJmoExdPathGroupInfo> getAvailableTableData() {
        ArrayList<SJmoExdPathGroupInfo> retList = new ArrayList<SJmoExdPathGroupInfo>(this.availableTableKeyList.size());
        for (SJmoExdPathGroupInfo pathGrp : this.availableTableKeyList) {
            if (!this.isUsablePathGroupRSG(pathGrp) || !this.policyData.isInternalUsage() && pathGrp.getRmiExdPathGroupInfo().referSubsystemID() == 0) continue;
            retList.add(pathGrp);
        }
        return retList;
    }

    private void changePathGroupRagio() {
        String selectKey = "COM_BY_NEW";
        if (this.subsystemInfo != null || this.pathGrpInfo != null) {
            SJctrDataController parentDC = this.getWizardWindow().getParentDC();
            SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
            if (parentDC instanceof SJctrExsPathGrpMappedVolsDC || parentTbl.getSelectedRowCount() != 0) {
                selectKey = "COM_BY_EXIST";
            }
        }
        SJctrRadioButtonGroupDataModel radio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_EXTPATHGPINF);
        radio.setSelect(selectKey);
    }

    private void initListener() {
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrExtPathGrpsDC.this.construct();
                Object notifyObj = event.getNofifyObject();
                if (notifyObj instanceof Map) {
                    Map map = (Map)notifyObj;
                    SJctrExtPathGrpsDC.this.exitCreatePathGrpAction(map);
                }
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.NEXT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrExtPathGrpsDC.this.discoveryEvent = event;
                SJctrExtPathGrpsDC.this.discoveryDstModel = dstModel;
                SJctrSimpleDataModel rootModel = SJctrExtPathGrpsDC.this.getRootDataModel();
                SJctrWizardDataController nextDc = SJctrExtPathGrpsDC.this.getWizardWindow().getNextIndexWizardDataController();
                if (nextDc == null) {
                    SJctrExtPathGrpsDC.this.getLogUty().putlog("doMessageAction", "nextDc is null");
                    return;
                }
                if (!nextDc.isConstruct() || rootModel.isChange()) {
                    SJctrExtPathGrpsDC.this.setDiscoveryFlg = false;
                }
                if (!SJctrExtPathGrpsDC.this.setDiscoveryFlg) {
                    try {
                        SJctrExtPathGrpsDC.this.setDiscoveryData();
                        SJctrExtPathGrpsDC.this.setDiscoveryFlg = true;
                    }
                    catch (SJcException e) {
                        SJctrExtPathGrpsDC.this.setDiscoveryFlg = false;
                        throw e;
                    }
                } else {
                    SJctrExtPathGrpsDC.this.nextEvent(SJctrExtPathGrpsDC.this.discoveryEvent, SJctrExtPathGrpsDC.this.discoveryDstModel);
                }
            }
        });
    }

    private void makeCreateExtPathGrp() {
        this.clearAllRsvData();
        HashMap map = new HashMap();
        List<SJmoExdPathGroupInfo> pathGrplist = this.getCache("COM_NEW_PATHGRP");
        if (pathGrplist != null) {
            ArrayList<SJctrCreatePathGrpData> list = new ArrayList<SJctrCreatePathGrpData>(1);
            SJctrCreatePathGrpData createPathGrpData = new SJctrCreatePathGrpData();
            createPathGrpData.setPathGroupInfo(pathGrplist);
            list.add(createPathGrpData);
            map.put(KEY_CREATED_PATHPROUP, list);
        }
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrCreateExtPathGrpDialogDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void exitCreatePathGrpAction(Map<String, List<?>> carryMap) {
        List<?> getList = carryMap.get(KEY_NEW_PATHPROUPDATA);
        if (getList == null || getList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrCreatePathGrpData newPathGrpData = (SJctrCreatePathGrpData)getList.get(0);
        SJmoExdPathGroupInfo newPathGrp = newPathGrpData.getPathGroupInfo().get(0);
        int pathGroupID = newPathGrp.getRmiExdPathGroupInfo().getPathGroupID();
        String strPathGrpId = SJctrComUtility.toDecString(pathGroupID);
        SJctrTextBoxDataModel pathGrptextbox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_EXTPATHGPID);
        pathGrptextbox.setValue(strPathGrpId);
        pathGrptextbox.setValueDefault(false);
        SJctrTextBoxDataModel pathNumtxtbox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_EXTPATHNUM);
        SJctrExtUtility extUtil = this.getComUtility().getExtUtility();
        int pathNum = extUtil.getExternalPathNum(newPathGrp);
        pathNumtxtbox.setValue(SJctrComUtility.toDecString(pathNum));
        this.putCache("COM_NEW_PATHGRP", newPathGrpData.getPathGroupInfo());
        Map<String, List<?>> cacheMap = this.getProxy().getCacheMap();
        cacheMap.remove("COM_TARGET_PATHGRP");
        cacheMap.remove("COM_DISCOVERY_DEVICE");
        cacheMap.remove("COM_DISCOVERY_RESULT");
    }

    @Override
    public void construct() throws SJcException {
        if (this.policyData == null) {
            this.policyData = new SJctrExdPolicyData(this.getOwner());
        }
        super.construct();
        if (this.selectRows != null) {
            SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
            table.addRowSelectionList(this.selectRows);
        }
    }

    private boolean isSamePathGroup(SJmoExdPathGroupInfo pathGrp1, SJmoExdPathGroupInfo pathGrp2) {
        int pathGrpId2;
        int pathGrpId1 = pathGrp1.getRmiExdPathGroupInfo().getPathGroupID();
        if (pathGrpId1 != (pathGrpId2 = pathGrp2.getRmiExdPathGroupInfo().getPathGroupID())) {
            return false;
        }
        int pathNum = 8;
        int[] pathList1 = pathGrp1.getRmiExdPathGroupInfo().referAllPhysicalPathList();
        int[] pathList2 = pathGrp2.getRmiExdPathGroupInfo().referAllPhysicalPathList();
        for (int index = 0; index < pathNum; ++index) {
            if (pathList1[index] == pathList2[index]) continue;
            return false;
        }
        return true;
    }

    private List<PortWwnInfo> getPortwwnList(SJmoExdPathGroupInfo pathGrp) {
        int physicalPathId;
        ArrayList<PortWwnInfo> portWwnList = new ArrayList<PortWwnInfo>(8);
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        SJctrTargetPortManager targetPortMgr = this.getManager(SJctrTargetPortManager.class);
        int[] physicalPathList = pathGrp.getRmiExdPathGroupInfo().referAllPhysicalPathList();
        for (int index = 0; index < physicalPathList.length && (physicalPathId = physicalPathList[index]) != -1; ++index) {
            SJmoExdPhysicalPathInfo physicalPath = physicalPathMgr.getPhysicalPathInfo(physicalPathId);
            if (physicalPath == null) {
                SJctrError err = new SJctrError(6, 22, 107018);
                SJcException exp = err.createException();
                throw exp;
            }
            int wwnId = physicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
            SJmoExdTargetPortInfo targetPortInfo = targetPortMgr.getTargetPortInfo(wwnId);
            if (targetPortInfo == null) {
                SJctrError err = new SJctrError(6, 22, 107018);
                SJcException exp = err.createException();
                throw exp;
            }
            int initiatorPortID = physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId();
            String wwn = targetPortInfo.getRmiExdTargetPortInfo().getDispTargetPortAddress();
            PortWwnInfo portwwn = new PortWwnInfo(initiatorPortID, wwn);
            portWwnList.add(portwwn);
        }
        return portWwnList;
    }

    private void setDiscoveryDeviceData(List<PortWwnInfo> portWwnList, SJmoExdPathGroupInfo selectPathGrp, EXDgetDiscoveryDevice_OUT output) {
        ArrayList<SJctrAddVolumeInfo> extVolInfos = new ArrayList<SJctrAddVolumeInfo>(4096);
        SJctrAuthorizeContainer authorizeContainer = this.getOwner().getAuthorizeContainer();
        SJctrLicenseContainer ppcontainer = authorizeContainer.getLisenceContainer();
        boolean uvmPP = ppcontainer.checkPP(SJctrLicenseContainer.PPID_UVM);
        byte pathMode = selectPathGrp.getRmiExdPathGroupInfo().getPathMode();
        int[] physicalPathIdList = selectPathGrp.getRmiExdPathGroupInfo().referAllPhysicalPathList();
        SJctrSubsytemManager subsystemMgr = this.getManager(SJctrSubsytemManager.class);
        SJmoExdSubsystemInfo subsystemInfo = subsystemMgr.getSubsystemInfo(selectPathGrp.getRmiExdPathGroupInfo().referSubsystemID());
        int profileId = subsystemInfo.getRmiExdSubsystemInfo().referProfileId();
        int pathIndex = 0;
        HashMap<String, SJctrDiscoveryResultInfo> errorMap = new HashMap<String, SJctrDiscoveryResultInfo>(4096);
        for (PortWwnInfo portWwnInfo : portWwnList) {
            EXDDiscoveryDevice[] eXDDiscoveryDeviceArray = output.getDiscoveryDevice((short)portWwnInfo.getPortId(), portWwnInfo.getWwn());
            for (int devIndex = 0; devIndex < eXDDiscoveryDeviceArray.length; ++devIndex) {
                SJctrDiscoveryResultInfo result;
                SJctrError error;
                EXDDiscoveryDevice discoveryDevice = eXDDiscoveryDeviceArray[devIndex];
                EXDExternalDeviceEx rmiExDevice = (EXDExternalDeviceEx)discoveryDevice.getExternalDevice();
                if (rmiExDevice.isConfigured()) continue;
                SJctrAddVolumeInfo extVolume = this.getSameVolume(rmiExDevice, extVolInfos);
                if (extVolume == null) {
                    EXDExternalVolumeEx rmiExdVolume = new EXDExternalVolumeEx(rmiExDevice);
                    rmiExdVolume.setPathMode(pathMode);
                    rmiExdVolume.setPathGroupID(selectPathGrp.getRmiExdPathGroupInfo().getPathGroupID());
                    extVolume = new SJctrAddVolumeInfo(rmiExdVolume);
                    extVolInfos.add(extVolume);
                }
                String identity2 = rmiExDevice.getIdentity2();
                if (!(uvmPP || rmiExDevice.isCommandDevice() || errorMap.containsKey(identity2))) {
                    error = new SJctrError(6, 22, 105204);
                    result = new SJctrDiscoveryResultInfo(identity2, error);
                    errorMap.put(identity2, result);
                }
                if (!rmiExDevice.isSupport() && !errorMap.containsKey(identity2)) {
                    error = new SJctrError(6, 22, 105251);
                    result = new SJctrDiscoveryResultInfo(identity2, error);
                    errorMap.put(identity2, result);
                }
                if (profileId == 10 && !errorMap.containsKey(identity2)) {
                    error = new SJctrError(6, 22, 105251);
                    result = new SJctrDiscoveryResultInfo(identity2, error);
                    errorMap.put(identity2, result);
                }
                EXDLogicalPath[] rmiLPathList = extVolume.getRmiExdVolumeInfo().getLogicalPathList();
                rmiLPathList[pathIndex] = discoveryDevice.getLogicalPath();
                rmiLPathList[pathIndex].setPriority((byte)pathIndex);
                rmiLPathList[pathIndex].setPhysicalpathID(physicalPathIdList[pathIndex]);
            }
            ++pathIndex;
        }
        int pathCount = portWwnList.size();
        for (SJmoExdVolumeInfo sJmoExdVolumeInfo : extVolInfos) {
            String identity2;
            EXDLogicalPath[] logicalPathList = sJmoExdVolumeInfo.getRmiExdVolumeInfo().getLogicalPathList();
            int logicalPathCount = 0;
            for (int iLogicalPath = 0; iLogicalPath < logicalPathList.length; ++iLogicalPath) {
                if (logicalPathList[iLogicalPath] == null) continue;
                ++logicalPathCount;
            }
            if (pathCount == logicalPathCount || errorMap.containsKey(identity2 = sJmoExdVolumeInfo.getRmiExdVolumeInfo().getExternalDeviceInfo().getIdentity2())) continue;
            SJctrError error = new SJctrError(6, 22, 105244);
            SJctrDiscoveryResultInfo result = new SJctrDiscoveryResultInfo(identity2, error);
            errorMap.put(identity2, result);
        }
        if (extVolInfos.size() == 0) {
            SJctrError err = new SJctrError(6, 22, 105241);
            SJcException sJcException = err.createException();
            throw sJcException;
        }
        ArrayList<SJmoExdPathGroupInfo> pathGrpList = new ArrayList<SJmoExdPathGroupInfo>();
        pathGrpList.add(selectPathGrp);
        this.putCache("COM_TARGET_PATHGRP", pathGrpList);
        this.putCache("COM_DISCOVERY_DEVICE", extVolInfos);
        ArrayList<SJctrDiscoveryResultInfo> arrayList = new ArrayList<SJctrDiscoveryResultInfo>(errorMap.size());
        for (SJctrDiscoveryResultInfo result : errorMap.values()) {
            arrayList.add(result);
        }
        Collections.sort(arrayList);
        if (arrayList.size() != 0) {
            String strFunc = String.valueOf(6);
            String strModule = String.valueOf(22);
            String strMsg = String.valueOf(109016);
            SJcMessage msg = new SJcMessage(strFunc, strModule, strMsg);
            SJctrRelatedDispDataObject relatedObj = this.createMsgDialog(msg);
            SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(relatedObj);
            msgDC.addButton(SJctrMessageDataController.MD_CLOSE);
            this.addUpdateDisp(relatedObj);
        }
        this.putCache("COM_DISCOVERY_RESULT", arrayList);
    }

    SJctrAddVolumeInfo getSameVolume(EXDExternalDevice device, List<SJctrAddVolumeInfo> extVolInfos) {
        SJctrAddVolumeInfo ret = null;
        for (int volCnt = 0; volCnt < extVolInfos.size(); ++volCnt) {
            SJctrAddVolumeInfo extVolumeData = extVolInfos.get(volCnt);
            String characteristic2 = extVolumeData.getRmiExdVolumeInfo().getExternalDeviceInfo().getIdentity2();
            if (!characteristic2.equals(device.getIdentity2())) continue;
            ret = extVolumeData;
            break;
        }
        return ret;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRscUtilExdPathGrp();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRscUtilLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRscUtilSsid();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRscUtilPg();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initManager() {
        this.addManager(SJctrPathGroupManager.class);
        this.addManager(SJctrSubsytemManager.class);
        this.addManager(SJctrPhysicalPathManager.class);
        this.addManager(SJctrPortManager.class);
        this.addManager(SJctrTargetPortManager.class);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelRequest() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        EXDgetDiscoveryDevice_IN input = new EXDgetDiscoveryDevice_IN();
        for (PortWwnInfo portWwn : this.portWwnList) {
            input.setPhysicalPath((short)portWwn.getPortId(), portWwn.getWwn());
        }
        SJctrGetExdDiscoveryDevice kind = new SJctrGetExdDiscoveryDevice(input);
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.asynWwrapper = new SJctrGetDirectWrapper(direct, false);
        set.add(this.asynWwrapper);
        return set;
    }

    @Override
    public int getTurnAroundTime() {
        return 240;
    }

    @Override
    public void setModelData(Map<SJctrGetDirectWrapper, List<?>> map) {
        List<?> dataList = map.get(this.asynWwrapper);
        EXDgetDiscoveryDevice_OUT ret = null;
        try {
            SJmoThroughRmiData rmiObj = (SJmoThroughRmiData)dataList.get(0);
            ret = (EXDgetDiscoveryDevice_OUT)rmiObj.getObjRmi();
        }
        catch (Exception e) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "EXDgetDiscoveryDevice", "exception", e);
            SJctrError error = new SJctrError(6, 22, 105241);
            SJcException exp = error.createException();
            throw exp;
        }
        SJmoRscUtilLdev ldevRscUtil = (SJmoRscUtilLdev)this.getCache(SJmoGetRscUtilLdev.class.getName()).get(0);
        ldevRscUtil.clearRsvData();
        this.setDiscoveryDeviceData(this.portWwnList, this.carryPathGrp, ret);
        this.nextEvent(this.discoveryEvent, this.discoveryDstModel);
    }

    boolean isUsablePathGroupRSG(SJmoExdPathGroupInfo pathGrpInfo) {
        boolean result = true;
        EXDPathGroup rmiPathGrp = pathGrpInfo.getRmiExdPathGroupInfo();
        int[] pysicalPathIdList = rmiPathGrp.referAllPhysicalPathList();
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        ArrayList<SJmoPortIndex> portList = new ArrayList<SJmoPortIndex>(pysicalPathIdList.length);
        for (int portcnt = 0; portcnt < pysicalPathIdList.length && pysicalPathIdList[portcnt] != -1; ++portcnt) {
            int physicalPathId = pysicalPathIdList[portcnt];
            SJmoExdPhysicalPathInfo phsicalPathInfo = physicalPathMgr.getPhysicalPathInfo(physicalPathId);
            int portId = phsicalPathInfo.getRmiExdPhysicalPathInfo().referInitiatorPortId();
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort((short)portId);
            portList.add(portIndex);
        }
        List<SJmoPortIndex> unUsableList = this.rsgUtil.extractImpossiblePort(portList);
        if (unUsableList.size() != 0) {
            result = false;
        }
        return result;
    }

    private void clearAllRsvData() {
        SJmoRscUtilLdev ldevRscUtil = (SJmoRscUtilLdev)this.getCache(SJctrAddExtVolsSubWizard.KEY_LDEV_UTIL_DATA).get(0);
        SJmoRscUtilExPathGrp pathGrpRscUtil = (SJmoRscUtilExPathGrp)this.getCache(SJctrAddExtVolsSubWizard.KEY_PATHGRP_UTIL_DATA).get(0);
        SJmoRscUtilPg pgRscUtil = (SJmoRscUtilPg)this.getCache(SJctrAddExtVolsSubWizard.KEY_PG_UTIL_DATA).get(0);
        SJmoRscUtilSsid ssidRscUtil = (SJmoRscUtilSsid)this.getCache(SJctrAddExtVolsSubWizard.KEY_SSID_UTIL_DATA).get(0);
        ldevRscUtil.clearRsvData();
        pathGrpRscUtil.clearRsvData();
        pgRscUtil.clearRsvData();
        ssidRscUtil.clearRsvData();
    }

    private class PortWwnInfo {
        private int portId;
        private String wwn;

        public PortWwnInfo(int portId, String wwn) {
            this.portId = portId;
            this.wwn = wwn;
        }

        public int getPortId() {
            return this.portId;
        }

        public String getWwn() {
            return this.wwn;
        }
    }
}

