/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.addextvols;

import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.model.connector.kind.SJmoGetSsidSummary;
import sanproject.sn2.model.data.volume.SJmoSsidSummary;

public class SJctrLdevIdDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_LDKC = "COM_NODE";
    public static final String KEY_CU = "COM_CU";
    public static final String KEY_DEV = "COM_DEV";
    public static final String KEY_INTV = "COM_INTV";
    private static final String KEY_LDEV_BTN = "COM_LDEV_BTN";
    public static final int LDKC_MIN = 0;
    public static final int CU_MIN = 0;
    public static final int CU_MAX = 254;
    public static final int LDEV_MIN = 0;
    public static final int LDEV_MAX = 255;
    public static final int INTV_MIN = 0;
    public static final int INTV_MAX = 255;
    public static final int INVALID = -1;

    public SJctrLdevIdDataModel() {
        this.initDataModel();
    }

    protected void initDataModel() {
        this.addDataModel(KEY_LDKC, new SJctrTextBoxDataModel(){

            @Override
            protected void makeDataObject() {
                this.setValue(SJctrComUtility.toHexString(0, 2, true));
            }
        });
        this.addDataModel(KEY_CU, new SJctrComboBoxDataModel(){

            @Override
            protected void makeDataObject() {
                SJctrWizardDataController dc = (SJctrWizardDataController)this.getDataController();
                List<?> ssidsummaryList = dc.getCache(SJmoGetSsidSummary.class);
                SJmoSsidSummary ssidSummary = (SJmoSsidSummary)ssidsummaryList.get(0);
                int maxCU = ssidSummary.getMaxCUCount();
                for (int cu = 0; cu < maxCU; ++cu) {
                    String strCu = SJctrComUtility.toHexString(cu, 2, true);
                    this.addItem(strCu);
                }
            }
        });
        this.addDataModel(KEY_DEV, new SJctrComboBoxDataModel(){

            @Override
            protected void makeDataObject() {
                for (int ldev = 0; ldev <= 255; ++ldev) {
                    String strLdev = SJctrComUtility.toHexString(ldev, 2, true);
                    this.addItem(strLdev);
                }
            }
        });
        this.addDataModel(KEY_INTV, new SJctrComboBoxDataModel(){

            @Override
            protected void makeDataObject() {
                for (int intv = 0; intv <= 255; ++intv) {
                    String strIntv = SJctrComUtility.toDecString(intv);
                    this.addItem(strIntv);
                }
            }
        });
        SJctrButtonDataModel btn = new SJctrButtonDataModel();
        btn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrLdevIdDataModel.this.fireMessageEvent(LDEVID_MSG.VIEW_LDEVID);
            }
        });
        this.addDataModel(KEY_LDEV_BTN, btn);
    }

    public int getLdkcValue() {
        int ldkc = -1;
        SJctrTextBoxDataModel txtBox = (SJctrTextBoxDataModel)this.getDataModel(KEY_LDKC);
        String input = txtBox.getValue();
        if (input.length() > 0) {
            ldkc = Integer.valueOf(txtBox.getValue());
        }
        return ldkc;
    }

    public int getCuValue() {
        int cu = -1;
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_CU);
        String selection = comboBox.getSelection();
        if (selection != null && selection.length() > 0) {
            cu = Integer.valueOf(comboBox.getSelection(), 16);
        }
        return cu;
    }

    public int getLdevValue() {
        int ldev = -1;
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_DEV);
        String selection = comboBox.getSelection();
        if (selection != null && selection.length() > 0) {
            ldev = Integer.valueOf(comboBox.getSelection(), 16);
        }
        return ldev;
    }

    public int getIntervalValue() {
        int intv = -1;
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_INTV);
        String selection = comboBox.getSelection();
        if (selection != null && selection.length() > 0) {
            intv = Integer.valueOf(comboBox.getSelection());
        }
        return intv;
    }

    public void setLdkcValue(int ldkc) {
        SJctrTextBoxDataModel txtBox = (SJctrTextBoxDataModel)this.getDataModel(KEY_LDKC);
        txtBox.setValue(SJctrComUtility.toHexString(ldkc, 2, true));
    }

    public void setCuValue(int cu) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_CU);
        comboBox.setSelection(SJctrComUtility.toHexString(cu, 2, true));
    }

    public void setLdevValue(int ldev) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_DEV);
        comboBox.setSelection(SJctrComUtility.toHexString(ldev, 2, true));
    }

    public void setIntervalValue(int intv) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_INTV);
        comboBox.setSelection(SJctrComUtility.toDecString(intv));
    }

    public void addCuItem(String cu) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_CU);
        comboBox.addItem(cu);
    }

    public void addLdevItem(String ldev) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_DEV);
        comboBox.addItem(ldev);
    }

    public void removeCuItem(String cu) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_CU);
        comboBox.removeItem(cu);
    }

    public void removeLdevItem(String ldev) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel(KEY_DEV);
        comboBox.removeItem(ldev);
    }

    public static enum LDEVID_MSG implements SJctrNotifyState
    {
        VIEW_LDEVID;

    }
}

