/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.column;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrSsidManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrVpgManager;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrSSIDColumnFromExdVolumeInfo
extends SJctrColumn {
    protected Map<String, Integer> numberMap = null;

    public SJctrSSIDColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId("SSID");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        list.add(SJmoGetExDVirtualPgInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        EXDExternalVolume rmiExdVol;
        ArrayList<Integer> list = new ArrayList<Integer>();
        Integer ssid = null;
        SJmoLdevIndex ldev = null;
        SJmoExdVolumeInfo volumeInfo = (SJmoExdVolumeInfo)index;
        SJctrVpgManager vpgMgr = (SJctrVpgManager)modelData.get(SJctrVpgManager.class).get(0);
        SJmoExDPgInfo pgInfo = vpgMgr.getVpgInfo((rmiExdVol = volumeInfo.getRmiExdVolumeInfo()).getIFB4(), rmiExdVol.getIPG());
        if (pgInfo != null && pgInfo.getSNumOfLdev() != 0) {
            ldev = pgInfo.getStartLdevId();
        }
        if (ldev != null) {
            SJctrSsidManager ssidMgr = (SJctrSsidManager)modelData.get(SJctrSsidManager.class).get(0);
            ssid = ssidMgr.getSsid(ldev);
        }
        list.add(ssid);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        Integer ssid = (Integer)dataList.get(0);
        if (ssid != null) {
            ret = SJctrComUtility.toHexString(ssid, 4, true);
            if (this.numberMap == null) {
                this.numberMap = new HashMap<String, Integer>(this.getTable().getRowCount());
            }
            this.numberMap.put(ret, ssid);
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        String strNum = this.getString(dat);
        if (strNum.length() != 0) {
            num = this.numberMap.get(strNum);
        }
        return num;
    }
}

