/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDPathGroup;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.comparator.SJctrPathGroupInfoComparator;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilExdPathGrp;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.modelrc.util.SJmoRscUtilExPathGrp;

public class SJctrPathGroupManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    private static final String DEFAULT_NICKNAME = "";
    private static final byte DEFAULT_PATHMODE = 0;
    private static final Comparator<Object> PATHGROUP_COMP = new SJctrPathGroupInfoComparator();
    private SJmoExdPathGroupInfoMgr exdPathGroupManager;
    private List<SJmoExdPathGroupInfo> createPathGroupList;
    private SJmoRscUtilExPathGrp rscPathGrpUtil;
    private int newPathGroupId;

    public SJctrPathGroupManager() {
        this.initField();
    }

    private void initField() {
        this.exdPathGroupManager = null;
        this.createPathGroupList = new ArrayList<SJmoExdPathGroupInfo>();
        this.newPathGroupId = 0;
        this.rscPathGrpUtil = null;
    }

    private SJmoExdPathGroupInfoMgr getExdPathGroupManager() {
        return this.exdPathGroupManager;
    }

    public List<SJmoExdPathGroupInfo> getCreatePathGroupList() {
        return this.createPathGroupList;
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetExdPathGroupInfoMgr();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        kind = new SJmoGetRscUtilExdPathGrp();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
        List<?> getList = models.get(SJmoGetExdPathGroupInfoMgr.class.getName());
        if (getList != null && getList.size() > 0) {
            this.exdPathGroupManager = (SJmoExdPathGroupInfoMgr)getList.get(0);
        }
        if ((getList = models.get(SJmoGetRscUtilExdPathGrp.class.getName())) != null && getList.size() > 0) {
            this.rscPathGrpUtil = (SJmoRscUtilExPathGrp)getList.get(0);
        }
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
    }

    public List<SJmoExdPathGroupInfo> getPathGroupList() {
        ArrayList retList = Collections.emptyList();
        SJmoExdPathGroupInfoMgr pathGroupManager = this.getExdPathGroupManager();
        if (pathGroupManager != null) {
            retList = pathGroupManager.getAlExdPathGroupInfo();
        }
        return retList;
    }

    public List<SJmoExdPathGroupInfo> getPathGroupListOfSubsystemId(int subsystemId) {
        ArrayList retList = Collections.emptyList();
        SJmoExdPathGroupInfoMgr pathGroupManager = this.getExdPathGroupManager();
        if (pathGroupManager != null) {
            retList = pathGroupManager.getAlPathGroupInfoOfSubsystemId(subsystemId);
        }
        return retList;
    }

    public SJmoExdPathGroupInfo getPathGroupInfo(int pathGroupId) {
        SJmoExdPathGroupInfo retInfo = null;
        SJmoExdPathGroupInfoMgr pathGroupManager = this.getExdPathGroupManager();
        if (pathGroupManager != null) {
            retInfo = pathGroupManager.getExdPathGroupInfo(pathGroupId);
        }
        if (retInfo == null) {
            retInfo = this.getCreatePathGroupInfo(pathGroupId);
        }
        return retInfo;
    }

    private SJmoExdPathGroupInfo getCreatePathGroupInfo(int pathGroupId) {
        SJmoExdPathGroupInfo retInfo = null;
        List<SJmoExdPathGroupInfo> list = this.getCreatePathGroupList();
        int index = Collections.binarySearch(list, pathGroupId, PATHGROUP_COMP);
        if (index >= 0) {
            retInfo = list.get(index);
        }
        return retInfo;
    }

    public int getNewPathGroupId() {
        int pathGroupId = this.getNewPathGroupId(this.newPathGroupId);
        return pathGroupId;
    }

    public int getNewPathGroupId(int startId) {
        int newId;
        for (newId = startId; newId <= SJctrExtUtility.PATHGROUPID_MAX && !this.checkPathGroupId(newId); ++newId) {
        }
        if (newId > SJctrExtUtility.PATHGROUPID_MAX) {
            newId = -1;
        }
        return newId;
    }

    public SJmoExdPathGroupInfo createPathGroupInfo(int subsystemId) {
        int pathGroupId = this.getNewPathGroupId();
        return this.createPathGroupInfo(subsystemId, pathGroupId);
    }

    public SJmoExdPathGroupInfo createPathGroupInfo(int subsystemId, int pathGroupId) {
        if (!this.checkPathGroupId(pathGroupId)) {
            return null;
        }
        int newId = this.getNewPathGroupId(pathGroupId);
        if (newId == this.getNewPathGroupId()) {
            this.newPathGroupId = newId + 1;
        }
        EXDPathGroup rmiPathGroup = new EXDPathGroup(newId, DEFAULT_NICKNAME, subsystemId, 0);
        SJmoExdPathGroupInfo newPathGroup = new SJmoExdPathGroupInfo(rmiPathGroup);
        this.setResource(newPathGroup);
        this.addCreatePathGroupInfo(newPathGroup);
        return newPathGroup;
    }

    public SJmoExdPathGroupInfo createPathGroupInfo(SJmoExdPathGroupInfo pathGroup) {
        int pathGroupId = pathGroup.getRmiExdPathGroupInfo().getPathGroupID();
        if (!this.checkPathGroupId(pathGroupId)) {
            return null;
        }
        if (pathGroupId == this.getNewPathGroupId()) {
            this.newPathGroupId = pathGroupId + 1;
        }
        this.addCreatePathGroupInfo(pathGroup);
        return pathGroup;
    }

    private void addCreatePathGroupInfo(SJmoExdPathGroupInfo pathGroup) {
        int index = Collections.binarySearch(this.createPathGroupList, pathGroup, PATHGROUP_COMP);
        int insertIndex = index < 0 ? -(index + 1) : index;
        this.createPathGroupList.add(insertIndex, pathGroup);
    }

    public boolean checkPathGroupId(int id) {
        if (id < 0 || SJctrExtUtility.PATHGROUPID_MAX < id) {
            return false;
        }
        List<SJmoExdPathGroupInfo> modelList = this.getPathGroupList();
        int index = Collections.binarySearch(modelList, id, PATHGROUP_COMP);
        if (index >= 0) {
            return false;
        }
        modelList = this.getCreatePathGroupList();
        index = Collections.binarySearch(modelList, id, PATHGROUP_COMP);
        if (index >= 0) {
            return false;
        }
        return this.rscPathGrpUtil.chkExPathGrpID(id) == 0;
    }

    public int removePathGroupInfo(SJmoExdPathGroupInfo pathGroup) {
        int index = Collections.binarySearch(this.createPathGroupList, pathGroup, PATHGROUP_COMP);
        if (index >= 0) {
            this.createPathGroupList.remove(index);
            this.setResource(pathGroup);
            int removeId = pathGroup.getRmiExdPathGroupInfo().getPathGroupID();
            if (this.newPathGroupId > removeId) {
                this.newPathGroupId = removeId;
            }
        }
        return index;
    }

    private void setResource(SJmoExdPathGroupInfo pathGroup) {
    }
}

