/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.editextvols;

import java.util.Set;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;

public class SJctrUseAluaDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_CHECKBOX = "COM_CHECKBOX";
    public static final String KEY_ALUAINF_RDO = "COM_ALUAINF_RDO";
    public static final String KEY_ENABLE = "COM_ENABLE";
    public static final String KEY_DISABLE = "COM_DISABLE";
    private SJctrCheckBoxDataModel checkBox = null;
    private SJctrRadioButtonGroupDataModel radio = null;

    public SJctrUseAluaDataModel() {
        this.initDataModel();
        this.initListener();
    }

    protected void initDataModel() {
        this.checkBox = new SJctrCheckBoxDataModel();
        this.addDataModel(KEY_CHECKBOX, this.checkBox);
        this.radio = new SJctrRadioButtonGroupDataModel();
        this.radio.add(KEY_ENABLE);
        this.radio.add(KEY_DISABLE);
        this.addDataModel(KEY_ALUAINF_RDO, this.radio);
    }

    public void initALUAMode(Set<Boolean> mixALUAMode) {
        if (mixALUAMode.size() == 1) {
            Boolean[] aluaModeArray = mixALUAMode.toArray(new Boolean[0]);
            boolean aluaset = aluaModeArray[0];
            if (aluaset) {
                this.radio.setSelect(KEY_ENABLE);
            } else {
                this.radio.setSelect(KEY_DISABLE);
            }
        }
    }

    private void initListener() {
        this.checkBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                boolean chk = SJctrUseAluaDataModel.this.checkBox.isSelect();
                SJctrUseAluaDataModel.this.radio.setChangeCheck(chk);
            }
        });
        this.radio.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                boolean chk = SJctrUseAluaDataModel.this.checkBox.isSelect();
                SJctrUseAluaDataModel.this.radio.setChangeCheck(chk);
            }
        });
    }

    public boolean isSelectEnable() {
        boolean ret = false;
        String select = this.radio.getSelect();
        if (select != null) {
            ret = select.equals(KEY_ENABLE);
        }
        return ret;
    }

    public boolean isSelectDisable() {
        boolean ret = false;
        String select = this.radio.getSelect();
        if (select != null) {
            ret = select.equals(KEY_DISABLE);
        }
        return ret;
    }

    public boolean isSelectCheckBox() {
        SJctrCheckBoxDataModel checkBox = (SJctrCheckBoxDataModel)this.getDataModel(KEY_CHECKBOX);
        return checkBox.isSelect();
    }
}

