/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.editextwwns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.EXDTargetPort_Fiber;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrEditExtWwnsConfirmData;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrEditExtWwnsDC;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrEditExtiSCSITargetConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;

public class SJctrEditExtiSCSITargetDC
extends SJctrEditExtWwnsDC {
    private static final int DISP_ID = 17834065;
    public static int EDITEXTWWNS_PTTYPE_IFIBRE = 205151;
    private final String TITLE = "EDIT_EXT_ISCSI_TARGETS";
    private List<SJmoPortIscsiTargetPathInfo> ptItPathList = Collections.emptyList();

    public SJctrEditExtiSCSITargetDC() {
        super(17834065);
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("COMMON", "EDIT_EXT_ISCSI_TARGETS");
    }

    @Override
    public boolean checkConstructData() {
        super.checkConstructData();
        this.ptItPathList = this.getCache(SJmoGetPortIscsiTargetPathInfo.class);
        if (this.ptItPathList == null) {
            SJctrError err = new SJctrError(6, 22, EDITEXTWWNS_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    protected int checkPortType(SJmoPortDetail portDtl) {
        int errorCode = RESULT_NORMAL;
        if (!SJctrPortUtility.isIscsiPort(portDtl)) {
            errorCode = EDITEXTWWNS_PTTYPE_IFIBRE;
        }
        return errorCode;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        if (!(this.qdepthModeDataModel.isSelectCheckBox() || this.iotovDataModel.isSelectCheckBox() || this.pathBlkWatchDataModel.isSelectCheckBox())) {
            ret = false;
            return ret;
        }
        SJmoExdTargetPortInfoMgr exdTargetPortMgr = (SJmoExdTargetPortInfoMgr)this.exdTargetPortMgrList.get(0);
        ArrayList<SJmoExdTargetPortInfo> createTargetPortList = new ArrayList<SJmoExdTargetPortInfo>();
        HashSet<Integer> portSet = new HashSet<Integer>(this.exdPhysicalPathList.size());
        SJmoPortIndex searchPort = new SJmoPortIndex();
        ArrayList<SJmoPortIscsiTargetPathInfo> confirmPtItPathList = new ArrayList<SJmoPortIscsiTargetPathInfo>(this.exdPhysicalPathList.size());
        for (Object selectData : this.exdPhysicalPathList) {
            SJmoExdPhysicalPathInfo physicalPath = (SJmoExdPhysicalPathInfo)selectData;
            int wwnId = physicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
            SJmoExdTargetPortInfo targetPort = exdTargetPortMgr.getExdTargetPortInfo(wwnId);
            int portId = physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId();
            if (portSet.add(portId)) {
                searchPort.setSPort((short)portId);
                int index = Collections.binarySearch(this.ptItPathList, searchPort);
                if (index >= 0) {
                    SJmoPortIscsiTargetPathInfo ptItPathInfo = this.ptItPathList.get(index);
                    confirmPtItPathList.add(ptItPathInfo);
                }
            }
            SJmoExdTargetPortInfo createTargetPort = null;
            try {
                createTargetPort = (SJmoExdTargetPortInfo)targetPort.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("selectPhysicalPath", "TargetPortInfo clone fail", e, 40000);
                continue;
            }
            EXDTargetPort_Fiber updatePort = (EXDTargetPort_Fiber)createTargetPort.getRmiExdTargetPortInfo();
            if (this.qdepthModeDataModel.isSelectCheckBox()) {
                updatePort.setQdepth(this.qdepthModeDataModel.getQepth());
            }
            if (this.iotovDataModel.isSelectCheckBox()) {
                updatePort.setIoTov(this.iotovDataModel.getIoTov());
            }
            if (this.pathBlkWatchDataModel.isSelectCheckBox()) {
                updatePort.setPathWatch(this.pathBlkWatchDataModel.getPathBlkWatch());
            }
            createTargetPortList.add(createTargetPort);
        }
        Collections.sort(confirmPtItPathList);
        SJmoExdTargetPortInfoMgr createTargetPortMgr = new SJmoExdTargetPortInfoMgr(createTargetPortList);
        ArrayList<SJmoExdTargetPortInfoMgr> createTargetPortMgrList = new ArrayList<SJmoExdTargetPortInfoMgr>();
        createTargetPortMgrList.add(createTargetPortMgr);
        SJctrEditExtiSCSITargetConfirmData confirmData = new SJctrEditExtiSCSITargetConfirmData();
        confirmData.setExdPhysicalPathInfo(this.exdPhysicalPathList);
        confirmData.setExdTargetPortInfoMgr(createTargetPortMgrList);
        confirmData.setPortDetail(this.portDetailList);
        confirmData.setPortiscsiTargetPathList(confirmPtItPathList);
        ArrayList<SJctrEditExtiSCSITargetConfirmData> confirmDataList = new ArrayList<SJctrEditExtiSCSITargetConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrEditExtWwnsConfirmData.class, confirmDataList);
        return ret;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetPortIscsiTargetPathInfo kind = new SJmoGetPortIscsiTargetPathInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

