/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;

public class SJctrClprTotalCacheArea
extends SJctrSimpleDataModel {
    public static final String KEY_CACHESIZE_CMB = "COM_CACHESIZE_CMB";
    public static final String KEY_MIN = "COM_MIN";
    public static final String KEY_MAX = "COM_MAX";
    private SJctrItemSelectListener itemSelectListener = null;
    private SJctrComUtility comUtil = null;
    protected SJctrComboBoxDataModel clprTotalCacheComboBox = new SJctrComboBoxDataModel();
    List<String> strValueList = null;
    int iValueMax = 0;

    public SJctrClprTotalCacheArea() {
        this.addDataModel(KEY_CACHESIZE_CMB, this.clprTotalCacheComboBox);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.comUtil = util;
    }

    public void initClprTotalCacheArea(int iCacheSizeMax, int iCacheSizeMin) {
        if (iCacheSizeMax < iCacheSizeMin || iCacheSizeMax % SJctrVpmUtility.CLPR_CACHE_DIV_UNIT != 0 || iCacheSizeMin < SJctrVpmUtility.CLPR_CACHE_MIN || iCacheSizeMin % SJctrVpmUtility.CLPR_CACHE_DIV_UNIT != 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "initComboBox", "Illegal Prm. iCacheSizeMax:" + iCacheSizeMax + ",iCacheSizeMin:" + iCacheSizeMin);
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        this.setActivityArea(true);
        this.clprTotalCacheComboBox.removeAllItems();
        this.strValueList = new ArrayList<String>();
        for (int iValue = iCacheSizeMin; iCacheSizeMax >= iValue; iValue += SJctrVpmUtility.CLPR_CACHE_DIV_UNIT) {
            this.strValueList.add(Integer.toString(iValue / 1024));
        }
        for (String strItem : this.strValueList) {
            this.clprTotalCacheComboBox.addItem(strItem);
        }
        this.iValueMax = this.strValueList.size();
        this.clprTotalCacheComboBox.setSelectedIndex(0);
        Object mngData = this.getManageData();
        ((SJctrDataObject)mngData).setData(KEY_MIN, this.strValueList.get(0));
        ((SJctrDataObject)mngData).setData(KEY_MAX, this.strValueList.get(this.strValueList.size() - 1));
    }

    public void updateClprTotalCacheArea(int iCacheSizeMax) {
        this.clprTotalCacheComboBox.clearSelection();
        this.clprTotalCacheComboBox.removeAllItems();
        List<Object> dataList = Collections.emptyList();
        int iCacheMaxIndex = this.getCacheSizeIndex(iCacheSizeMax);
        Object mngData = this.getManageData();
        if (0 <= iCacheMaxIndex && iCacheMaxIndex <= this.iValueMax) {
            dataList = this.strValueList.subList(0, iCacheMaxIndex + 1);
            ((SJctrDataObject)mngData).setData(KEY_MIN, dataList.get(0));
            ((SJctrDataObject)mngData).setData(KEY_MAX, dataList.get(dataList.size() - 1));
        } else {
            dataList = new ArrayList();
            dataList.add("");
            ((SJctrDataObject)mngData).setData(KEY_MIN, "0");
            ((SJctrDataObject)mngData).setData(KEY_MAX, "0");
        }
        for (String string : dataList) {
            this.clprTotalCacheComboBox.addItem(string);
        }
        this.clprTotalCacheComboBox.setSelectedIndex(0);
    }

    private int getCacheSizeIndex(int iCacheSize) {
        int iRet = iCacheSize - SJctrVpmUtility.CLPR_CACHE_MIN;
        if (iCacheSize >= SJctrVpmUtility.CLPR_CACHE_MIN) {
            iRet /= SJctrVpmUtility.CLPR_CACHE_DIV_UNIT;
        }
        return iRet;
    }

    public void setActivityArea(boolean bActivity) {
        this.clprTotalCacheComboBox.setEnable(bActivity);
    }

    public void setSelection(String strSelect) {
        this.clprTotalCacheComboBox.setSelection(strSelect);
    }

    public int getSelectCapa() {
        String selection = this.clprTotalCacheComboBox.getSelection();
        int ret = -1;
        try {
            ret = Integer.valueOf(selection);
            ret *= 1024;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public void initListener() {
        if (this.itemSelectListener == null) {
            this.itemSelectListener = new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    if (event.isSelect()) {
                        SJctrClprTotalCacheArea.this.fireMessageEvent(TOTALCAPA_MSG.CHG_CAPA);
                    }
                }
            };
            this.clprTotalCacheComboBox.addItemSelectListener(this.itemSelectListener);
        }
    }

    public static enum TOTALCAPA_MSG implements SJctrNotifyState
    {
        CHG_CAPA;

    }
}

