/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.migrateclprresources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.vpm.comdialog.clprproperty.SJctrClprPropertyDialogDC;
import sanproject.sn2.controller.wizard.vpm.migrateclprresources.SJctrMigrateClprConfirmTableModel;
import sanproject.sn2.model.data.system.SJmoClprInfo;

public class SJctrMigrateClprConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 17831551;
    private SJctrMigrateClprConfirmTableModel confirmTbl = null;

    public SJctrMigrateClprConfirmDC() throws SJcException {
        super(17831551);
        this.initDataModel();
    }

    private void initDataModel() {
        this.confirmTbl = new SJctrMigrateClprConfirmTableModel();
        this.addDataObjectModel("COM_TABLE", this.confirmTbl);
        SJctrButtonDataModel detailBtn = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_DETAIL", detailBtn);
        detailBtn.setRollBackCheck(true);
        detailBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrMigrateClprConfirmDC.this.detailAction();
            }
        });
    }

    @Override
    public void makeDataModel() {
        List<SJmoClprInfo> defClprList = this.getCache("KEY_GET_SELECTED_CLPRINFO_ALL");
        this.confirmTbl.setTableKeyList(defClprList);
        this.confirmTbl.setBasicData(SJctrVpmUtility.KEY_CLASS_PG_DETAIL, this.getCache(SJctrVpmUtility.KEY_CLASS_PG_DETAIL));
        this.confirmTbl.setBasicData(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL, this.getCache(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL));
        this.confirmTbl.setBasicData(SJctrVpmUtility.KEY_CLASS_ALL_RSG, this.getCache(SJctrVpmUtility.KEY_CLASS_ALL_RSG));
    }

    public void detailAction() {
        SJctrTableDataModel clprTable = (SJctrTableDataModel)this.getDataObjectModel("COM_TABLE");
        if (clprTable.getSelectedRowCount() != 1) {
            SJctrLogUty.warn("SJctrMigrateClprConfirmDC", "detailAction", "Invalid value for Table:" + clprTable.getSelectedRowCount());
            SJctrVpmUtility.makeErrorDialog(105002);
        }
        List<Object> basicDataList = clprTable.getSelectedRowDataOrder();
        HashMap transDataMap = new HashMap();
        List<?> baseClprInfoList = this.getCache("KEY_GET_BASE_CLPRINFO");
        ArrayList clprInfoList = new ArrayList(this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO));
        ArrayList pgDtlList = new ArrayList(this.getCache(SJctrVpmUtility.KEY_CLASS_PG_DETAIL));
        ArrayList LdevDtlList = new ArrayList(this.getCache(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL));
        Collections.sort(clprInfoList);
        Collections.sort(pgDtlList);
        Collections.sort(LdevDtlList);
        int iSearch = Collections.binarySearch(baseClprInfoList, basicDataList.get(0));
        if (iSearch < 0) {
            SJctrLogUty.warn("SJctrMigrateClprConfirmDC", "detailAction", "clpr Not Found. CLPRID = " + ((SJmoClprInfo)basicDataList.get(0)).getSClpr());
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        ArrayList<SJmoClprInfo> selectClprList = new ArrayList<SJmoClprInfo>();
        selectClprList.add((SJmoClprInfo)baseClprInfoList.get(iSearch));
        transDataMap.put("KEY_SELECT_CLPR_INDEX", selectClprList);
        transDataMap.put("KEY_GET_BASE_CLPRINFO", baseClprInfoList);
        transDataMap.put("KEY_DETAIL_CLPR_DETAIL", clprInfoList);
        transDataMap.put("KEY_DETAIL_PG_DETAIL", pgDtlList);
        transDataMap.put("KEY_DETAIL_LDEV_DETAIL", LdevDtlList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrClprPropertyDialogDC.class, transDataMap);
        this.addUpdateDisp(relatedObj);
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        retMap.put(SJctrVpmUtility.KEY_CLASS_CLPR_INFO.getName(), this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO));
        retMap.put(SJctrVpmUtility.KEY_CLASS_PG_DETAIL.getName(), this.getCache(SJctrVpmUtility.KEY_CLASS_PG_DETAIL));
        retMap.put(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL.getName(), this.getCache(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL));
        retMap.put(SJctrVpmUtility.KEY_CLASS_ALL_RSG.getName(), this.getCache(SJctrVpmUtility.KEY_CLASS_ALL_RSG));
        retMap.put("KEY_GET_SELECTED_CLPRINFO_ALL", this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO));
        retMap.put("KEY_GET_BASE_CLPRINFO", this.getCache("KEY_GET_BASE_CLPRINFO"));
        return retMap;
    }
}

