/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vvol.expandvvol.model;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.hdp.com.SJctrPoolDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.hdp.model.SJctrHdpCapModel;
import sanproject.sn2.controller.wizard.vvol.com.SJctrHDPUtility;
import sanproject.sn2.controller.wizard.vvol.com.data.SJctrHDPLDEVDetail;
import sanproject.sn2.controller.wizard.vvol.expandvvol.dc.SJctrExpandVVOLDC;
import sanproject.sn2.model.data.volume.SJmoThinProvisioningVolumesStatus;

public class SJctrExpandVVOLCapModel
extends SJctrHdpCapModel {
    public static final int ERROR_OVERPOOL = 105211;
    public static final String KEY_CAP_SPECIFY = "COM_CAP_SPECIFY";
    public static final String KEY_TOTAL = "COM_TOTAL";
    public static final String KEY_ADDISIONAL = "COM_ADDITIONAL";
    public static final String GUID_TOTAL = "SPECIFY_TOTAL_CAP";
    public static final String GUID_ADDITIONAL = "SPECIFY_ADDITIONAL_CAP";

    @Override
    public void initDataModel() {
        super.initDataModel();
        this.addDataModel(KEY_CAP_SPECIFY, new SJctrRadioButtonGroupDataModel());
    }

    public void refData(List LDEVList, SJctrPoolDetail pool) {
        List<?> dpVolStatusList = ((SJctrExpandVVOLDC)this.getDataController()).getCache(KEY_CLASS_GETDPVOLSTATUS);
        this.initSpecify();
        int iEmuType = 0;
        this.numTextBox.setValue(Integer.toString(LDEVList.size()));
        long lMinSize = pool.getMinSize();
        boolean bTse = false;
        for (int i = 0; i < LDEVList.size(); ++i) {
            SJctrHDPLDEVDetail ldev = (SJctrHDPLDEVDetail)LDEVList.get(i);
            if (lMinSize > ldev.getLLDEVLBASize()) continue;
            lMinSize = ldev.getLLDEVLBASize();
            iEmuType = ldev.getIEmulationType();
            bTse = ldev.getbTseVol();
        }
        String strEmuType = this.getComUtility().getCVSUtility().getEmulationTypeName(iEmuType);
        super.refData(strEmuType);
        long lMaxSize = this.getComUtility().getCVSUtility().getRemUserSizeTse(pool.getRemainingTotalLBA_Expand(LDEVList), iEmuType, 1, 1, false, bTse);
        int addCvdevNum = 0;
        int iUseCvdevNum = 0;
        for (int i = 0; i < LDEVList.size(); ++i) {
            int ldevIndex;
            SJctrLDEVDetail ldev = (SJctrLDEVDetail)LDEVList.get(i);
            if (dpVolStatusList != null && (ldevIndex = Collections.binarySearch(dpVolStatusList, ldev)) >= 0) {
                SJmoThinProvisioningVolumesStatus dpVolStatus = (SJmoThinProvisioningVolumesStatus)dpVolStatusList.get(ldevIndex);
                ldev.setDPVolStatus(dpVolStatus);
            }
            if (ldev.getBDRDVol() || ldev.getIDataSavingStatus() != 0) {
                iUseCvdevNum += 2;
                addCvdevNum += super.getCVDEVData().getCVDEVDRDMaxNum(ldev.getLTotalLBA(), ldev.getByVolumeType(), ldev.isBPoolType());
                continue;
            }
            ++iUseCvdevNum;
            addCvdevNum += super.getCVDEVData().getCVDEVMaxNum(ldev.getLTotalLBA(), ldev.getByVolumeType(), ldev.isBPoolType());
        }
        long lCvdevNum = (super.getCVDEVData().getIRemaningCVDEVCount() + addCvdevNum) / iUseCvdevNum;
        long wkCvdevSize = 6442082304L * lCvdevNum;
        if (lMaxSize > wkCvdevSize) {
            lMaxSize = wkCvdevSize;
        }
        if (this.getSpecifyRadio().getSelect().equals(KEY_ADDISIONAL)) {
            lMaxSize -= lMinSize;
            lMinSize = 0L;
        }
        this.toDisplayData(lMinSize, lMaxSize, LDEVList.size(), strEmuType);
    }

    private void initSpecify() {
        this.getSpecifyRadio().setEnableListener(false);
        if (this.getSpecifyRadio().getSelect() == null) {
            this.getSpecifyRadio().add(KEY_TOTAL, this.getComUtility().getGuidance(GUID_TOTAL));
            this.getSpecifyRadio().add(KEY_ADDISIONAL, this.getComUtility().getGuidance(GUID_ADDITIONAL));
            this.getSpecifyRadio().setSelect(KEY_TOTAL);
        }
        this.getSpecifyRadio().setEnableListener(true);
    }

    public void toDisplayData(long lMinSize, long lMaxSize, int iMinNum, String strEmu) {
        int iEmu = this.getComUtility().getCVSUtility().getEmu(strEmu);
        SJctrCapacityUtility.UNIT unit = SJctrCVSUtility.getUnit(this.comboBox.getSelection());
        String strMinSize = "";
        long wklMinSize = this.getExpandMinSize(lMinSize, unit, strEmu);
        switch (unit) {
            case CYL: {
                strMinSize = this.getComUtility().getCapacityUtility().toString(wklMinSize, unit, iEmu);
                if (wklMinSize <= lMaxSize) break;
                SJctrHDPUtility.errorMsg(32, 22, 105211);
                break;
            }
            case MB: {
                if (this.getSpecifyRadio().getSelect().equals(KEY_ADDISIONAL)) {
                    strMinSize = "0.01";
                    break;
                }
                strMinSize = SJctrCVSUtility.toUnitLBA_ExpandUP(this.getDisplaySize(wklMinSize, unit, strEmu), unit);
                if (wklMinSize > lMaxSize && lMinSize >= lMaxSize) {
                    SJctrHDPUtility.errorMsg(32, 22, 105211);
                }
                if (this.chkOffset.isSelect()) break;
                Double dbMin = Double.parseDouble(strMinSize);
                Double dbSize = Double.parseDouble("0.01");
                BigDecimal bd1 = new BigDecimal(dbMin);
                BigDecimal bd2 = new BigDecimal(dbSize);
                BigDecimal bd3 = bd1.add(bd2);
                DecimalFormat BYTE_CHANGE_FORMAT = new DecimalFormat("0.00");
                strMinSize = BYTE_CHANGE_FORMAT.format(bd3);
                break;
            }
            default: {
                strMinSize = SJctrCVSUtility.toUnitLBA_ExpandUP(this.getDisplaySize(wklMinSize, unit, strEmu), unit);
                if (wklMinSize <= lMaxSize || lMinSize < lMaxSize) break;
                SJctrHDPUtility.errorMsg(32, 22, 105211);
            }
        }
        String strMaxSize = this.getComUtility().getCapacityUtility().toString(this.getDisplaySize(lMaxSize, unit, strEmu), unit, iEmu);
        if (Double.parseDouble(strMinSize) > Double.parseDouble(strMaxSize)) {
            this.clearData();
        } else if (iMinNum == 0) {
            this.clearData();
        } else {
            this.textBox.setMin(strMinSize);
            this.textBox.setMax(strMaxSize);
            this.numTextBox.setMin(Integer.toString(iMinNum));
            this.numTextBox.setMax(Integer.toString(iMinNum));
        }
        this.getDataController().setUnitSelect(unit.toString());
    }

    private long getExpandMinSize(long lSize, SJctrCapacityUtility.UNIT unit, String strEmu) {
        long rtn = 0L;
        if (!this.chkOffset.isSelect()) {
            rtn = lSize + 1L;
        } else {
            int iEmu = this.getComUtility().getCVSUtility().getEmu(strEmu);
            switch (unit) {
                case BLOCK: {
                    rtn = lSize + 1L;
                    break;
                }
                default: {
                    int iSlot = this.getComUtility().getCVSUtility().getSlotSize(iEmu);
                    if (strEmu.equals("OPEN-V")) {
                        iSlot = 64;
                    }
                    rtn = lSize + (long)(15 * iSlot * 2);
                    if (!strEmu.equals("3390-A") || rtn <= 114004800L) break;
                    long wkUsedCap = 33390 * iSlot;
                    long wkMinNum = rtn / wkUsedCap;
                    if (rtn % wkUsedCap > 0L) {
                        ++wkMinNum;
                    }
                    rtn = wkMinNum * wkUsedCap;
                }
            }
        }
        return rtn;
    }

    @Override
    public void initListener() {
        this.getSpecifyRadio().addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrExpandVVOLCapModel.this.fireMessageEvent(SJctrExpandVVOLDC.NOTIFY_EXPAND_LDEV.CHANGE_OFFSET);
                }
            }
        });
        this.chkOffset.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrExpandVVOLCapModel.this.fireMessageEvent(SJctrExpandVVOLDC.NOTIFY_EXPAND_LDEV.CHANGE_OFFSET);
            }
        });
        this.comboBox.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrNestedListDataObject) {
                    SJctrExpandVVOLCapModel.this.fireMessageEvent(SJctrExpandVVOLDC.NOTIFY_EXPAND_LDEV.SELECT_UNIT);
                    SJctrExpandVVOLCapModel.this.comboBox.setChangeCheck(true);
                }
            }
        });
        this.textBox.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrExpandVVOLCapModel.this.fireMessageEvent(SJctrExpandVVOLDC.NOTIFY_EXPAND_LDEV.SELECT_UNIT);
                SJctrExpandVVOLCapModel.this.textBox.setChangeCheck(true);
            }
        });
    }

    @Override
    public void chkData() {
        String strUnit = this.comboBox.getSelection();
        this.logUty.putlog("initTextBox", "comboBox: " + strUnit);
        this.chkCapacity();
    }

    private void chkCapacity() {
        String strCap = this.textBox.getValue();
        this.logUty.putlog("initTextBox", "Capacity: " + strCap);
        if (!strCap.equals("")) {
            Double lCap = 0.0;
            try {
                lCap = Double.parseDouble(strCap);
            }
            catch (Exception ex) {
                SJctrHDPUtility.errorMsg(30, 22, 105155);
            }
            if (lCap < Double.parseDouble(this.textBox.getMin()) || lCap > Double.parseDouble(this.textBox.getMax())) {
                SJctrHDPUtility.errorMsg(30, 22, 105153);
            }
            if (lCap <= 0.0) {
                SJctrHDPUtility.errorMsg(30, 22, 105154);
            }
        } else {
            SJctrHDPUtility.errorMsg(30, 22, 105148);
        }
    }

    private SJctrRadioButtonGroupDataModel getSpecifyRadio() {
        return (SJctrRadioButtonGroupDataModel)this.getDataModel(KEY_CAP_SPECIFY);
    }

    public long[] getCapacity(String strEmuType, boolean bTse, long lLdevSize) {
        long[] rtn = this.getSpecifyRadio().getSelect().equals(KEY_TOTAL) ? this.getCapacitySimple(strEmuType, 1, true) : (this.getComUtility().getCVSUtility().isOpen(strEmuType) ? this.getCapacity(strEmuType, lLdevSize) : this.getCapacityMF(strEmuType, lLdevSize));
        super.getTseSize(strEmuType, bTse, rtn);
        return rtn;
    }
}

