/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec;

import java.util.HashMap;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.exec.inf.SJhtclExecInterface;

public abstract class SJhtclExecBase
implements SJhtclExecInterface {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclExecBase.class.getSimpleName();
    protected static SJcLoggerInterface htclLogger = null;
    protected SJbaseUserSessionInterface session = null;
    protected Map<String, Object> requestMap = null;
    private static final Object lock = new Object();

    public SJhtclExecBase(SJbaseUserSessionInterface session, Map<String, Object> requestMap) {
        this.session = session;
        this.requestMap = requestMap;
        htclLogger = SJhtclHttpCliUty.getHtclLogger();
    }

    protected boolean checkVersion() {
        return true;
    }

    protected boolean checkParameters() {
        return true;
    }

    protected boolean checkRole() {
        return true;
    }

    protected boolean checkPP() {
        return true;
    }

    protected boolean checkResource() {
        return true;
    }

    protected String getRaidinfVer() {
        return SJhtclParameterUty.getStrFromMap(this.requestMap, "raidinf-version");
    }

    protected abstract HashMap<String, Object> executeCommand();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, Object> exec() {
        String LOG_SUBTITLE = "exec";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "exec", "Start.");
        HashMap<String, Object> responseMap = new HashMap();
        if (!this.checkVersion()) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "exec", "Version is invalid.");
            responseMap = SJhtclHttpCliUty.getErrorMapCmd("107007");
            return responseMap;
        }
        if (!this.checkParameters()) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "exec", "Parameter is invalid.");
            responseMap = SJhtclHttpCliUty.getErrorMapCmd("107003");
            return responseMap;
        }
        if (!this.checkRole()) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "exec", "Role is invalid.");
            responseMap = SJhtclHttpCliUty.getErrorMapCmd("107002");
            return responseMap;
        }
        if (!this.checkPP()) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "exec", "P.P is invalid.");
            responseMap = SJhtclHttpCliUty.getErrorMapCmd("107008");
            return responseMap;
        }
        if (!this.checkResource()) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "exec", "Resource is invalid.");
            responseMap = SJhtclHttpCliUty.getErrorMapCmd("107009");
            return responseMap;
        }
        try {
            Object object = lock;
            synchronized (object) {
                responseMap = this.executeCommand();
            }
        }
        catch (SJcException sjce) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "exec", "Command execution failed.", sjce);
            responseMap = SJhtclHttpCliUty.getErrorMap(sjce.getMsg());
        }
        catch (Throwable th) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "exec", "Runtime error occurred.", th);
            responseMap = SJhtclHttpCliUty.getErrorMapCmd("107010");
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "exec", "End.");
        return responseMap;
    }

    protected boolean isEnablePP(String ppKey) {
        SJctrLicenseContainer lc;
        SJctrAuthorizeContainer ac;
        boolean res = false;
        SJctrUserController uc = (SJctrUserController)this.session.getUserController();
        if (uc != null && (ac = uc.getAuthorizeContainer()) != null && (lc = ac.getLisenceContainer()) != null) {
            res = lc.checkPP(ppKey);
        }
        return res;
    }
}

