/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.CryptographicParameters;
import sanproject.sn2.kms.kmip.client.info.common.Name;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVDateTime;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterCreate
extends Converter {
    private static final String module = "ConverterCreate";

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        int batchCount = ii.getRequiredKeyNum();
        int cryptographicUsageMask = 12;
        String sortOfData = ii.getSortOfData();
        if (sortOfData == null || sortOfData.length() == 0) {
            STD_LOGGER.info(module, method, " - check sortOfData", " - invalid");
            throw new KeyInfoBlankException();
        }
        if (sortOfData.indexOf("VSP") != 0 && sortOfData.indexOf("HUS_VM") != 0 && sortOfData.indexOf("R800") != 0) {
            STD_LOGGER.info(module, method, " - check sortOfData", " - invalid");
            throw new KeyInfoBlankException();
        }
        String keyType = sortOfData.substring(sortOfData.indexOf(":") + 1);
        if (keyType.startsWith("KEK") || keyType.startsWith("KEKdynamic")) {
            batchCount = 1;
            cryptographicUsageMask = 48;
        } else {
            if (keyType.compareToIgnoreCase("DEK") != 0) {
                STD_LOGGER.info(module, method, " - check sortOfData", " - invalid");
                throw new KeyInfoBlankException();
            }
            if (batchCount < 1) {
                STD_LOGGER.info(module, method, " - check requiredKeyNum", " - invalid");
                throw new KeyInfoBlankException();
            }
            cryptographicUsageMask = 12;
        }
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(batchCount);
        }
        tReq.addValue(this.getRequestHeader(rhc, batchCount));
        int i = 0;
        while (true) {
            TTLVStructure tAttr;
            if (i >= batchCount) {
                STD_LOGGER.info(module, method, " - ", " - end");
                return tReq;
            }
            TTLVStructure tBI = this.getBatchItem(1, i + 1);
            tReq.addValue(tBI);
            TTLVStructure tPay = new TTLVStructure(121);
            tBI.addValue(tPay);
            tPay.addValue(new TTLVEnumeration(87, 2));
            TTLVStructure tTempAttr = new TTLVStructure(-111);
            tPay.addValue(tTempAttr);
            TTLVStructure tAttr1 = new TTLVStructure(8);
            tTempAttr.addValue(tAttr1);
            tAttr1.addValue(new TTLVTextString(10, "Cryptographic Algorithm"));
            tAttr1.addValue(new TTLVEnumeration(11, 3));
            TTLVStructure tAttr2 = new TTLVStructure(8);
            tTempAttr.addValue(tAttr2);
            tAttr2.addValue(new TTLVTextString(10, "Cryptographic Length"));
            tAttr2.addValue(new TTLVInteger(11, 256));
            TTLVStructure tAttr3 = new TTLVStructure(8);
            tTempAttr.addValue(tAttr3);
            tAttr3.addValue(new TTLVTextString(10, "Cryptographic Usage Mask"));
            tAttr3.addValue(new TTLVInteger(11, cryptographicUsageMask));
            if (ii.getAttrNeeds("Name")) {
                Name name = ii.getNameList().get(i);
                if (name.getNameValue() == null || name.getNameValue().length() == 0) {
                    throw new KeyInfoBlankException();
                }
                if (name.getNameType() == 0) {
                    throw new KeyInfoBlankException();
                }
                TTLVStructure tAttr4 = new TTLVStructure(8);
                tTempAttr.addValue(tAttr4);
                tAttr4.addValue(new TTLVTextString(10, "Name"));
                TTLVStructure tAttrName = new TTLVStructure(83);
                tAttr4.addValue(tAttrName);
                tAttrName.addValue(new TTLVTextString(85, name.getNameValue()));
                tAttrName.addValue(new TTLVEnumeration(84, name.getNameType()));
            }
            if (ii.getAttrNeeds("Cryptographic Parameters")) {
                tAttr = new TTLVStructure(8);
                tTempAttr.addValue(tAttr);
                tAttr.addValue(new TTLVTextString(10, "Cryptographic Parameters"));
                TTLVStructure tAttr5Value = new TTLVStructure(11);
                tAttr.addValue(tAttr5Value);
                CryptographicParameters cp = ii.getCryptographicParameters();
                if (ii.getCryptographicParameters().getAttrNeeds(0)) {
                    tAttr5Value.addValue(new TTLVEnumeration(17, cp.getBlockCipherMode()));
                }
                if (ii.getCryptographicParameters().getAttrNeeds(1)) {
                    tAttr5Value.addValue(new TTLVEnumeration(95, cp.getPaddingMethod()));
                }
                if (ii.getCryptographicParameters().getAttrNeeds(2)) {
                    tAttr5Value.addValue(new TTLVEnumeration(56, cp.getHashingAlgorithm()));
                }
                if (ii.getCryptographicParameters().getAttrNeeds(3)) {
                    tAttr5Value.addValue(new TTLVEnumeration(-125, cp.getKeyRoleType()));
                }
            }
            if (ii.getAttrNeeds("Activation Date")) {
                tAttr = new TTLVStructure(8);
                tTempAttr.addValue(tAttr);
                tAttr.addValue(new TTLVTextString(10, "Activation Date"));
                tAttr.addValue(new TTLVDateTime(11, ii.getActivationDate()));
            }
            if (ii.getAttrNeeds("Deactivation Date")) {
                tAttr = new TTLVStructure(8);
                tTempAttr.addValue(tAttr);
                tAttr.addValue(new TTLVTextString(10, "Deactivation Date"));
                tAttr.addValue(new TTLVDateTime(11, ii.getDeactivationDate()));
            }
            if (ii.getAttrNeeds("Process Start Date")) {
                tAttr = new TTLVStructure(8);
                tTempAttr.addValue(tAttr);
                tAttr.addValue(new TTLVTextString(10, "Process Start Date"));
                tAttr.addValue(new TTLVDateTime(11, ii.getProcessStartDate()));
            }
            if (ii.getAttrNeeds("Protect Stop Date")) {
                tAttr = new TTLVStructure(8);
                tTempAttr.addValue(tAttr);
                tAttr.addValue(new TTLVTextString(10, "Protect Stop Date"));
                tAttr.addValue(new TTLVDateTime(11, ii.getProtectStopDate()));
            }
            ++i;
        }
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        if (this.responseBatchCount != ki.getInputInfo().getRequiredKeyNum()) {
            STD_LOGGER.info(module, method, " - check created key num", " - invalid");
            throw new ResponseException();
        }
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        if (resvTTLV.getValueSize((byte)15) < 0) {
            return;
        }
        ArrayList<TTLV> al = resvTTLV.getValueList((byte)15);
        for (int i = 0; i < al.size(); ++i) {
            OutputInfo oi = new OutputInfo();
            if (al.get(i).getType() != 1) {
                STD_LOGGER.info(module, method, " - check Type of Batch Item", " - invalid");
                throw new ResponseException();
            }
            TTLVStructure tRP = this.checkBatchItem((TTLVStructure)al.get(i), oi);
            if (tRP != null) {
                this.checkValue(tRP, (byte)-108, (byte)7, 1);
                TTLVTextString tUI = (TTLVTextString)tRP.getValueList((byte)-108).get(0);
                ArrayList<String> uniqueIdentifierList = new ArrayList<String>();
                uniqueIdentifierList.add(tUI.getValue());
                oi.setUniqueIdentifierList(uniqueIdentifierList);
            }
            oiList.add(oi);
        }
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

