/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.CryptographicParameters;
import sanproject.sn2.kms.kmip.client.info.common.Name;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVByteString;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVDateTime;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterRegister
extends Converter {
    private static final String module = "ConverterRegister";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(1);
        }
        tReq.addValue(this.getRequestHeader(rhc, 1));
        TTLVStructure tBI = this.getBatchItem(3);
        tReq.addValue(tBI);
        TTLVStructure tPay = new TTLVStructure(121);
        tBI.addValue(tPay);
        tPay.addValue(new TTLVEnumeration(87, 7));
        TTLVStructure tTempAttr = new TTLVStructure(-111);
        tPay.addValue(tTempAttr);
        String[] attrName = new String[]{"Object Group", "x-ProductID", "x-BackupDate", "x-BackupTaskName", "x-HashAlgorithm", "x-Hash", "x-BackupDataSize", "x-KeyMaterialFormatID", "x-BackupComment", "x-RegularBackup", "x-KEKUID"};
        String[] attrValue = new String[]{ii.getSortOfData(), ii.getProductID(), ii.getBackupDate(), ii.getBackupTaskName(), Integer.toHexString(ii.getHashAlgrithm()), ii.getHash(), Integer.toHexString(ii.getBackupDataSize()), Integer.toHexString(ii.getKeyMaterialFormatID()), ii.getBackupComment(), Integer.toString(ii.getRegularBackup()), ii.getUniqueIdentifier()};
        boolean[] attrNeed = new boolean[]{true, true, true, false, true, true, true, true, false, false, true};
        int mode = this.getMode(ii);
        if (mode == 0) {
            STD_LOGGER.info(module, method, " - check mode", " - invalid");
            throw new KeyInfoBlankException();
        }
        int goal = mode == 1 ? 7 : attrName.length;
        for (int i = 0; i < goal; ++i) {
            if (attrValue[i] == null || attrValue[i].length() == 0) {
                if (!attrNeed[i]) continue;
                STD_LOGGER.info(module, method, " - check " + attrName[i], " - invalid");
                throw new KeyInfoBlankException();
            }
            TTLVStructure ta = new TTLVStructure(8);
            ta.addValue(new TTLVTextString(10, attrName[i]));
            ta.addValue(new TTLVTextString(11, attrValue[i]));
            tTempAttr.addValue(ta);
        }
        if (mode == 3) {
            TTLVStructure ta = new TTLVStructure(8);
            ta.addValue(new TTLVTextString(10, "x-SplitNum"));
            ta.addValue(new TTLVInteger(11, ii.getSplitNum()));
            tTempAttr.addValue(ta);
            ta = new TTLVStructure(8);
            ta.addValue(new TTLVTextString(10, "x-SplitID"));
            ta.addValue(new TTLVInteger(11, ii.getSplitID()));
            tTempAttr.addValue(ta);
        }
        if (ii.getAttrNeeds("Name")) {
            Name name = ii.getNameList().get(0);
            if (name.getNameValue() == null || name.getNameValue().length() == 0) {
                throw new KeyInfoBlankException();
            }
            if (name.getNameType() == 0) {
                throw new KeyInfoBlankException();
            }
            TTLVStructure tAttr = new TTLVStructure(8);
            tTempAttr.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Name"));
            TTLVStructure tAttrName = new TTLVStructure(83);
            tAttr.addValue(tAttrName);
            tAttrName.addValue(new TTLVTextString(85, name.getNameValue()));
            tAttrName.addValue(new TTLVEnumeration(84, name.getNameType()));
        }
        if (ii.getAttrNeeds("Cryptographic Parameters")) {
            TTLVStructure tAttr = new TTLVStructure(8);
            tTempAttr.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Cryptographic Parameters"));
            TTLVStructure tAttrValue = new TTLVStructure(11);
            tAttr.addValue(tAttrValue);
            CryptographicParameters cp = ii.getCryptographicParameters();
            if (ii.getCryptographicParameters().getAttrNeeds(0)) {
                tAttrValue.addValue(new TTLVEnumeration(17, cp.getBlockCipherMode()));
            }
            if (ii.getCryptographicParameters().getAttrNeeds(1)) {
                tAttrValue.addValue(new TTLVEnumeration(95, cp.getPaddingMethod()));
            }
            if (ii.getCryptographicParameters().getAttrNeeds(2)) {
                tAttrValue.addValue(new TTLVEnumeration(56, cp.getHashingAlgorithm()));
            }
            if (ii.getCryptographicParameters().getAttrNeeds(3)) {
                tAttrValue.addValue(new TTLVEnumeration(-125, cp.getKeyRoleType()));
            }
        }
        if (ii.getAttrNeeds("Activation Date")) {
            TTLVStructure tAttr = new TTLVStructure(8);
            tTempAttr.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Activation Date"));
            tAttr.addValue(new TTLVDateTime(11, ii.getActivationDate()));
        }
        if (ii.getAttrNeeds("Deactivation Date")) {
            TTLVStructure tAttr = new TTLVStructure(8);
            tTempAttr.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Deactivation Date"));
            tAttr.addValue(new TTLVDateTime(11, ii.getDeactivationDate()));
        }
        if (ii.getAttrNeeds("Process Start Date")) {
            TTLVStructure tAttr = new TTLVStructure(8);
            tTempAttr.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Process Start Date"));
            tAttr.addValue(new TTLVDateTime(11, ii.getProcessStartDate()));
        }
        if (ii.getAttrNeeds("Protect Stop Date")) {
            TTLVStructure tAttr = new TTLVStructure(8);
            tTempAttr.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Protect Stop Date"));
            tAttr.addValue(new TTLVDateTime(11, ii.getProtectStopDate()));
        }
        TTLVStructure tSD = new TTLVStructure(-123);
        tPay.addValue(tSD);
        tSD.addValue(new TTLVEnumeration(-122, 1));
        TTLVStructure tKB = new TTLVStructure(64);
        tSD.addValue(tKB);
        tKB.addValue(new TTLVEnumeration(66, 2));
        TTLVStructure tKV = new TTLVStructure(69);
        tKB.addValue(tKV);
        TTLVByteString tKM = new TTLVByteString(67);
        String s = ii.getBackupData();
        if (s == null || s.length() == 0) {
            STD_LOGGER.info(module, method, " - check BackupData", " - invalid");
            throw new KeyInfoBlankException();
        }
        tKM.setValue(s);
        tKV.addValue(tKM);
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    protected int getMode(InputInfo ii) {
        String method = "getMode";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String[] compareString = new String[]{"VSP:KEK", "HUS_VM:KEK", "R800:KEK", "VSP:DEK"};
        int[] mode = new int[]{1, 1, 1, 2};
        String s = ii.getSortOfData();
        if (s == null) {
            STD_LOGGER.info(module, method, " - check SortOfData", " - invalid");
            return 0;
        }
        for (int i = 0; i < compareString.length; ++i) {
            if (s.compareToIgnoreCase(compareString[i]) != 0) continue;
            STD_LOGGER.info(module, method, " - ", " - end");
            return mode[i];
        }
        String husvm_dek = "HUS_VM:DEK";
        String r800_dek = "R800:DEK";
        if (s.compareToIgnoreCase(r800_dek) == 0 || s.compareToIgnoreCase(husvm_dek) == 0) {
            STD_LOGGER.info(module, method, " - ", " - end");
            return ii.getSplitFlag() ? 2 : 3;
        }
        STD_LOGGER.info(module, method, " - check SortOfData", " - mismatch");
        return 0;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        if (resvTTLV.getValueSize((byte)15) < 0) {
            return;
        }
        ArrayList<TTLV> al = resvTTLV.getValueList((byte)15);
        for (int i = 0; i < al.size(); ++i) {
            OutputInfo oi = new OutputInfo();
            if (al.get(i).getType() != 1) {
                STD_LOGGER.info(module, method, " - check Type of Batch Item", " - invalid");
                throw new ResponseException();
            }
            TTLVStructure tRP = this.checkBatchItem((TTLVStructure)al.get(i), oi);
            if (tRP != null) {
                this.checkValue(tRP, (byte)-108, (byte)7, 1);
                TTLVTextString tUI = (TTLVTextString)tRP.getValueList((byte)-108).get(0);
                ArrayList<String> uniqueIdentifierList = new ArrayList<String>();
                uniqueIdentifierList.add(tUI.getValue());
                oi.setUniqueIdentifierList(uniqueIdentifierList);
            }
            oiList.add(oi);
        }
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

