/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.ttlv;

import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class TTLVEnumeration
extends TTLV {
    private static final String module = "TTLVEnumeration";
    protected byte[] value;

    public TTLVEnumeration(byte tag) {
        super(tag);
    }

    public TTLVEnumeration(byte[] data, int pos) {
        super(data, pos);
        System.arraycopy(data, pos + 8, this.value, 0, this.value.length);
    }

    public TTLVEnumeration(byte tag, int value) {
        super(tag);
        this.setValue(value);
    }

    @Override
    protected void init() {
        String method = "init";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.length = 4;
        this.value = new byte[this.length];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = 0;
        }
    }

    @Override
    public byte getType() {
        String method = "getType";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return 5;
    }

    @Override
    public void makeSendData(byte[] data, int pos) {
        String method = "makeSendData";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.makeTTL(data, pos);
        System.arraycopy(this.value, 0, data, pos + 8, this.value.length);
        int goal = this.getBinaryDataSize();
        for (int i = 8 + this.length; i < goal; ++i) {
            data[pos + i] = 0;
        }
    }

    public int getValue() {
        String method = "getValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return TTLVEnumeration.convertInteger(this.value);
    }

    public void setValue(int newValue) {
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        TTLVEnumeration.convertByte((long)newValue, this.value);
    }
}

