/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.ttlv;

import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class TTLVInterval
extends TTLV {
    private static final String module = "TTLVInterval";
    protected byte[] value;

    public TTLVInterval(byte tag) {
        super(tag);
    }

    public TTLVInterval(byte[] data, int pos) {
        super(data, pos);
        System.arraycopy(data, pos + 8, this.value, 0, this.value.length);
    }

    public TTLVInterval(byte tag, String interval) {
        super(tag);
        this.setValue(interval);
    }

    @Override
    protected void init() {
        String method = "init";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        this.length = 4;
        this.value = new byte[this.length];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = 0;
        }
        STD_LOGGER.info(module, method, " - ", " - end");
    }

    @Override
    public byte getType() {
        String method = "getType";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - done");
        return 10;
    }

    @Override
    public void makeSendData(byte[] data, int pos) {
        String method = "makeSendData";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        this.makeTTL(data, pos);
        System.arraycopy(this.value, 0, data, pos + 8, this.value.length);
        int goal = this.getBinaryDataSize();
        for (int i = 8 + this.length; i < goal; ++i) {
            data[pos + i] = 0;
        }
        STD_LOGGER.info(module, method, " - ", " - end");
    }

    public void setValue(String newValue) {
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        int[] bias = new int[]{24, 60, 60};
        long t = new Integer(newValue.substring(0, 4)).longValue();
        for (int i = 0; i < 3; ++i) {
            int pos = i * 2 + 4;
            t = t * (long)bias[i] + new Integer(newValue.substring(pos, pos + 2)).longValue();
        }
        TTLVInterval.convertByte(t, this.value);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

