/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.ttlv;

import java.nio.charset.Charset;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class TTLVTextString
extends TTLV {
    private static final String module = "TTLVTextString";
    protected byte[] value;

    public TTLVTextString(byte tag) {
        super(tag);
    }

    public TTLVTextString(byte[] data, int pos) {
        super(data, pos);
        this.value = new byte[this.length];
        System.arraycopy(data, pos + 8, this.value, 0, this.value.length);
    }

    public TTLVTextString(byte tag, String value) {
        super(tag);
        this.setValue(value);
    }

    @Override
    protected void init() {
        String method = "init";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.length = 0;
        this.value = null;
    }

    @Override
    public byte getType() {
        String method = "getType";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return 7;
    }

    @Override
    public void makeSendData(byte[] data, int pos) {
        String method = "makeSendData";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.makeTTL(data, pos);
        System.arraycopy(this.value, 0, data, pos + 8, this.value.length);
        int goal = this.getBinaryDataSize();
        for (int i = 8 + this.length; i < goal; ++i) {
            data[pos + i] = 0;
        }
    }

    public String getValue() {
        String method = "getValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return new String(this.value, Charset.forName("UTF-8"));
    }

    public void setValue(String newValue) {
        String method = "setValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.length = newValue.length();
        this.value = newValue.getBytes(Charset.forName("UTF-8"));
    }
}

