/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.kms.exception.SJkmsKeystoreUtyException;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class SJkmsKeystoreUty {
    private static final String LOG_FUNCTION = "Kms";
    private static final String LOG_TITLE = "SJkmsKeystoreUty";
    private static final String CLIENT_STORE_PASS = "GOGOtea0sugerDIORDNA12345";
    private static final String CLIENT_ALIAS = "sn2_kmsC";
    private static final String SERVER_STORE_PASS = "Gozira55portal2SanDoaSign";
    private static final String SERVER_ALIAS = "sn2_kmsS";

    private SJkmsKeystoreUty() {
    }

    public static Key readClientKey(String servername, String password) throws SJcException, SJkmsKeystoreUtyException {
        String LOG_SUBTITLE = "readClientKey";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "readClientKey", "start");
        if (servername == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "readClientKey", "servername parameter is null");
            throw new SJcException();
        }
        if (password == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "readClientKey", "parameter is null");
            throw new SJcException();
        }
        char[] passwd = password.toCharArray();
        String keystore_file = "";
        Key key = null;
        try {
            String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
            keystore_file = dataPath + "kms\\tmp\\" + servername + ".Kms.keystore";
            KeyStore ks = SJkmsKeystoreUty.getClientKeyStore(keystore_file, "pkcs12", passwd);
            String ali = null;
            ali = ks.aliases().nextElement();
            key = ks.getKey(ali, passwd);
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "readClientKey", "Client cert file read error", ex);
            throw new SJkmsKeystoreUtyException(ex);
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "readClientKey", "end");
        return key;
    }

    public static Certificate[] readClientCert(String servername, String password) throws SJcException, SJkmsKeystoreUtyException {
        String LOG_SUBTITLE = "readClientCert";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "readClientCert", "start");
        if (servername == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "readClientCert", "servername parameter is null");
            throw new SJcException();
        }
        if (password == null) {
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "readClientCert", "parameter is null");
            throw new SJcException();
        }
        char[] passwd = password.toCharArray();
        String keystore_file = "";
        Certificate[] cert = null;
        try {
            String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
            keystore_file = dataPath + "kms\\tmp\\" + servername + ".Kms.keystore";
            KeyStore ks = SJkmsKeystoreUty.getClientKeyStore(keystore_file, "pkcs12", passwd);
            String ali = null;
            ali = ks.aliases().nextElement();
            cert = ks.getCertificateChain(ali);
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "readClientCert", "Read client cert file error");
            throw new SJkmsKeystoreUtyException(ex);
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "readClientCert", "end");
        return cert;
    }

    public static Certificate readServerCert(String servername) throws SJcException, SJkmsKeystoreUtyException {
        String LOG_SUBTITLE = "readServerCert";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "readServerCert", "start");
        if (servername == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "readServerCert", "servername parameter is null");
            throw new SJcException();
        }
        InputStream fis = null;
        String keystore_file = "";
        Certificate cert = null;
        try {
            String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
            keystore_file = dataPath + "kms\\tmp\\" + servername + ".Kms.truststore";
            fis = SJcFileUty.getInStream(keystore_file);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = cf.generateCertificate(fis);
            fis.close();
            fis = null;
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "readServerCert", "Read setver cert file error");
            throw new SJkmsKeystoreUtyException(ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {}
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "readServerCert", "end");
        return cert;
    }

    private static KeyStore getClientKeyStore(String fName, String type, char[] passwd) throws SJcException, SJkmsKeystoreUtyException {
        String LOG_SUBTITLE = "getClientKeyStore";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getClientKeyStore", "start");
        if (fName == null || fName.length() == 0 || type == null || type.length() == 0 || passwd == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getClientKeyStore", "parameter is null");
            throw new SJcException();
        }
        InputStream fis = null;
        KeyStore ks = null;
        try {
            fis = SJcFileUty.getInStream(fName);
            ks = KeyStore.getInstance(type);
            ks.load(fis, passwd);
            fis.close();
            fis = null;
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getClientKeyStore", "cannot get Client Keystore");
            throw new SJkmsKeystoreUtyException(ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {}
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getClientKeyStore", "end");
        return ks;
    }

    public static void updateClientKeyStore(String servername, Certificate[] cert, Key key) throws SJcException, SJkmsKeystoreUtyException {
        String LOG_SUBTITLE = "updateClientKeyStore";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "updateClientKeyStore", "start");
        if (servername == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "updateClientKeyStore", "servername parameter is null");
            throw new SJcException();
        }
        if (cert == null || cert.length == 0 || key == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "updateClientKeyStore", "parameter is null");
            throw new SJcException();
        }
        char[] passwd = CLIENT_STORE_PASS.toCharArray();
        KeyStore oks = null;
        try {
            oks = KeyStore.getInstance("JKS");
            oks.load(null, passwd);
            oks.setKeyEntry(CLIENT_ALIAS, key, CLIENT_STORE_PASS.toCharArray(), cert);
        }
        catch (Exception e) {
            throw new SJkmsKeystoreUtyException(e);
        }
        String keystore_file = "";
        OutputStream out = null;
        try {
            String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
            keystore_file = dataPath + "kms\\setting\\" + servername + ".Kms.keystore";
            out = SJcFileUty.getOutStream(keystore_file);
            oks.store(out, passwd);
            out.close();
            out = null;
        }
        catch (Exception e) {
            throw new SJkmsKeystoreUtyException(e);
        }
        finally {
            try {
                out.close();
                out = null;
            }
            catch (Exception ex) {}
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "updateClientKeyStore", "end");
    }

    public static void updateServerKeyStore(String servername, Certificate cert) throws SJcException, SJkmsKeystoreUtyException {
        String LOG_SUBTITLE = "updateServerKeyStore";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "updateServerKeyStore", "start");
        if (servername == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "updateServerKeyStore", "servername parameter is null");
            throw new SJcException();
        }
        if (cert == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "updateServerKeyStore", "parameter is null");
            throw new SJcException();
        }
        char[] passwd = SERVER_STORE_PASS.toCharArray();
        KeyStore oks = null;
        try {
            oks = KeyStore.getInstance("JKS");
            oks.load(null, passwd);
            oks.setCertificateEntry(SERVER_ALIAS, cert);
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "updateServerKeyStore", "Create Keystore Error");
            throw new SJkmsKeystoreUtyException(ex);
        }
        String keystore_file = "";
        OutputStream out = null;
        try {
            String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
            keystore_file = dataPath + "kms\\setting\\" + servername + ".Kms.truststore";
            out = SJcFileUty.getOutStream(keystore_file);
            oks.store(out, passwd);
            out.close();
            out = null;
        }
        catch (Exception e) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "updateServerKeyStore", "Output Keystore Error");
            throw new SJkmsKeystoreUtyException(e);
        }
        finally {
            try {
                out.close();
                out = null;
            }
            catch (Exception ex) {}
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "updateServerKeyStore", "end");
    }

    public static HashMap<String, KeyManager[]> getKeyManager(List<String> servernames, boolean flg, String pass) throws SJcException, SJkmsKeystoreUtyException {
        String LOG_SUBTYTLE = "getKeyManager";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getKeyManager", "start");
        if (servernames == null || servernames.size() == 0 || flg && pass == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getKeyManager", "Parameter is null");
            throw new SJcException();
        }
        HashMap<String, KeyManager[]> ret = new HashMap<String, KeyManager[]>();
        for (String servername : servernames) {
            try {
                char[] key_pass;
                KeyStore keyStore = KeyStore.getInstance("JKS");
                if (flg) {
                    key_pass = pass.toCharArray();
                    Key key = SJkmsKeystoreUty.readClientKey(servername, pass);
                    Certificate[] cert = SJkmsKeystoreUty.readClientCert(servername, pass);
                    keyStore.load(null, key_pass);
                    keyStore.setKeyEntry(CLIENT_ALIAS, key, key_pass, cert);
                } else {
                    key_pass = CLIENT_STORE_PASS.toCharArray();
                    String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
                    String keyStoreDir = dataPath + "kms\\setting\\" + servername + ".Kms.keystore";
                    InputStream fis = null;
                    try {
                        fis = SJcFileUty.getInStream(keyStoreDir);
                        keyStore.load(fis, key_pass);
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (Exception ex) {}
                    }
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(keyStore, key_pass);
                KeyManager[] keymanager = keyManagerFactory.getKeyManagers();
                ret.put(servername, keymanager);
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getKeyManager", "Keystore/Certification Read error");
                throw new SJkmsKeystoreUtyException(ex);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getKeyManager", "end");
        return ret;
    }

    public static HashMap<String, TrustManager[]> getTrustManager(List<String> servernames, boolean flg) throws SJcException, SJkmsKeystoreUtyException {
        String LOG_SUBTYTLE = "getTrustManager";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getTrustManager", "start");
        if (servernames == null || servernames.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getTrustManager", "Parameter is null");
            throw new SJcException();
        }
        HashMap<String, TrustManager[]> ret = new HashMap<String, TrustManager[]>();
        for (String servername : servernames) {
            try {
                KeyStore trustStore = KeyStore.getInstance("JKS");
                char[] trust_pass = SERVER_STORE_PASS.toCharArray();
                if (flg) {
                    Certificate cert = SJkmsKeystoreUty.readServerCert(servername);
                    trustStore.load(null, trust_pass);
                    trustStore.setCertificateEntry(SERVER_ALIAS, cert);
                } else {
                    String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
                    String trustStoreDir = dataPath + "kms\\setting\\" + servername + ".Kms.truststore";
                    InputStream fis = null;
                    try {
                        fis = SJcFileUty.getInStream(trustStoreDir);
                        trustStore.load(fis, trust_pass);
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (Exception ex) {}
                    }
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init(trustStore);
                TrustManager[] trustmanager = trustManagerFactory.getTrustManagers();
                ret.put(servername, trustmanager);
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getTrustManager", "Keystore/Certification Read error");
                throw new SJkmsKeystoreUtyException(ex);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getTrustManager", "end");
        return ret;
    }
}

