/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model;

import java.util.ArrayList;
import java.util.HashMap;
import sanproject.client.com.RJComDef;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.serverux.data.ChangeDataAllString;
import sanproject.serverux.data.ChangeDataString;
import sanproject.sn2.model.SJmoUtility;

public class SJmoDataChange
extends RJDataChange {
    int m_iOemType = 0;
    ArrayList FileNameList = null;
    ChangeDataAllString[] ProductnameData;
    ChangeDataString[] hostmodeNameData;
    HashMap m_EmuToId = new HashMap();

    public SJmoDataChange(int iOemType) {
        this.m_iOemType = iOemType;
    }

    @Override
    public ArrayList getFileNameListEx(int iOeminf, RJDataControl DC) {
        if (this.FileNameList == null) {
            String strLang = "_en";
            this.FileNameList = new ArrayList();
            this.FileNameList.add("porttype");
            if ((iOeminf & 0xFF0000) == 65536) {
                this.FileNameList.add("hostmode");
            } else {
                this.FileNameList.add("hostmode_HP");
            }
            this.FileNameList.add("fibreaddress");
            this.FileNameList.add("topology");
            this.FileNameList.add("RAIDLEVEL");
            this.FileNameList.add("devname");
            this.FileNameList.add("ErrorMessage");
            if ((iOeminf & 0xFF) == 3) {
                this.FileNameList.add("Portname");
            } else {
                this.FileNameList.add("PortnameRKModel");
            }
            this.FileNameList.add("ClientMessage");
            this.FileNameList.add("Rsim");
            this.FileNameList.add("LUNfibreaddress");
            if ((iOeminf & 0xFF0000) == 65536) {
                if ((iOeminf & 0xFF00) == 16384) {
                    this.FileNameList.add("guidlist" + strLang);
                } else {
                    this.FileNameList.add("guidlist_J" + strLang);
                }
            } else if ((iOeminf & 0xFF00) == 16384) {
                this.FileNameList.add("guidlist_HP" + strLang);
            } else {
                this.FileNameList.add("guidlist_HPJ" + strLang);
            }
            this.FileNameList.add("e_typeinfo");
            this.FileNameList.add("e_typegroup");
            this.FileNameList.add("e_typerestrict_A");
            this.FileNameList.add("HDDCONFJAV");
            this.FileNameList.add("e_typerestrict_H");
            this.FileNameList.add("e_typerestrict_D");
            this.FileNameList.add("MsgIndex");
            if ((iOeminf & 0xFF0000) == 65536) {
                if ((iOeminf & 0xFF00) == 16384) {
                    this.FileNameList.add("ClientIMessage" + strLang);
                    this.FileNameList.add("ServerIMessage" + strLang);
                } else {
                    this.FileNameList.add("ClientIMessage_J" + strLang);
                    this.FileNameList.add("ServerIMessage_J" + strLang);
                }
            } else if ((iOeminf & 0xFF00) == 16384) {
                this.FileNameList.add("ClientIMessage_HP" + strLang);
                this.FileNameList.add("ServerIMessage_HP" + strLang);
            } else {
                this.FileNameList.add("ClientIMessage_HPJ" + strLang);
                this.FileNameList.add("ServerIMessage_HPJ" + strLang);
            }
            this.FileNameList.add("HostModeOpt");
            this.FileNameList.add("Targetname");
            this.FileNameList.add("EmulationID");
        }
        return this.FileNameList;
    }

    public void makeDataChangeTable(ArrayList dataList) {
        this.CreateData(dataList);
        this.ProductnameData = (ChangeDataAllString[])dataList.get(5);
        this.hostmodeNameData = (ChangeDataString[])dataList.get(21);
        this.m_EmuToId.clear();
        ChangeDataString[] emuTmp = this.getEmulationIDData();
        if (null != emuTmp) {
            for (int iEmu = 0; iEmu < emuTmp.length; ++iEmu) {
                this.m_EmuToId.put(emuTmp[iEmu].strChangeData1, new Integer(emuTmp[iEmu].nMibData));
            }
        } else {
            SJmoUtility.putLogDetail("SJmoDataChange", "makeDataChangeTable", "Emulation ID Failed");
        }
    }

    @Override
    public String ChangeProductName(RJDataControl dc) {
        boolean bLoop = true;
        int wkCnt = 0;
        ArrayList chgData = new ArrayList();
        String rtnString = new String("");
        String Type2 = Integer.toHexString(this.m_iOemType);
        while (bLoop && wkCnt < this.ProductnameData.length) {
            if (this.ProductnameData[wkCnt].strMibData.indexOf(Type2) != -1) {
                rtnString = this.ProductnameData[wkCnt].strChangeData1;
                bLoop = false;
                continue;
            }
            ++wkCnt;
        }
        return rtnString;
    }

    public String getHostModeName(int iHostModeOptNo) {
        boolean bLoop = true;
        int wkCnt = 0;
        String rtnString = RJComDef.N_A;
        while (bLoop && wkCnt < this.hostmodeNameData.length) {
            if (iHostModeOptNo == this.hostmodeNameData[wkCnt].nMibData) {
                rtnString = this.hostmodeNameData[wkCnt].strChangeData1;
                bLoop = false;
                continue;
            }
            ++wkCnt;
        }
        return rtnString;
    }

    @Override
    public RJDataMsg getDefaultError(int iPos, int iErrCode, int iErrLevel) {
        RJDataMsg retObj = null;
        retObj = new RJDataMsg("An Error occurred.", "Art-Mess.gif", iPos, iErrCode, iErrLevel);
        return retObj;
    }

    public int getEmulationId(String strEmu) {
        Integer intTmp;
        int iRet = -1;
        if (!this.m_EmuToId.isEmpty() && null != (intTmp = (Integer)this.m_EmuToId.get(strEmu))) {
            iRet = intTmp;
        }
        return iRet;
    }

    public boolean isOemType(int iCheckOemType) {
        boolean bVender = false;
        boolean bLang = false;
        switch (iCheckOemType & 0xFF0000) {
            case 0: {
                bVender = true;
                break;
            }
            case 65536: {
                if ((this.m_iOemType & 0xFF0000) != 65536) break;
                bVender = true;
                break;
            }
            case 131072: {
                if ((this.m_iOemType & 0xFF0000) != 131072) break;
                bVender = true;
            }
        }
        switch (iCheckOemType & 0xFF00) {
            case 0: {
                bLang = true;
                break;
            }
            case 16384: {
                if ((this.m_iOemType & 0xFF00) != 16384) break;
                bLang = true;
                break;
            }
            case 61440: {
                if ((this.m_iOemType & 0xFF00) == 28672) {
                    bLang = true;
                    break;
                }
                if ((this.m_iOemType & 0xFF00) != 32768) break;
                bLang = true;
            }
        }
        return bVender && bLang;
    }
}

