/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.device;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import java.util.Arrays;
import sanproject.serverux.dataimpl.RJiPortInfoDetail;
import sanproject.serverux.dataimpl.RJiPortInfoDetailEx;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiDataMacro;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJmoPortDetail
extends SJmoPortIndex
implements SJmoData_IF,
SJmoKeyValueDefine_IF {
    static final long serialVersionUID = -6359448683609437288L;
    private String strPortDisplayName = "";
    private String strPortKindName = "";
    private byte byPortKindNo = (byte)-1;
    private short sPortFibreAddress = (short)-1;
    private byte byPortFibreTopology = (byte)-1;
    private byte[] byPortWWN = new byte[8];
    private byte byUserChannelSpeed = (byte)-1;
    private byte byDKCChannelSpeed = (byte)-1;
    private boolean bPortSecuritySwitch = false;
    private int iVPortMode = 0;
    private short[] sVPortIDs = new short[0];
    private int[] iV4IPAddress = new int[4];
    private int[] iV4NetMaskAddress = new int[4];
    private int[] iV4GateWayAddress = new int[4];
    private boolean bV6Mode = false;
    private boolean bV6LinkAddressMode = false;
    private int[] iV6LinkAddressManual = new int[8];
    private int[] iV6LinkAddressAuto = new int[8];
    private int iV6LinkAddressStatus = -1;
    private boolean bV6GlobalAddressMode = false;
    private int[] iV6GlobalAddressManual = new int[8];
    private int[] iV6GlobalAddressAuto = new int[8];
    private int iV6GlobalAddressStatus = -1;
    private int[] iV6GateWayAddress = new int[8];
    private int[] iV6GateWayAddressCurrent = new int[8];
    private int iV6GateWayAddressStatus = -1;
    private int[] iV6GlobalAddress2Manual = new int[8];
    private int[] iV6GlobalAddress2Auto = new int[8];
    private int iV6GlobalAddress2Status = -1;
    private int iV6SubnetPrefixSize = -1;
    private int iTcpPortNumber = -1;
    private boolean bAvailableSelectiveACK = false;
    private boolean bAvailableDelayedACK = false;
    private int iTcpWindowSize = -1;
    private int iMtuSize = -1;
    private int iLinkedMtuSize = -1;
    private int[] iMACAddress = new int[6];
    private boolean bAvailableVlanTagging = false;
    private int iVlanId = -1;
    private int iKeepAliveTimer = -1;
    private boolean bIsnsServerMode = false;
    private int iIsnsIpType = -1;
    private int[] iIsnsV4Address = new int[4];
    private int[] iIsnsV6Address = new int[8];
    private int iIsnsTcpPortNumber = -1;
    private String strIscsiName = "";
    private String strUserName = "";
    private String strSecret = "";
    private int iT10Pi = -1;
    private byte sfpDataTransferRate = (byte)-1;

    public void setStrPortDisplayName(String strPortDisplayName) {
        this.strPortDisplayName = strPortDisplayName;
    }

    public void setStrPortKindName(String strPortKindName) {
        this.strPortKindName = strPortKindName;
    }

    public void setByPortKindNo(byte byPortKindNo) {
        this.byPortKindNo = byPortKindNo;
    }

    public void setSPortFibreAddress(short portFibreAddress) {
        this.sPortFibreAddress = portFibreAddress;
    }

    public void setByPortFibreTopology(byte byPortFibreTopology) {
        this.byPortFibreTopology = byPortFibreTopology;
    }

    public void setByPortWWN(byte[] byPortWWN) {
        this.byPortWWN = byPortWWN;
    }

    public void setByUserChannelSpeed(byte byUserChannelSpeed) {
        this.byUserChannelSpeed = byUserChannelSpeed;
    }

    public void setByDKCChannelSpeed(byte byDKCChannelSpeed) {
        this.byDKCChannelSpeed = byDKCChannelSpeed;
    }

    public void setBPortSecuritySwitch(boolean portSecuritySwitch) {
        this.bPortSecuritySwitch = portSecuritySwitch;
    }

    public void setIV4IPAddress(int[] iV4IPAddress) {
        this.iV4IPAddress = iV4IPAddress;
    }

    public void setIV4NetMaskAddress(int[] iV4NetMaskAddress) {
        this.iV4NetMaskAddress = iV4NetMaskAddress;
    }

    public void setIV4GateWayAddress(int[] iV4GateWayAddress) {
        this.iV4GateWayAddress = iV4GateWayAddress;
    }

    public void setBV6Mode(boolean bV6Mode) {
        this.bV6Mode = bV6Mode;
    }

    public void setBV6LinkAddressMode(boolean bV6LinkAddressMode) {
        this.bV6LinkAddressMode = bV6LinkAddressMode;
    }

    public void setIV6LinkAddressManual(int[] iV6LinkAddressManual) {
        this.iV6LinkAddressManual = iV6LinkAddressManual;
    }

    public void setIV6LinkAddressAuto(int[] iV6LinkAddressAuto) {
        this.iV6LinkAddressAuto = iV6LinkAddressAuto;
    }

    public void setIV6LinkAddressStatus(int iV6LinkAddressStatus) {
        this.iV6LinkAddressStatus = iV6LinkAddressStatus;
    }

    public void setBV6GlobalAddressMode(boolean bV6GlobalAddressMode) {
        this.bV6GlobalAddressMode = bV6GlobalAddressMode;
    }

    public void setIV6GlobalAddressManuals(int[] iV6GlobalAddressManual) {
        this.iV6GlobalAddressManual = iV6GlobalAddressManual;
    }

    public void setIV6GlobalAddressAuto(int[] iV6GlobalAddressAuto) {
        this.iV6GlobalAddressAuto = iV6GlobalAddressAuto;
    }

    public void setIV6GlobalAddressStatus(int iV6GlobalAddressStatus) {
        this.iV6GlobalAddressStatus = iV6GlobalAddressStatus;
    }

    public void setIV6GlobalAddress2Manuals(int[] iV6GlobalAddress2Manual) {
        this.iV6GlobalAddress2Manual = iV6GlobalAddress2Manual;
    }

    public void setIV6GlobalAddress2Auto(int[] iV6GlobalAddress2Auto) {
        this.iV6GlobalAddress2Auto = iV6GlobalAddress2Auto;
    }

    public void setIV6GlobalAddress2Status(int iV6GlobalAddress2Status) {
        this.iV6GlobalAddress2Status = iV6GlobalAddress2Status;
    }

    public void setIV6GateWayAddress(int[] iV6GateWayAddress) {
        this.iV6GateWayAddress = iV6GateWayAddress;
    }

    public void setIV6GateWayAddressCurrent(int[] iV6GateWayAddressCurrent) {
        this.iV6GateWayAddressCurrent = iV6GateWayAddressCurrent;
    }

    public void setIV6GateWayAddressStatus(int iV6GateWayAddressStatus) {
        this.iV6GateWayAddressStatus = iV6GateWayAddressStatus;
    }

    public void setIV6SubnetPrefixSize(int iV6SubnetPrefixSize) {
        this.iV6SubnetPrefixSize = iV6SubnetPrefixSize;
    }

    public void setITcpPortNumber(int iTcpPortNumber) {
        this.iTcpPortNumber = iTcpPortNumber;
    }

    public void setBAvailableSelectiveACK(boolean bAvailableSelectiveACK) {
        this.bAvailableSelectiveACK = bAvailableSelectiveACK;
    }

    public void setBAvailableDelayedACK(boolean bAvailableDelayedACK) {
        this.bAvailableDelayedACK = bAvailableDelayedACK;
    }

    public void setITcpWindowSize(int iTcpWindowSize) {
        this.iTcpWindowSize = iTcpWindowSize;
    }

    public void setIMtuSize(int iMtuSize) {
        this.iMtuSize = iMtuSize;
    }

    public void setILinkedMtuSize(int iLinkedMtuSize) {
        this.iLinkedMtuSize = iLinkedMtuSize;
    }

    public void setIMACAddress(int[] iMACAddress) {
        this.iMACAddress = iMACAddress;
    }

    public void setBAvailableVlanTagging(boolean bAvailableVlanTagging) {
        this.bAvailableVlanTagging = bAvailableVlanTagging;
    }

    public void setIVLANID(int iVlanId) {
        this.iVlanId = iVlanId;
    }

    public void setIKeepAliveTimer(int iKeepAliveTimer) {
        this.iKeepAliveTimer = iKeepAliveTimer;
    }

    public void setBIsnsServerMode(boolean bIsnsServerMode) {
        this.bIsnsServerMode = bIsnsServerMode;
    }

    public void setIIsnsIpType(int iIsnsIpType) {
        this.iIsnsIpType = iIsnsIpType;
    }

    public void setIIsnsV4Address(int[] iIsnsV4Address) {
        this.iIsnsV4Address = iIsnsV4Address;
    }

    public void setIIsnsV6Address(int[] iIsnsV6Address) {
        this.iIsnsV6Address = iIsnsV6Address;
    }

    public void setIIsnsTcpPortNumber(int iIsnsTcpPortNumber) {
        this.iIsnsTcpPortNumber = iIsnsTcpPortNumber;
    }

    public String getStrPortDisplayName() {
        return this.strPortDisplayName;
    }

    public String getStrPortKindName() {
        return this.strPortKindName;
    }

    public byte getByPortKindNo() {
        return this.byPortKindNo;
    }

    public short getSPortFibreAddress() {
        return this.sPortFibreAddress;
    }

    public byte getByPortFibreTopology() {
        return this.byPortFibreTopology;
    }

    public byte[] getByPortWWN() {
        return this.byPortWWN;
    }

    public byte getByUserChannelSpeed() {
        return this.byUserChannelSpeed;
    }

    public byte getByDKCChannelSpeed() {
        return this.byDKCChannelSpeed;
    }

    public boolean isBPortSecuritySwitch() {
        return this.bPortSecuritySwitch;
    }

    public int[] getIV4IPAddress() {
        return this.iV4IPAddress;
    }

    public int[] getIV4NetMaskAddress() {
        return this.iV4NetMaskAddress;
    }

    public int[] getIV4GateWayAddress() {
        return this.iV4GateWayAddress;
    }

    public boolean getBV6Mode() {
        return this.bV6Mode;
    }

    public boolean getBV6LinkAddressMode() {
        return this.bV6LinkAddressMode;
    }

    public int[] getIV6LinkAddressManual() {
        return this.iV6LinkAddressManual;
    }

    public int[] getIV6LinkAddressAuto() {
        return this.iV6LinkAddressAuto;
    }

    public int getIV6LinkAddressStatus() {
        return this.iV6LinkAddressStatus;
    }

    public boolean getBV6GlobalAddressMode() {
        return this.bV6GlobalAddressMode;
    }

    public int[] getIV6GlobalAddressManual() {
        return this.iV6GlobalAddressManual;
    }

    public int[] getIV6GlobalAddressAuto() {
        return this.iV6GlobalAddressAuto;
    }

    public int getIV6GlobalAddressStatus() {
        return this.iV6GlobalAddressStatus;
    }

    public int[] getIV6GlobalAddress2Manual() {
        if (this.iV6GlobalAddress2Manual == null) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        }
        return this.iV6GlobalAddress2Manual;
    }

    public int[] getIV6GlobalAddress2Auto() {
        if (this.iV6GlobalAddress2Auto == null) {
            return new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        }
        return this.iV6GlobalAddress2Auto;
    }

    public int getIV6GlobalAddress2Status() {
        return this.iV6GlobalAddress2Status;
    }

    public int[] getIV6GateWayAddress() {
        return this.iV6GateWayAddress;
    }

    public int[] getIV6GateWayAddressCurrent() {
        return this.iV6GateWayAddressCurrent;
    }

    public int getIV6GateWayAddressStatus() {
        return this.iV6GateWayAddressStatus;
    }

    public int getIV6SubnetPrefixSize() {
        return this.iV6SubnetPrefixSize;
    }

    public int getITcpPortNumber() {
        return this.iTcpPortNumber;
    }

    public boolean getBAvailableSelectiveACK() {
        return this.bAvailableSelectiveACK;
    }

    public boolean getBAvailableDelayedACK() {
        return this.bAvailableDelayedACK;
    }

    public int getITcpWindowSize() {
        return this.iTcpWindowSize;
    }

    public int getIMtuSize() {
        return this.iMtuSize;
    }

    public int getILinkedMtuSize() {
        return this.iLinkedMtuSize;
    }

    public int[] getIMACAddress() {
        return this.iMACAddress;
    }

    public boolean getBAvailableVlanTagging() {
        return this.bAvailableVlanTagging;
    }

    public int getIVlanId() {
        return this.iVlanId;
    }

    public int getiKeepAliveTimer() {
        return this.iKeepAliveTimer;
    }

    public boolean getBIsnsServerMode() {
        return this.bIsnsServerMode;
    }

    public int getIIsnsIpType() {
        return this.iIsnsIpType;
    }

    public int[] getIIsnsV4Address() {
        return this.iIsnsV4Address;
    }

    public int[] getIIsnsV6Address() {
        return this.iIsnsV6Address;
    }

    public int getIIsnsTcpPortNumber() {
        return this.iIsnsTcpPortNumber;
    }

    public String getStrIscsiName() {
        return this.strIscsiName;
    }

    public void setStrIscsiName(String strIscsiName) {
        this.strIscsiName = strIscsiName;
    }

    public String getStrUserName() {
        return this.strUserName;
    }

    public void setStrUserName(String strUserName) {
        this.strUserName = strUserName;
    }

    public String getStrSecret() {
        if (null != this.strSecret && this.strSecret.length() != 0) {
            return SJcSecureUty.decryptStrToStr(this.strSecret);
        }
        return this.strSecret;
    }

    public void setStrSecret(String strSecret) {
        this.strSecret = null != strSecret && strSecret.length() != 0 ? SJcSecureUty.encryptStrToStr(strSecret) : strSecret;
    }

    public int getIT10Pi() {
        return this.iT10Pi;
    }

    public void setIT10Pi(int pi) {
        this.iT10Pi = pi;
    }

    public int getIVPortMode() {
        return this.iVPortMode;
    }

    public void setIVPortMode(int vpmode) {
        this.iVPortMode = vpmode;
    }

    public short getSVPortCount() {
        return (short)this.sVPortIDs.length;
    }

    public short[] getSVPortIDs() {
        return this.sVPortIDs;
    }

    public void setSVPortIDs(short[] vpIDs) {
        int len = SJctrIscsiDataMacro.VIRTUAL_PORT_MAX;
        if (len > vpIDs.length) {
            len = vpIDs.length;
        }
        this.sVPortIDs = Arrays.copyOf(vpIDs, len);
    }

    public byte getSFPDataTransferRate() {
        return this.sfpDataTransferRate;
    }

    public void setSFPDataTransferRate(byte sfpDataTransferRate) {
        this.sfpDataTransferRate = sfpDataTransferRate;
    }

    public SJmoPortDetail() {
    }

    public SJmoPortDetail(RJiPortInfoDetail rmiData) throws SJmoException {
        if (null == rmiData) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoPortDetail", "SJmoPortDetail");
        }
        this.setAllData(rmiData);
    }

    public void setAllData(RJiPortInfoDetail rmiData) throws SJmoException {
        if (null != rmiData) {
            this.setSPort(rmiData.getSPort());
            this.getIndexKey();
            if (null != rmiData.getStrPortDisplayName()) {
                this.setStrPortDisplayName(rmiData.getStrPortDisplayName());
            }
            if (null != rmiData.getStrPortKindName()) {
                this.setStrPortKindName(rmiData.getStrPortKindName());
            }
            this.setByPortKindNo(rmiData.getByPortKindNo());
            this.setSPortFibreAddress(rmiData.getSPortFibreAddress());
            this.setByPortFibreTopology(rmiData.getByPortFibreTopology());
            if (null != rmiData.getByPortWWN()) {
                this.setByPortWWN(rmiData.getByPortWWN());
            }
            this.setByUserChannelSpeed(rmiData.getByUserChannelSpeed());
            this.setByDKCChannelSpeed(rmiData.getByDKCChannelSpeed());
            this.setBPortSecuritySwitch(rmiData.isBPortSecuritySwitch());
            if (rmiData instanceof RJiPortInfoDetailEx) {
                RJiPortInfoDetailEx rmiDataEx = (RJiPortInfoDetailEx)rmiData;
                this.setIT10Pi(rmiDataEx.getT10pi());
                this.setSFPDataTransferRate(rmiDataEx.getSFPDataTransferRate());
            } else {
                SJmoUtility.putLogDetail("SJmoPortDetail", "setAllData", "rmiData cast error");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoPortDetail", "setAllData");
        }
    }

    public void setIscsiPortData(SanObject iscsiPortData) {
        block4: {
            try {
                if (null != iscsiPortData) {
                    SanObject ipv4Obj = iscsiPortData.getObj("Ipv4");
                    this.setIV4IPAddress(ipv4Obj.getIntArray("IpAddress"));
                    this.setIV4NetMaskAddress(ipv4Obj.getIntArray("SubNetMask"));
                    this.setIV4GateWayAddress(ipv4Obj.getIntArray("DefaultGateway"));
                    SanObject ipv6Obj = iscsiPortData.getObj("Ipv6");
                    this.setBV6Mode(ipv6Obj.getBoolean("Available"));
                    SanObject linkLocalAddr = ipv6Obj.getObj("LinkLocalAddress");
                    this.setBV6LinkAddressMode(linkLocalAddr.getBoolean("AutoMode"));
                    this.setIV6LinkAddressManual(linkLocalAddr.getIntArray("ManualAddress"));
                    SanObject globalAddr = ipv6Obj.getObj("GlobalAddress");
                    this.setBV6GlobalAddressMode(globalAddr.getBoolean("AutoMode"));
                    this.setIV6GlobalAddressManuals(globalAddr.getIntArray("ManualAddress"));
                    SanObject globalAddr2 = ipv6Obj.getObj("GlobalAddress2");
                    this.setIV6GlobalAddress2Manuals(globalAddr2.getIntArray("ManualAddress"));
                    SanObject defGateAddr = ipv6Obj.getObj("DefaultGateway");
                    this.setIV6GateWayAddress(defGateAddr.getIntArray("AssignedAddress"));
                    this.setITcpPortNumber(iscsiPortData.getInt("TcpPortNumber"));
                    this.setBAvailableSelectiveACK(iscsiPortData.getBoolean("AvailableSelectiveAck"));
                    this.setBAvailableDelayedACK(iscsiPortData.getBoolean("AvailableDelayedAck"));
                    this.setITcpWindowSize(iscsiPortData.getInt("TcpWindowSize"));
                    SanObject ethernetMtu = iscsiPortData.getObj("EthernetMtuSize");
                    this.setIMtuSize(ethernetMtu.getInt("Mtu"));
                    SanObject vLan = iscsiPortData.getObj("Vlan");
                    this.setBAvailableVlanTagging(vLan.getBoolean("AvailableTagging"));
                    this.setIVLANID(vLan.getInt("Id"));
                    this.setIKeepAliveTimer(iscsiPortData.getInt("KeepAliveTimer"));
                    SanObject isnsServer = iscsiPortData.getObj("iSnsServer");
                    this.setBIsnsServerMode(isnsServer.getBoolean("Enabled"));
                    this.setIIsnsIpType(isnsServer.getInt("IpType"));
                    this.setIIsnsV4Address(isnsServer.getIntArray("Ipv4Address"));
                    this.setIIsnsV6Address(isnsServer.getIntArray("Ipv6Address"));
                    this.setIIsnsTcpPortNumber(isnsServer.getInt("TcpPortNumber"));
                    this.setIVPortMode(iscsiPortData.getInt("VirtualPortMode"));
                    SanList iscsiVirtualPortList = iscsiPortData.getList("iScsiVirtualPorts");
                    this.sVPortIDs = new short[iscsiVirtualPortList.size()];
                    int sVportListIndex = 0;
                    for (SanObject iscsiVirtualPortInfo : iscsiVirtualPortList) {
                        this.sVPortIDs[sVportListIndex] = (short)iscsiVirtualPortInfo.getInt("Id");
                        sVportListIndex = (short)(sVportListIndex + 1);
                    }
                    break block4;
                }
                throw SJmoUtility.getException(201, 23, 107000, "SJmoPortDetail", "setIscsiPortData");
            }
            catch (SanDataException sdEx) {
                throw SJmoUtility.getException(201, 23, 107000, "SJmoPortDetail", "setIscsiPortData");
            }
        }
    }

    public void setIscsiPortCurrentData(SanObject iscsiPortCurData) {
        try {
            if (null != iscsiPortCurData) {
                if (this.getBV6Mode()) {
                    SanObject ipv6Obj = iscsiPortCurData.getObj("Ipv6");
                    SanObject linkLocalAddr = ipv6Obj.getObj("LinkLocalAddress");
                    if (this.getBV6LinkAddressMode()) {
                        this.setIV6LinkAddressAuto(linkLocalAddr.getIntArray("AutoAddress"));
                    }
                    this.setIV6LinkAddressStatus(linkLocalAddr.getInt("StatusCode"));
                    SanObject globalAddr = ipv6Obj.getObj("GlobalAddress");
                    if (this.getBV6GlobalAddressMode()) {
                        this.setIV6GlobalAddressAuto(globalAddr.getIntArray("AutoAddress"));
                    }
                    this.setIV6GlobalAddressStatus(globalAddr.getInt("StatusCode"));
                    SanObject globalAddr2 = ipv6Obj.getObj("GlobalAddress2");
                    if (this.getBV6GlobalAddressMode()) {
                        this.setIV6GlobalAddress2Auto(globalAddr2.getIntArray("AutoAddress"));
                    }
                    this.setIV6GlobalAddress2Status(globalAddr2.getInt("StatusCode"));
                    SanObject defGateAddr = ipv6Obj.getObj("DefaultGateway");
                    this.setIV6GateWayAddressCurrent(defGateAddr.getIntArray("CurrentAddress"));
                    this.setIV6GateWayAddressStatus(defGateAddr.getInt("StatusCode"));
                    this.setIV6SubnetPrefixSize(ipv6Obj.getInt("SubnetPrefixSize"));
                }
            } else {
                throw SJmoUtility.getException(201, 23, 107000, "SJmoPortDetail", "setIscsiPortCurrentData");
            }
            SanObject ethernetMtu = iscsiPortCurData.getObj("EthernetMtuSize");
            this.setILinkedMtuSize(ethernetMtu.getInt("LinkedMtu"));
            this.setIMACAddress(iscsiPortCurData.getIntArray("MacAddress"));
        }
        catch (SanDataException sdEx) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoPortDetail", "setIscsiPortCurrentData");
        }
    }

    public void setIscsiPortInitiatorData(SanObject iscsiPortInitiatorData) {
        try {
            if (null != iscsiPortInitiatorData) {
                SanObject iscsiInitiator = iscsiPortInitiatorData.getObj("iScsiInitiator");
                this.setStrIscsiName(iscsiInitiator.getString("Name"));
                SanObject iscsiUser = iscsiInitiator.getObj("iScsiUser");
                this.setStrUserName(iscsiUser.getString("UserId"));
                this.setStrSecret(iscsiUser.getString("Secret"));
            }
        }
        catch (SanDataException sdEx) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoPortDetail", "setIscsiPortInitiatorData");
        }
    }
}

