/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.lu;

import java.util.ArrayList;
import java.util.BitSet;
import sanproject.common.Robj_interface_RJiWWN;
import sanproject.serverux.dataimpl.RJiHostGroup;
import sanproject.serverux.dataimpl.RJiWWN;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoHostGroupInfo
extends SJmoPortIndex
implements SJmoData_IF {
    static final long serialVersionUID = -3549556862990952359L;
    private short sHostGroup = (short)-1;
    private String strHostgroupNickName = "";
    private byte byHostMode = (byte)-1;
    private String strHostModeDisplayName = "";
    private BitSet btOption = new BitSet(64);
    private ArrayList alHostGroupWwn = new ArrayList();
    private String strHtgIndexKey = "";

    @Override
    public void setSPort(short sPort) {
        super.setSPort(sPort);
        this.strHtgIndexKey = "";
    }

    public void setSHostGroup(short hostGroup) {
        this.sHostGroup = hostGroup;
        this.strHtgIndexKey = "";
    }

    public void setStrHostgroupNickName(String strHostgroupNickName) {
        this.strHostgroupNickName = strHostgroupNickName;
    }

    public void setByHostMode(byte byHostMode) {
        this.byHostMode = byHostMode;
    }

    public void setStrHostModeDisplayName(String strHostModeDisplayName) {
        this.strHostModeDisplayName = strHostModeDisplayName;
    }

    public void setBtOption(BitSet btOption) {
        this.btOption = btOption;
    }

    public void setAlHostGroupWwn(ArrayList alHostGroupWwn) {
        this.alHostGroupWwn = alHostGroupWwn;
    }

    public short getSHostGroup() {
        return this.sHostGroup;
    }

    public String getStrHostgroupNickName() {
        return this.strHostgroupNickName;
    }

    public byte getByHostMode() {
        return this.byHostMode;
    }

    public String getStrHostModeDisplayName() {
        return this.strHostModeDisplayName;
    }

    public BitSet getBtOption() {
        return this.btOption;
    }

    public ArrayList getAlHostGroupWwn() {
        return this.alHostGroupWwn;
    }

    public SJmoHostGroupInfo() {
    }

    public SJmoHostGroupInfo(RJiHostGroup rmiData, short sPort) throws SJmoException {
        if (null == rmiData) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoHostGroupInfo", "SJmoHostGroupInfo");
        }
        this.setAllData(rmiData, sPort);
    }

    public SJmoHostGroupInfo(byte byDataMode) {
        this.setIDataMode(byDataMode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAllData(RJiHostGroup rmiData, short sPort) throws SJmoException {
        Robj_interface_RJiWWN[] wwnTmp;
        if (null == rmiData) throw SJmoUtility.getException(201, 23, 107000, "SJmoHostGroupInfo", "setAllData");
        this.setSPort(sPort);
        this.setSHostGroup(rmiData.getSHostgroupID());
        this.getIndexKey();
        if (null != rmiData.getStrHostgroupNickName()) {
            this.setStrHostgroupNickName(rmiData.getStrHostgroupNickName());
        }
        this.setByHostMode(rmiData.getByHostMode());
        if (null != rmiData.getStrHostModeDisplayName()) {
            this.setStrHostModeDisplayName(rmiData.getStrHostModeDisplayName());
        }
        if (null != rmiData.getBtOption()) {
            this.setBtOption(rmiData.getBtOption());
        }
        if (null == (wwnTmp = rmiData.getObjWWN())) throw SJmoUtility.getException(201, 23, 107000, "SJmoHostGroupInfo", "setAllData");
        for (int iWwnCnt = 0; iWwnCnt < wwnTmp.length; ++iWwnCnt) {
            if (null != wwnTmp[iWwnCnt]) {
                SJmoWwn wwnInf = new SJmoWwn((RJiWWN)wwnTmp[iWwnCnt]);
                this.getAlHostGroupWwn().add(wwnInf);
                continue;
            }
            SJmoUtility.putLog("The array element is illegal. Array element number = [" + iWwnCnt + "] : SJmoHostGroupInfo");
        }
    }

    @Override
    public int getIndex() {
        int iHtgIndex = -1;
        iHtgIndex = this.sPort << 8 | this.sHostGroup;
        return iHtgIndex;
    }

    @Override
    public String getIndexKey() {
        if (0 == this.strHtgIndexKey.length()) {
            this.strHtgIndexKey = this.makeIndexKey();
        }
        return this.strHtgIndexKey;
    }

    @Override
    public boolean isValidIndex() {
        boolean bRet = true;
        if (super.isValidIndex()) {
            if (0 > this.sHostGroup || SJmoDataMacro_IF.NUM_MAX_HTG < this.sHostGroup) {
                bRet = false;
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    @Override
    public String makeIndexKey() {
        String strKey = "";
        if (this.isValidIndex()) {
            strKey = SJmoUtility.itoh(this.getIndex(), 4);
        }
        return strKey;
    }

    @Override
    public int compareTo(Object KeyObj) {
        if (KeyObj instanceof SJmoHostGroupInfo) {
            return this.getIndex() - ((SJmoHostGroupInfo)KeyObj).getIndex();
        }
        return this.getIndexKey().compareTo(KeyObj.toString());
    }

    @Override
    public String toString() {
        return this.getIndexKey();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoHostGroupInfo retObj = (SJmoHostGroupInfo)super.clone();
        retObj.setAlHostGroupWwn(SJmoDataUtility.alDeepCopy(retObj.getAlHostGroupWwn()));
        retObj.setBtOption((BitSet)this.btOption.clone());
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

