/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.lu;

import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.inf.SJmoDataIndex_IF;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoLuIndex
extends SJmoHostGroupIndex
implements SJmoDataIndex_IF {
    private static final long serialVersionUID = -818102169646247875L;
    private int iLUN = -1;
    protected int iLuIndex = -1;
    protected String strLuIndexKey = "";

    public int getILUN() {
        return this.iLUN;
    }

    @Override
    public void setSPort(short sPort) {
        super.setSPort(sPort);
        this.initIndex();
    }

    @Override
    public void setSHostGroup(short sHostGroup) {
        super.setSHostGroup(sHostGroup);
        this.initIndex();
    }

    public void setILUN(int ilun) {
        this.iLUN = ilun;
        this.initIndex();
    }

    protected void initIndex() {
        this.iLuIndex = this.sPort << 24 | this.sHostGroup << 16 | this.iLUN;
        this.strLuIndexKey = "";
    }

    @Override
    public int getIndex() {
        return this.iLuIndex;
    }

    @Override
    public String getIndexKey() {
        if (this.strLuIndexKey.length() == 0) {
            this.strLuIndexKey = this.makeIndexKey();
        }
        return this.strLuIndexKey;
    }

    @Override
    public boolean isNumKey() {
        return true;
    }

    @Override
    public boolean isValidIndex() {
        boolean bRet = true;
        if (super.isValidIndex()) {
            if (this.iLUN < 0 || SJmoDataMacro_IF.NUM_MAX_LUN < this.iLUN) {
                bRet = false;
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    @Override
    public String makeIndexKey() {
        String strRet = "";
        int iDigit = 8;
        if (this.isValidIndex()) {
            strRet = SJmoUtility.itoh(this.getIndex(), iDigit, false);
        }
        return strRet;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof SJmoLuIndex) {
            return this.getIndex() - ((SJmoLuIndex)o).getIndex();
        }
        return this.getIndexKey().compareTo(o.toString());
    }

    @Override
    public String toString() {
        return this.getIndexKey();
    }
}

