/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.remote.manager;

import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoDataMgr_IF;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationLuPath;
import sanproject.sn2.model.data.util.SJmoLdevUtility;
import sanproject.sn2.model.data.util.SJmoRemoteReplicationUtility;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoUniversalReplicatorPairVolInfoMgr
extends SJmoModelData_Base
implements SJmoDataMgr_IF {
    private static final long serialVersionUID = -1570855577433635290L;
    private SJmoReplicationPairVolInfo[] pairVolInfoList = new SJmoReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];

    public SJmoUniversalReplicatorPairVolInfoMgr() {
    }

    public SJmoUniversalReplicatorPairVolInfoMgr(SJmoReplicationPairVolInfo[] PairVolInfo) {
        if (null == PairVolInfo) {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.setPairVolInfoList(PairVolInfo);
    }

    public SJmoReplicationPairVolInfo getPairVolInfo(int iLdevIndex) {
        SJmoReplicationPairVolInfo retPairVol = null;
        if (SJmoLdevUtility.isValidLdevId(iLdevIndex)) {
            retPairVol = this.pairVolInfoList[iLdevIndex];
        }
        return retPairVol;
    }

    public SJmoReplicationPairVolInfo getPairVolInfo(SJmoLdevIndex ldevIndex) {
        return this.getPairVolInfo(ldevIndex.getIndex());
    }

    public SJmoReplicationPairVolInfo[] getPairVolInfoList() {
        return this.pairVolInfoListCopy(this.pairVolInfoList);
    }

    public SJmoReplicationPairVolInfo getPairVolInfo(SJmoRemoteReplicationLuPath moLuPath, String strDeviceNumber, int iDevice) {
        SJmoReplicationPairVolInfo retPairVol = null;
        for (int iPairCnt = 0; iPairCnt < this.pairVolInfoList.length; ++iPairCnt) {
            if (this.pairVolInfoList[iPairCnt] == null) continue;
            SJmoReplicationPairVolInfo pairVol = this.pairVolInfoList[iPairCnt];
            if (SJmoRemoteReplicationUtility.isPairVolInfo(pairVol.getAlPVolIndex(), moLuPath, strDeviceNumber, iDevice)) {
                retPairVol = pairVol;
                break;
            }
            if (!SJmoRemoteReplicationUtility.isPairVolInfo(pairVol.getAlSVolIndex(), moLuPath, strDeviceNumber, iDevice)) continue;
            retPairVol = pairVol;
            break;
        }
        return retPairVol;
    }

    public void setPairVolInfo(SJmoReplicationPairVolInfo pairVol) {
        if (SJmoLdevUtility.isValidLdevId(pairVol.getIndex())) {
            this.pairVolInfoList[pairVol.getIndex()] = pairVol;
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setPairVolInfo", "pairVol LDEVID# invalid:" + pairVol.getIndex());
        }
    }

    public void setPairVolInfoList(SJmoReplicationPairVolInfo[] pairVolInfoList) {
        this.pairVolInfoList = pairVolInfoList;
    }

    private SJmoReplicationPairVolInfo[] getShallowPairVolInfoList() {
        return this.pairVolInfoList;
    }

    private SJmoReplicationPairVolInfo[] pairVolInfoListCopy(SJmoReplicationPairVolInfo[] pairVolInfoList) {
        return this.pairVolInfoListClone(pairVolInfoList, false);
    }

    private SJmoReplicationPairVolInfo[] pairVolInfoListDeepCopy(SJmoReplicationPairVolInfo[] pairVolInfoList) {
        return this.pairVolInfoListClone(pairVolInfoList, true);
    }

    private SJmoReplicationPairVolInfo[] pairVolInfoListClone(SJmoReplicationPairVolInfo[] srcList, boolean bPairVolInfoDeepCopy) {
        SJmoReplicationPairVolInfo[] retList = null;
        if (null != srcList) {
            retList = new SJmoReplicationPairVolInfo[srcList.length];
            for (int iListCnt = 0; iListCnt < srcList.length; ++iListCnt) {
                if (bPairVolInfoDeepCopy) {
                    if (null == srcList[iListCnt]) continue;
                    try {
                        retList[iListCnt] = (SJmoReplicationPairVolInfo)srcList[iListCnt].clone();
                    }
                    catch (Exception e) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "pairVolInfoListClone", "clone failed iListCnt =" + iListCnt + e.toString());
                    }
                    continue;
                }
                retList[iListCnt] = srcList[iListCnt];
            }
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "pairVolInfoListClone", "srcList is null.");
        }
        return retList;
    }

    @Override
    public Object getToOutSideObj() {
        Object retObj = null;
        try {
            retObj = super.clone();
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getToOutSideObj", "Exception " + e.toString());
        }
        return retObj;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoUniversalReplicatorPairVolInfoMgr retObj = (SJmoUniversalReplicatorPairVolInfoMgr)super.clone();
        retObj.setPairVolInfoList(retObj.pairVolInfoListDeepCopy(retObj.getShallowPairVolInfoList()));
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

