/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.modelrc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.client.com.RJComDef;
import sanproject.sn2.base.system.inf.SJbaseSystemInterface;
import sanproject.sn2.base.system.inf.SJbaseSystemStatusInterface;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.controller.com.SJctrQueueController;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.SJmoSNBaseStatusInterface;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRscUtil_IF;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;
import sanproject.sn2.model.data.volume.SJmoVdevLdevInfo;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.modelrc.SJmoRscDataMgr;
import sanproject.sn2.modelrc.util.SJmoRscLbaComparator;
import sanproject.sn2.modelrc.util.SJmoRscUtil;
import sanproject.sn2.modelrc.util.SJmoRscUtilClpr;
import sanproject.sn2.modelrc.util.SJmoRscUtilExPathGrp;
import sanproject.sn2.modelrc.util.SJmoRscUtilHostGrp;
import sanproject.sn2.modelrc.util.SJmoRscUtilInnerPg;
import sanproject.sn2.modelrc.util.SJmoRscUtilIscsiTarget;
import sanproject.sn2.modelrc.util.SJmoRscUtilLdev;
import sanproject.sn2.modelrc.util.SJmoRscUtilLocalReplication;
import sanproject.sn2.modelrc.util.SJmoRscUtilLun;
import sanproject.sn2.modelrc.util.SJmoRscUtilPdev;
import sanproject.sn2.modelrc.util.SJmoRscUtilPg;
import sanproject.sn2.modelrc.util.SJmoRscUtilPool;
import sanproject.sn2.modelrc.util.SJmoRscUtilSsid;

public class SJmoRscMgr
implements SJbaseSystemInterface {
    private SJmoRscDataMgr m_RscData = null;
    private SJmoGetAgent m_ModelAgent = null;
    private int m_iRscStatus = 0;
    private SJmoException m_moExp = null;
    private Object m_ObjStatus = null;
    private SJmoDataChange m_dataChg = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        SJmoUtility.putLogDetail("SJmoRscMgr", "initialize", "Start");
        boolean bInit = true;
        this.m_moExp = null;
        this.m_iRscStatus = 1;
        boolean bModelReadyFlg = false;
        try {
            SJmoModelMgr modelMgr = SJmoModelMgr.getModelMgr();
            SJmoUtility.putLogDetail("SJmoRscMgr", "initialize", "Model Check Start:");
            block14: while (!bModelReadyFlg) {
                switch (this.m_iRscStatus) {
                    case 2: 
                    case 11: {
                        SJmoUtility.putLogDetail("SJmoRscMgr", "initialize", "Return");
                        return;
                    }
                }
                SJbaseSystemStatusInterface ModelStatus = modelMgr.getStatus();
                switch (ModelStatus.getPhase()) {
                    case 2: 
                    case 4: {
                        bModelReadyFlg = true;
                        continue block14;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception jvExp) {
                    SJmoUtility.putLogDetail("SJmoRscMgr", "initialize", "SleepTimer Exception:");
                    jvExp.printStackTrace();
                }
            }
            this.m_RscData = new SJmoRscDataMgr();
            this.m_ObjStatus = new Object();
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoRscMgr", "initialize", "initialize failed:" + exp.toString());
            bInit = false;
        }
        finally {
            if (bInit) {
                this.m_iRscStatus = 2;
            } else {
                this.m_iRscStatus = 9;
                this.m_moExp = SJmoUtility.getException(201, 23, 107003, "SJmoRscMgr", "initialize");
            }
        }
        SJmoUtility.putLogDetail("SJmoRscMgr", "initialize", "End");
    }

    @Override
    public void abort_initialize() {
        SJmoUtility.putLogDetail("SJmoRscMgr", "abort_initialize", "Start");
        this.m_RscData = null;
        this.m_ModelAgent = null;
        this.m_moExp = null;
        this.m_iRscStatus = 0;
        this.m_ObjStatus = null;
        SJmoUtility.putLogDetail("SJmoRscMgr", "abort_initialize", "End");
    }

    @Override
    public void finish() {
        SJmoUtility.putLogDetail("SJmoRscMgr", "finish", "Start");
        this.m_iRscStatus = 10;
        this.m_RscData = null;
        this.m_ModelAgent = null;
        this.m_moExp = null;
        this.m_ObjStatus = null;
        this.m_iRscStatus = 11;
        SJmoUtility.putLogDetail("SJmoRscMgr", "finish", "End");
    }

    @Override
    public void abort_finish() {
        SJmoUtility.putLogDetail("SJmoRscMgr", "abort_finish", "Start");
        this.finish();
        SJmoUtility.putLogDetail("SJmoRscMgr", "abort_finish", "End");
    }

    @Override
    public SJbaseSystemStatusInterface getStatus() {
        SJmoSNBaseStatusInterface rscsStatus = new SJmoSNBaseStatusInterface();
        switch (this.m_iRscStatus) {
            case 0: {
                rscsStatus.setPhase(0);
                rscsStatus.setFatal(false);
                break;
            }
            case 1: {
                rscsStatus.setPhase(1);
                rscsStatus.setFatal(false);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                rscsStatus.setPhase(2);
                rscsStatus.setFatal(false);
                break;
            }
            case 9: {
                rscsStatus.setPhase(0);
                rscsStatus.setFatal(false);
                rscsStatus.setReqRetry(true);
                break;
            }
            case 10: {
                rscsStatus.setPhase(3);
                rscsStatus.setFatal(false);
                break;
            }
            case 11: {
                rscsStatus.setPhase(4);
                rscsStatus.setFatal(false);
                break;
            }
            default: {
                rscsStatus.setPhase(2);
                rscsStatus.setFatal(false);
            }
        }
        return rscsStatus;
    }

    public static SJmoRscMgr getInstance() throws SJmoException {
        SJmoRscMgr rscMgr = null;
        Object objTmp = SJcSingletonManagerUty.getInstance(SJmoRscMgr.class);
        if (null != objTmp && objTmp instanceof SJmoRscMgr) {
            rscMgr = (SJmoRscMgr)objTmp;
        } else {
            SJmoUtility.putLogDetail("SJmoRscMgr", "getInstance", "get instance failed FuncID=201 ModuleID=23 MsgID=108000");
        }
        return rscMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDiffData(List lsDiffList) throws SJmoException {
        block50: {
            SJmoUtility.putLogDetail("SJmoRscMgr", "setDiffData", "Start");
            mdlMgr = SJmoModelMgr.getModelMgr();
            this.m_ModelAgent = mdlMgr.getDataAgent();
            try {
                if (null != this.m_moExp) {
                    SJmoUtility.putLogDetail("SJmoRscMgr", "setDiffData", "m_moExp is not null. FuncID=" + this.m_moExp.getMsg().getFunctionID() + " ModuleID=" + this.m_moExp.getMsg().getModuleID() + " MsgID=" + this.m_moExp.getMsg().getMsgID());
                    throw this.m_moExp;
                }
                if (null == lsDiffList) ** GOTO lbl82
                iRtyTimCnt = 0;
                bLockflg = true;
                while (bLockflg) {
                    if (450000 <= iRtyTimCnt) {
                        this.m_iRscStatus = 8;
                        this.m_moExp = SJmoUtility.getException(201, 23, 107023, "SJmoRscMgr", "setDiffData");
                        throw this.m_moExp;
                    }
                    var5_7 = this.m_ObjStatus;
                    synchronized (var5_7) {
                        switch (this.m_iRscStatus) {
                            case 0: 
                            case 1: 
                            case 10: 
                            case 11: {
                                SJmoUtility.putLogDetail("SJmoRscMgr", "setDiffData", "SJmoRscMgr is not ready");
                                return;
                            }
                            case 2: {
                                this.m_iRscStatus = 3;
                                bLockflg = false;
                                break;
                            }
                            case 8: 
                            case 9: {
                                SJmoUtility.putLogDetail("SJmoRscMgr", "setDiffData", "m_iRscStatus is RSC_DATAFAILED or RSC_RSCMGRFAILED. FuncID=" + this.m_moExp.getMsg().getFunctionID() + " ModuleID=" + this.m_moExp.getMsg().getModuleID() + " MsgID=" + this.m_moExp.getMsg().getMsgID());
                                throw this.m_moExp;
                            }
                        }
                    }
                    try {
                        Thread.sleep(200L);
                        iRtyTimCnt += 200;
                    }
                    catch (InterruptedException intExp) {
                        SJmoUtility.putLogDetail("SJmoRscMgr", "setDiffData", "Thread Interrupted");
                    }
                }
                ldevDtlList = new ArrayList<SJmoLdevDetail>();
                ssidDtlList = new ArrayList<SJmoSsidDetail>();
                poolDtlList = new ArrayList<SJmoPoolDetail>();
                pgInfList = new ArrayList<SJmoExDPgInfo>();
                pathGrpInfList = new ArrayList<SJmoExdPathGroupInfo>();
                lunDtlList = new ArrayList<SJmoPortLunDetail>();
                hostGrpInf = new ArrayList<SJmoHostGroupInfo>();
                vdevDtlList = new ArrayList<SJmoVdevDetail>();
                localPairList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
                clprList = new ArrayList<SJmoClprInfo>();
                iscsiTgList = new ArrayList<SJmoIscsiTargetInfo>();
                pgDetailList = new ArrayList<SJmoPgDetail>();
                pdevDetailList = new ArrayList<SJmoPdevDetail>();
                iList1Cnt = 0;
lbl50:
                // 2 sources

                while (true) {
                    if (iList1Cnt < lsDiffList.size()) {
                        obj1 = lsDiffList.get(iList1Cnt);
                        if (null == obj1 || !(obj1 instanceof List)) break block50;
                        objList = (List)obj1;
                        break;
                    }
                    if (0 != ldevDtlList.size()) {
                        this.chkLdevID(ldevDtlList);
                    }
                    if (0 != ssidDtlList.size()) {
                        this.chkSsid(ssidDtlList);
                    }
                    if (0 != poolDtlList.size()) {
                        this.chkPoolID(poolDtlList);
                    }
                    if (0 != pgInfList.size()) {
                        this.chkPgID(pgInfList);
                    }
                    if (0 != pathGrpInfList.size()) {
                        this.chkExPathGrpID(pathGrpInfList);
                    }
                    if (0 != lunDtlList.size()) {
                        this.chkLunID(lunDtlList);
                    }
                    if (0 != hostGrpInf.size()) {
                        this.chkHostGrpID(hostGrpInf);
                    }
                    if (0 != vdevDtlList.size()) {
                        this.chkLdevLba(vdevDtlList);
                    }
                    if (0 != localPairList.size()) {
                        this.chkLocalReplicationMu(localPairList);
                    }
                    if (0 != clprList.size()) {
                        this.chkClprID(clprList);
                    }
                    if (0 != iscsiTgList.size()) {
                        this.chkIscsiTargetID(iscsiTgList);
                    }
                    if (0 != pgDetailList.size()) {
                        this.chkInnnerPg(pgDetailList);
                    }
                    if (0 != pdevDetailList.size()) {
                        this.chkPdev(pdevDetailList);
                    }
lbl82:
                    // 4 sources

                    this.m_RscData.registDiffData(lsDiffList);
                    return;
                }
            }
            catch (SJmoException moExp) {
                throw moExp;
            }
            catch (Exception exp) {
                SJmoUtility.putLogDetail("SJmoRscMgr", "setDiffData", "setDiffData catch Exception:" + exp.toString());
                this.m_moExp = SJmoUtility.getException(201, 23, 107003, "SJmoRscMgr", "setDiffData");
                throw this.m_moExp;
            }
            finally {
                if (3 == this.m_iRscStatus) {
                    this.m_iRscStatus = 2;
                }
                SJmoUtility.putLogDetail("SJmoRscMgr", "setDiffData", "End");
            }
            for (iList2Cnt = 0; iList2Cnt < objList.size(); ++iList2Cnt) {
                obj2 = objList.get(iList2Cnt);
                if (null == obj2 || !(obj2 instanceof ArrayList)) continue;
                aryList = (ArrayList)obj2;
                for (iAryListCnt = 0; iAryListCnt < aryList.size(); ++iAryListCnt) {
                    aryObj = aryList.get(iAryListCnt);
                    if (null == aryObj) continue;
                    if (aryObj instanceof SJmoLdevDetail) {
                        ldevDtlList.add((SJmoLdevDetail)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoSsidDetail) {
                        ssidDtlList.add((SJmoSsidDetail)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoPoolDetail) {
                        poolDtlList.add((SJmoPoolDetail)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoExDPgInfo) {
                        pgInfList.add((SJmoExDPgInfo)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoExdPathGroupInfo) {
                        pathGrpInfList.add((SJmoExdPathGroupInfo)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoPortLunDetail) {
                        lunDtlList.add((SJmoPortLunDetail)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoHostGroupInfo) {
                        hostGrpInf.add((SJmoHostGroupInfo)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoVdevDetail) {
                        vdevDtlList.add((SJmoVdevDetail)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoLocalReplicationPairVolInfo) {
                        localPairList.add((SJmoLocalReplicationPairVolInfo)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoClprInfo) {
                        clprList.add((SJmoClprInfo)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoIscsiTargetInfo) {
                        iscsiTgList.add((SJmoIscsiTargetInfo)aryObj);
                        continue;
                    }
                    if (aryObj instanceof SJmoPgDetail) {
                        pgDetailList.add((SJmoPgDetail)aryObj);
                        continue;
                    }
                    if (!(aryObj instanceof SJmoPdevDetail)) continue;
                    pdevDetailList.add((SJmoPdevDetail)aryObj);
                }
            }
        }
        ++iList1Cnt;
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delDiffData(List lsDiffList, int iReason) throws SJmoException {
        SJmoUtility.putLogDetail("SJmoRscMgr", "delDiffData", "Start");
        try {
            if (null != this.m_moExp) {
                return;
            }
            int iRtyTimCnt = 0;
            Boolean bLockflg = true;
            while (bLockflg.booleanValue()) {
                if (450000 <= iRtyTimCnt) {
                    this.m_iRscStatus = 8;
                    this.m_moExp = SJmoUtility.getException(201, 23, 107023, "SJmoRscMgr", "delDiffData");
                    throw this.m_moExp;
                }
                Object object = this.m_ObjStatus;
                synchronized (object) {
                    switch (this.m_iRscStatus) {
                        case 0: 
                        case 1: 
                        case 10: 
                        case 11: {
                            SJmoUtility.putLogDetail("SJmoRscMgr", "delDiffData", "SJmoRscMgr is not ready");
                            return;
                        }
                        case 2: {
                            this.m_iRscStatus = 4;
                            bLockflg = false;
                            break;
                        }
                        case 5: {
                            if (0 != iReason) break;
                            this.m_iRscStatus = 4;
                            bLockflg = false;
                            break;
                        }
                        case 8: 
                        case 9: {
                            SJmoUtility.putLogDetail("SJmoRscMgr", "delDiffData", "m_iRscStatus is RSC_DATAFAILED or RSC_RSCMGRFAILED. FuncID=" + this.m_moExp.getMsg().getFunctionID() + " ModuleID=" + this.m_moExp.getMsg().getModuleID() + " MsgID=" + this.m_moExp.getMsg().getMsgID());
                            throw this.m_moExp;
                        }
                    }
                }
                try {
                    Thread.sleep(200L);
                    iRtyTimCnt += 200;
                }
                catch (InterruptedException inpExp) {
                    SJmoUtility.putLogDetail("SJmoRscMgr", "delDiffData", "Thread Interrupted");
                }
            }
            this.m_RscData.rejectDiffData(lsDiffList);
            return;
        }
        catch (SJmoException moExp) {
            throw moExp;
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoRscMgr", "delDiffData", "delDiffData catch Exception:" + exp.toString());
            this.m_moExp = SJmoUtility.getException(201, 23, 107003, "SJmoRscMgr", "delDiffData");
            throw this.m_moExp;
        }
        finally {
            if (4 == this.m_iRscStatus) {
                this.m_iRscStatus = 2;
            }
            SJmoUtility.putLogDetail("SJmoRscMgr", "delDiffData", "End");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshDiffData() throws SJmoException {
        SJmoUtility.putLogDetail("SJmoRscMgr", "refreshDiffData", "Start");
        try {
            Object mdlMgr;
            int iErrLv = -1;
            if (null != this.m_moExp) {
                mdlMgr = SJmoModelMgr.getModelMgr();
                if (null == mdlMgr) {
                    this.m_moExp = SJmoUtility.getException(201, 23, 107003, "SJmoRscMgr", "refreshDiffData");
                    throw this.m_moExp;
                }
                SJdsSupplierMgr supMgr = ((SJmoModelMgr)mdlMgr).getSupplierMgr();
                if (null == supMgr) {
                    this.m_moExp = SJmoUtility.getException(201, 23, 107003, "SJmoRscMgr", "refreshDiffData");
                    throw this.m_moExp;
                }
                iErrLv = SJmoUtility.getModelErrLevel(this.m_moExp, supMgr);
            }
            if (1 == iErrLv) {
                SJmoUtility.putLogDetail("SJmoRscMgr", "refreshDiffData", "m_moExp Error Level 1. FuncID=" + this.m_moExp.getMsg().getFunctionID() + " ModuleID=" + this.m_moExp.getMsg().getModuleID() + " MsgID=" + this.m_moExp.getMsg().getMsgID());
                throw this.m_moExp;
            }
            mdlMgr = this.m_ObjStatus;
            synchronized (mdlMgr) {
                switch (this.m_iRscStatus) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        this.m_iRscStatus = 7;
                        break;
                    }
                    case 9: {
                        SJmoUtility.putLogDetail("SJmoRscMgr", "refreshDiffData", "m_iRscStatus is RSC_RSCMGRFAILED. FuncID=" + this.m_moExp.getMsg().getFunctionID() + " ModuleID=" + this.m_moExp.getMsg().getModuleID() + " MsgID=" + this.m_moExp.getMsg().getMsgID());
                        throw this.m_moExp;
                    }
                }
            }
            this.m_RscData.clearDiffData();
            SJctrQueueController queCtr = SJctrQueueController.getInstance();
            List<SJctrTask> taskList = queCtr.getTaskList();
            if (null != taskList) {
                for (int iListCnt = 0; iListCnt < taskList.size(); ++iListCnt) {
                    SJctrTask task;
                    SJctrTask obj = taskList.get(iListCnt);
                    if (null == obj || !(task = obj).isPreExecute()) continue;
                    List<List<ArrayList<? extends SJmoModelData_Base>>> diffData = task.getResourceDiff();
                    this.m_RscData.registDiffData(diffData);
                }
            }
            this.m_moExp = null;
            return;
        }
        catch (SJmoException moExp) {
            throw moExp;
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoRscMgr", "refreshDiffData", "refreshDiffData catch Exception:" + exp.toString());
            this.m_moExp = SJmoUtility.getException(201, 23, 107003, "SJmoRscMgr", "refreshDiffData");
            throw this.m_moExp;
        }
        finally {
            if (7 == this.m_iRscStatus) {
                this.m_iRscStatus = 2;
            }
            SJmoUtility.putLogDetail("SJmoRscMgr", "refreshDiffData", "End");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SJmoRscUtil getRscUtil(SJmoGetRscUtil_IF utlKind) throws SJmoException {
        SJmoUtility.putLogDetail("SJmoRscMgr", "getRscUtil", "Start");
        try {
            SJmoRscUtil retRscUtl = null;
            SJmoModelMgr mdlMgr = SJmoModelMgr.getModelMgr();
            this.m_ModelAgent = mdlMgr.getDataAgent();
            int iUtlID = utlKind.getgetRscUtilKind();
            switch (iUtlID) {
                case 0: {
                    retRscUtl = new SJmoRscUtilLdev();
                    break;
                }
                case 1: {
                    retRscUtl = new SJmoRscUtilSsid();
                    break;
                }
                case 2: {
                    retRscUtl = new SJmoRscUtilPool();
                    break;
                }
                case 3: {
                    retRscUtl = new SJmoRscUtilPg();
                    break;
                }
                case 4: {
                    retRscUtl = new SJmoRscUtilExPathGrp();
                    break;
                }
                case 5: {
                    retRscUtl = new SJmoRscUtilLun();
                    break;
                }
                case 6: {
                    retRscUtl = new SJmoRscUtilHostGrp();
                    break;
                }
                case 7: {
                    retRscUtl = new SJmoRscUtilLocalReplication();
                    break;
                }
                case 8: {
                    retRscUtl = new SJmoRscUtilClpr();
                    break;
                }
                case 9: {
                    retRscUtl = new SJmoRscUtilIscsiTarget();
                    break;
                }
                case 10: {
                    retRscUtl = new SJmoRscUtilInnerPg();
                    break;
                }
                case 11: {
                    retRscUtl = new SJmoRscUtilPdev();
                    break;
                }
                default: {
                    throw SJmoUtility.getException(201, 23, 107000, "SJmoRscMgr", "getRscUtil");
                }
            }
            List rscGetList = retRscUtl.getNeccessityCls();
            List mdlDataList = this.m_ModelAgent.getDataInf(rscGetList);
            retRscUtl.setModelData(mdlDataList);
            int iRtyTimCnt = 0;
            boolean bLockflg = true;
            while (bLockflg) {
                if (450000 <= iRtyTimCnt) {
                    this.m_iRscStatus = 8;
                    this.m_moExp = SJmoUtility.getException(201, 23, 107023, "SJmoRscMgr", "getRscUtil");
                    throw this.m_moExp;
                }
                Object object = this.m_ObjStatus;
                synchronized (object) {
                    switch (this.m_iRscStatus) {
                        case 0: 
                        case 1: 
                        case 10: 
                        case 11: {
                            SJmoUtility.putLogDetail("SJmoRscMgr", "getRscUtil", "SJmoRscMgr is not ready");
                            SJmoRscUtil sJmoRscUtil = retRscUtl;
                            return sJmoRscUtil;
                        }
                        case 2: {
                            this.m_iRscStatus = 6;
                            bLockflg = false;
                            break;
                        }
                        case 8: 
                        case 9: {
                            SJmoUtility.putLogDetail("SJmoRscMgr", "getRscUtil", "m_iRscStatus is RSC_DATAFAILED or RSC_RSCMGRFAILED. FuncID=" + this.m_moExp.getMsg().getFunctionID() + " ModuleID=" + this.m_moExp.getMsg().getModuleID() + " MsgID=" + this.m_moExp.getMsg().getMsgID());
                            throw this.m_moExp;
                        }
                    }
                }
                try {
                    Thread.sleep(200L);
                    iRtyTimCnt += 200;
                }
                catch (InterruptedException inpExp) {
                    SJmoUtility.putLogDetail("SJmoRscMgr", "getRscUtil", "Thread Interrupted");
                }
            }
            SJmoGetKind_IF[] getKindList = this.getKindList(rscGetList);
            List diffDataList = this.m_RscData.getDiffData(getKindList);
            retRscUtl.setDiffData(diffDataList);
            SJmoRscUtil sJmoRscUtil = retRscUtl;
            return sJmoRscUtil;
        }
        catch (SJmoException moExp) {
            throw moExp;
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoRscMgr", "getRscUtil", "getRscUtil catch Exception" + exp.toString());
            this.m_moExp = SJmoUtility.getException(201, 23, 107003, "SJmoRscMgr", "getRscUtil");
            throw this.m_moExp;
        }
        finally {
            if (6 == this.m_iRscStatus) {
                this.m_iRscStatus = 2;
            }
            SJmoUtility.putLogDetail("SJmoRscMgr", "getRscUtil", "End");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rcvModelUpdate() throws SJmoException {
        SJmoUtility.putLogDetail("SJmoRscMgr", "rcvModelUpdate", "Start");
        if (null != this.m_moExp) {
            SJmoUtility.putLogDetail("SJmoRscMgr", "rcvModelUpdate", "m_moExp is not null. FuncID=" + this.m_moExp.getMsg().getFunctionID() + " ModuleID=" + this.m_moExp.getMsg().getModuleID() + " MsgID=" + this.m_moExp.getMsg().getMsgID());
            throw this.m_moExp;
        }
        int iRtyTimCnt = 0;
        boolean bLockflg = true;
        while (bLockflg) {
            if (450000 <= iRtyTimCnt) {
                this.m_iRscStatus = 8;
                this.m_moExp = SJmoUtility.getException(201, 23, 107023, "SJmoRscMgr", "rcvModelUpdate");
                throw this.m_moExp;
            }
            Object object = this.m_ObjStatus;
            synchronized (object) {
                switch (this.m_iRscStatus) {
                    case 0: 
                    case 1: 
                    case 10: 
                    case 11: {
                        SJmoUtility.putLogDetail("SJmoRscMgr", "rcvModelUpdate", "SJmoRscMgr is not ready");
                        return;
                    }
                    case 2: {
                        this.m_iRscStatus = 5;
                        bLockflg = false;
                        break;
                    }
                    case 8: 
                    case 9: {
                        SJmoUtility.putLogDetail("SJmoRscMgr", "rcvModelUpdate", "m_iRscStatus is RSC_DATAFAILED or RSC_RSCMGRFAILED. FuncID=" + this.m_moExp.getMsg().getFunctionID() + " ModuleID=" + this.m_moExp.getMsg().getModuleID() + " MsgID=" + this.m_moExp.getMsg().getMsgID());
                        throw this.m_moExp;
                    }
                }
            }
            try {
                Thread.sleep(200L);
                iRtyTimCnt += 200;
            }
            catch (InterruptedException inpExp) {
                SJmoUtility.putLogDetail("SJmoRscMgr", "rcvModelUpdate", "Thread Interrupted");
            }
            catch (Exception e) {
                SJmoUtility.putLogDetail("SJmoRscMgr", "rcvModelUpdate", "rcvModelUpdate catch Exception" + e.toString());
                this.m_moExp = SJmoUtility.getException(201, 23, 107003, "SJmoRscMgr", "rcvModelUpdate");
                throw this.m_moExp;
            }
        }
        SJmoUtility.putLogDetail("SJmoRscMgr", "rcvModelUpdate", "End");
    }

    private SJmoGetKind_IF[] getKindList(List getDrctList) {
        SJmoGetKind_IF[] retGetKindList = new SJmoGetKind_IF[getDrctList.size()];
        for (int iListCnt = 0; iListCnt < getDrctList.size(); ++iListCnt) {
            SJmoGetKind_IF getKind;
            Object obj = getDrctList.get(iListCnt);
            if (!(obj instanceof SJmoGetDirect)) continue;
            SJmoGetDirect getDrct = (SJmoGetDirect)obj;
            retGetKindList[iListCnt] = getKind = getDrct.getGetKind();
        }
        return retGetKindList;
    }

    private void chkLdevID(List<SJmoLdevDetail> ldevDtlList) throws SJmoException {
        int iEmuGrp = -1;
        int iEmuTypeTmp = -1;
        SJmoRscUtilLdev ldevRscUtl = new SJmoRscUtilLdev();
        List ldevRscGetList = ldevRscUtl.getNeccessityCls();
        List ldevMdlDataList = this.m_ModelAgent.getDataInf(ldevRscGetList);
        ldevRscUtl.setModelData(ldevMdlDataList);
        SJmoGetKind_IF[] ldevGetKindList = this.getKindList(ldevRscGetList);
        List ldevDiffDataList = this.m_RscData.getDiffData(ldevGetKindList);
        ldevRscUtl.setDiffData(ldevDiffDataList);
        ArrayList pgInfList = new ArrayList();
        for (int iListCnt = 0; iListCnt < ldevDtlList.size(); ++iListCnt) {
            SJmoLdevDetail ldevDtl = ldevDtlList.get(iListCnt);
            int iRetLdevID = 0;
            if (ldevDtl.getIDataMode() == 3) {
                iRetLdevID = ldevRscUtl.chkEquipLdevID(ldevDtl);
            } else {
                int iEmuType = ldevDtl.getIEmulationType();
                if (iEmuTypeTmp != iEmuType) {
                    iEmuGrp = this.getEmuGroup(iEmuType);
                    iEmuTypeTmp = iEmuType;
                }
                iRetLdevID = ldevRscUtl.chkLdevID(ldevDtl, iEmuGrp);
            }
            if (0 == iRetLdevID) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkLdevID");
        }
    }

    private void chkLdevLba(List<SJmoVdevDetail> vdevDtlList) throws SJmoException {
        SJmoRscUtilLdev ldevRscUtl = new SJmoRscUtilLdev();
        List ldevRscGetList = ldevRscUtl.getNeccessityCls();
        List ldevMdlDataList = this.m_ModelAgent.getDataInf(ldevRscGetList);
        ldevRscUtl.setModelData(ldevMdlDataList);
        SJmoGetKind_IF[] ldevGetKindList = this.getKindList(ldevRscGetList);
        List ldevDiffDataList = this.m_RscData.getDiffData(ldevGetKindList);
        ldevRscUtl.setDiffData(ldevDiffDataList);
        List lsDiffVdev = ldevRscUtl.getRsvVdevInfo();
        ArrayList alDiffVdev = (ArrayList)lsDiffVdev.get(0);
        if (null != alDiffVdev && alDiffVdev.size() > 0) {
            for (int iListCnt = 0; iListCnt < vdevDtlList.size(); ++iListCnt) {
                SJmoVdevDetail chkVdev = vdevDtlList.get(iListCnt);
                int iVdevChk = Collections.binarySearch(alDiffVdev, chkVdev);
                if (iVdevChk < 0) continue;
                SJmoVdevDetail diffVdev = (SJmoVdevDetail)alDiffVdev.get(iVdevChk);
                ArrayList alDiffVdevLdev = diffVdev.getAlVdevLdev();
                ArrayList alChkVdevLdev = chkVdev.getAlVdevLdev();
                for (int iVdevLdevCnt = 0; iVdevLdevCnt < alChkVdevLdev.size(); ++iVdevLdevCnt) {
                    long lBeforeLBAEnd;
                    SJmoVdevLdevInfo diffVdevLdevBefore;
                    SJmoVdevLdevInfo chkVdevLdev = (SJmoVdevLdevInfo)alChkVdevLdev.get(iVdevLdevCnt);
                    long lChkStartLBA = chkVdevLdev.getLStartLba();
                    long lChkEndLBA = lChkStartLBA + chkVdevLdev.getLTotalLbaSize();
                    int iVdevLdevChk = Collections.binarySearch(alDiffVdevLdev, chkVdevLdev, new SJmoRscLbaComparator());
                    if (iVdevLdevChk >= 0) {
                        throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkLdevLba");
                    }
                    int iSetLba = -1 * iVdevLdevChk - 1;
                    if (iSetLba < alDiffVdevLdev.size()) {
                        if (iSetLba == 0) {
                            SJmoVdevLdevInfo diffVdevLdevNext = (SJmoVdevLdevInfo)alDiffVdevLdev.get(iSetLba);
                            if (lChkEndLBA < diffVdevLdevNext.getLStartLba()) continue;
                            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkLdevLba");
                        }
                        if (iSetLba <= 0) continue;
                        diffVdevLdevBefore = (SJmoVdevLdevInfo)alDiffVdevLdev.get(iSetLba - 1);
                        lBeforeLBAEnd = diffVdevLdevBefore.getLStartLba() + diffVdevLdevBefore.getLTotalLbaSize();
                        SJmoVdevLdevInfo diffVdevLdevNext = (SJmoVdevLdevInfo)alDiffVdevLdev.get(iSetLba);
                        if (lChkStartLBA > lBeforeLBAEnd && lChkEndLBA < diffVdevLdevNext.getLStartLba()) continue;
                        throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkLdevLba");
                    }
                    if (iSetLba != alDiffVdevLdev.size() || lChkStartLBA > (lBeforeLBAEnd = (diffVdevLdevBefore = (SJmoVdevLdevInfo)alDiffVdevLdev.get(iSetLba - 1)).getLStartLba() + diffVdevLdevBefore.getLTotalLbaSize())) continue;
                    throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkLdevLba");
                }
            }
        }
    }

    private void chkSsid(List<SJmoSsidDetail> ssidDtlList) throws SJmoException {
        SJmoRscUtilSsid ssidRscUtl = new SJmoRscUtilSsid();
        List ssidRscGetList = ssidRscUtl.getNeccessityCls();
        List ssidMdlDataList = this.m_ModelAgent.getDataInf(ssidRscGetList);
        ssidRscUtl.setModelData(ssidMdlDataList);
        SJmoGetKind_IF[] ssidGetKindList = this.getKindList(ssidRscGetList);
        List ssidDiffDataList = this.m_RscData.getDiffData(ssidGetKindList);
        ssidRscUtl.setDiffData(ssidDiffDataList);
        for (int iListCnt = 0; iListCnt < ssidDtlList.size(); ++iListCnt) {
            short sLdev;
            short sCu;
            short sLdkc;
            SJmoSsidDetail ssidDtl = ssidDtlList.get(iListCnt);
            int iSsid = ssidDtl.getSSID();
            int iRetSsID = ssidRscUtl.chkSsid(iSsid, sLdkc = ssidDtl.getLDKC(), sCu = ssidDtl.getCU(), sLdev = ssidDtl.getStartLDEV());
            if (0 == iRetSsID) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkSsid");
        }
    }

    private void chkPoolID(List<SJmoPoolDetail> poolDtlList) throws SJmoException {
        SJmoRscUtilPool poolRscUtl = new SJmoRscUtilPool();
        List poolRscGetList = poolRscUtl.getNeccessityCls();
        List poolMdlDataList = this.m_ModelAgent.getDataInf(poolRscGetList);
        poolRscUtl.setModelData(poolMdlDataList);
        SJmoGetKind_IF[] poolGetKindList = this.getKindList(poolRscGetList);
        List poolDiffDataList = this.m_RscData.getDiffData(poolGetKindList);
        poolRscUtl.setDiffData(poolDiffDataList);
        for (int iListCnt = 0; iListCnt < poolDtlList.size(); ++iListCnt) {
            SJmoPoolDetail poolDtl = poolDtlList.get(iListCnt);
            int iRetPoolID = poolRscUtl.chkPoolID(poolDtl);
            if (0 == iRetPoolID) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkPoolID");
        }
    }

    private void chkPgID(List<SJmoExDPgInfo> pgInfList) throws SJmoException {
        SJmoRscUtilPg pgRscUtl = new SJmoRscUtilPg();
        List pgRscGetList = pgRscUtl.getNeccessityCls();
        List pgMdlDataList = this.m_ModelAgent.getDataInf(pgRscGetList);
        pgRscUtl.setModelData(pgMdlDataList);
        SJmoGetKind_IF[] pgGetKindList = this.getKindList(pgRscGetList);
        List pgDiffDataList = this.m_RscData.getDiffData(pgGetKindList);
        pgRscUtl.setDiffData(pgDiffDataList);
        for (int iListCnt = 0; iListCnt < pgInfList.size(); ++iListCnt) {
            SJmoExDPgInfo pgInf = pgInfList.get(iListCnt);
            int iRetPgID = pgRscUtl.chkPgID(pgInf);
            if (0 == iRetPgID) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkPgID");
        }
    }

    private void chkExPathGrpID(List<SJmoExdPathGroupInfo> pathGrpInfList) throws SJmoException {
        SJmoRscUtilExPathGrp pathGrpRscUtl = new SJmoRscUtilExPathGrp();
        List pathGrpRscGetList = pathGrpRscUtl.getNeccessityCls();
        List pathGrpMdlDataList = this.m_ModelAgent.getDataInf(pathGrpRscGetList);
        pathGrpRscUtl.setModelData(pathGrpMdlDataList);
        SJmoGetKind_IF[] pathGrpGetKindList = this.getKindList(pathGrpRscGetList);
        List pathGrpDiffDataList = this.m_RscData.getDiffData(pathGrpGetKindList);
        pathGrpRscUtl.setDiffData(pathGrpDiffDataList);
        for (int iListCnt = 0; iListCnt < pathGrpInfList.size(); ++iListCnt) {
            SJmoExdPathGroupInfo pathGrpInf = pathGrpInfList.get(iListCnt);
            int iRetPathGrpID = pathGrpRscUtl.chkExPathGrpID(pathGrpInf);
            if (0 == iRetPathGrpID) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkExPathGrpID");
        }
    }

    private void chkLunID(List<SJmoPortLunDetail> lunDtlList) throws SJmoException {
        SJmoRscUtilLun lunRscUtl = new SJmoRscUtilLun();
        List lunRscGetList = lunRscUtl.getNeccessityCls();
        List lunMdlDataList = this.m_ModelAgent.getDataInf(lunRscGetList);
        lunRscUtl.setModelData(lunMdlDataList);
        SJmoGetKind_IF[] lunGetKindList = this.getKindList(lunRscGetList);
        List lunDiffDataList = this.m_RscData.getDiffData(lunGetKindList);
        lunRscUtl.setDiffData(lunDiffDataList);
        for (int iListCnt = 0; iListCnt < lunDtlList.size(); ++iListCnt) {
            SJmoPortLunDetail lunDtl = lunDtlList.get(iListCnt);
            int iRetLunID = lunRscUtl.chkLunID(lunDtl);
            if (0 == iRetLunID) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkLunID");
        }
    }

    private void chkHostGrpID(List<SJmoHostGroupInfo> hostGrpInfList) throws SJmoException {
        SJmoRscUtilHostGrp hostGrpRscUtl = new SJmoRscUtilHostGrp();
        List hostGrpRscGetList = hostGrpRscUtl.getNeccessityCls();
        List hostGrpMdlDataList = this.m_ModelAgent.getDataInf(hostGrpRscGetList);
        hostGrpRscUtl.setModelData(hostGrpMdlDataList);
        SJmoGetKind_IF[] hostGrpGetKindList = this.getKindList(hostGrpRscGetList);
        List hostGrpDiffDataList = this.m_RscData.getDiffData(hostGrpGetKindList);
        hostGrpRscUtl.setDiffData(hostGrpDiffDataList);
        for (int iListCnt = 0; iListCnt < hostGrpInfList.size(); ++iListCnt) {
            SJmoHostGroupInfo hostGrpInf = hostGrpInfList.get(iListCnt);
            int iRetHostGrpID = hostGrpRscUtl.chkHostGrpID(hostGrpInf);
            if (0 == iRetHostGrpID) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkHostGrpID");
        }
    }

    private void chkLocalReplicationMu(List<SJmoLocalReplicationPairVolInfo> pairList) throws SJmoException {
        int iPair;
        SJmoRscUtilLocalReplication rscUtilLocal = new SJmoRscUtilLocalReplication();
        List lsRscUtilGetList = rscUtilLocal.getNeccessityCls();
        List lsModelData = this.m_ModelAgent.getDataInf(lsRscUtilGetList);
        rscUtilLocal.setModelData(lsModelData);
        List lsResource = this.m_RscData.getDiffData(this.getKindList(lsRscUtilGetList));
        rscUtilLocal.setDiffData(lsResource);
        SJmoLocalReplicationPairVolInfo[] lsPair = new SJmoLocalReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        for (iPair = 0; iPair < pairList.size(); ++iPair) {
            SJmoLocalReplicationPairVolInfo volInfo;
            lsPair[volInfo.getIndex()] = volInfo = pairList.get(iPair);
        }
        for (iPair = 0; iPair < pairList.size(); ++iPair) {
            SJmoLocalReplicationPairVolInfo target = pairList.get(iPair);
            if (target.getAlSVolIndex().size() <= 0) continue;
            for (int iSvol = 0; iSvol < target.getAlSVolIndex().size(); ++iSvol) {
                SJmoLdevIndex pairVol = target.getAlSVolIndex().get(iSvol);
                if (null != lsPair[pairVol.getIndex()]) {
                    short sMu = lsPair[pairVol.getIndex()].getSMuNum();
                    int iMuChk = rscUtilLocal.chkMuId(target.getSLdkc(), target.getSCu(), target.getSLdev(), (short)2, (short)0, sMu);
                    if (iMuChk == 0) continue;
                    throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkLocalReplicationMu");
                }
                SJmoUtility.putLogDetail("chkLocalReplicationMu", "chkLocalReplicationMu", "S-VOL Info failed");
            }
        }
    }

    private void chkClprID(List<SJmoClprInfo> clprInfList) throws SJmoException {
        SJmoRscUtilClpr clprRscUtl = new SJmoRscUtilClpr();
        List clprRscGetList = clprRscUtl.getNeccessityCls();
        List clprMdlDataList = this.m_ModelAgent.getDataInf(clprRscGetList);
        clprRscUtl.setModelData(clprMdlDataList);
        SJmoGetKind_IF[] clprGetKindList = this.getKindList(clprRscGetList);
        List clprDiffDataList = this.m_RscData.getDiffData(clprGetKindList);
        clprRscUtl.setDiffData(clprDiffDataList);
        for (SJmoClprInfo clprInf : clprInfList) {
            int iChk = clprRscUtl.chkClprID(clprInf);
            if (0 == iChk) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkClprID");
        }
    }

    private void chkIscsiTargetID(List<SJmoIscsiTargetInfo> iscsiTgList) throws SJmoException {
        SJmoRscUtilIscsiTarget iscsiTgRscUtl = new SJmoRscUtilIscsiTarget();
        List<SJmoGetDirect> iscsiTgRscGetList = iscsiTgRscUtl.getNeccessityCls();
        List iscsiTgMdlDataList = this.m_ModelAgent.getDataInf(iscsiTgRscGetList);
        iscsiTgRscUtl.setModelData(iscsiTgMdlDataList);
        SJmoGetKind_IF[] iscsiTgGetKindList = this.getKindList(iscsiTgRscGetList);
        List iscsiTgDiffDataList = this.m_RscData.getDiffData(iscsiTgGetKindList);
        iscsiTgRscUtl.setDiffData(iscsiTgDiffDataList);
        for (SJmoIscsiTargetInfo iscsiTgInfo : iscsiTgList) {
            int iRetIscsiTgID = iscsiTgRscUtl.chkIscsiTargetID(iscsiTgInfo);
            if (0 == iRetIscsiTgID) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkIscsiTargetID");
        }
    }

    private void chkInnnerPg(List<SJmoPgDetail> pgDetailList) {
        SJmoRscUtilInnerPg pgRscUtil = new SJmoRscUtilInnerPg();
        List pgDirect = pgRscUtil.getNeccessityCls();
        List lsModel = this.m_ModelAgent.getDataInf(pgDirect);
        pgRscUtil.setModelData(lsModel);
        SJmoGetKind_IF[] pgGetKindList = this.getKindList(pgDirect);
        List lsDiff = this.m_RscData.getDiffData(pgGetKindList);
        pgRscUtil.setDiffData(lsDiff);
        for (SJmoPgDetail pgDetail : pgDetailList) {
            int iRet = pgRscUtil.chkPgID(pgDetail);
            if (0 == iRet) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkInnnerPg");
        }
    }

    private void chkPdev(List<SJmoPdevDetail> pdevDetailList) {
        SJmoRscUtilPdev pdevRscUtil = new SJmoRscUtilPdev();
        List pgDirect = pdevRscUtil.getNeccessityCls();
        List lsModel = this.m_ModelAgent.getDataInf(pgDirect);
        pdevRscUtil.setModelData(lsModel);
        SJmoGetKind_IF[] pgGetKindList = this.getKindList(pgDirect);
        List lsDiff = this.m_RscData.getDiffData(pgGetKindList);
        pdevRscUtil.setDiffData(lsDiff);
        for (SJmoPdevDetail pdevDetail : pdevDetailList) {
            int iRet = pdevRscUtil.chkCRID(pdevDetail);
            if (0 == iRet) continue;
            throw SJmoUtility.getException(201, 23, 107024, "SJmoRscMgr", "chkInnnerPg");
        }
    }

    @Override
    public boolean destroy() {
        return false;
    }

    private byte getEmuGroup(int iEmuType) {
        int byRet = -1;
        SJmoModelMgr modelMgr = SJmoModelMgr.getModelMgr();
        if (modelMgr == null) {
            byRet = -1;
        } else {
            String strEmuType;
            if (this.m_dataChg == null) {
                this.m_dataChg = modelMgr.getDataChange();
            }
            byRet = (strEmuType = this.m_dataChg.getEmulationTypeName(iEmuType)).equals("") || strEmuType == RJComDef.N_A ? -1 : (int)((byte)this.m_dataChg.getEmuGroup(strEmuType));
        }
        return (byte)byRet;
    }
}

