/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtDkaStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtELunInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMfDMInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtDkaReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Dka";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"dka", "module", "numberOfPgs", "numberOfLdevsTotal", "numberOfLdevsUnallocated", "totalLdevCapacity", "unallocatedLdevCapacity"};
    private static final String[] HM_HEADER_KEY_ARRAY = new String[]{"dkb", "numberOfPgs", "numberOfLdevsTotal", "numberOfLdevsUnallocated", "totalLdevCapacity", "unallocatedLdevCapacity"};
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Dka";
    private static final String EXPLANATION_KEY = "Common.explanation.Dka";
    private static final String TABLE_HEADER_BASE_KEY = "Dka.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Dka.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Dka.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Dka.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Dka.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Dka.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Dka.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            return HM_HEADER_KEY_ARRAY;
        }
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public List<String[]> getTableDataList() {
        String unallocatedLdevCapacity;
        List<String[]> ldevInfoUnallocatedRecordList;
        String totalLdevCapacity;
        List<String[]> ldevInfoRecordList;
        String[] oneRecord;
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        SJdtDkaStatusCSVWrapper dkaStatus = (SJdtDkaStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("DkaStatus.csv");
        SJdtELunInfoCSVWrapper eLunInfo = (SJdtELunInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ELunInfo.csv");
        SJdtMfDMInfoCSVWrapper mfDMInfo = (SJdtMfDMInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MfDMInfo.csv");
        if (eLunInfo.getCsvDataListSize() > 0) {
            if (SJdtRPTDTDevice.isHmdev()) {
                oneRecord = new String[HM_HEADER_KEY_ARRAY.length];
                oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"dkb")).intValue()] = "External";
            } else {
                oneRecord = new String[HEADER_KEY_ARRAY.length];
                oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"module")).intValue()] = "-";
                oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"dka")).intValue()] = "External";
            }
            List<String> eccGroupList = eLunInfo.getAllRecordColumnValueSet("ECC Group");
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"numberOfPgs")).intValue()] = String.valueOf(eccGroupList.size());
            ldevInfoRecordList = ldevInfo.getPrefixMatchedAllRecord("E", "ECC Group");
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"numberOfLdevsTotal")).intValue()] = String.valueOf(ldevInfoRecordList.size());
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"totalLdevCapacity")).intValue()] = totalLdevCapacity = ldevInfo.getSumSize(ldevInfoRecordList, "Volume Size(MB)");
            ldevInfoUnallocatedRecordList = ldevInfo.getUnallocatedRecordList(ldevInfoRecordList);
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"numberOfLdevsUnallocated")).intValue()] = String.valueOf(ldevInfoUnallocatedRecordList.size());
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"unallocatedLdevCapacity")).intValue()] = unallocatedLdevCapacity = ldevInfo.getSumSize(ldevInfoUnallocatedRecordList, "Volume Size(MB)");
            tableDataList.add(oneRecord);
        }
        if (!SJdtRPTDTDevice.isHmdev() && mfDMInfo.getCsvDataListSize() > 0) {
            oneRecord = new String[HEADER_KEY_ARRAY.length];
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"dka")).intValue()] = "External(FICON DM)";
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"module")).intValue()] = "-";
            List<String> mVolGroupList = mfDMInfo.getAllRecordColumnValueSet("Migration Volume Group");
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"numberOfPgs")).intValue()] = String.valueOf(mVolGroupList.size());
            ldevInfoRecordList = ldevInfo.getPrefixMatchedAllRecord("M", "ECC Group");
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"numberOfLdevsTotal")).intValue()] = String.valueOf(ldevInfoRecordList.size());
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"totalLdevCapacity")).intValue()] = totalLdevCapacity = ldevInfo.getSumSize(ldevInfoRecordList, "Volume Size(MB)");
            ldevInfoUnallocatedRecordList = ldevInfo.getUnallocatedRecordList(ldevInfoRecordList);
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"numberOfLdevsUnallocated")).intValue()] = String.valueOf(ldevInfoUnallocatedRecordList.size());
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"unallocatedLdevCapacity")).intValue()] = unallocatedLdevCapacity = ldevInfo.getSumSize(ldevInfoUnallocatedRecordList, "Volume Size(MB)");
            tableDataList.add(oneRecord);
        }
        oneRecord = null;
        List<String[]> csvDataList = dkaStatus.getCsvDataList();
        String dkaLocation = null;
        for (String[] dkaStatusRecord : csvDataList) {
            String unallocatedLdevCapacity2;
            String totalLdevCapacity2;
            if (SJdtRPTDTDevice.isHmdev()) {
                oneRecord = new String[HM_HEADER_KEY_ARRAY.length];
                oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"dkb")).intValue()] = dkaLocation = dkaStatus.getValue(dkaStatusRecord, "DKB Location");
            } else {
                oneRecord = new String[HEADER_KEY_ARRAY.length];
                oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"module")).intValue()] = dkaStatus.getValue(dkaStatusRecord, "Module#");
                oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"dka")).intValue()] = dkaLocation = dkaStatus.getValue(dkaStatusRecord, "DKA Location");
            }
            List<String> eccGroupList = pdevInfo.getEccGroupValueSet(dkaLocation);
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"numberOfPgs")).intValue()] = String.valueOf(eccGroupList.size());
            List<String[]> ldevInfoRecordList2 = ldevInfo.getMachedAllRecordSet(eccGroupList);
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"numberOfLdevsTotal")).intValue()] = String.valueOf(ldevInfoRecordList2.size());
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"totalLdevCapacity")).intValue()] = totalLdevCapacity2 = ldevInfo.getSumSize(ldevInfoRecordList2, "Volume Size(MB)");
            List<String[]> ldevInfoUnallocatedRecordList2 = ldevInfo.getUnallocatedRecordList(ldevInfoRecordList2);
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"numberOfLdevsUnallocated")).intValue()] = String.valueOf(ldevInfoUnallocatedRecordList2.size());
            oneRecord[((Integer)SJdtDkaReportGenerator.headerMap.get((Object)"unallocatedLdevCapacity")).intValue()] = unallocatedLdevCapacity2 = ldevInfo.getSumSize(ldevInfoUnallocatedRecordList2, "Volume Size(MB)");
            tableDataList.add(oneRecord);
        }
        return tableDataList;
    }
}

