/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtChaStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPTMInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPkInfoCSVWrapper;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.Cha;
import sanproject.sn2.rptdt.report.generator.SJdtChaReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtHMChaReportGenerator
extends SJdtChaReportGenerator {
    private static final String REPORT_NAME = "Cha";
    private static final String VM_LIBLARY_PATH = "/sanproject/sn2/rptdt/template/cha/vm/VM_HMcha_library.vm";
    private static final String CONTENTS_BODY_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/cha/vm/contentsBody_HMCha.vm";
    private static final int lcpFcpColumnSize = 4;
    private final String[] CHBB_EIOM = new String[]{"CHB-1J", "CHB-2J", "CHB-1K", "CHB-2K", "CHB-1L", "CHB-2L", "CHB-1M", "CHB-2M"};

    @Override
    public void generateContentsBody() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        context.put("libraryPath", (Object)VM_LIBLARY_PATH);
        this.setFixedStr(context);
        this.setVariableStr(context);
        String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_BODY_VM_FILE_PATH, generateFilePath);
        String cssFileName = "contentsBody_Cha.css";
        String originalFilePath = "/sanproject/sn2/rptdt/template/cha/css/" + cssFileName;
        String destFilePath = this.OUTPUT_CSS_DIR + cssFileName;
        SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
        SJdtReportGeneratorManager.copyAllFile(this, "/cha/img/", this.OUTPUT_IMG_DIR);
    }

    private void setFixedStr(VelocityContext context) {
        context.put("dkc", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.dkc"));
        context.put("numbersOfPorts", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.numbersOfPorts"));
        context.put("totalNumberOfPorts", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.totalNumberOfPorts"));
        context.put("numberOfPortsOnControllerChassis", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.numberOfPortsOnControllerChassis"));
        context.put("numberOfPortsOnChannelBoardBox", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.numberOfPortsOnChannelBoardBox"));
        context.put("cha1a", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1a"));
        context.put("cha1b", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1b"));
        context.put("cha1c", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1c"));
        context.put("cha1d", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1d"));
        context.put("cha1e", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1e"));
        context.put("cha1f", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1f"));
        context.put("cha1g", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1g"));
        context.put("cha1h", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1h"));
        context.put("cha1j", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1j"));
        context.put("cha1k", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1k"));
        context.put("cha1l", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1l"));
        context.put("cha1m", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1m"));
        context.put("cha2a", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2a"));
        context.put("cha2b", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2b"));
        context.put("cha2c", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2c"));
        context.put("cha2d", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2d"));
        context.put("cha2e", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2e"));
        context.put("cha2f", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2f"));
        context.put("cha2g", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2g"));
        context.put("cha2h", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2h"));
        context.put("cha2j", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2j"));
        context.put("cha2k", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2k"));
        context.put("cha2l", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2l"));
        context.put("cha2m", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2m"));
        context.put("chb1a1b1c1d", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.chb1a1b1c1d"));
        context.put("chb2a2b2c2d", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.chb2a2b2c2d"));
        context.put("notInstalled", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.notInstalled"));
    }

    private void setVariableStr(VelocityContext context) {
        String model = SJdtRPTDTDevice.getModel(SJdtRPTDTDevice.getModelInfo());
        context.put("modelInfo", (Object)model);
        this.setChaInfo(context);
    }

    private void setChaInfo(VelocityContext context) {
        SJdtChaStatusCSVWrapper chaStatus = (SJdtChaStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ChaStatus.csv");
        SJdtPkInfoCSVWrapper pkInfo = (SJdtPkInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PkInfo.csv");
        SJdtPTMInfoCSVWrapper ptmInfo = (SJdtPTMInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PECBInfo.csv");
        boolean chbbFlg = ptmInfo.isPTMForChbAll();
        HashMap<String, Cha> chaMap = new HashMap<String, Cha>();
        int dkc0NumberOfPorts = 0;
        int numberOfDkcPorts = 0;
        int numberOfChbbPorts = 0;
        List<String[]> csvDataList = chaStatus.getCsvDataList();
        for (String[] chaStatusRecord : csvDataList) {
            Cha cha = new Cha();
            String chaLocation = chaStatus.getValue(chaStatusRecord, "CHB Location");
            String chaLocationLowerCace = chaLocation.replaceFirst("-", "").replaceAll("/", "").toLowerCase();
            String packageType = pkInfo.getMatchedOneRecordColumnValue(chaLocation, "CHB Location", "Package Type");
            cha.setPackageType(packageType);
            int numberOfPort = 0;
            int numberOfDkcPort = 0;
            int numberOfChbbPort = 0;
            Boolean[] portInstalledArray = new Boolean[4];
            for (int i = 0; i < 4; ++i) {
                String lcpFcpColumn = "Port#0" + i;
                String lcpFcp = chaStatus.getValue(chaStatusRecord, lcpFcpColumn);
                if (StringUtils.isNotEmpty((String)lcpFcp)) {
                    ++numberOfPort;
                    if (this.isChbbEIOM(chaLocation)) {
                        ++numberOfChbbPort;
                    }
                    portInstalledArray[i] = Boolean.TRUE;
                    continue;
                }
                portInstalledArray[i] = Boolean.FALSE;
            }
            cha.setPortInstalledArray(portInstalledArray);
            dkc0NumberOfPorts += numberOfPort;
            numberOfDkcPort = numberOfPort - numberOfChbbPort;
            numberOfDkcPorts += numberOfDkcPort;
            numberOfChbbPorts += numberOfChbbPort;
            chaMap.put(chaLocationLowerCace, cha);
        }
        context.put("chaMap", chaMap);
        context.put("valueOfDkc0NumberOfPorts", (Object)String.valueOf(dkc0NumberOfPorts));
        context.put("valueOfNumberOfDkcPorts", (Object)String.valueOf(numberOfDkcPorts));
        context.put("valueOfNumberOfChbbPorts", (Object)String.valueOf(numberOfChbbPorts));
        context.put("chbbFlg", (Object)chbbFlg);
    }

    private boolean isChbbEIOM(String chbLocation) {
        boolean result = false;
        for (int i = 0; i < this.CHBB_EIOM.length; ++i) {
            if (!this.CHBB_EIOM[i].equals(chbLocation)) continue;
            result = true;
            break;
        }
        return result;
    }
}

