/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.sn2com.utility;

import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.controller.com.SJctrTask;

public class SJsncTaskHashUty {
    private static String LOG_FUNCTION = "SnTaskInfo";
    private static String LOG_TITLE = SJsncTaskHashUty.class.getSimpleName();

    public static String createHash(SJctrTask task) {
        String LOG_SUBTITLE = "createHash";
        SJcLoggerInterface logger = SJcLogUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, "createHash", "Start.");
        String hashString = null;
        if (task == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "createHash", "Task is null.");
            return hashString;
        }
        String snid = task.getId();
        String userID = task.getUserId();
        long wizardStartTime = task.getWizardStartTime();
        long submitTime = task.getSubmitTime();
        hashString = SJsncTaskHashUty.createHash(snid, userID, wizardStartTime, submitTime);
        logger.trace(LOG_FUNCTION, LOG_TITLE, "createHash", "End.");
        return hashString;
    }

    public static String createHash(String snid, String userID, long wizardStartTime, long submitTime) {
        String LOG_SUBTITLE = "createHash";
        SJcLoggerInterface logger = SJcLogUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, "createHash", "Start.");
        String hashString = null;
        String serialNumber = SJcProductUty.getSerialNumber();
        String idseed = snid + ":" + userID + ":" + wizardStartTime + ":" + submitTime + ":" + serialNumber;
        try {
            hashString = SJcSecureUty.getHashValueStringHex(idseed);
        }
        catch (Exception ex) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "createHash", "SNID:" + snid, ex);
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "createHash", "End.");
        return hashString;
    }
}

